/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.javazic;

import java.util.ArrayList;
import java.util.List;
import sun.tools.javazic.Checksum;
import sun.tools.javazic.RuleRec;
import sun.tools.javazic.Time;
import sun.tools.javazic.ZoneRec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Timezone {
    private String name;
    private List<Long> transitions;
    private List<Integer> offsets;
    private List<Integer> gmtOffsets;
    private List<Integer> dstOffsets;
    private List<ZoneRec> usedZoneRecs;
    private List<RuleRec> usedRuleRecs;
    private int dstType;
    static final int UNDEF_DST = 0;
    static final int NO_DST = 1;
    static final int LAST_DST = 2;
    static final int X_DST = 3;
    static final int DST = 4;
    private int rawOffset;
    private int crc32;
    private ZoneRec lastZoneRec;
    private List<RuleRec> lastRules;
    private int lastSaving;
    private boolean willRawOffsetChange = false;

    Timezone(String string) {
        this.name = string;
    }

    int getNTransitions() {
        if (this.transitions == null) {
            return 0;
        }
        return this.transitions.size();
    }

    String getName() {
        return this.name;
    }

    List<RuleRec> getRules() {
        return this.usedRuleRecs;
    }

    List<ZoneRec> getZones() {
        return this.usedZoneRecs;
    }

    List<Long> getTransitions() {
        return this.transitions;
    }

    List<Integer> getOffsets() {
        return this.offsets;
    }

    List<Integer> getDstOffsets() {
        return this.dstOffsets;
    }

    List<Integer> getGmtOffsets() {
        return this.gmtOffsets;
    }

    int getCRC32() {
        return this.crc32;
    }

    boolean willGMTOffsetChange() {
        return this.willRawOffsetChange;
    }

    int getRawOffset() {
        return this.rawOffset;
    }

    void setRawOffset(int n) {
        this.rawOffset = n;
    }

    void setRawOffset(int n, long l) {
        if (l > Time.getCurrentTime()) {
            this.willRawOffsetChange = true;
        }
        this.setRawOffset(n);
    }

    void addTransition(long l, int n, int n2) {
        if (this.transitions == null) {
            this.transitions = new ArrayList<Long>();
            this.offsets = new ArrayList<Integer>();
            this.dstOffsets = new ArrayList<Integer>();
        }
        this.transitions.add(l);
        this.offsets.add(n);
        this.dstOffsets.add(n2);
    }

    void setDSTType(int n) {
        this.dstType = n;
    }

    int getDSTType() {
        return this.dstType;
    }

    void addUsedRec(ZoneRec zoneRec) {
        if (this.usedZoneRecs == null) {
            this.usedZoneRecs = new ArrayList<ZoneRec>();
        }
        this.usedZoneRecs.add(zoneRec);
    }

    void addUsedRec(RuleRec ruleRec) {
        if (this.usedRuleRecs == null) {
            this.usedRuleRecs = new ArrayList<RuleRec>();
        }
        int n = this.usedRuleRecs.size();
        for (int i = 0; i < n; ++i) {
            if (!this.usedRuleRecs.get(i).equals(ruleRec)) continue;
            return;
        }
        this.usedRuleRecs.add(ruleRec);
    }

    void setLastZoneRec(ZoneRec zoneRec) {
        this.lastZoneRec = zoneRec;
    }

    ZoneRec getLastZoneRec() {
        return this.lastZoneRec;
    }

    void setLastRules(List<RuleRec> list) {
        int n = list.size();
        if (n > 0) {
            this.lastRules = list;
            RuleRec ruleRec = list.get(0);
            int n2 = ruleRec.getSave();
            if (n2 > 0) {
                this.setLastDSTSaving(n2);
            } else {
                System.err.println("\t    No DST starting rule in the last rules.");
            }
        }
    }

    List<RuleRec> getLastRules() {
        return this.lastRules;
    }

    void setLastDSTSaving(int n) {
        this.lastSaving = n;
    }

    int getLastDSTSaving() {
        return this.lastSaving;
    }

    void checksum() {
        if (this.transitions == null) {
            this.crc32 = 0;
            return;
        }
        Checksum checksum = new Checksum();
        for (int i = 0; i < this.transitions.size(); ++i) {
            int n = this.offsets.get(i);
            checksum.update(this.transitions.get(i) + (long)n);
            checksum.update(n);
            checksum.update(this.dstOffsets.get(i));
        }
        this.crc32 = (int)checksum.getValue();
    }

    void optimize() {
        int n;
        if (this.gmtOffsets.size() == 1) {
            this.transitions = null;
            this.usedRuleRecs = null;
            this.setDSTType(1);
            return;
        }
        for (n = 0; n < this.transitions.size() - 2; ++n) {
            if (this.transitions.get(n) != this.transitions.get(n + 1)) continue;
            this.transitions.remove(n);
            this.offsets.remove(n);
            this.dstOffsets.remove(n);
            --n;
        }
        for (n = 0; n < this.transitions.size() - 2; ++n) {
            if (this.offsets.get(n) != this.offsets.get(n + 1) || this.dstOffsets.get(n) != this.dstOffsets.get(n + 1)) continue;
            this.transitions.remove(n + 1);
            this.offsets.remove(n + 1);
            this.dstOffsets.remove(n + 1);
            --n;
        }
    }

    int getOffsetIndex(int n) {
        return this.getOffsetIndex(n, 0);
    }

    int getDstOffsetIndex(int n) {
        if (n == 0) {
            return -1;
        }
        return this.getOffsetIndex(n, 1);
    }

    private int getOffsetIndex(int n, int n2) {
        if (this.gmtOffsets == null) {
            this.gmtOffsets = new ArrayList<Integer>();
        }
        for (int i = n2; i < this.gmtOffsets.size(); ++i) {
            if (n != this.gmtOffsets.get(i)) continue;
            return i;
        }
        if (this.gmtOffsets.size() < n2) {
            this.gmtOffsets.add(0);
        }
        this.gmtOffsets.add(n);
        return this.gmtOffsets.size() - 1;
    }
}

