/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.builders;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.ConstantsSummaryWriter;
import com.sun.tools.doclets.internal.toolkit.builders.AbstractBuilder;
import com.sun.tools.doclets.internal.toolkit.builders.LayoutParser;
import com.sun.tools.doclets.internal.toolkit.util.VisibleMemberMap;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ConstantsSummaryBuilder
extends AbstractBuilder {
    public static final String ROOT = "ConstantSummary";
    public static final int MAX_CONSTANT_VALUE_INDEX_LENGTH = 2;
    protected ConstantsSummaryWriter writer;
    protected Set classDocsWithConstFields;
    protected Set printedPackageHeaders;
    private PackageDoc currentPackage;
    private ClassDoc currentClass;

    private ConstantsSummaryBuilder(Configuration configuration) {
        super(configuration);
    }

    public static ConstantsSummaryBuilder getInstance(Configuration configuration, ConstantsSummaryWriter constantsSummaryWriter) {
        ConstantsSummaryBuilder constantsSummaryBuilder = new ConstantsSummaryBuilder(configuration);
        constantsSummaryBuilder.writer = constantsSummaryWriter;
        constantsSummaryBuilder.classDocsWithConstFields = new HashSet();
        return constantsSummaryBuilder;
    }

    public void invokeMethod(String string, Class[] classArray, Object[] objectArray) throws Exception {
        Method method = this.getClass().getMethod(string, classArray);
        method.invoke((Object)this, objectArray);
    }

    public void build() throws IOException {
        if (this.writer == null) {
            return;
        }
        this.build(LayoutParser.getInstance(this.configuration).parseXML(ROOT));
    }

    public String getName() {
        return ROOT;
    }

    public void buildConstantSummary(List list) throws Exception {
        this.build(list);
        this.writer.close();
    }

    public void buildHeader() {
        this.writer.writeHeader();
    }

    public void buildFooter() {
        this.writer.writeFooter();
    }

    public void buildContents() {
        this.writer.writeContentsHeader();
        PackageDoc[] packageDocArray = this.configuration.packages;
        this.printedPackageHeaders = new HashSet();
        for (int i = 0; i < packageDocArray.length; ++i) {
            if (!this.hasConstantField(packageDocArray[i]) || this.hasPrintedPackageIndex(packageDocArray[i].name())) continue;
            this.writer.writeLinkToPackageContent(packageDocArray[i], this.parsePackageName(packageDocArray[i].name()), this.printedPackageHeaders);
        }
        this.writer.writeContentsFooter();
    }

    public void buildConstantSummaries(List list) {
        PackageDoc[] packageDocArray = this.configuration.packages;
        this.printedPackageHeaders = new HashSet();
        for (int i = 0; i < packageDocArray.length; ++i) {
            if (!this.hasConstantField(packageDocArray[i])) continue;
            this.currentPackage = packageDocArray[i];
            this.build(list);
        }
    }

    public void buildPackageConstantSummary(List list) {
        this.build(list);
    }

    public void buildClassConstantSummary(List list) {
        Object[] objectArray = this.currentPackage.name().length() > 0 ? this.currentPackage.allClasses() : this.configuration.classDocCatalog.allClasses("&lt;Unnamed&gt;");
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            if (!this.classDocsWithConstFields.contains(objectArray[i]) || !objectArray[i].isIncluded()) continue;
            this.currentClass = objectArray[i];
            this.build(list);
        }
    }

    public void buildPackageHeader() {
        String string = this.parsePackageName(this.currentPackage.name());
        if (!this.printedPackageHeaders.contains(string)) {
            this.writer.writePackageName(this.currentPackage, this.parsePackageName(this.currentPackage.name()));
            this.printedPackageHeaders.add(string);
        }
    }

    public void buildClassHeader() {
        this.writer.writeConstantMembersHeader(this.currentClass);
    }

    public void buildConstantMembers() {
        new ConstantFieldBuilder(this.currentClass).buildMembersSummary();
    }

    public void buildClassFooter() {
        this.writer.writeConstantMembersFooter(this.currentClass);
    }

    private boolean hasConstantField(PackageDoc packageDoc) {
        ClassDoc[] classDocArray = packageDoc.name().length() > 0 ? packageDoc.allClasses() : this.configuration.classDocCatalog.allClasses("&lt;Unnamed&gt;");
        boolean bl = false;
        for (int i = 0; i < classDocArray.length; ++i) {
            if (!classDocArray[i].isIncluded() || !this.hasConstantField(classDocArray[i])) continue;
            bl = true;
        }
        return bl;
    }

    private boolean hasConstantField(ClassDoc classDoc) {
        VisibleMemberMap visibleMemberMap = new VisibleMemberMap(classDoc, 2, this.configuration.nodeprecated);
        List list = visibleMemberMap.getLeafClassMembers(this.configuration);
        for (FieldDoc fieldDoc : list) {
            if (fieldDoc.constantValueExpression() == null) continue;
            this.classDocsWithConstFields.add(classDoc);
            return true;
        }
        return false;
    }

    private boolean hasPrintedPackageIndex(String string) {
        String[] stringArray = this.printedPackageHeaders.toArray(new String[0]);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.startsWith(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private String parsePackageName(String string) {
        int n = -1;
        for (int i = 0; i < 2; ++i) {
            n = string.indexOf(".", n + 1);
        }
        if (n != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    private class ConstantFieldBuilder {
        protected VisibleMemberMap visibleMemberMapFields = null;
        protected VisibleMemberMap visibleMemberMapEnumConst = null;
        protected ClassDoc classdoc;

        public ConstantFieldBuilder(ClassDoc classDoc) {
            this.classdoc = classDoc;
            this.visibleMemberMapFields = new VisibleMemberMap(classDoc, 2, ConstantsSummaryBuilder.this.configuration.nodeprecated);
            this.visibleMemberMapEnumConst = new VisibleMemberMap(classDoc, 1, ConstantsSummaryBuilder.this.configuration.nodeprecated);
        }

        protected void buildMembersSummary() {
            ArrayList arrayList = new ArrayList(this.members());
            if (arrayList.size() > 0) {
                Collections.sort(arrayList);
                ConstantsSummaryBuilder.this.writer.writeConstantMembers(this.classdoc, arrayList);
            }
        }

        protected List members() {
            List list = this.visibleMemberMapFields.getLeafClassMembers(ConstantsSummaryBuilder.this.configuration);
            list.addAll(this.visibleMemberMapEnumConst.getLeafClassMembers(ConstantsSummaryBuilder.this.configuration));
            if (list == null) {
                return null;
            }
            Iterator iterator = list.iterator();
            LinkedList<FieldDoc> linkedList = new LinkedList<FieldDoc>();
            while (iterator.hasNext()) {
                FieldDoc fieldDoc = (FieldDoc)iterator.next();
                if (fieldDoc.constantValue() == null) continue;
                linkedList.add(fieldDoc);
            }
            return linkedList;
        }
    }
}

