/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html;

import com.sun.tools.doclets.formats.html.AbstractIndexWriter;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.sun.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.doclets.internal.toolkit.util.IndexBuilder;
import java.io.IOException;

public class SplitIndexWriter
extends AbstractIndexWriter {
    protected int prev;
    protected int next;

    public SplitIndexWriter(ConfigurationImpl configurationImpl, String string, String string2, String string3, IndexBuilder indexBuilder, int n, int n2) throws IOException {
        super(configurationImpl, string, string2, string3, indexBuilder);
        this.prev = n;
        this.next = n2;
    }

    public static void generate(ConfigurationImpl configurationImpl, IndexBuilder indexBuilder) {
        String string = "";
        String string2 = DirectoryManager.getPath("index-files");
        String string3 = DirectoryManager.getRelativePath("index-files");
        try {
            for (int i = 0; i < indexBuilder.elements().length; ++i) {
                int n = i + 1;
                int n2 = n == 1 ? -1 : i;
                int n3 = n == indexBuilder.elements().length ? -1 : n + 1;
                string = "index-" + n + ".html";
                SplitIndexWriter splitIndexWriter = new SplitIndexWriter(configurationImpl, string2, string, string3, indexBuilder, n2, n3);
                splitIndexWriter.generateIndexFile((Character)indexBuilder.elements()[i]);
                splitIndexWriter.close();
            }
        }
        catch (IOException iOException) {
            configurationImpl.standardmessage.error("doclet.exception_encountered", iOException.toString(), string);
            throw new DocletAbortException();
        }
    }

    protected void generateIndexFile(Character c) throws IOException {
        this.printHtmlHeader(this.configuration.getText("doclet.Window_Split_Index", c.toString()), null, true);
        this.navLinks(true);
        this.aName("main");
        this.aEnd();
        this.println("");
        this.printLinksForIndexes();
        this.hr();
        this.generateContents(c, this.indexbuilder.getMemberList(c));
        this.navLinks(false);
        this.printLinksForIndexes();
        this.printBottom();
        this.printBodyHtmlEnd();
    }

    protected void printLinksForIndexes() {
        for (int i = 0; i < this.indexbuilder.elements().length; ++i) {
            int n = i + 1;
            this.printHyperLink("index-" + n + ".html", this.indexbuilder.elements()[i].toString());
            this.print(' ');
        }
    }

    protected void navLinkPrevious() {
        if (this.prev == -1) {
            this.printText("doclet.Prev_Letter");
        } else {
            this.printHyperLink("index-" + this.prev + ".html", "", this.configuration.getText("doclet.Prev_Letter"), true);
        }
    }

    protected void navLinkNext() {
        if (this.next == -1) {
            this.printText("doclet.Next_Letter");
        } else {
            this.printHyperLink("index-" + this.next + ".html", "", this.configuration.getText("doclet.Next_Letter"), true);
        }
    }
}

