/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.apt.mirror.declaration;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.ExecutableDeclaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.PackageDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.declaration.TypeParameterDeclaration;
import com.sun.tools.apt.mirror.AptEnv;
import com.sun.tools.apt.mirror.declaration.AnnotationMirrorImpl;
import com.sun.tools.apt.mirror.declaration.AnnotationTypeDeclarationImpl;
import com.sun.tools.apt.mirror.declaration.AnnotationTypeElementDeclarationImpl;
import com.sun.tools.apt.mirror.declaration.ClassDeclarationImpl;
import com.sun.tools.apt.mirror.declaration.ConstructorDeclarationImpl;
import com.sun.tools.apt.mirror.declaration.EnumConstantDeclarationImpl;
import com.sun.tools.apt.mirror.declaration.EnumDeclarationImpl;
import com.sun.tools.apt.mirror.declaration.FieldDeclarationImpl;
import com.sun.tools.apt.mirror.declaration.InterfaceDeclarationImpl;
import com.sun.tools.apt.mirror.declaration.MethodDeclarationImpl;
import com.sun.tools.apt.mirror.declaration.PackageDeclarationImpl;
import com.sun.tools.apt.mirror.declaration.ParameterDeclarationImpl;
import com.sun.tools.apt.mirror.declaration.TypeParameterDeclarationImpl;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.util.Context;
import java.util.HashMap;
import java.util.Map;

public class DeclarationMaker {
    private AptEnv env;
    private Context context;
    private static final Context.Key<DeclarationMaker> declarationMakerKey = new Context.Key();
    private Map<Symbol.PackageSymbol, PackageDeclaration> packageDecls = new HashMap<Symbol.PackageSymbol, PackageDeclaration>();
    private Map<Symbol.ClassSymbol, TypeDeclaration> typeDecls = new HashMap<Symbol.ClassSymbol, TypeDeclaration>();
    private Map<Symbol.MethodSymbol, ExecutableDeclaration> executableDecls = new HashMap<Symbol.MethodSymbol, ExecutableDeclaration>();
    private Map<Symbol.VarSymbol, FieldDeclaration> fieldDecls = new HashMap<Symbol.VarSymbol, FieldDeclaration>();

    public static DeclarationMaker instance(Context context) {
        DeclarationMaker declarationMaker = context.get(declarationMakerKey);
        if (declarationMaker == null) {
            declarationMaker = new DeclarationMaker(context);
        }
        return declarationMaker;
    }

    private DeclarationMaker(Context context) {
        context.put(declarationMakerKey, this);
        this.env = AptEnv.instance(context);
        this.context = context;
    }

    public PackageDeclaration getPackageDeclaration(Symbol.PackageSymbol packageSymbol) {
        PackageDeclaration packageDeclaration = this.packageDecls.get(packageSymbol);
        if (packageDeclaration == null) {
            packageDeclaration = new PackageDeclarationImpl(this.env, packageSymbol);
            this.packageDecls.put(packageSymbol, packageDeclaration);
        }
        return packageDeclaration;
    }

    public PackageDeclaration getPackageDeclaration(String string) {
        Symbol.PackageSymbol packageSymbol = null;
        if (string.equals("")) {
            packageSymbol = this.env.symtab.emptyPackage;
        } else {
            if (!DeclarationMaker.isJavaName(string)) {
                return null;
            }
            Symbol symbol = this.nameToSymbol(string);
            if (symbol instanceof Symbol.PackageSymbol) {
                packageSymbol = (Symbol.PackageSymbol)symbol;
                if (!packageSymbol.exists()) {
                    return null;
                }
            } else {
                return null;
            }
        }
        return this.getPackageDeclaration(packageSymbol);
    }

    public TypeDeclaration getTypeDeclaration(Symbol.ClassSymbol classSymbol) {
        long l = AptEnv.getFlags(classSymbol);
        if (classSymbol.kind == 31) {
            return null;
        }
        TypeDeclaration typeDeclaration = this.typeDecls.get(classSymbol);
        if (typeDeclaration == null) {
            typeDeclaration = (l & 0x2000L) != 0L ? new AnnotationTypeDeclarationImpl(this.env, classSymbol) : ((l & 0x200L) != 0L ? new InterfaceDeclarationImpl(this.env, classSymbol) : ((l & 0x4000L) != 0L ? new EnumDeclarationImpl(this.env, classSymbol) : new ClassDeclarationImpl(this.env, classSymbol)));
            this.typeDecls.put(classSymbol, typeDeclaration);
        }
        return typeDeclaration;
    }

    public TypeDeclaration getTypeDeclaration(String string) {
        if (!DeclarationMaker.isJavaName(string)) {
            return null;
        }
        Symbol symbol = this.nameToSymbol(string);
        if (symbol instanceof Symbol.ClassSymbol) {
            Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)symbol;
            return this.getTypeDeclaration(classSymbol);
        }
        return null;
    }

    private Symbol nameToSymbol(String string) {
        JavaCompiler javaCompiler = JavaCompiler.instance(this.context);
        Symbol symbol = null;
        symbol = javaCompiler.resolveIdent(string);
        if (symbol.kind == 31) {
            return null;
        }
        return symbol;
    }

    ExecutableDeclaration getExecutableDeclaration(Symbol.MethodSymbol methodSymbol) {
        ExecutableDeclaration executableDeclaration = this.executableDecls.get(methodSymbol);
        if (executableDeclaration == null) {
            executableDeclaration = methodSymbol.isConstructor() ? new ConstructorDeclarationImpl(this.env, methodSymbol) : (DeclarationMaker.isAnnotationTypeElement(methodSymbol) ? new AnnotationTypeElementDeclarationImpl(this.env, methodSymbol) : new MethodDeclarationImpl(this.env, methodSymbol));
            this.executableDecls.put(methodSymbol, executableDeclaration);
        }
        return executableDeclaration;
    }

    FieldDeclaration getFieldDeclaration(Symbol.VarSymbol varSymbol) {
        FieldDeclaration fieldDeclaration = this.fieldDecls.get(varSymbol);
        if (fieldDeclaration == null) {
            fieldDeclaration = DeclarationMaker.hasFlag(varSymbol, 16384L) ? new EnumConstantDeclarationImpl(this.env, varSymbol) : new FieldDeclarationImpl(this.env, varSymbol);
            this.fieldDecls.put(varSymbol, fieldDeclaration);
        }
        return fieldDeclaration;
    }

    ParameterDeclaration getParameterDeclaration(Symbol.VarSymbol varSymbol) {
        return new ParameterDeclarationImpl(this.env, varSymbol);
    }

    public TypeParameterDeclaration getTypeParameterDeclaration(Symbol.TypeSymbol typeSymbol) {
        return new TypeParameterDeclarationImpl(this.env, typeSymbol);
    }

    AnnotationMirror getAnnotationMirror(Attribute.Compound compound, Declaration declaration) {
        return new AnnotationMirrorImpl(this.env, compound, declaration);
    }

    public static boolean isJavaIdentifier(String string) {
        if (string.length() == 0) {
            return false;
        }
        int n = string.codePointAt(0);
        if (!Character.isJavaIdentifierStart(n)) {
            return false;
        }
        for (int i = Character.charCount(n); i < string.length(); i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (Character.isJavaIdentifierPart(n)) continue;
            return false;
        }
        return true;
    }

    public static boolean isJavaName(String string) {
        for (String string2 : string.split("\\.")) {
            if (DeclarationMaker.isJavaIdentifier(string2)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAnnotationTypeElement(Symbol.MethodSymbol methodSymbol) {
        return DeclarationMaker.hasFlag(methodSymbol.enclClass(), 8192L);
    }

    private static boolean hasFlag(Symbol symbol, long l) {
        return AptEnv.hasFlag(symbol, l);
    }
}

