/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.apt.mirror.apt;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.AnnotationProcessorListener;
import com.sun.mirror.apt.Filer;
import com.sun.mirror.apt.Messager;
import com.sun.mirror.apt.RoundCompleteEvent;
import com.sun.mirror.apt.RoundCompleteListener;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.PackageDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.util.DeclarationVisitor;
import com.sun.mirror.util.DeclarationVisitors;
import com.sun.mirror.util.Declarations;
import com.sun.mirror.util.SimpleDeclarationVisitor;
import com.sun.mirror.util.Types;
import com.sun.tools.apt.mirror.apt.FilerImpl;
import com.sun.tools.apt.mirror.apt.MessagerImpl;
import com.sun.tools.apt.mirror.apt.RoundCompleteEventImpl;
import com.sun.tools.apt.mirror.apt.RoundStateImpl;
import com.sun.tools.apt.mirror.declaration.DeclarationMaker;
import com.sun.tools.apt.mirror.util.DeclarationsImpl;
import com.sun.tools.apt.mirror.util.TypesImpl;
import com.sun.tools.apt.util.Bark;
import com.sun.tools.javac.util.Context;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationProcessorEnvironmentImpl
implements AnnotationProcessorEnvironment {
    Collection<TypeDeclaration> spectypedecls;
    Collection<TypeDeclaration> typedecls;
    Map<String, String> origOptions;
    DeclarationMaker declMaker;
    Declarations declUtils;
    Types typeUtils;
    Messager messager;
    FilerImpl filer;
    Bark bark;
    Set<RoundCompleteListener> roundCompleteListeners;

    public AnnotationProcessorEnvironmentImpl(Collection<TypeDeclaration> collection, Collection<TypeDeclaration> collection2, Map<String, String> map, Context context) {
        this.spectypedecls = Collections.unmodifiableCollection(collection);
        this.typedecls = Collections.unmodifiableCollection(collection2);
        this.origOptions = Collections.unmodifiableMap(map);
        this.declMaker = DeclarationMaker.instance(context);
        this.declUtils = DeclarationsImpl.instance(context);
        this.typeUtils = TypesImpl.instance(context);
        this.messager = MessagerImpl.instance(context);
        this.filer = FilerImpl.instance(context);
        this.bark = Bark.instance(context);
        this.roundCompleteListeners = new LinkedHashSet<RoundCompleteListener>();
    }

    public Map<String, String> getOptions() {
        return this.origOptions;
    }

    public Messager getMessager() {
        return this.messager;
    }

    public Filer getFiler() {
        return this.filer;
    }

    public Collection<TypeDeclaration> getSpecifiedTypeDeclarations() {
        return this.spectypedecls;
    }

    public PackageDeclaration getPackage(String string) {
        return this.declMaker.getPackageDeclaration(string);
    }

    public TypeDeclaration getTypeDeclaration(String string) {
        return this.declMaker.getTypeDeclaration(string);
    }

    public Collection<TypeDeclaration> getTypeDeclarations() {
        return this.typedecls;
    }

    public Collection<Declaration> getDeclarationsAnnotatedWith(AnnotationTypeDeclaration annotationTypeDeclaration) {
        CollectingAP collectingAP = new CollectingAP(this, annotationTypeDeclaration);
        collectingAP.process();
        return collectingAP.decls;
    }

    public Declarations getDeclarationUtils() {
        return this.declUtils;
    }

    public Types getTypeUtils() {
        return this.typeUtils;
    }

    public void addListener(AnnotationProcessorListener annotationProcessorListener) {
        if (annotationProcessorListener == null) {
            throw new NullPointerException();
        }
        if (annotationProcessorListener instanceof RoundCompleteListener) {
            this.roundCompleteListeners.add((RoundCompleteListener)annotationProcessorListener);
        }
    }

    public void removeListener(AnnotationProcessorListener annotationProcessorListener) {
        if (annotationProcessorListener == null) {
            throw new NullPointerException();
        }
        this.roundCompleteListeners.remove(annotationProcessorListener);
    }

    public void roundComplete() {
        RoundStateImpl roundStateImpl = new RoundStateImpl(this.bark.nerrors > 0, this.filer.getSourceFileNames().size() > 0, this.filer.getClassFileNames().size() > 0, this.origOptions);
        RoundCompleteEventImpl roundCompleteEventImpl = new RoundCompleteEventImpl(this, roundStateImpl);
        this.filer.roundOver();
        for (RoundCompleteListener roundCompleteListener : this.roundCompleteListeners) {
            roundCompleteListener.roundComplete((RoundCompleteEvent)roundCompleteEventImpl);
        }
    }

    private static class CollectingAP
    implements AnnotationProcessor {
        AnnotationProcessorEnvironment env;
        Collection<Declaration> decls;
        AnnotationTypeDeclaration atd;

        CollectingAP(AnnotationProcessorEnvironment annotationProcessorEnvironment, AnnotationTypeDeclaration annotationTypeDeclaration) {
            this.env = annotationProcessorEnvironment;
            this.atd = annotationTypeDeclaration;
            this.decls = new HashSet<Declaration>();
        }

        public void process() {
            for (TypeDeclaration typeDeclaration : this.env.getSpecifiedTypeDeclarations()) {
                typeDeclaration.accept(DeclarationVisitors.getSourceOrderDeclarationScanner((DeclarationVisitor)new CollectingVisitor(), (DeclarationVisitor)DeclarationVisitors.NO_OP));
            }
        }

        private class CollectingVisitor
        extends SimpleDeclarationVisitor {
            private CollectingVisitor() {
            }

            public void visitDeclaration(Declaration declaration) {
                for (AnnotationMirror annotationMirror : declaration.getAnnotationMirrors()) {
                    if (!annotationMirror.getAnnotationType().getDeclaration().equals(CollectingAP.this.atd)) continue;
                    CollectingAP.this.decls.add(declaration);
                }
            }
        }
    }
}

