/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.rmic.iiop;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class EscapedUnicodeFilterWriter
extends FilterWriter {
    public static final int ESCAPE_THRESHOLD = 127;
    private static final char[] HEX_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public EscapedUnicodeFilterWriter(Writer writer) {
        super(writer);
    }

    public void write(String string, int n, int n2) throws IOException {
        int n3 = n;
        int n4 = n + n2;
        for (int i = n; i < n4; ++i) {
            char c = string.charAt(i);
            if (c <= '\u007f') continue;
            if (n3 < i) {
                this.out.write(string, n3, i - n3);
            }
            this.writeEscapedSequence(c);
            n3 = i + 1;
        }
        if (n3 < n4) {
            this.out.write(string, n3, n4 - n3);
        }
    }

    public void write(int n) throws IOException {
        if (n > 127) {
            this.writeEscapedSequence(n);
        } else {
            this.out.write(n);
        }
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        int n3 = n;
        int n4 = n + n2;
        for (int i = n; i < n4; ++i) {
            char c = cArray[i];
            if (c <= '\u007f') continue;
            if (n3 < i) {
                this.out.write(cArray, n3, i - n3);
            }
            this.writeEscapedSequence(c);
            n3 = i + 1;
        }
        if (n3 < n4) {
            this.out.write(cArray, n3, n4 - n3);
        }
    }

    private void writeEscapedSequence(int n) throws IOException {
        this.out.write("\\u");
        this.out.write(HEX_CHAR[0xF & n >>> 12]);
        this.out.write(HEX_CHAR[0xF & n >>> 8]);
        this.out.write(HEX_CHAR[0xF & n >>> 4]);
        this.out.write(HEX_CHAR[0xF & n]);
    }
}

