/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.systemdump;

import com.ibm.jvm.j9.dump.systemdump.Dump;
import com.ibm.jvm.j9.dump.systemdump.GenericThread;
import com.ibm.jvm.j9.dump.systemdump.J9AddressSpace;
import com.ibm.jvm.j9.dump.systemdump.J9Process;
import com.ibm.jvm.j9.dump.systemdump.MemoryRange;
import com.ibm.jvm.j9.dump.systemdump.NativeThreadContext;
import com.ibm.jvm.j9.dump.systemdump.Register;
import com.ibm.jvm.j9.dump.systemdump.StackFrame;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;

public class Windump
extends Dump {
    private static MinidumpHeader minidumpHeader;
    private static MinidumpDirectoryElement[] minidumpDirectoryElements;
    private static boolean verbose;
    private static int numberOfThreads;
    private static int numberOfModules;
    private static long numberOfMemoryRanges;
    private static MinidumpThread[] minidumpThreads;
    private static MinidumpModule[] minidumpModules;
    private static MemoryRange[] memoryRanges;
    private static long baseRva;
    private static boolean isMiniDump;
    private static boolean isWindowsDump;
    private static Vector debugFiles;
    private static final long PEBADDRESS = 2147348480L;
    private static final int INFOBLOCKADDRESSOFFSET = 16;
    private static final int COMMANDLINEADDRESSOFFSET = 68;
    private static final int COMMANDLINELENGTHADDRESSOFFSET = 64;
    private static final long PEB64ADDRESS = 0L;
    private static final String[] regNames;
    private static final String[] regNames64;
    int regNames64Count = regNames64.length;
    int regNamesCount = regNames.length;

    public static boolean isSupportedDump(RandomAccessFile randomAccessFile) {
        byte[] byArray = new byte[4];
        byte[] byArray2 = new byte[4];
        boolean bl = false;
        try {
            randomAccessFile.seek(0L);
            randomAccessFile.read(byArray);
            String string = new String(byArray);
            if (string.toUpperCase().equals("MDMP")) {
                bl = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.err.println("\nUsage: java WinDump filename\n");
            System.exit(1);
        }
        verbose = true;
        try {
            new Windump(stringArray[0]);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("\n File \"" + stringArray[0] + "\" not found.");
            System.exit(1);
        }
    }

    public Windump(String string) throws FileNotFoundException {
        super(string);
        bIsLittleEndian = true;
        this.setSystemType(1);
        minidumpHeader = new MinidumpHeader();
        this.addressSpaces = new J9AddressSpace[1];
        this.addressSpaces[0] = new J9AddressSpace("WinAS", this, 0);
        J9Process j9Process = new J9Process("WinProc", 0);
        this.addressSpaces[0].addProcess(j9Process);
        if (isMiniDump) {
            this.dumpTime = Windump.minidumpHeader.timeDateStamp;
            this.processMdStreams(minidumpHeader);
        } else {
            this.processUdStreams();
        }
        j9Process.setCmdLine(this.findCommandLine());
    }

    public static String getStringFromBytes(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (null == byArray) {
            return "bad string";
        }
        for (int i = 0; i < byArray.length && byArray[i] != 0 && byArray[0] != 0; ++i) {
            stringBuffer.append((char)byArray[i]);
        }
        return stringBuffer.toString();
    }

    private String getModuleName(int n) {
        String string = "????";
        long l = 0L;
        try {
            l = this.getFilePointer();
            this.seek(n);
            int n2 = Windump.convertEndian(this.readInt());
            if (n2 >= 512 || n2 <= 0) {
                n2 = 512;
            }
            byte[] byArray = new byte[n2];
            this.read(byArray);
            byte[] byArray2 = new byte[n2 / 2];
            for (int i = 0; i < n2 / 2; ++i) {
                byArray2[i] = byArray[2 * i];
            }
            string = new String(byArray2);
            this.seek(l);
        }
        catch (IOException iOException) {
            System.err.println("IOError in getModuleName");
        }
        return string;
    }

    protected static final short convertEndian(short s) {
        int n = s & 0xFFFF;
        int n2 = n << 8;
        int n3 = n >>> 8;
        short s2 = (short)(n2 + n3);
        return s2;
    }

    protected static final int convertEndian(int n) {
        return n >>> 24 | n << 24 | n << 8 & 0xFF0000 | n >> 8 & 0xFF00;
    }

    public static long longFromBytes(byte[] byArray, boolean bl) {
        long l = 0L;
        if (byArray.length != 8) {
            System.err.println("Invalid use of longFromBytes - 0 returned");
            return l;
        }
        byte[] byArray2 = new byte[]{byArray[0], byArray[1], byArray[2], byArray[3], byArray[4], byArray[5], byArray[6], byArray[7]};
        if (bl) {
            byArray2[0] = byArray[7];
            byArray2[1] = byArray[6];
            byArray2[2] = byArray[5];
            byArray2[3] = byArray[4];
            byArray2[4] = byArray[3];
            byArray2[5] = byArray[2];
            byArray2[6] = byArray[1];
            byArray2[7] = byArray[0];
        }
        for (int i = 0; i < 8; ++i) {
            l <<= 8;
            if (byArray2[i] < 0) {
                l = l + (long)byArray2[i] + 256L;
                continue;
            }
            l += (long)byArray2[i];
        }
        return l;
    }

    private void processUdStreams() {
        UserdumpHeader userdumpHeader = new UserdumpHeader();
        this.processUdMemory(userdumpHeader);
    }

    private void processMdStreams(MinidumpHeader minidumpHeader) {
        int n;
        try {
            this.seek(minidumpHeader.streamDirectoryRva);
            minidumpDirectoryElements = new MinidumpDirectoryElement[minidumpHeader.numberOfStreams];
            for (n = 0; n < minidumpHeader.numberOfStreams; ++n) {
                Windump.minidumpDirectoryElements[n] = new MinidumpDirectoryElement();
                Windump.minidumpDirectoryElements[n].streamType = Windump.convertEndian(this.readInt());
                Windump.minidumpDirectoryElements[n].dataSize = Windump.convertEndian(this.readInt());
                Windump.minidumpDirectoryElements[n].location = Windump.convertEndian(this.readInt());
                if (!verbose) continue;
                System.err.println("Stream Type:" + Windump.minidumpDirectoryElements[n].streamType + "\tdataSize: " + Windump.minidumpDirectoryElements[n].dataSize + "\tlocation: " + Windump.minidumpDirectoryElements[n].location + "\tdescription: " + MinidumpStreamTypes.getDescription(Windump.minidumpDirectoryElements[n].streamType));
            }
        }
        catch (IOException iOException) {
            System.err.println(" IOException whilst locating minidump streams");
            System.exit(1);
        }
        block11: for (n = 0; n < minidumpHeader.numberOfStreams; ++n) {
            switch (Windump.minidumpDirectoryElements[n].streamType) {
                case 9: {
                    this.processMemory64(n);
                    continue block11;
                }
                case 7: {
                    this.processSystemInfo(n);
                }
            }
        }
        block12: for (n = 0; n < minidumpHeader.numberOfStreams; ++n) {
            switch (Windump.minidumpDirectoryElements[n].streamType) {
                case 3: {
                    this.processThreads(n);
                    continue block12;
                }
                case 4: {
                    this.processModules(n);
                    continue block12;
                }
            }
        }
    }

    private void processThreads(int n) {
        try {
            this.seek(Windump.minidumpDirectoryElements[n].location);
            numberOfThreads = Windump.convertEndian(this.readInt());
            minidumpThreads = new MinidumpThread[numberOfThreads];
            if (verbose) {
                System.err.println("Number of threads = " + numberOfThreads);
            }
            for (int i = 0; i < numberOfThreads; ++i) {
                Windump.minidumpThreads[i] = new MinidumpThread();
                Windump.minidumpThreads[i].threadId = Windump.convertEndian(this.readInt());
                Windump.minidumpThreads[i].suspendCount = Windump.convertEndian(this.readInt());
                Windump.minidumpThreads[i].priorityClass = Windump.convertEndian(this.readInt());
                Windump.minidumpThreads[i].priority = Windump.convertEndian(this.readInt());
                byte[] byArray = new byte[8];
                this.read(byArray);
                Windump.minidumpThreads[i].teb = Windump.longFromBytes(byArray, true);
                this.read(byArray);
                Windump.minidumpThreads[i].stackStartOfMemoryRange = Windump.longFromBytes(byArray, true);
                Windump.minidumpThreads[i].stackDataSize = Windump.convertEndian(this.readInt());
                Windump.minidumpThreads[i].stackRva = Windump.convertEndian(this.readInt());
                Windump.minidumpThreads[i].contextDataSize = Windump.convertEndian(this.readInt());
                Windump.minidumpThreads[i].contextRva = Windump.convertEndian(this.readInt());
                if (verbose) {
                    System.err.println("Thread id: 0x" + Integer.toHexString(Windump.minidumpThreads[i].threadId));
                }
                GenericThread genericThread = new GenericThread("0x" + Integer.toHexString(Windump.minidumpThreads[i].threadId), Windump.minidumpThreads[i].stackStartOfMemoryRange, Windump.minidumpThreads[i].stackDataSize, Windump.minidumpThreads[i].stackRva);
                this.addressSpaces[0].getProcess(0).addThread(genericThread);
                if (this.bIs32Bit) {
                    this.createRegisters(genericThread, Windump.minidumpThreads[i].contextRva);
                } else {
                    this.createRegisters64(genericThread, Windump.minidumpThreads[i].contextRva);
                }
                Register register = genericThread.getNamedRegister("ebp");
                Register register2 = genericThread.getNamedRegister("esp");
                this.analyseStack(genericThread, register, register2);
            }
        }
        catch (IOException iOException) {
            System.err.println(" IOERROR in processThreads");
            System.exit(1);
        }
    }

    private void analyseStack(GenericThread genericThread, Register register, Register register2) {
        if (null == genericThread || null == register || null == register2) {
            return;
        }
        int n = genericThread.getStacksize();
        long l = genericThread.getStackstart();
        if (register.value < l) {
            return;
        }
        long l2 = 0L;
        try {
            l2 = this.getFilePointer();
            byte[] byArray = this.getMemoryBytes(l, n);
            boolean bl = false;
            int n2 = 0;
            long l3 = -1L;
            long l4 = register2.value - (long)(register.size / 8);
            n2 = (int)(register2.value - l);
            if (n2 >= 0) {
                l3 = this.readPtr(byArray, n2);
            }
            genericThread.addNativeFrame(new StackFrame(l4, l3));
            l4 = register.value;
            while (!bl) {
                n2 = (int)(l4 - l);
                if (n2 < 0 || n2 > n) {
                    bl = true;
                    continue;
                }
                long l5 = this.readPtr(byArray, n2);
                l3 = this.readPtr(byArray, n2 += register.size / 8);
                genericThread.addNativeFrame(new StackFrame(l4, l3));
                if (l4 == 0L || l5 < l && l5 == 0L || l5 > l + (long)n) {
                    bl = true;
                }
                l4 = l5;
            }
            this.seek(l2);
        }
        catch (Exception exception) {
            try {
                this.seek(l2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void createRegisters(GenericThread genericThread, long l) {
        try {
            long l2 = this.getFilePointer();
            this.seek(l);
            for (int i = 0; i < this.regNamesCount; ++i) {
                Register register = new Register(regNames[i], 32, Windump.convertEndian(this.readInt()));
                genericThread.addRegister(register);
            }
            this.seek(l2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        genericThread.context = new NativeThreadContext(32, 0L, genericThread.getNamedRegister("eip").getValue(), 0L, genericThread.getNamedRegister("esp").getValue(), genericThread.getNamedRegister("ebp").getValue());
    }

    private void createRegisters64(GenericThread genericThread, long l) {
        try {
            long l2 = this.getFilePointer();
            this.seek(l + 56L);
            for (int i = 0; i < 6; ++i) {
                Register register = new Register(regNames64[i], 16, Windump.convertEndian(this.readShort()));
                genericThread.addRegister(register);
            }
            Register register = new Register(regNames64[6], 32, Windump.convertEndian(this.readInt()));
            genericThread.addRegister(register);
            this.seek(this.getFilePointer() + 48L);
            for (int i = 0; i < 16; ++i) {
                Register register2 = new Register(regNames64[i + 7], 64, this.readLongEx());
                genericThread.addRegister(register2);
            }
            this.seek(l2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        genericThread.context = null;
    }

    private void processSystemInfo(int n) {
        try {
            byte by;
            this.seek(Windump.minidumpDirectoryElements[n].location);
            short s = Windump.convertEndian(this.readShort());
            short s2 = Windump.convertEndian(this.readShort());
            short s3 = Windump.convertEndian(this.readShort());
            byte by2 = this.readByte();
            this.processorCount = by2;
            byte by3 = by = this.readByte();
            this.processorType = s < 0 || s > MinidumpConstants.PROCESSOR_ARCH_STRING.length - 1 ? MinidumpConstants.PROCESSOR_ARCH_STRING[0] : MinidumpConstants.PROCESSOR_ARCH_STRING[s + 1];
            this.bIs32Bit = true;
            if (9 == s || 6 == s || 7 == s || 10 == s) {
                this.bIs32Bit = false;
            }
        }
        catch (IOException iOException) {
            System.err.println(" IOERROR in processSystemInfo");
            System.exit(1);
        }
    }

    private void processModules(int n) {
        Object object;
        try {
            this.seek(Windump.minidumpDirectoryElements[n].location);
            numberOfModules = Windump.convertEndian(this.readInt());
            minidumpModules = new MinidumpModule[numberOfModules];
            for (int i = 0; i < numberOfModules; ++i) {
                Windump.minidumpModules[i] = new MinidumpModule();
                object = new byte[8];
                this.read((byte[])object);
                Windump.minidumpModules[i].baseOfImage = Windump.longFromBytes((byte[])object, true);
                Windump.minidumpModules[i].sizeOfImage = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].checkSum = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].timeDateStamp = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].moduleNameRva = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].moduleName = this.getModuleName(Windump.minidumpModules[i].moduleNameRva);
                Windump.minidumpModules[i].versionInfoDwSignature = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].versionInfoDwStrucVersion = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].versionInfoDwFileVersionMS = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].versionInfoDwFileVersionLS = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].versionInfoDwProductVersionMS = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].versionInfoDwProductVersionLS = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].versionInfoDwFileFlagsMask = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].versionInfoDwFileFlags = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].versionInfoDwFileOS = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].versionInfoDwFileType = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].versionInfoDwFileSubtype = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].versionInfoDwFileDateMS = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].versionInfoDwFileDateLS = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].cvRecordDataSize = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].cvRecordDataRva = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].miscRecordDataSize = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].miscRecordDataRva = Windump.convertEndian(this.readInt());
                this.read((byte[])object);
                this.read((byte[])object);
            }
        }
        catch (IOException iOException) {
            System.err.println(" IOERROR in processModules");
            System.exit(1);
        }
        J9AddressSpace j9AddressSpace = this.getAddressSpace(this.getCurrentAS());
        object = j9AddressSpace.getProcess(j9AddressSpace.getCurrentProcess());
        for (int i = 0; i < numberOfModules; ++i) {
            ((J9Process)object).addModule(numberOfModules, i, Windump.minidumpModules[i].moduleName, Windump.minidumpModules[i].baseOfImage, Windump.minidumpModules[i].sizeOfImage);
        }
    }

    private void processUdMemory(UserdumpHeader userdumpHeader) {
        long l = 0L;
        long l2 = 0L;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        try {
            int n6;
            this.seek(userdumpHeader.regionOffset);
            memoryRanges = new MemoryRange[userdumpHeader.regionCount];
            boolean bl = true;
            int n7 = 0;
            for (n6 = 0; n6 < userdumpHeader.regionCount; ++n6) {
                l = Windump.convertEndian(this.readInt());
                l2 = Windump.convertEndian(this.readInt());
                n = Windump.convertEndian(this.readInt());
                n2 = Windump.convertEndian(this.readInt());
                n3 = Windump.convertEndian(this.readInt());
                n4 = Windump.convertEndian(this.readInt());
                n5 = Windump.convertEndian(this.readInt());
                if (bl) {
                    Windump.memoryRanges[n7] = new MemoryRange();
                }
                bl = false;
                if (0 == n7) {
                    memoryRanges[n7].setVaddr(l);
                    memoryRanges[n7].setFileoffset(userdumpHeader.dataOffset);
                    memoryRanges[n7].setSize(n2);
                    ++n7;
                    bl = true;
                    continue;
                }
                if (memoryRanges[n7 - 1].getVaddr() + memoryRanges[n7 - 1].getSize() == l) {
                    memoryRanges[n7 - 1].setSize(memoryRanges[n7 - 1].getSize() + (long)n2);
                    continue;
                }
                memoryRanges[n7].setFileoffset(memoryRanges[n7 - 1].getFileoffset() + memoryRanges[n7 - 1].getSize());
                memoryRanges[n7].setVaddr(l);
                memoryRanges[n7].setSize(n2);
                ++n7;
                bl = true;
            }
            numberOfMemoryRanges = n7;
            memoryRanges = this.reformMemoryRanges(memoryRanges, (int)numberOfMemoryRanges);
            if (verbose) {
                System.err.println("True number of memory sections = " + numberOfMemoryRanges);
                n6 = 0;
                while ((long)n6 < numberOfMemoryRanges) {
                    System.err.println("Memory: 0x" + Long.toHexString(memoryRanges[n6].getVaddr()) + "  \tlength: " + memoryRanges[n6].getSize() + " bytes    \toffsetInFile: 0x" + Long.toHexString(memoryRanges[n6].getFileoffset()));
                    ++n6;
                }
            }
        }
        catch (IOException iOException) {
            System.err.println(" IOERROR in processUdMemory");
            System.exit(1);
        }
    }

    private void processMemory64(int n) {
        try {
            this.seek(Windump.minidumpDirectoryElements[n].location);
            byte[] byArray = new byte[8];
            this.read(byArray);
            numberOfMemoryRanges = Windump.longFromBytes(byArray, true);
            this.read(byArray);
            baseRva = Windump.longFromBytes(byArray, true);
            memoryRanges = new MemoryRange[(int)numberOfMemoryRanges];
            long l = 0L;
            long l2 = 0L;
            int n2 = 0;
            boolean bl = true;
            int n3 = 0;
            while ((long)n3 < numberOfMemoryRanges) {
                if (bl) {
                    Windump.memoryRanges[n2] = new MemoryRange();
                }
                bl = false;
                this.read(byArray);
                l2 = Windump.longFromBytes(byArray, true);
                this.read(byArray);
                l = Windump.longFromBytes(byArray, true);
                if (0 == n2) {
                    memoryRanges[n2].setVaddr(l2);
                    memoryRanges[n2].setFileoffset(baseRva);
                    memoryRanges[n2].setSize(l);
                    ++n2;
                    bl = true;
                } else if (memoryRanges[n2 - 1].getVaddr() + memoryRanges[n2 - 1].getSize() == l2) {
                    memoryRanges[n2 - 1].setSize(memoryRanges[n2 - 1].getSize() + l);
                } else {
                    memoryRanges[n2].setFileoffset(memoryRanges[n2 - 1].getFileoffset() + memoryRanges[n2 - 1].getSize());
                    memoryRanges[n2].setVaddr(l2);
                    memoryRanges[n2].setSize(l);
                    ++n2;
                    bl = true;
                }
                ++n3;
            }
            numberOfMemoryRanges = n2;
            memoryRanges = this.reformMemoryRanges(memoryRanges, (int)numberOfMemoryRanges);
            if (verbose) {
                System.err.println("True number of memory sections = " + numberOfMemoryRanges);
                n3 = 0;
                while ((long)n3 < numberOfMemoryRanges) {
                    System.err.println("Memory: 0x" + Long.toHexString(memoryRanges[n3].getVaddr()) + "  \tlength: " + memoryRanges[n3].getSize() + " bytes    \toffsetInFile: 0x" + Long.toHexString(memoryRanges[n3].getFileoffset()));
                    ++n3;
                }
            }
        }
        catch (IOException iOException) {
            System.err.println(" IOERROR in processMemory64");
            System.exit(1);
        }
    }

    private MemoryRange[] reformMemoryRanges(MemoryRange[] memoryRangeArray, int n) {
        MemoryRange[] memoryRangeArray2 = new MemoryRange[n];
        for (int i = 0; i < n; ++i) {
            memoryRangeArray2[i] = memoryRangeArray[i];
        }
        return memoryRangeArray2;
    }

    protected MemoryRange[] getRawMemoryRanges() {
        return memoryRanges;
    }

    private String findCommandLine() {
        String string = "!!! Cannot establish Command Line !!!";
        try {
            long l = this.readPtr(2147348496L);
            if (-1L != l && 0L != this.seekToMemoryAddress(l + 64L)) {
                long l2;
                int n = this.readShortEx();
                short s = this.readShortEx();
                if (n > 1024) {
                    n = 1024;
                }
                if (n > 0 && -1L != (l2 = this.readPtr(l + 68L)) && 0L != this.seekToMemoryAddress(l2)) {
                    char[] cArray = new char[n / 2];
                    for (int i = 0; i < n / 2; ++i) {
                        cArray[i] = (char)Windump.convertEndian(this.readShort());
                    }
                    string = new String(cArray);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    public static Vector findDebugFiles(String string, Dump dump, boolean bl) {
        if (debugFiles != null) {
            return debugFiles;
        }
        debugFiles = new Vector();
        for (int i = 0; i < numberOfModules; ++i) {
            String string2 = Windump.minidumpModules[i].moduleName;
            debugFiles.add(string2);
        }
        return debugFiles;
    }

    static {
        verbose = false;
        debugFiles = null;
        regNames = new String[]{"contextFlags", "dr0", "dr1", "dr2", "dr3", "dr6", "dr7", "80387ControlWord", "80387StatusWord", "80387TagWord", "80387ErrorOffset", "80387ErrorSelector", "80387DataOffset", "80387DataSelector", "80387R0", "80387R1", "80387R2", "80387R3", "80387R4", "80387R5", "80387R6", "80387R7", "80387R8", "80387R9", "80387R10", "80387R11", "80387R12", "80387R13", "80387R14", "80387R15", "80387R16", "80387R17", "80387R18", "80387R19", "Cr0NpxState", "SegGs", "SegFs", "SegEs", "SegDs", "edi", "esi", "ebx", "edx", "ecx", "eax", "ebp", "eip", "SegCs", "eFlags", "esp", "SegSs"};
        regNames64 = new String[]{"SegCs", "SegDs", "SegEs", "SegFS", "SegGs", "SegSS", "EFlags", "Rax", "Rcx", "Rdx", "Rbx", "Rsp", "Rbp", "Rsi", "Rdi", "R8", "R9", "R10", "R11", "R12", "R13", "R14", "R15"};
        Dump.registerDumpSupport(Windump.class);
    }

    static final class MinidumpStreamTypes {
        static final int UNUSED = 0;
        static final int RESERVED0 = 1;
        static final int RESERVED1 = 2;
        static final int THREADLIST = 3;
        static final int MODULELIST = 4;
        static final int MEMORYLIST = 5;
        static final int EXCEPTIONLIST = 6;
        static final int SYSTEMINFO = 7;
        static final int THREADEXLIST = 8;
        static final int MEMORY64LIST = 9;
        static final int COMMENTSTREAMA = 10;
        static final int COMMENTSTREAMW = 11;
        static final int HANDLEDATA = 12;
        static final int FUNCTIONTABLE = 13;
        static final String[] descriptions = new String[]{"UNUSED", "RESERVED0", "RESERVED1", "THREADLIST", "MODULELIST", "MEMORYLIST", "EXCEPTIONLIST", "SYSTEMINFO", "THREADEXLIST", "MEMORY64LIST", "COMMENTSTREAMA", "COMMENTSTREAMW", "HANDLEDATA", "FUNCTIONTABLE"};

        MinidumpStreamTypes() {
        }

        static final String getDescription(int n) {
            if (n < 0 | n >= descriptions.length) {
                return " !!! Unrecognised Stream !!!";
            }
            return descriptions[n];
        }
    }

    static final class MinidumpConstants {
        static final int PROCESSOR_ARCHITECTURE_INTEL = 0;
        static final int PROCESSOR_ARCHITECTURE_MIPS = 1;
        static final int PROCESSOR_ARCHITECTURE_ALPHA = 2;
        static final int PROCESSOR_ARCHITECTURE_PPC = 3;
        static final int PROCESSOR_ARCHITECTURE_SHX = 4;
        static final int PROCESSOR_ARCHITECTURE_ARM = 5;
        static final int PROCESSOR_ARCHITECTURE_IA64 = 6;
        static final int PROCESSOR_ARCHITECTURE_ALPHA64 = 7;
        static final int PROCESSOR_ARCHITECTURE_MSIL = 8;
        static final int PROCESSOR_ARCHITECTURE_AMD64 = 9;
        static final int PROCESSOR_ARCHITECTURE_IA32_ON_WIN64 = 10;
        static final String[] PROCESSOR_ARCH_STRING = new String[]{"unknown", "Intel", "MIPS", "ALPHA", "PPC", "SHX", "ARM", "IA64", "ALPHA64", "MSIL", "AMD64", "IA32_ON_WIN64"};

        MinidumpConstants() {
        }
    }

    class UserdumpHeader {
        byte[] signature = new byte[8];
        int unknown1;
        int unknown2;
        int unknown3;
        int threadCount;
        int moduleCount;
        int regionCount;
        long contextOffset;
        long moduleOffset;
        long dataOffset;
        long regionOffset;
        long debugOffset;
        long threadOffset;
        long versionInfoOffset;

        UserdumpHeader() {
            try {
                Windump.this.seek(0L);
                Windump.this.read(this.signature);
                this.unknown1 = Windump.convertEndian(Windump.this.readInt());
                this.unknown2 = Windump.convertEndian(Windump.this.readInt());
                this.unknown3 = Windump.convertEndian(Windump.this.readInt());
                this.threadCount = Windump.convertEndian(Windump.this.readInt());
                this.moduleCount = Windump.convertEndian(Windump.this.readInt());
                this.regionCount = Windump.convertEndian(Windump.this.readInt());
                this.contextOffset = Windump.convertEndian(Windump.this.readInt());
                this.moduleOffset = Windump.convertEndian(Windump.this.readInt());
                this.dataOffset = Windump.convertEndian(Windump.this.readInt());
                this.regionOffset = Windump.convertEndian(Windump.this.readInt());
                this.debugOffset = Windump.convertEndian(Windump.this.readInt());
                this.threadOffset = Windump.convertEndian(Windump.this.readInt());
                this.versionInfoOffset = Windump.convertEndian(Windump.this.readInt());
                if (verbose) {
                    String string = new String(this.signature);
                    System.err.println("Sig: " + string + "  threads: " + this.threadCount + " threadOffset: 0x" + Long.toHexString(this.threadOffset) + "\nregions: " + this.regionCount + " regionOffset: 0x" + Long.toHexString(this.regionOffset) + " dataOffset: 0x" + Long.toHexString(this.dataOffset));
                }
            }
            catch (IOException iOException) {
                System.err.println("IOException");
            }
        }
    }

    class MinidumpHeader {
        byte[] signature = new byte[4];
        int version;
        int numberOfStreams;
        long streamDirectoryRva;
        int checkSum;
        int timeDateStamp;

        MinidumpHeader() {
            try {
                Windump.this.read(this.signature);
                String string = new String(this.signature);
                if (string.toUpperCase().equals("MDMP")) {
                    isMiniDump = true;
                    isWindowsDump = true;
                    this.version = Windump.convertEndian(Windump.this.readInt());
                    this.numberOfStreams = Windump.convertEndian(Windump.this.readInt());
                    this.streamDirectoryRva = Windump.convertEndian(Windump.this.readInt());
                    this.checkSum = Windump.convertEndian(Windump.this.readInt());
                    this.timeDateStamp = Windump.convertEndian(Windump.this.readInt());
                } else {
                    Windump.this.seek(0L);
                    this.signature = new byte[8];
                    Windump.this.read(this.signature);
                    string = new String(this.signature);
                    if (string.toUpperCase().equals("USERDUMP")) {
                        isMiniDump = false;
                        isWindowsDump = true;
                    } else {
                        isWindowsDump = false;
                    }
                }
            }
            catch (IOException iOException) {
                System.err.println("IOException");
            }
        }
    }

    class MinidumpDirectoryElement {
        int streamType;
        int dataSize;
        int location;

        MinidumpDirectoryElement() {
        }
    }

    class MinidumpThread {
        int threadId;
        int suspendCount;
        int priorityClass;
        int priority;
        long teb;
        long stackStartOfMemoryRange;
        int stackDataSize;
        int stackRva;
        int contextDataSize;
        int contextRva;

        MinidumpThread() {
        }
    }

    class MinidumpModule {
        long baseOfImage;
        int sizeOfImage;
        int checkSum;
        int timeDateStamp;
        int moduleNameRva;
        String moduleName;
        int versionInfoDwSignature;
        int versionInfoDwStrucVersion;
        int versionInfoDwFileVersionMS;
        int versionInfoDwFileVersionLS;
        int versionInfoDwProductVersionMS;
        int versionInfoDwProductVersionLS;
        int versionInfoDwFileFlagsMask;
        int versionInfoDwFileFlags;
        int versionInfoDwFileOS;
        int versionInfoDwFileType;
        int versionInfoDwFileSubtype;
        int versionInfoDwFileDateMS;
        int versionInfoDwFileDateLS;
        int cvRecordDataSize;
        int cvRecordDataRva;
        int miscRecordDataSize;
        int miscRecordDataRva;
        long reserved0;
        long reserved1;

        MinidumpModule() {
        }
    }
}

