/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.systemdump;

import com.ibm.jvm.j9.dump.commandconsole.Console;
import com.ibm.jvm.j9.dump.commandconsole.DumpConsole;
import com.ibm.jvm.j9.dump.commandconsole.DumpUtils;
import com.ibm.jvm.j9.dump.commandconsole.J9JVMConsole;
import com.ibm.jvm.j9.dump.commandconsole.J9JVMUtils;
import com.ibm.jvm.j9.dump.systemdump.ClassField;
import com.ibm.jvm.j9.dump.systemdump.Dump;
import com.ibm.jvm.j9.dump.systemdump.J9ConstantPool;
import com.ibm.jvm.j9.dump.systemdump.J9FieldIterator;
import com.ibm.jvm.j9.dump.systemdump.J9Method;
import com.ibm.jvm.j9.dump.systemdump.J9Static;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

public class J9Class {
    private static int ptrSize = 0;
    private Vector fields;
    private Vector methods;
    private Vector statics;
    private int modifiers;
    private String name;
    private String id;
    private long address;
    private String superId;
    private int instanceSize;
    private String loader;
    private boolean isLittleEndian;
    private Vector inheritanceChain;
    private boolean bInheritanceChainProcessed;
    private boolean isArrayClass;
    private J9ArrayClass arrayClass = null;
    private static ArrayList arrayClassReworkList = new ArrayList();
    private J9ConstantPool constantPool;
    private Vector interfaces;
    private boolean isPrimitiveClass;
    private byte primitiveClassType;
    private int arrayElementSize = 0;
    public static final String[] primativeClasses = new String[]{"int", "char", "boolean", "long", "short", "byte", "float", "double"};
    private static final int[] primativeSizes = new int[]{4, 2, 1, 8, 2, 1, 4, 8};
    private static final byte[] primativeTypes = new byte[]{6, 1, 0, 7, 5, 4, 2, 3};
    private int[] referenceOffsets;
    private boolean bRefOffsetsProcessed = false;

    public J9Class(String string, String string2, String string3, String string4, String string5, String string6) {
        this.name = string;
        if (-1 == this.name.indexOf(47)) {
            this.arrayElementSize = this.testPrimitive();
            if (0 != this.arrayElementSize) {
                this.isPrimitiveClass = true;
                this.primitiveClassType = this.setPrimitiveClassType();
            } else {
                this.arrayElementSize = -1;
            }
        } else {
            this.arrayElementSize = -1;
        }
        this.id = string2;
        this.address = DumpUtils.parseLongHex(DumpUtils.stripOff0x(this.id));
        this.superId = string3;
        this.instanceSize = Integer.parseInt(string4);
        this.loader = string5;
        this.fields = new Vector();
        this.methods = new Vector();
        this.statics = new Vector();
        this.interfaces = new Vector();
        this.isLittleEndian = DumpConsole.getTheDump().isLittleEndian();
        if (string6 != null) {
            if ((string6 = DumpUtils.stripOff0x(string6)).length() == 8) {
                string6 = string6.substring(1);
            }
            this.modifiers = Integer.parseInt(string6, 16);
        }
    }

    protected J9Class(String string, String string2, String string3, String string4, String string5, boolean bl) {
        this.name = string;
        this.id = string2;
        this.address = DumpUtils.parseLongHex(DumpUtils.stripOff0x(this.id));
        this.superId = string3;
        this.instanceSize = Integer.parseInt(string4);
        this.loader = string5;
        this.fields = new Vector();
        this.methods = new Vector();
        this.statics = new Vector();
        this.isLittleEndian = bl;
    }

    public J9Class(String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl, String string8) {
        this.name = string;
        this.id = string2;
        if (string8 != null) {
            if ((string8 = DumpUtils.stripOff0x(string8)).length() == 8) {
                string8 = string8.substring(1);
            }
            this.modifiers = Integer.parseInt(string8, 16);
        }
        this.address = DumpUtils.parseLongHex(DumpUtils.stripOff0x(this.id));
        this.isLittleEndian = DumpConsole.getTheDump().isLittleEndian();
        this.arrayClass = new J9ArrayClass(string3, string4, string5, string6, string7, bl, this);
        this.isArrayClass = true;
    }

    public void addField(String string, String string2, String string3, String string4, String string5) {
        String string6 = null;
        if (!string.equals(this.id)) {
            string6 = string;
        }
        this.fields.add(new ClassField(string6, string2, string3, string4, string5));
    }

    public void addMethod(J9Method j9Method) {
        this.methods.add(j9Method);
    }

    public void addConstantPool(J9ConstantPool j9ConstantPool) {
        this.constantPool = j9ConstantPool;
    }

    public void addStatic(J9Static j9Static) {
        this.statics.add(j9Static);
    }

    public J9FieldIterator getFieldIterator(J9Class j9Class) {
        J9FieldIterator j9FieldIterator = new J9FieldIterator(j9Class);
        return j9FieldIterator;
    }

    public String getId() {
        return this.id;
    }

    public long getClassAddress() {
        return this.address;
    }

    public int getInstanceSize() {
        return this.instanceSize;
    }

    public String getLoader() {
        return this.loader;
    }

    public String getName() {
        if (null == this.name || this.isArrayClass) {
            if (this.isArrayClass) {
                String string = this.name;
                this.name = "[";
                for (int i = 1; i < this.arrayClass.arity; ++i) {
                    this.name = this.name + "[";
                }
                long l = this.getLeaf();
                if (l != 0L) {
                    J9Class j9Class = J9JVMUtils.findClass(l);
                    this.name = j9Class != null ? this.name + j9Class.getName() : string;
                    return this.name;
                }
                this.name = null;
            }
            return "!Unknown!";
        }
        return this.name;
    }

    public String getSuperId() {
        return this.superId;
    }

    public String toString() {
        int n;
        this.findInheritanceChain();
        StringBuffer stringBuffer = new StringBuffer("\nname = " + this.name + "  id = " + this.id + " superId = " + this.superId + "  instanceSize = " + this.instanceSize + "  loader = " + this.loader + "\n");
        if (this.modifiers != 0) {
            stringBuffer.append("\tmodifiers: " + ClassField.convertModifier(this.modifiers) + "\n");
        }
        if ((n = this.inheritanceChain.size()) > 0) {
            stringBuffer.append("\tInheritance chain....\n");
            for (int i = n; i > -1; --i) {
                for (int j = n - i + 2; j > 0; --j) {
                    stringBuffer.append("\t");
                }
                if (i != 0) {
                    stringBuffer.append(this.inheritanceChain.get(i - 1));
                } else {
                    stringBuffer.append(this.name);
                }
                stringBuffer.append("\n");
            }
        }
        Iterator iterator = null;
        if (null != this.fields) {
            iterator = this.fields.iterator();
            stringBuffer.append("\n\tFields......\n");
            while (iterator.hasNext()) {
                ClassField classField = (ClassField)iterator.next();
                stringBuffer.append("\t" + classField.toString() + "\n");
            }
        }
        if (null != this.statics) {
            iterator = this.statics.iterator();
            stringBuffer.append("\n\tStatics......\n");
            while (iterator.hasNext()) {
                J9Static j9Static = (J9Static)iterator.next();
                stringBuffer.append("\t" + j9Static.toString() + "\n");
            }
        }
        if (null != this.statics) {
            iterator = this.methods.iterator();
            stringBuffer.append("\n\tMethods......\n");
            while (iterator.hasNext()) {
                J9Method j9Method = (J9Method)iterator.next();
                stringBuffer.append("\t" + j9Method.toString() + "\n");
            }
        }
        return stringBuffer.toString();
    }

    private int testPrimitive() {
        for (int i = 0; i < primativeClasses.length; ++i) {
            if (!this.name.equals(primativeClasses[i])) continue;
            return primativeSizes[i];
        }
        return 0;
    }

    private byte setPrimitiveClassType() {
        byte by = -1;
        for (int i = 0; i < primativeClasses.length; ++i) {
            if (!this.name.equals(primativeClasses[i])) continue;
            by = (byte)i;
            return by;
        }
        return by;
    }

    public Vector getFields() {
        return this.fields;
    }

    public int getFieldOffset(String string) {
        int n = -1;
        int n2 = this.fields.size();
        if (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                ClassField classField = (ClassField)this.fields.get(i);
                if (!classField.getFieldName().equals(string)) continue;
                return classField.getOffset();
            }
        }
        return n;
    }

    public int[] getReferenceOffsets() {
        if (!this.bRefOffsetsProcessed) {
            int n;
            int n2 = this.getFieldCount();
            int[] nArray = new int[n2];
            int n3 = 0;
            for (n = 0; n < n2; ++n) {
                String string = ((ClassField)this.fields.get(n)).getSignature();
                if (!string.startsWith("L")) continue;
                nArray[n3] = ((ClassField)this.fields.get(n)).getOffset();
                ++n3;
            }
            this.bRefOffsetsProcessed = true;
            if (n3 > 0) {
                this.referenceOffsets = new int[n3];
                for (n = 0; n < n3; ++n) {
                    this.referenceOffsets[n] = nArray[n];
                }
            }
        }
        return this.referenceOffsets;
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    public String formatObject(long l) {
        StringBuffer stringBuffer;
        block7: {
            stringBuffer = new StringBuffer();
            byte[] byArray = new byte[this.instanceSize];
            Dump dump = DumpConsole.getTheDump();
            if (dump.seekToMemoryAddress(l) > 0L) {
                try {
                    int n = dump.readEx(byArray);
                    if (this.instanceSize == n) {
                        for (ClassField classField : this.fields) {
                            if (0 == ptrSize) {
                                ptrSize = dump.is32bit() ? 4 : 8;
                            }
                            stringBuffer = stringBuffer.append("\n\t" + classField.formatField(byArray, this.isLittleEndian, ptrSize));
                        }
                        break block7;
                    }
                    stringBuffer.append("Could not read enough memory at address 0x" + Long.toHexString(l));
                }
                catch (IOException iOException) {
                    stringBuffer.append("IOException reading memory for address 0x" + Long.toHexString(l));
                }
            } else {
                stringBuffer.append("Unable to read memory for address 0x" + Long.toHexString(l));
            }
        }
        return stringBuffer.toString();
    }

    private void findInheritanceChain() {
        if (!this.bInheritanceChainProcessed) {
            this.bInheritanceChainProcessed = true;
            this.inheritanceChain = new Vector();
            J9Class j9Class = this;
            String string = j9Class.getSuperId();
            while (string != null) {
                long l = DumpUtils.parseLongHex(DumpUtils.stripOff0x(string));
                j9Class = J9JVMConsole.getClass(l);
                if (null != j9Class) {
                    string = j9Class.getSuperId();
                    this.inheritanceChain.add(j9Class.name);
                    continue;
                }
                string = null;
            }
        }
    }

    public Vector getStatics() {
        return this.statics;
    }

    public boolean isArrayClass() {
        return this.isArrayClass;
    }

    public byte getArrayType() {
        return this.primitiveClassType;
    }

    public int getArity() {
        if (null == this.arrayClass) {
            return -1;
        }
        return this.arrayClass.arity;
    }

    public int getFirstElementOffset() {
        if (null == this.arrayClass) {
            return -1;
        }
        return this.arrayClass.firstElementOffset;
    }

    public int getSizeOffset() {
        if (null != this.arrayClass) {
            return this.arrayClass.sizeOffset;
        }
        if (this.name.equals("java/lang/Class")) {
            return this.instanceSize;
        }
        return -1;
    }

    public int getSizeBytes() {
        if (null == this.arrayClass) {
            return -1;
        }
        return this.arrayClass.sizeOffset;
    }

    public boolean isSizedAsElements() {
        if (null == this.arrayClass) {
            return false;
        }
        return this.arrayClass.bSizedAsElements;
    }

    public long getLeaf() {
        if (null == this.arrayClass) {
            return -1L;
        }
        return this.arrayClass.leaf;
    }

    public int getArrayElementSize() {
        return this.arrayElementSize;
    }

    public boolean isPrimitiveClass() {
        return this.isPrimitiveClass;
    }

    public boolean isPrimitiveArray() {
        if (null == this.arrayClass) {
            return false;
        }
        return this.arrayClass.isPrimitiveArray;
    }

    public Vector getMethods() {
        return this.methods;
    }

    public static void reworkArrayClassReworkList() {
        for (J9ArrayClass j9ArrayClass : arrayClassReworkList) {
            J9Class j9Class = J9JVMConsole.getClass(j9ArrayClass.leaf);
            if (null == j9Class) {
                Console.reportError("Array object has leafClass (leafIn) that was not found in the dump (xml error)", null);
                continue;
            }
            if (j9Class.isPrimitiveClass()) {
                j9ArrayClass.isPrimitiveArray = true;
                continue;
            }
            j9ArrayClass.myClass.arrayElementSize = -1;
        }
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public J9ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public Vector getInterfaces() {
        return this.interfaces;
    }

    public void addInterface(String string) {
        this.interfaces.add(string);
    }

    class J9ArrayClass {
        long leaf = 0L;
        int arity;
        int firstElementOffset;
        int sizeOffset;
        int sizeBytes;
        boolean bSizedAsElements;
        boolean isPrimitiveArray;
        J9Class myClass;

        J9ArrayClass(String string, String string2, String string3, String string4, String string5, boolean bl, J9Class j9Class2) {
            this.myClass = j9Class2;
            if (string != null) {
                this.leaf = DumpUtils.parseLongHex(DumpUtils.stripOff0x(string));
                J9Class j9Class3 = J9JVMConsole.getClass(this.leaf);
                if (null == j9Class3) {
                    arrayClassReworkList.add(this);
                } else if (j9Class3.isPrimitiveClass()) {
                    this.isPrimitiveArray = true;
                } else {
                    J9Class.this.arrayElementSize = -1;
                }
            } else {
                Console.reportError("Arrayclass element in xml has no leafClass in xml metadata", null);
            }
            this.arity = Integer.parseInt(DumpUtils.stripOff0x(string2), 16);
            this.firstElementOffset = Integer.parseInt(string3);
            this.sizeOffset = Integer.parseInt(string4);
            this.sizeBytes = Integer.parseInt(string5);
            this.bSizedAsElements = bl;
        }
    }
}

