/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.command.trace;

import com.ibm.jvm.format.TraceFormat;
import com.ibm.jvm.j9.dump.command.DumpBaseCmds;
import com.ibm.jvm.j9.dump.command.J9JVMBaseCmds;
import com.ibm.jvm.j9.dump.command.trace.J9TraceFormatterListener;
import com.ibm.jvm.j9.dump.commandconsole.Console;
import com.ibm.jvm.j9.dump.commandconsole.J9JVMConsole;
import com.ibm.jvm.j9.dump.systemdump.Dump;
import com.ibm.jvm.j9.dump.systemdump.J9TraceBuffer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class J9JVMBaseTraceCommands {
    private static Dump theDump;
    private static J9JVMBaseCmds caller;
    private static String snapTraceFileName;
    private static String snapTraceOutputFileName;
    private static String snapTraceInfoFileName;
    private static String savedFileName;
    private static int waitFlag;
    private static boolean verbose;
    private static int traceOutStart;
    private static int traceOutPage;
    public static final String FAIL_STRING = "Failed";
    public static final String NO_TRACE_BUFFERS = "No Buffers";

    public J9JVMBaseTraceCommands(J9JVMBaseCmds j9JVMBaseCmds) {
        theDump = DumpBaseCmds.getTheDump();
        caller = j9JVMBaseCmds;
    }

    public String traceFormat(String string) {
        String string2 = FAIL_STRING;
        if (!this.isTraceEnabled()) {
            caller.notifyObservers("\nCannot format trace - There are no trace buffers in this dump.");
        } else {
            if (snapTraceFileName == null) {
                string2 = this.traceExtract(null);
                caller.notifyObservers("\n\n");
            }
            if (!string2.equals(FAIL_STRING)) {
                int n;
                String[] stringArray;
                string2 = FAIL_STRING;
                if (Console.getProperty("TRACE_DATADIR") == null || Console.getProperty("TRACE_DATADIR").toUpperCase().equals("NULL")) {
                    stringArray = theDump.getDumpName();
                    n = stringArray.lastIndexOf("\\");
                    if (-1 == n) {
                        n = stringArray.lastIndexOf("/");
                    }
                    if (-1 != n) {
                        String string3 = stringArray.substring(0, n + 1);
                        String string4 = string3.concat("J9TraceFormat.dat");
                        String string5 = string3.concat("TraceFormat.dat");
                        File file = new File(string4);
                        if (file.exists() && (file = new File(string5)).exists()) {
                            this.traceDatadir(string3);
                        }
                    }
                }
                caller.notifyObservers("Running Trace Formatter\n=======================");
                if (snapTraceFileName != null) {
                    stringArray = this.buildFormatArgs();
                    caller.notifyObservers("input file:   \"" + stringArray[0] + "\"");
                    caller.notifyObservers("output file:  \"" + stringArray[1] + "\"");
                    for (n = 2; n < stringArray.length; ++n) {
                        caller.notifyObservers("option:       " + stringArray[n]);
                    }
                    caller.notifyObservers("\n\n");
                    string2 = this.doTraceFormat(stringArray);
                } else {
                    caller.notifyObservers("\nERROR: Problem reading extracted trace file.\n");
                }
            }
        }
        return string2;
    }

    public String traceExtract(String string) {
        String string2 = FAIL_STRING;
        if (this.isTraceEnabled()) {
            caller.notifyObservers("\nRunning Dump Extractor\n======================");
            if (snapTraceFileName == null) {
                string2 = this.doCreateTraceFile();
            } else {
                caller.notifyObservers("\nThe file already exists and will be used.\nThe trace filename is: \"" + snapTraceFileName + "\"");
                string2 = snapTraceFileName;
            }
        } else {
            caller.notifyObservers("\nCannot Extract - There are no trace buffers in this dump.");
            string2 = "NoBuffers";
        }
        return string2;
    }

    public String traceSummary(String string) {
        String string2 = null;
        caller.notifyObservers("Display Trace Summary\n=====================\n");
        if (snapTraceFileName != null) {
            String[] stringArray = new String[]{snapTraceFileName, snapTraceFileName + ".tmp", "-summary"};
            this.doTraceFormat(stringArray);
        } else {
            caller.notifyObservers("\nThe trace file must already exist before the TRACE SUMMARY command is run.\n(Use TRACE EXTRACT or TRACE FORMAT before running TRACE SUMMARY).");
        }
        return string2;
    }

    public String traceDisplay(String string) {
        String string2 = null;
        if (snapTraceOutputFileName == null) {
            caller.notifyObservers("Unable to comply - trace must first be formatted.");
            return null;
        }
        if (string == null || string.equals("")) {
            this.displayFile(snapTraceOutputFileName, traceOutStart, traceOutStart + traceOutPage - 1);
        } else if (string.length() > 5 && string.toUpperCase().substring(0, 5).equals("PAGE ")) {
            String string3 = new String(string.substring(5));
            Integer n = new Integer(string3);
            if (n >= 5 && n <= 10001) {
                caller.notifyObservers("\nPage size set to " + n);
                traceOutPage = n;
            } else {
                caller.notifyObservers("\nERROR: Page size must be between 5 and 10000.");
            }
        } else if (string.toUpperCase().equals("ALL")) {
            caller.notifyObservers("");
            this.displayFile(snapTraceOutputFileName, 1, 1000000);
        } else if (string.substring(0, 1).equals("+")) {
            caller.notifyObservers("");
            if (!this.displayFile(snapTraceOutputFileName, traceOutStart += traceOutPage, traceOutStart + traceOutPage - 1) && (traceOutStart -= traceOutPage) < 1) {
                traceOutStart = 1;
            }
        } else if (string.substring(0, 1).equals("-")) {
            if ((traceOutStart -= traceOutPage) < 1) {
                traceOutStart = 1;
            }
            caller.notifyObservers("");
            this.displayFile(snapTraceOutputFileName, traceOutStart, traceOutStart + traceOutPage - 1);
        } else {
            caller.notifyObservers("Usage Error:\n   TRACE DISPLAY [ + | - | ALL ]");
        }
        return string2;
    }

    public String traceThreads(String string) {
        String string2 = null;
        Object var3_3 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = true;
        caller.notifyObservers("Display Threads\n===============\n");
        if (snapTraceFileName == null) {
            caller.notifyObservers("The trace file does not exist so threads cannot be displayed.\n(Use TRACE FORMAT or EXTRACT before running TRACE THREADS).");
            bl = false;
        }
        if (bl && snapTraceInfoFileName == null) {
            this.cacheSummaryInfo();
        }
        boolean bl2 = false;
        String string3 = null;
        BufferedReader bufferedReader = null;
        if (bl) {
            try {
                bufferedReader = new BufferedReader(new FileReader(snapTraceFileName + ".info"));
                while (bufferedReader.ready()) {
                    string3 = bufferedReader.readLine();
                    if (bl2) {
                        if (string3.trim().toUpperCase().equals("")) {
                            bl2 = false;
                        } else {
                            String string4 = string3.trim();
                            caller.notifyObservers("THREAD: 0x" + string4);
                            String string5 = new String("0x" + string4.substring(0, string4.indexOf(" "))).toUpperCase();
                            arrayList.add(string5);
                        }
                    }
                    if (!string3.trim().toUpperCase().equals("ACTIVE THREADS :")) continue;
                    bl2 = true;
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                caller.notifyObservers("ERROR: Unexpected exception reading " + snapTraceFileName + ".info " + "(" + exception + ", " + exception.getMessage() + ")");
                exception.printStackTrace();
            }
        }
        caller.notifyObservers(" ");
        if (string == null) {
            this.checkThreadArgs("NONE", arrayList, bl);
        } else {
            this.checkThreadArgs(string, arrayList, bl);
        }
        return string2;
    }

    public String traceEntries(String string) {
        String string2 = null;
        caller.notifyObservers("Query/Set Entries Option\n========================\n");
        if (string == null) {
            String string3 = null;
            try {
                string3 = Console.getProperty("TRACE_ENTRIES");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (null == string3) {
                string3 = "ALL";
            }
            caller.notifyObservers("TRACE_ENTRIES = " + string3);
        } else {
            String string4;
            StringTokenizer stringTokenizer;
            boolean bl = true;
            if (!string.toUpperCase().equals("ALL")) {
                stringTokenizer = new StringTokenizer(string, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    string4 = stringTokenizer.nextToken().toLowerCase();
                    StringTokenizer stringTokenizer2 = J9JVMBaseTraceCommands.getValidTraceEntries();
                    boolean bl2 = false;
                    while (stringTokenizer2.hasMoreTokens() && !bl2) {
                        String string5 = stringTokenizer2.nextToken().toLowerCase();
                        if (!string4.equals(string5)) continue;
                        bl2 = true;
                    }
                    if (bl2) continue;
                    caller.notifyObservers("ERROR: invalid token - " + string4 + "\n");
                    bl = false;
                }
            }
            if (bl) {
                Console.setProperty("TRACE_ENTRIES", string.toUpperCase());
                caller.notifyObservers("TRACE_ENTRIES = " + Console.getProperty("TRACE_ENTRIES"));
            } else {
                stringTokenizer = J9JVMBaseTraceCommands.getValidTraceEntries();
                string4 = "Allowed options are:";
                while (stringTokenizer.hasMoreTokens()) {
                    string4 = string4 + "\n\t" + stringTokenizer.nextToken();
                }
                caller.notifyObservers(string4);
                caller.notifyObservers("\nTRACE_ENTRIES = " + Console.getProperty("TRACE_ENTRIES") + " (unchanged)");
            }
        }
        return string2;
    }

    public String traceIVS(String string, String string2) {
        String string3 = null;
        caller.notifyObservers("Query/Set Formatted Trace Options\n=================================\n");
        string = string.toUpperCase();
        if (string.equals("SYMBOLIC") || string.equals("VERBOSE") || string.equals("INDENT")) {
            this.doTraceCMD("TRACE_" + string, string2);
        } else {
            caller.notifyObservers("Usage error:\n   unrecognised TRACE option: " + string);
        }
        return string3;
    }

    private void doTraceCMD(String string, String string2) {
        if (string2 == null) {
            String string3 = null;
            string3 = Console.getProperty(string);
            if (null == string3) {
                string3 = "false";
            }
            caller.notifyObservers(string + " = " + string3);
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
            if (stringTokenizer.countTokens() == 2) {
                stringTokenizer.nextToken();
                string2 = stringTokenizer.nextToken();
            }
            try {
                if (string2.toUpperCase().equals("TRUE")) {
                    Console.setProperty(string, "true");
                    caller.notifyObservers(string + " = true");
                    if (string.toUpperCase().equals("VERBOSE")) {
                        verbose = true;
                    }
                } else if (string2.toUpperCase().equals("FALSE")) {
                    Console.setProperty(string, "false");
                    caller.notifyObservers(string + " = false");
                    if (string.toUpperCase().equals("VERBOSE")) {
                        verbose = false;
                    }
                } else {
                    caller.notifyObservers("Usage Error:\n   TRACE " + string.substring(6, string.length()) + " true|false");
                }
            }
            catch (Exception exception) {
                caller.notifyObservers("ERROR: Exception setting TRACE_" + string + " (" + exception.getMessage() + ")");
            }
        }
    }

    public String traceDatadir(String string) {
        String string2;
        Object object;
        String string3 = null;
        caller.notifyObservers("Query/Set Data directory\n========================\n");
        if (string != null) {
            if (string.equals("NULL")) {
                Console.setProperty("TRACE_DATADIR", "NULL");
                caller.notifyObservers("TRACE_DATADIR property cleared.\n");
            } else {
                if (string != null && string.indexOf(" ") != -1) {
                    string = string.substring(0, string.indexOf(" "));
                }
                caller.notifyObservers("attempting to set TRACE_DATADIR to:\n   " + string);
                object = new File(string);
                string2 = new String(object + System.getProperty("file.separator") + "TraceFormat.dat");
                if (((File)object).exists() && ((File)object).isDirectory() && new File(string2).exists()) {
                    Console.setProperty("TRACE_DATADIR", string);
                    caller.notifyObservers("TRACE_DATADIR set to:\n   " + string + "\n");
                } else {
                    caller.notifyObservers("ERROR: TraceFormat.dat cannot be found in the specified directory.\n");
                }
            }
        }
        object = null;
        if (Console.getProperty("TRACE_DATADIR").toUpperCase().equals("NULL")) {
            string2 = System.getProperty("java.home");
            string2 = string2.concat(File.separator).concat("lib");
            object = System.getProperty("ibm.dg.trc.format", string2);
        } else {
            object = Console.getProperty("TRACE_DATADIR");
        }
        caller.notifyObservers("Trace formatter will use TraceFormat.dat from:\n   " + (String)object);
        return string3;
    }

    public String traceSet(String string) {
        Object object;
        String string2;
        String string3;
        Object object2;
        String string4 = null;
        caller.notifyObservers("OPTIONS FOR TRACE FORMATTER\n===========================\n");
        if (string != null) {
            object2 = new StringTokenizer(string, "= ");
            while (((StringTokenizer)object2).hasMoreTokens()) {
                string3 = null;
                string2 = null;
                if (((StringTokenizer)object2).hasMoreTokens()) {
                    string3 = ((StringTokenizer)object2).nextToken().toUpperCase();
                }
                if (((StringTokenizer)object2).hasMoreTokens()) {
                    string2 = ((StringTokenizer)object2).nextToken();
                }
                if (string3 == null || string2 == null) {
                    caller.notifyObservers("Usage Error:\n   TRACE SET [<option>=<value>]");
                    continue;
                }
                if (string3.equals("VERBOSE") || string3.equals("SYMBOLIC") || string3.equals("INDENT") || string3.equals("ENTRIES") || string3.equals("OUTFILENAME") || string3.equals("THREADS") || string3.equals("DATADIR")) {
                    if (string3.equals("VERBOSE")) {
                        this.traceIVS("VERBOSE", string);
                    }
                    if (string3.equals("INDENT")) {
                        this.traceIVS("INDENT", string);
                    }
                    if (string3.equals("SYMBOLIC")) {
                        this.traceIVS("SYMBOLIC", string);
                    }
                    if (string3.equals("THREADS")) {
                        this.traceThreads(string);
                    }
                    if (string3.equals("ENTRIES")) {
                        this.traceEntries(string);
                    }
                    if (string3.equals("OUTFILENAME")) {
                        this.traceOutfilename(string);
                    }
                    if (!string3.equals("DATADIR")) continue;
                    this.traceDatadir(string);
                    continue;
                }
                caller.notifyObservers("Usage Error:\n   TRACE SET [<OUTFILENAME|THREADS|SYMBOLIC|INDENT|ENTRIES|VERBOSE|<DATADIR>>=<value>]");
            }
        }
        object2 = J9JVMConsole.getProperty("dump");
        string3 = Console.getProperty("WORKDIR");
        if (null != string3) {
            string2 = Console.getProperty("dump");
            object = new File(string2);
            object2 = string3 + File.separator + ((File)object).getName();
        }
        caller.notifyObservers("\nTRACE_INFILENAME  = \"" + (String)object2 + ".trc\"  ");
        string2 = Console.getProperty("TRACE_OUTFILENAME");
        if (null == string2) {
            string2 = "NULL";
        }
        if (string2.toUpperCase().equals("NULL")) {
            string2 = "<not set - will default to \"" + (String)object2 + ".trc.fmt\">";
        }
        caller.notifyObservers("TRACE_OUTFILENAME = " + string2);
        string2 = Console.getProperty("TRACE_THREADS");
        if (null == string2) {
            string2 = "NULL";
        }
        if (string2.toUpperCase().equals("NULL")) {
            string2 = "<not set - will default to ALL>";
        }
        caller.notifyObservers("TRACE_THREADS     = " + string2);
        string2 = Console.getProperty("TRACE_SYMBOLIC");
        if (null == string2) {
            string2 = "NULL";
        }
        if (string2.toUpperCase().equals("NULL")) {
            string2 = "<not set - will default to false>";
        }
        caller.notifyObservers("TRACE_SYMBOLIC    = " + string2);
        string2 = Console.getProperty("TRACE_INDENT");
        if (null == string2) {
            string2 = "NULL";
        }
        if (string2.toUpperCase().equals("NULL")) {
            string2 = "<not set - will default to false>";
        }
        caller.notifyObservers("TRACE_INDENT      = " + string2);
        string2 = Console.getProperty("TRACE_ENTRIES");
        if (null == string2) {
            string2 = "NULL";
        }
        if (string2.toUpperCase().equals("NULL")) {
            string2 = "<not set - will default to ALL>";
        }
        caller.notifyObservers("TRACE_ENTRIES     = " + string2);
        string2 = Console.getProperty("TRACE_VERBOSE");
        if (null == string2) {
            string2 = "NULL";
        }
        if (string2.toUpperCase().equals("NULL")) {
            string2 = "<not set - will default to false>";
        }
        caller.notifyObservers("TRACE_VERBOSE     = " + string2);
        string2 = Console.getProperty("TRACE_DATADIR");
        if (null == string2) {
            string2 = "NULL";
        }
        if (string2.toUpperCase().equals("NULL")) {
            object = System.getProperty("java.home");
            object = ((String)object).concat(File.separator).concat("lib");
            string2 = System.getProperty("ibm.dg.trc.format", (String)object);
            string2 = "<not set - will default to:\n                    " + string2 + ">";
        }
        caller.notifyObservers("TRACE_DATADIR     = " + string2);
        return string4;
    }

    public String traceOutfilename(String string) {
        String string2 = null;
        caller.notifyObservers("Query/Set Formatted Trace File Name\n===================================\n");
        if (string == null) {
            String string3 = null;
            try {
                string3 = Console.getProperty("TRACE_OUTFILENAME");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string3 == null) {
                string3 = "extracted.trc.fmt";
            }
            caller.notifyObservers("trace out file name = \"" + string3 + "\"");
        } else {
            try {
                Console.setProperty("TRACE_OUTFILENAME", string);
                caller.notifyObservers("TRACE_OUTFILENAME = " + string);
            }
            catch (Exception exception) {
                caller.notifyObservers("ERROR: Exception setting TRACE_OUTFILENAME (" + exception.getMessage() + ")");
            }
        }
        caller.notifyObservers("\nNOTE - Embedding %T in an outfilename, e.g.: \"TRACE OUTFILENAME thread.%T.fmt\"\n       will cause the threadid to be inserted at that point when tracing a\n       single thread.");
        return string2;
    }

    private boolean isTraceEnabled() {
        return J9JVMConsole.getTraceBuffers().size() > 0;
    }

    private String doCreateTraceFile() {
        Object object;
        String string;
        String string2 = FAIL_STRING;
        caller.notifyObservers("Processing Trace File Header\n----------------------------");
        try {
            string = Console.getProperty("TRACE_VERBOSE");
            verbose = string.toUpperCase().equals("TRUE");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        string = Console.getProperty("WORKDIR");
        if (null == string) {
            snapTraceFileName = J9JVMConsole.getProperty("dump") + ".trc";
        } else {
            object = Console.getProperty("dump");
            File file = new File((String)object);
            snapTraceFileName = string + File.separator + file.getName() + ".trc";
        }
        try {
            object = new File(snapTraceFileName);
            ((File)object).createNewFile();
        }
        catch (Exception exception) {
            caller.notifyObservers(" Unable to create \"" + snapTraceFileName + "\"");
            return string2;
        }
        long l = J9JVMConsole.getTraceFileHeaderAddress();
        int n = J9JVMConsole.getTraceFileHeaderLength();
        caller.notifyObservers("address of TraceFileHeader = 0x" + Long.toHexString(l));
        caller.notifyObservers("TraceFileHeader length     = " + n + " (hex 0x" + Long.toHexString(n) + ")");
        caller.notifyObservers("\nwriting TraceFileHeader");
        J9JVMBaseTraceCommands.writeDataToFile(l, n, "NEW");
        caller.notifyObservers("\nProcessing Trace Buffers\n------------------------");
        int n2 = 0;
        if (J9JVMConsole.getTraceBuffers().size() > 0) {
            for (J9TraceBuffer j9TraceBuffer : J9JVMConsole.getTraceBuffers()) {
                J9JVMBaseTraceCommands.writeDataToFile(j9TraceBuffer.getStart(), j9TraceBuffer.getLength(), "APPEND");
                ++n2;
            }
            string2 = snapTraceFileName;
        } else {
            caller.notifyObservers("There were no trace buffers identified in the xml.");
        }
        caller.notifyObservers(n2 + " trace buffers processed.");
        return string2;
    }

    private String[] buildFormatArgs() {
        String[] stringArray;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string = null;
        string = snapTraceFileName;
        hashtable.put("infilename", string);
        string = Console.getProperty("TRACE_OUTFILENAME");
        if (null == string) {
            string = snapTraceFileName.concat(".fmt");
        } else if (string.indexOf("%T") != -1) {
            stringArray = null;
            String string2 = null;
            String string3 = null;
            String string4 = Console.getProperty("TRACE_THREADS");
            int n = string.indexOf("%T");
            stringArray = new String("");
            if (n > 0) {
                stringArray = string.substring(0, n);
            }
            if (null == string4 || null != string4 && string4.toUpperCase().equals("ALL")) {
                string2 = "ALL";
            } else {
                string2 = string4;
                if (string2.indexOf(",") != -1) {
                    string2 = "MULTI";
                }
            }
            string3 = new String("");
            if (n < string.length()) {
                string3 = string.substring(n + 2, string.length());
            }
            string = stringArray.concat(string2).concat(string3);
        }
        hashtable.put("outfilename", string);
        savedFileName = string;
        string = Console.getProperty("TRACE_THREADS");
        if (null != string && !string.equals("ALL") && !string.equals("NULL")) {
            hashtable.put("thread", "-thread:" + string);
        }
        if (null != (string = Console.getProperty("TRACE_INDENT")) && string.toUpperCase().equals("TRUE")) {
            hashtable.put("indent", "-indent");
        }
        if (null != (string = Console.getProperty("TRACE_SYMBOLIC")) && string.toUpperCase().equals("TRUE")) {
            hashtable.put("symbolic", "-symbolic");
        }
        if (null != (string = Console.getProperty("TRACE_ENTRIES")) && !string.equals("ALL") && !string.equals("NULL")) {
            hashtable.put("entries", "-entries:" + string);
        }
        stringArray = new String[hashtable.size()];
        int n = 0;
        if (hashtable.get("infilename") != null) {
            stringArray[n++] = (String)hashtable.get("infilename");
        }
        if (hashtable.get("outfilename") != null) {
            stringArray[n++] = (String)hashtable.get("outfilename");
        }
        if (hashtable.get("thread") != null) {
            stringArray[n++] = (String)hashtable.get("thread");
        }
        if (hashtable.get("indent") != null) {
            stringArray[n++] = (String)hashtable.get("indent");
        }
        if (hashtable.get("symbolic") != null) {
            stringArray[n++] = (String)hashtable.get("symbolic");
        }
        if (hashtable.get("entries") != null) {
            stringArray[n++] = (String)hashtable.get("entries");
        }
        return stringArray;
    }

    private String doTraceFormat(String[] stringArray) {
        String string = FAIL_STRING;
        PipedInputStream pipedInputStream = null;
        PrintStream printStream = null;
        try {
            pipedInputStream = new PipedInputStream();
            printStream = new PrintStream(new PipedOutputStream(pipedInputStream));
        }
        catch (IOException iOException) {
            caller.notifyObservers("ERROR: Unexpected exception creating output pipe.");
            return string;
        }
        waitFlag = 0;
        J9TraceFormatterListener j9TraceFormatterListener = new J9TraceFormatterListener(pipedInputStream, null, caller);
        j9TraceFormatterListener.start();
        while (waitFlag < 1) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                caller.notifyObservers("ERROR: Unexpected exception during sleep.");
                return string;
            }
        }
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)System.getProperties());
        if (null != Console.getProperty("TRACE_DATADIR")) {
            System.setProperty("ibm.dg.trc.format", Console.getProperty("TRACE_DATADIR"));
        }
        String string2 = null;
        String string3 = System.getProperty("java.home");
        string3 = string3.concat(File.separator).concat("lib");
        string2 = System.getProperty("ibm.dg.trc.format", string3);
        string2 = string2.concat(System.getProperty("file.separator")).concat("TraceFormat.dat");
        caller.notifyObservers("Looking for Trace Format data in file: \n   " + string2 + "\n");
        if (!new File(string2).exists()) {
            caller.notifyObservers("ERROR: Unable to format Trace file - TraceFormat.dat does not exist.");
            return string;
        }
        TraceFormat traceFormat = new TraceFormat(printStream, stringArray);
        waitFlag = 2;
        while (waitFlag < 3) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                caller.notifyObservers("ERROR: Unexpected exception during sleep.");
                return string;
            }
        }
        try {
            printStream.close();
            pipedInputStream.close();
        }
        catch (IOException iOException) {
            caller.notifyObservers("ERROR: unexpected exception closing print stream.");
            return string;
        }
        System.setProperties(properties);
        if (snapTraceOutputFileName == null) {
            string = null != Console.getProperty("TRACE_OUTFILENAME") ? (snapTraceOutputFileName = Console.getProperty("TRACE_OUTFILENAME")) : (snapTraceOutputFileName = new String(snapTraceFileName + ".fmt"));
        }
        return string;
    }

    private static void writeDataToFile(long l, int n, String string) {
        FileOutputStream fileOutputStream;
        boolean bl = true;
        byte[] byArray = null;
        boolean bl2 = true;
        if (string.toUpperCase().trim().equals("NEW")) {
            bl2 = false;
        }
        caller.notifyObservers("writing 0x" + Long.toHexString(n) + " bytes from address 0x" + Long.toHexString(l) + " to file \"" + snapTraceFileName + "\"");
        try {
            fileOutputStream = new FileOutputStream(snapTraceFileName, bl2);
        }
        catch (IOException iOException) {
            caller.notifyObservers("Exception opening FileOutputStream for " + snapTraceFileName);
            return;
        }
        try {
            byArray = new byte[n];
            theDump.seekToMemoryAddress(l);
            theDump.readFullyEx(byArray);
        }
        catch (Exception exception) {
            caller.notifyObservers("Exception trying to put bytes into array");
            bl = false;
        }
        if (bl) {
            try {
                fileOutputStream.write(byArray);
            }
            catch (IOException iOException) {
                caller.notifyObservers("Exception writing bytes to " + snapTraceFileName);
            }
        }
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            caller.notifyObservers("Exception closing FileOutputStream");
        }
    }

    public static void setWaitFlag(int n) {
        waitFlag = n;
    }

    public static int getWaitFlag() {
        return waitFlag;
    }

    private boolean displayFile(String string, int n, int n2) {
        BufferedReader bufferedReader = null;
        File file = new File(string);
        FileReader fileReader = null;
        boolean bl = false;
        if (!file.exists()) {
            caller.notifyObservers("ERROR: the file " + file.getName() + " doesn't exist");
            return false;
        }
        if (!file.canRead()) {
            caller.notifyObservers("ERROR: Unable to read the file " + file.getName());
            return false;
        }
        int n3 = 1;
        String string2 = null;
        boolean bl2 = false;
        try {
            fileReader = new FileReader(file);
            bufferedReader = new BufferedReader(fileReader);
            while (bufferedReader.ready() && !bl2) {
                string2 = bufferedReader.readLine();
                if (n3 >= n) {
                    if (n3 <= n2) {
                        caller.notifyObservers("[" + n3 + "] " + string2);
                        bl = true;
                    } else {
                        bl2 = true;
                    }
                }
                ++n3;
            }
            fileReader.close();
            bufferedReader.close();
        }
        catch (Exception exception) {
            caller.notifyObservers("ERROR: Unexpected exception reading \"" + snapTraceOutputFileName + "\" (" + exception + ", " + exception.getMessage() + ")");
            exception.printStackTrace();
        }
        return bl;
    }

    private static StringTokenizer getValidTraceEntries() {
        return new StringTokenizer("dg,st,lk,xe,xm,ci,cl,dc,hpi,xhpi,java,awt,awt_dnd_datatransfer,Audio,jit,jdwp,mt,fontmanager,net,awt_java2d,awt_print", ",");
    }

    private void checkThreadArgs(String string, ArrayList arrayList, boolean bl) {
        String string2;
        boolean bl2 = false;
        if (string != null) {
            bl2 = true;
        }
        if (string.equals("NONE")) {
            try {
                string = Console.getProperty("TRACE_THREADS");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string == null) {
            string = "ALL";
        }
        if ((string = string.toLowerCase()).toUpperCase().equals("ALL")) {
            Console.setProperty("TRACE_THREADS", "ALL");
            caller.notifyObservers("\nThe trace formatter will be run without the -thread option");
            return;
        }
        if (string == null) {
            caller.notifyObservers("No optional parameters supplied.");
            return;
        }
        boolean bl3 = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (!string2.substring(0, 2).equals("0x")) {
                caller.notifyObservers("ERROR: " + string2 + " does not must begin \"0x\" (hex)");
                bl3 = true;
            }
            if (!bl3 && string2.length() == 2) {
                caller.notifyObservers("ERROR: 0x on it's own is not a valid hex number!!");
                bl3 = true;
            }
            if (!bl3) {
                String string3 = string2.substring(2, string2.length());
                try {
                    Long.parseLong(string3, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    caller.notifyObservers("ERROR: " + string2 + " is not a proper hex number.");
                    bl3 = true;
                }
            }
            if (!bl) continue;
            if (arrayList.contains(string2.toUpperCase())) {
                caller.notifyObservers(string2 + " is a valid thread.");
                continue;
            }
            caller.notifyObservers("ERROR: " + string2 + " is not in list of active threads.");
            bl3 = true;
        }
        try {
            if (bl3) {
                if (!bl2) {
                    Console.setProperty("TRACE_THREADS", "ALL");
                }
            } else {
                Console.setProperty("TRACE_THREADS", string);
            }
        }
        catch (Exception exception) {
            caller.notifyObservers("ERROR: Unexpected Exception received setting TRACE_THREADS");
            caller.notifyObservers("expception text:" + exception.getMessage());
        }
        string2 = null;
        string2 = Console.getProperty("TRACE_THREADS");
        if (string2 != null) {
            caller.notifyObservers("\nThe trace formatter will be run with the following option:");
            caller.notifyObservers("\"-thread:" + string2.toLowerCase() + "\"");
        }
    }

    private void cacheSummaryInfo() {
        PrintStream printStream = null;
        if (snapTraceFileName != null) {
            if (snapTraceInfoFileName == null) {
                String[] stringArray = new String[]{snapTraceFileName, snapTraceFileName + ".tmp", "-summary"};
                try {
                    printStream = new PrintStream(new FileOutputStream(snapTraceFileName + ".info"));
                }
                catch (IOException iOException) {
                    caller.notifyObservers("ERROR: Unexpected exception creating printStream.");
                }
                TraceFormat traceFormat = new TraceFormat(printStream, stringArray);
                printStream.close();
                snapTraceInfoFileName = new String(snapTraceFileName + ".info");
            }
        } else {
            caller.notifyObservers("\nThe trace file must already exist before the TRACE CACHE command is run.\n(Use TRACE EXTRACT before running TRACE CACHE).");
        }
    }

    static {
        snapTraceInfoFileName = null;
        traceOutStart = 1;
        traceOutPage = 25;
    }
}

