/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel;

import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDump;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDumpClassCache;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDumpHandler;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDumpRecord;
import com.ibm.jvm.j9.dump.systemdump.J9Object;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ShortObjectRecord
extends PortableHeapDumpRecord {
    public static final byte MAGIC_NUMBER = -128;
    private byte classCacheIndex;
    private byte gapSize;
    private short gapPreceding;
    private short hashcode;

    public ShortObjectRecord(J9Object j9Object, J9Object j9Object2, byte by) {
        this.tag = (byte)-128;
        if (by > 3) {
            throw new IllegalArgumentException("classCacheIndex is too big!");
        }
        this.classCacheIndex = by;
        this.setReferences(j9Object);
        long l = ShortObjectRecord.getAddressDifference(j9Object, j9Object2);
        if (l > 32767L || l < -32768L) {
            throw new IllegalArgumentException("address differences is too big - need long record");
        }
        this.gapSize = PortableHeapDumpRecord.sizeofReference(l);
        this.gapPreceding = (short)l;
    }

    public void writeHeapDump(DataOutput dataOutput) throws IOException {
        int n = 128;
        n |= this.classCacheIndex << 5;
        n |= this.References.length << 3;
        n |= this.gapSize << 2;
        dataOutput.writeByte(n |= this.referenceSize);
        this.writeReference(dataOutput, this.gapSize, this.gapPreceding);
        if (PortableHeapDump.isJ9()) {
            dataOutput.writeShort(this.hashcode);
        }
        if (PortableHeapDump.DEBUG) {
            PortableHeapDump.DEBUG_STREAM.println("\ttag and flag = " + n + " num of ref = " + this.References.length);
        }
        this.writeReferences(dataOutput);
    }

    public static void readHeapDump(DataInput dataInput, byte by, PortableHeapDumpHandler portableHeapDumpHandler, PortableHeapDumpClassCache portableHeapDumpClassCache) {
    }
}

