/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel;

import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDump;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDumpHandler;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDumpRecord;
import com.ibm.jvm.j9.dump.systemdump.J9Object;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class PrimitiveArrayRecord
extends PortableHeapDumpRecord {
    public static final byte MAGIC_NUMBER = 32;
    public static final String[] PRIMITIVE_TYPE_NAME = new String[]{"boolean", "char", "float", "double", "byte", "short", "int", "long"};
    public static final byte BOOL_TYPE = 0;
    public static final byte CHAR_TYPE = 1;
    public static final byte FLOAT_TYPE = 2;
    public static final byte DOUBLE_TYPE = 3;
    public static final byte BYTE_TYPE = 4;
    public static final byte SHORT_TYPE = 5;
    public static final byte INT_TYPE = 6;
    public static final byte LONG_TYPE = 7;
    protected byte arrayType;
    protected byte arrayLengthSize;
    protected int arrayLength;
    protected long gapPreceding;

    public PrimitiveArrayRecord(J9Object j9Object, J9Object j9Object2) {
        this.tag = (byte)32;
        this.arrayLength = j9Object.getElementCount();
        this.arrayType = j9Object.getPrimitiveArrayType();
        this.arrayLengthSize = PrimitiveArrayRecord.sizeofReference(this.arrayLength);
        this.gapPreceding = PrimitiveArrayRecord.getAddressDifference(j9Object, j9Object2);
        byte by = PrimitiveArrayRecord.sizeofReference(this.gapPreceding);
        if (PortableHeapDump.DEBUG) {
            PortableHeapDump.DEBUG_STREAM.print("  before: arrayLengthSize = " + this.arrayLengthSize + " gapSize = " + by);
        }
        byte by2 = this.arrayLengthSize = by > this.arrayLengthSize ? by : this.arrayLengthSize;
        if (PortableHeapDump.DEBUG) {
            PortableHeapDump.DEBUG_STREAM.print("  after: arrayLengthSize = " + this.arrayLengthSize + " gapSize = " + by);
        }
    }

    public void writeHeapDump(DataOutput dataOutput) throws IOException {
        this.tag = (byte)(this.tag | this.arrayType << 2);
        this.tag = (byte)(this.tag | this.arrayLengthSize);
        dataOutput.writeByte(this.tag);
        if (PortableHeapDump.DEBUG) {
            PortableHeapDump.DEBUG_STREAM.print(" tag = " + this.tag + " ");
        }
        this.writeReference(dataOutput, this.arrayLengthSize, this.gapPreceding);
        this.writeReference(dataOutput, this.arrayLengthSize, this.arrayLength);
        if (PortableHeapDump.isJ9()) {
            dataOutput.writeShort(this.hashCode);
        }
    }

    public static void readHeapDump(DataInput dataInput, byte by, PortableHeapDumpHandler portableHeapDumpHandler) {
    }
}

