/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel;

import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDumpClassCache;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDumpHandler;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDumpHeader;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDumpIO;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDumpRecord;
import com.ibm.jvm.j9.dump.systemdump.Dump;
import com.ibm.jvm.j9.dump.systemdump.J9Class;
import com.ibm.jvm.j9.dump.systemdump.J9Object;
import com.ibm.jvm.j9.dump.systemdump.J9ObjectIterator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;

public class PortableHeapDump
implements PortableHeapDumpIO {
    public static boolean DEBUG = false;
    public static PrintStream DEBUG_STREAM = System.err;
    public static String DEBUG_FILENAME = "heapdump.debug";
    public static final boolean DEBUG_SUMMARY = false;
    public static final String DEBUG_SUMMARY_OUTPUT = "d:\\debugouthd.txt";
    public static final byte START_OF_HEADER = 1;
    public static final byte END_OF_HEADER = 2;
    public static final byte START_OF_DUMP = 2;
    public static final byte END_OF_DUMP = 3;
    public static final String MAGIC_STRING = "portable heap dump";
    public static final int VERSION_NUMBER = 4;
    public static int classRecords;
    private int flags;
    private PortableHeapDumpHeader header;
    private ArrayList dumpRecords;
    private boolean is32bit = true;
    boolean isLittleEndian;
    private boolean isJ9 = true;
    private static PortableHeapDump currentPortableHeapDumpinstance;
    private Dump j9Dump;

    public PortableHeapDump(Dump dump, boolean bl, boolean bl2) {
        this.j9Dump = dump;
        this.is32bit = bl;
        this.isLittleEndian = bl2;
        currentPortableHeapDumpinstance = this;
    }

    public PortableHeapDump(Dump dump, boolean bl, boolean bl2, boolean bl3) {
        this(dump, bl, bl2);
        this.isJ9 = bl3;
    }

    public static void main(String[] stringArray) {
    }

    private static int writeDumpRecords(J9ObjectIterator j9ObjectIterator, DataOutput dataOutput) throws IOException {
        Object var2_2 = null;
        Object var3_3 = null;
        PortableHeapDumpClassCache portableHeapDumpClassCache = new PortableHeapDumpClassCache();
        J9Object j9Object = null;
        J9Object j9Object2 = null;
        int n = 0;
        classRecords = 0;
        while (j9ObjectIterator.hasNext()) {
            j9Object = (J9Object)j9ObjectIterator.next();
            if (DEBUG) {
                DEBUG_STREAM.print("Object number = " + n + " ");
            }
            J9Class j9Class = j9Object.getClassForObject();
            boolean bl = j9Object.isArray();
            boolean bl2 = j9Object.isInstanceOfClass();
            byte by = -1;
            if (!bl && !bl2) {
                by = portableHeapDumpClassCache.getClassCacheIndex(j9Object.getClassForObject());
            }
            if (bl) {
                PortableHeapDumpRecord.writeArrayRecord(dataOutput, j9Object, j9Object2);
            } else if (bl2) {
                ++classRecords;
                PortableHeapDumpRecord.writeClassRecord(dataOutput, j9Object, j9Object2);
            } else {
                if (by == -1) {
                    portableHeapDumpClassCache.setClassCacheIndex(j9Object.getClassForObject());
                }
                PortableHeapDumpRecord.writeObjectRecord(dataOutput, j9Object, j9Object2, by);
            }
            j9Object2 = j9Object;
            ++n;
        }
        return n;
    }

    public int writeHeapDump(DataOutput dataOutput) throws IOException {
        J9ObjectIterator j9ObjectIterator = J9ObjectIterator.getObjectIterator(null);
        return this.writeHeapDump(j9ObjectIterator, dataOutput);
    }

    private int writeHeapDump(J9ObjectIterator j9ObjectIterator, DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(MAGIC_STRING);
        dataOutput.writeInt(4);
        int n = 0;
        if (!PortableHeapDump.is32bit()) {
            n = 1;
        }
        if (PortableHeapDump.isJ9()) {
            n += 6;
        }
        dataOutput.writeInt(n);
        PortableHeapDumpHeader portableHeapDumpHeader = new PortableHeapDumpHeader(this.j9Dump);
        dataOutput.writeByte(1);
        portableHeapDumpHeader.writeHeapDump(dataOutput);
        dataOutput.writeByte(2);
        dataOutput.writeByte(2);
        int n2 = PortableHeapDump.writeDumpRecords(j9ObjectIterator, dataOutput);
        dataOutput.writeByte(3);
        if (DEBUG) {
            DEBUG_STREAM.println("Number of ClassRecords processed = " + classRecords);
        }
        return n2;
    }

    public void readHeapDump(DataInput dataInput, PortableHeapDumpHandler portableHeapDumpHandler) {
        try {
            String string = dataInput.readUTF();
            if (!string.equals(MAGIC_STRING)) {
                portableHeapDumpHandler.exceptionDetected(new IOException("Magic String not found"));
            }
            int n = dataInput.readInt();
            int n2 = dataInput.readInt();
            portableHeapDumpHandler.magicInfo(n, n2);
            if (dataInput.readByte() == 1) {
                portableHeapDumpHandler.startOfHeader();
            } else {
                portableHeapDumpHandler.exceptionDetected(new IOException("start of header not found"));
            }
            PortableHeapDumpHeader.readHeapDump(dataInput, portableHeapDumpHandler);
            if (dataInput.readByte() == 2) {
                portableHeapDumpHandler.endOfHeader();
            } else {
                portableHeapDumpHandler.exceptionDetected(new IOException("end of header not found"));
            }
            if (dataInput.readByte() == 2) {
                portableHeapDumpHandler.startOfDump();
            } else {
                portableHeapDumpHandler.exceptionDetected(new IOException("start of dump not found"));
            }
            PortableHeapDumpRecord.readObjectRecords(dataInput, portableHeapDumpHandler);
        }
        catch (Exception exception) {
            portableHeapDumpHandler.exceptionDetected(exception);
        }
    }

    public static boolean isJ9() {
        return PortableHeapDump.currentPortableHeapDumpinstance.isJ9;
    }

    public static boolean is32bit() {
        return PortableHeapDump.currentPortableHeapDumpinstance.is32bit;
    }

    public static boolean isDEBUG() {
        return DEBUG;
    }

    public static void setDEBUG(boolean bl) {
        DEBUG = bl;
    }

    static {
        currentPortableHeapDumpinstance = null;
    }
}

