/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import com.ibm.security.cmskeystore.BERObject;
import com.ibm.security.cmskeystore.BERObjectParser;
import java.util.Vector;

class DNItem
extends BERObject
implements BERObjectParser {
    private String cn;
    private String ou;
    private String o;
    private String l;
    private String s;
    private String pc;
    private String c;
    private String em;
    private Vector<String> optional;

    public DNItem() {
        this(null, null, null, null, null, null, null, null, null);
    }

    public DNItem(byte[] berData) {
        super(berData);
    }

    public DNItem(String cn, String ou, String o, String c) {
        this(cn, ou, o, null, null, null, c, null);
    }

    public DNItem(String cn, String ou, String o, String l, String s, String pc, String c, String em) {
        this.cn = cn;
        this.ou = ou;
        this.o = o;
        this.l = l;
        this.s = s;
        this.pc = pc;
        this.c = c;
        this.em = em;
        this.optional = null;
        this.collapse();
    }

    public DNItem(String cn, String ou, String o, String l, String s, String pc, String c, String em, byte[] encodedBer) {
        this.cn = cn;
        this.ou = ou;
        this.o = o;
        this.l = l;
        this.s = s;
        this.pc = pc;
        this.c = c;
        this.em = em;
        this.optional = null;
        this.setEncoded(encodedBer);
    }

    public void expand() {
    }

    public void collapse() {
        this.berData = null;
    }

    public boolean isValidDN() {
        if (this.cn != null && this.cn.length() > 64) {
            return false;
        }
        if (this.ou != null && this.ou.length() > 64) {
            return false;
        }
        if (this.o != null && this.o.length() > 64) {
            return false;
        }
        if (this.l != null && this.l.length() > 64) {
            return false;
        }
        if (this.s != null && (this.s.length() > 64 || this.s.length() < 3)) {
            return false;
        }
        return this.c == null || this.c.length() == 2;
    }

    public String getCommonName() {
        return this.cn;
    }

    public String getOrganizationUnit() {
        return this.ou;
    }

    public String getOrganization() {
        return this.o;
    }

    public String getLocality() {
        return this.l;
    }

    public String getState() {
        return this.s;
    }

    public String getCountryName() {
        return this.c;
    }

    public String getZipCode() {
        return this.pc;
    }

    public String getEmailAddr() {
        return this.em;
    }

    public Vector getOptional() {
        return this.optional;
    }

    public void setOptional(Vector extraFields) {
        if (extraFields == null) {
            this.optional = null;
        } else {
            if (this.optional == null) {
                this.optional = new Vector();
            } else {
                this.optional.removeAllElements();
            }
            for (int i = 0; i < extraFields.size(); ++i) {
                String opt = (String)extraFields.elementAt(i);
                this.optional.addElement(opt);
            }
        }
    }

    public void addOptionalField(String field) {
        if (field == null) {
            return;
        }
        if (this.optional == null) {
            this.optional = new Vector();
        }
        this.optional.addElement(field);
    }

    public String getRFC1779String() {
        StringBuffer sb = new StringBuffer();
        if (this.cn != null) {
            sb.append("cn=\"" + this.cn + "\"");
        }
        if (this.ou != null) {
            sb.append(",ou=\"" + this.ou + "\"");
        }
        if (this.o != null) {
            sb.append(",o=\"" + this.o + "\"");
        }
        if (this.l != null) {
            sb.append(",l=\"" + this.l + "\"");
        }
        if (this.s != null) {
            sb.append(",st=\"" + this.s + "\"");
        }
        if (this.pc != null) {
            sb.append(",POSTALCODE=\"" + this.pc + "\"");
        }
        if (this.c != null) {
            sb.append(",c=\"" + this.c + "\"");
        }
        if (this.em != null) {
            sb.append(",email=\"" + this.em + "\"");
        }
        return new String(sb);
    }

    public String toStringWithoutTag() {
        String str = "";
        String addr = "";
        if (this.cn != null) {
            str = this.cn;
        }
        if (this.ou != null) {
            str = (!str.equals("") ? str + "\n" : "") + this.ou;
        }
        if (this.o != null) {
            str = (!str.equals("") ? str + "\n" : "") + this.o;
        }
        if (this.l != null) {
            addr = this.l;
        }
        if (this.s != null) {
            addr = (!addr.equals("") ? addr + ", " : "") + this.s;
        }
        if (this.pc != null) {
            addr = (!addr.equals("") ? addr + ", " : "") + this.pc;
        }
        if (this.c != null) {
            addr = (!addr.equals("") ? addr + ", " : "") + this.c;
        }
        if (addr != null) {
            str = (!str.equals("") ? str + "\n" : "") + addr;
        }
        if (this.em != null) {
            str = (!str.equals("") ? str + "\n" : "") + this.em;
        }
        if (this.optional != null) {
            str = (!str.equals("") ? str + "\n" : "") + this.optional.toString();
        }
        return str;
    }

    public String toStringWithoutTagForKeyInfo() {
        String str = "";
        String addr = "";
        if (this.cn != null) {
            str = "cn=" + this.cn;
        }
        if (this.ou != null) {
            str = (!str.equals("") ? str + "\n" : "") + "ou=" + this.ou;
        }
        if (this.o != null) {
            str = (!str.equals("") ? str + "\n" : "") + "o =" + this.o;
        }
        if (this.l != null) {
            addr = "l =" + this.l;
        }
        if (this.s != null) {
            addr = (!addr.equals("") ? addr + ", " : "") + "s =" + this.s;
        }
        if (this.pc != null) {
            addr = (!addr.equals("") ? addr + ", " : "") + "pc=" + this.pc;
        }
        if (this.c != null) {
            addr = (!addr.equals("") ? addr + ", " : "") + "c =" + this.c;
        }
        if (addr != null) {
            str = (!str.equals("") ? str + "\n" : "") + addr;
        }
        if (this.em != null) {
            str = (!str.equals("") ? str + "\n" : "") + "em=" + this.em;
        }
        if (this.optional != null) {
            str = (!str.equals("") ? str + "\n" : "") + this.optional.toString();
        }
        return str;
    }

    public String toString() {
        return this.paramString();
    }

    public String paramString() {
        String str = "";
        if (this.cn != null) {
            str = str + ", CN=" + this.cn;
        }
        if (this.ou != null) {
            str = str + ", OU=" + this.ou;
        }
        if (this.o != null) {
            str = str + ", O=" + this.o;
        }
        if (this.l != null) {
            str = str + ", L=" + this.l;
        }
        if (this.s != null) {
            str = str + ", S=" + this.s;
        }
        if (this.pc != null) {
            str = str + ", PC=" + this.pc;
        }
        if (this.c != null) {
            str = str + ", C=" + this.c;
        }
        if (this.em != null) {
            str = str + ", EM=" + this.em;
        }
        if (this.optional != null) {
            str = str + ", OPT=" + this.optional.toString();
        }
        return super.toString() + str;
    }
}

