/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import com.ibm.security.cmskeystore.BERObject;
import com.ibm.security.cmskeystore.BERObjectParser;
import com.ibm.security.cmskeystore.DNItem;
import com.ibm.security.cmskeystore.KMUtil;

class CertificateRequestItem
extends BERObject
implements BERObjectParser {
    public static final short REQ_TYPE_PKCS10 = 1;
    public static final short REQ_TYPE_PEM = 2;
    private short requestType;
    private byte[] certReqInfoBER;
    private byte[] signature;
    private BERObject sigAlgIdBER;
    private String sigAlgIdOID;
    private String sigAlgIdOIDName;
    private short keySize;
    private DNItem subject;
    private BERObject spkiBER;
    private BERObject attribBER;
    private boolean isAttribPresent;

    public CertificateRequestItem(byte[] berData) {
        super(berData);
    }

    public CertificateRequestItem() {
        this(0, null, null, null, null, null, null, null, null, null);
    }

    public CertificateRequestItem(short keySize, DNItem subjectName, BERObject spkiBER, BERObject attributeBER, byte[] sig, BERObject sigAlgIdBER, String sigAlgIdOID, String sigAlgIdOIDName) {
        this(keySize, subjectName, spkiBER, attributeBER, sig, sigAlgIdBER, sigAlgIdOID, sigAlgIdOIDName, null, null);
        this.collapse();
    }

    public CertificateRequestItem(short keySize, DNItem subjectName, BERObject spkiBER, BERObject attributeBER, byte[] sig, BERObject sigAlgIdBER, String sigAlgIdOID, String sigAlgIdOIDName, byte[] encodedBER, byte[] certReqInfoBER) {
        this.requestType = 1;
        this.keySize = keySize;
        this.subject = subjectName;
        this.signature = sig;
        this.sigAlgIdBER = sigAlgIdBER;
        this.sigAlgIdOID = sigAlgIdOID;
        this.sigAlgIdOIDName = sigAlgIdOIDName;
        this.spkiBER = spkiBER;
        this.attribBER = attributeBER;
        this.isAttribPresent = this.attribBER != null;
        this.setEncoded(encodedBER);
        this.certReqInfoBER = certReqInfoBER;
    }

    public void expand() {
    }

    public void collapse() {
        this.berData = null;
    }

    public short getReqType() {
        return this.requestType;
    }

    public byte[] getCertReqInfoBER() {
        return this.certReqInfoBER;
    }

    public String getFingerPrint() {
        return KMUtil.getMD5(this.certReqInfoBER);
    }

    public short getKeySize() {
        return this.keySize;
    }

    public DNItem getSubject() {
        return this.subject;
    }

    public BERObject getSubjectPublicKeyInfoBER() {
        return this.spkiBER;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public String getSigAlgorithmIdOID() {
        return this.sigAlgIdOID;
    }

    public String getSigAlgorithmIdOIDName() {
        return this.sigAlgIdOIDName;
    }

    public BERObject getAttribute() {
        return this.attribBER;
    }

    public boolean isAttributePresent() {
        return this.isAttribPresent;
    }

    public String toString() {
        return this.paramString();
    }

    public String getTypeName() {
        return this.requestType == 1 ? "PKCS10 Request" : "PEM Request";
    }

    public String paramString() {
        String subjectStr = this.subject == null ? "null" : this.subject.toString();
        try {
            return super.toString() + ", type=" + this.getTypeName() + ", keySize=" + this.keySize + ", isAttribPresent=" + this.isAttribPresent + ", subject=" + subjectStr + ", signature algorithm=" + this.sigAlgIdOIDName + "(" + this.sigAlgIdOID + ")";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Error e) {
            e.printStackTrace();
        }
        return null;
    }
}

