/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.BASE64Decoder;
import com.ibm.misc.BASE64Encoder;
import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.util.BitArray;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;

public class X509Key
implements PublicKey {
    private static final long serialVersionUID = -5359250853002055002L;
    protected AlgorithmId algid;
    protected byte[] key = null;
    private int unusedBits = 0;
    private BitArray bitStringKey = null;
    protected byte[] encodedKey;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.X509Key";

    public X509Key() {
        if (debug != null) {
            debug.entry(16384L, className, "X509Key");
            debug.exit(16384L, className, "X509Key");
        }
    }

    private X509Key(AlgorithmId algorithmId, BitArray bitArray) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, className, "X509Key", algorithmId, bitArray);
        }
        this.algid = algorithmId;
        this.setKey(bitArray);
        this.encode();
        if (debug != null) {
            debug.exit(16384L, className, "X509Key");
        }
    }

    protected void setKey(BitArray bitArray) {
        this.bitStringKey = (BitArray)bitArray.clone();
        this.key = bitArray.toByteArray();
        int n = bitArray.length() % 8;
        this.unusedBits = n == 0 ? 0 : 8 - n;
    }

    protected BitArray getKey() {
        this.bitStringKey = new BitArray(this.key.length * 8 - this.unusedBits, this.key);
        return (BitArray)this.bitStringKey.clone();
    }

    public static PublicKey parse(DerValue derValue, String string) throws IOException {
        PublicKey publicKey;
        if (debug != null) {
            debug.entry(16384L, className, "parse", derValue, string);
        }
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "parse", "corrupt subject key");
            }
            throw new IOException("corrupt subject key");
        }
        AlgorithmId algorithmId = AlgorithmId.parse(derValue.getData().getDerValue());
        try {
            publicKey = X509Key.buildX509Key(algorithmId, derValue.getData().getUnalignedBitString(), string);
        }
        catch (InvalidKeyException invalidKeyException) {
            if (debug != null) {
                debug.exception(512L, className, "parse", invalidKeyException);
            }
            throw new IOException("subject key, " + invalidKeyException.getMessage());
        }
        if (derValue.getData().available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "parse", "excess subject key");
            }
            throw new IOException("excess subject key");
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "parse", publicKey);
        }
        return publicKey;
    }

    public static PublicKey parse(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "parse", derValue);
            debug.exit(16384L, className, "parse");
        }
        return X509Key.parse(derValue, null);
    }

    protected void parseKeyBits() throws IOException, InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, className, "parseKeyBits");
        }
        this.encode();
        if (debug != null) {
            debug.exit(16384L, className, "parseKeyBits");
        }
    }

    static PublicKey buildX509Key(AlgorithmId algorithmId, BitArray bitArray, String string) throws IOException, InvalidKeyException {
        Object[] objectArray;
        PublicKey publicKey = null;
        if (debug != null) {
            objectArray = new Object[]{algorithmId, bitArray, string};
            debug.entry(16384L, (Object)className, "buildX509Key", objectArray);
        }
        objectArray = new DerOutputStream();
        X509Key.encode((DerOutputStream)objectArray, algorithmId, bitArray);
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(objectArray.toByteArray());
        try {
            KeyFactory keyFactory = null;
            if (string != null) {
                try {
                    keyFactory = KeyFactory.getInstance(algorithmId.getName(), string);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    keyFactory = KeyFactory.getInstance(algorithmId.getName());
                }
            } else {
                keyFactory = KeyFactory.getInstance(algorithmId.getName());
            }
            publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "buildX509Key", publicKey);
            }
            return publicKey;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            if (debug != null) {
                debug.exception(512L, className, "buildX509Key", noSuchProviderException);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (debug != null) {
                debug.exception(512L, className, "buildX509Key", noSuchAlgorithmException);
            }
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            if (debug != null) {
                debug.exception(512L, className, "buildX509Key", invalidKeySpecException);
            }
            throw new InvalidKeyException(invalidKeySpecException.toString());
        }
        X509Key x509Key = new X509Key();
        x509Key.algid = algorithmId;
        x509Key.setKey(bitArray);
        x509Key.parseKeyBits();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "buildX509Key", x509Key);
        }
        return x509Key;
    }

    static PublicKey buildX509Key(AlgorithmId algorithmId, byte[] byArray, String string) throws IOException, InvalidKeyException {
        Object[] objectArray;
        PublicKey publicKey = null;
        if (debug != null) {
            objectArray = new Object[]{algorithmId, byArray, string};
            debug.entry(16384L, (Object)className, "buildX509Key", objectArray);
        }
        objectArray = new DerOutputStream();
        X509Key.encode((DerOutputStream)objectArray, algorithmId, byArray);
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(objectArray.toByteArray());
        try {
            KeyFactory keyFactory = null;
            keyFactory = string != null ? KeyFactory.getInstance(algorithmId.getName(), string) : KeyFactory.getInstance(algorithmId.getName());
            publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "buildX509Key", publicKey);
            }
            return publicKey;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            if (debug != null) {
                debug.exception(512L, className, "buildX509Key", noSuchProviderException);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (debug != null) {
                debug.exception(512L, className, "buildX509Key", noSuchAlgorithmException);
            }
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            if (debug != null) {
                debug.exception(512L, className, "buildX509Key", invalidKeySpecException);
            }
            throw new InvalidKeyException(invalidKeySpecException.toString());
        }
        X509Key x509Key = new X509Key();
        x509Key.algid = algorithmId;
        x509Key.setKey(new BitArray(byArray.length, byArray));
        x509Key.parseKeyBits();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "buildX509Key", x509Key);
        }
        return x509Key;
    }

    public String getAlgorithm() {
        if (debug != null) {
            debug.entry(16384L, className, "getAlgorithm");
            debug.exit(16384L, (Object)className, "getAlgorithm", this.algid.getName());
        }
        return this.algid.getName();
    }

    public AlgorithmId getAlgorithmId() {
        if (debug != null) {
            debug.entry(16384L, className, "getAlgorithmId");
            debug.exit(16384L, (Object)className, "getAlgorithmId", this.algid);
        }
        return this.algid;
    }

    public final void encode(DerOutputStream derOutputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", derOutputStream);
        }
        X509Key.encode(derOutputStream, this.algid, this.getKey());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public synchronized byte[] getEncoded() {
        byte[] byArray;
        block4: {
            if (debug != null) {
                debug.entry(16384L, className, "getEncoded");
            }
            byArray = null;
            try {
                byArray = (byte[])this.getEncodedInternal().clone();
            }
            catch (InvalidKeyException invalidKeyException) {
                if (debug == null) break block4;
                debug.exception(512L, className, "getEncoded", invalidKeyException);
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getEncoded", byArray);
        }
        return byArray;
    }

    private byte[] getEncodedInternal() throws InvalidKeyException {
        byte[] byArray = this.encodedKey;
        if (byArray == null) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                this.encode(derOutputStream);
                byArray = derOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                throw new InvalidKeyException("IOException : " + iOException.getMessage());
            }
            this.encodedKey = byArray;
        }
        return byArray;
    }

    public String getFormat() {
        if (debug != null) {
            debug.entry(16384L, className, "getFormat");
            debug.exit(16384L, (Object)className, "getFormat", "X.509");
        }
        return "X.509";
    }

    public byte[] encode() throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, className, "encode");
        }
        byte[] byArray = (byte[])this.getEncodedInternal().clone();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "encode", byArray);
        }
        return byArray;
    }

    public String toString() {
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        return "algorithm = " + this.algid.toString() + ", unparsed keybits = \r\n" + hexDumpEncoder.encodeBuffer(this.key);
    }

    public void decode(InputStream inputStream) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", inputStream);
        }
        try {
            DerValue derValue = new DerValue(inputStream);
            if (derValue.getTag() != 48) {
                if (debug != null) {
                    debug.text(16384L, className, "decode", "invalid key format");
                }
                throw new InvalidKeyException("invalid key format");
            }
            this.algid = AlgorithmId.parse(derValue.getData().getDerValue());
            this.setKey(derValue.getData().getUnalignedBitString());
            this.parseKeyBits();
            if (derValue.getData().available() != 0) {
                if (debug != null) {
                    debug.text(16384L, className, "decode", "excess key data");
                }
                throw new InvalidKeyException("excess key data");
            }
        }
        catch (IOException iOException) {
            if (debug != null) {
                iOException.printStackTrace();
                debug.exception(512L, className, "decode", iOException);
            }
            throw new InvalidKeyException("IOException: " + iOException.getMessage());
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    public void decode(byte[] byArray) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", (Object)byArray);
        }
        this.decode(new ByteArrayInputStream(byArray));
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "writeObject", objectOutputStream);
        }
        objectOutputStream.write(this.getEncoded());
        if (debug != null) {
            debug.exit(16384L, className, "writeObject");
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "readObject", objectInputStream);
        }
        try {
            this.decode(objectInputStream);
        }
        catch (InvalidKeyException invalidKeyException) {
            if (debug != null) {
                debug.exception(512L, className, "readObject", invalidKeyException);
            }
            throw new IOException("deserialized key is invalid: " + invalidKeyException.getMessage());
        }
        if (debug != null) {
            debug.exit(8192L, className, "readObject");
        }
    }

    public boolean equals(Object object) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "equals", object);
        }
        if (this == object) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals", new Boolean(true));
            }
            return true;
        }
        if (!(object instanceof Key)) {
            return false;
        }
        try {
            byte[] byArray = this.getEncodedInternal();
            byte[] byArray2 = object instanceof X509Key ? ((X509Key)object).getEncodedInternal() : ((Key)object).getEncoded();
            boolean bl = Arrays.equals(byArray, byArray2);
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals", new Boolean(bl));
            }
            return bl;
        }
        catch (InvalidKeyException invalidKeyException) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
    }

    public int hashCode() {
        int n = 0;
        if (debug != null) {
            debug.entry(16384L, className, "hashCode");
        }
        byte[] byArray = this.getEncoded();
        for (int i = 1; i < byArray.length; ++i) {
            n += byArray[i] * i;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hashCode", n);
        }
        return n;
    }

    static void encode(DerOutputStream derOutputStream, AlgorithmId algorithmId, byte[] byArray) throws IOException {
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{derOutputStream, algorithmId, byArray};
            debug.entry(16384L, (Object)className, "encode", objectArray);
        }
        objectArray = new DerOutputStream();
        algorithmId.encode((DerOutputStream)objectArray);
        objectArray.putBitString(byArray);
        derOutputStream.write((byte)48, (DerOutputStream)objectArray);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    static void encode(DerOutputStream derOutputStream, AlgorithmId algorithmId, BitArray bitArray) throws IOException {
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{derOutputStream, algorithmId, bitArray};
            debug.entry(16384L, (Object)className, "encode", objectArray);
        }
        objectArray = new DerOutputStream();
        algorithmId.encode((DerOutputStream)objectArray);
        objectArray.putUnalignedBitString(bitArray);
        derOutputStream.write((byte)48, (DerOutputStream)objectArray);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public void write(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "write", string);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            byte[] byArray = this.encode();
            fileOutputStream.write(byArray);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(512L, className, "write", exception);
            }
            throw new IOException("Could not write to " + string + ".  " + exception.toString());
        }
        if (debug != null) {
            debug.exit(16384L, className, "write");
        }
    }

    public void writeBASE64(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "writeBASE64", string);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            byte[] byArray = this.encode();
            BASE64Encoder bASE64Encoder = new BASE64Encoder();
            bASE64Encoder.encode(byArray, (OutputStream)fileOutputStream);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(512L, className, "writeBASE64", exception);
            }
            throw new IOException("Could not write to " + string + ".  " + exception.toString());
        }
        if (debug != null) {
            debug.exit(16384L, className, "writeBASE64");
        }
    }

    protected void read(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "read", string);
        }
        try {
            FileInputStream fileInputStream;
            try {
                fileInputStream = new FileInputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (debug != null) {
                    debug.exception(512L, className, "read", fileNotFoundException);
                }
                throw new IOException("File " + string + " not found.");
            }
            int n = fileInputStream.available();
            byte[] byArray = new byte[n];
            fileInputStream.read(byArray);
            fileInputStream.close();
            this.decode(byArray);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(512L, className, "read", exception);
            }
            throw new IOException("Could not read from " + string + ".  " + exception.toString());
        }
        if (debug != null) {
            debug.exit(16384L, className, "read");
        }
    }

    protected void readBASE64(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "readBASE64", string);
        }
        try {
            FileInputStream fileInputStream;
            try {
                fileInputStream = new FileInputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (debug != null) {
                    debug.exception(512L, className, "readBASE64", fileNotFoundException);
                }
                throw new IOException("File " + string + " not found.");
            }
            BASE64Decoder bASE64Decoder = new BASE64Decoder();
            byte[] byArray = bASE64Decoder.decodeBuffer(fileInputStream);
            fileInputStream.close();
            this.decode(byArray);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(512L, className, "readBASE64", exception);
            }
            throw new IOException("Could not read from " + string + ".  " + exception.toString());
        }
        if (debug != null) {
            debug.exit(16384L, className, "readBASE64");
        }
    }
}

