/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.CertificateAlgorithmId;
import com.ibm.security.x509.CertificateExtensions;
import com.ibm.security.x509.CertificateIssuerName;
import com.ibm.security.x509.CertificateIssuerUniqueIdentity;
import com.ibm.security.x509.CertificateSerialNumber;
import com.ibm.security.x509.CertificateSubjectName;
import com.ibm.security.x509.CertificateSubjectUniqueIdentity;
import com.ibm.security.x509.CertificateValidity;
import com.ibm.security.x509.CertificateVersion;
import com.ibm.security.x509.CertificateX509Key;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.OIDMap;
import com.ibm.security.x509.SubjectAlternativeNameExtension;
import com.ibm.security.x509.UniqueIdentity;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509AttributeName;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class X509CertInfo
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info";
    public static final String NAME = "info";
    public static final String VERSION = "version";
    public static final String SERIAL_NUMBER = "serialNumber";
    public static final String ALGORITHM_ID = "algorithmID";
    public static final String ISSUER = "issuer";
    public static final String VALIDITY = "validity";
    public static final String SUBJECT = "subject";
    public static final String KEY = "key";
    public static final String ISSUER_ID = "issuerID";
    public static final String SUBJECT_ID = "subjectID";
    public static final String EXTENSIONS = "extensions";
    protected CertificateVersion version = new CertificateVersion();
    protected CertificateSerialNumber serialNum = null;
    protected CertificateAlgorithmId algId = null;
    protected CertificateIssuerName issuer = null;
    protected CertificateValidity interval = null;
    protected CertificateSubjectName subject = null;
    protected CertificateX509Key pubKey = null;
    protected CertificateIssuerUniqueIdentity issuerUniqueId = null;
    protected CertificateSubjectUniqueIdentity subjectUniqueId = null;
    protected CertificateExtensions extensions = null;
    private static final int ATTR_VERSION = 1;
    private static final int ATTR_SERIAL = 2;
    private static final int ATTR_ALGORITHM = 3;
    private static final int ATTR_ISSUER = 4;
    private static final int ATTR_VALIDITY = 5;
    private static final int ATTR_SUBJECT = 6;
    private static final int ATTR_KEY = 7;
    private static final int ATTR_ISSUER_ID = 8;
    private static final int ATTR_SUBJECT_ID = 9;
    private static final int ATTR_EXTENSIONS = 10;
    private byte[] rawCertInfo = null;
    private static final HashMap<String, Integer> map = new HashMap();
    private String provider = null;
    private static Debug debug;
    private static String className;

    public X509CertInfo() {
        if (debug != null) {
            debug.entry(16384L, className, "X509CertInfo");
            debug.exit(16384L, className, "X509CertInfo");
        }
    }

    public X509CertInfo(String string) {
        if (debug != null) {
            debug.entry(16384L, className, "X509CertInfo");
            if (string != null) {
                this.provider = new String(string);
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "X509CertInfo");
        }
    }

    public X509CertInfo(byte[] byArray) throws CertificateParsingException {
        this(byArray, null);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "X509CertInfo", (Object)byArray);
            debug.exit(16384L, className, "X509CertInfo");
        }
    }

    public X509CertInfo(byte[] byArray, String string) throws CertificateParsingException {
        if (debug != null) {
            debug.entry(16384L, className, "X509CertInfo", byArray, string);
        }
        if (string != null) {
            this.provider = new String(string);
        }
        try {
            DerValue derValue = new DerValue(byArray);
            this.parse(derValue);
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.exception(16384L, className, "X509CertInfo", iOException);
            }
            throw new CertificateParsingException(iOException.toString());
        }
        if (debug != null) {
            debug.exit(16384L, className, "X509CertInfo");
        }
    }

    public X509CertInfo(DerValue derValue) throws CertificateParsingException {
        this(derValue, null);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "X509CertInfo", derValue);
            debug.exit(16384L, className, "X509CertInfo");
        }
    }

    public X509CertInfo(DerValue derValue, String string) throws CertificateParsingException {
        if (debug != null) {
            debug.entry(16384L, className, "X509CertInfo", derValue, string);
        }
        if (string != null) {
            this.provider = new String(string);
        }
        try {
            this.parse(derValue);
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.exception(16384L, className, "X509CertInfo", iOException);
            }
            throw new CertificateParsingException(iOException.toString());
        }
        if (debug != null) {
            debug.exit(16384L, className, "X509CertInfo");
        }
    }

    @Override
    public void decode(InputStream inputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", inputStream);
            debug.text(16384L, className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void encode(OutputStream outputStream) throws CertificateException, IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        if (this.rawCertInfo == null) {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.emit(derOutputStream);
            this.rawCertInfo = derOutputStream.toByteArray();
        }
        outputStream.write((byte[])this.rawCertInfo.clone());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public Enumeration<String> getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(VERSION);
        attributeNameEnumeration.addElement(SERIAL_NUMBER);
        attributeNameEnumeration.addElement(ALGORITHM_ID);
        attributeNameEnumeration.addElement(ISSUER);
        attributeNameEnumeration.addElement(VALIDITY);
        attributeNameEnumeration.addElement(SUBJECT);
        attributeNameEnumeration.addElement(KEY);
        attributeNameEnumeration.addElement(ISSUER_ID);
        attributeNameEnumeration.addElement(SUBJECT_ID);
        attributeNameEnumeration.addElement(EXTENSIONS);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", attributeNameEnumeration.elements());
        }
        return attributeNameEnumeration.elements();
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }

    public byte[] getEncodedInfo() throws CertificateEncodingException {
        if (debug != null) {
            debug.entry(16384L, className, "getEncodedInfo");
        }
        try {
            if (this.rawCertInfo == null) {
                DerOutputStream derOutputStream = new DerOutputStream();
                this.emit(derOutputStream);
                this.rawCertInfo = derOutputStream.toByteArray();
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getEncodedInfo", this.rawCertInfo.clone());
            }
            return (byte[])this.rawCertInfo.clone();
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.exception(16384L, className, "getEncodedInfo", iOException);
            }
            throw new CertificateEncodingException(iOException.toString());
        }
        catch (CertificateException certificateException) {
            if (debug != null) {
                debug.exception(16384L, className, "getEncodedInfo", certificateException);
            }
            throw new CertificateEncodingException(certificateException.toString());
        }
    }

    public boolean equals(Object object) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (object instanceof X509CertInfo) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(this.equals((X509CertInfo)object)));
            }
            return this.equals((X509CertInfo)object);
        }
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", new Boolean(false));
        }
        return false;
    }

    public boolean equals(X509CertInfo x509CertInfo) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", x509CertInfo);
        }
        if (this == x509CertInfo) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", new Boolean(true));
            }
            return true;
        }
        if (this.rawCertInfo == null || x509CertInfo.rawCertInfo == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", new Boolean(false));
            }
            return false;
        }
        if (this.rawCertInfo.length != x509CertInfo.rawCertInfo.length) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_3", new Boolean(false));
            }
            return false;
        }
        for (int i = 0; i < this.rawCertInfo.length; ++i) {
            if (this.rawCertInfo[i] == x509CertInfo.rawCertInfo[i]) continue;
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_4", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }

    public int hashCode() {
        if (debug != null) {
            debug.entry(16384L, className, "hasCode");
        }
        int n = 0;
        for (int i = 1; i < this.rawCertInfo.length; ++i) {
            n += this.rawCertInfo[i] * i;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hasCode", n);
        }
        return n;
    }

    @Override
    public String toString() {
        if (this.subject == null || this.pubKey == null || this.interval == null || this.issuer == null || this.algId == null || this.serialNum == null) {
            throw new NullPointerException("X.509 cert is incomplete");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[\r\n");
        stringBuilder.append("  " + this.version.toString() + "\r\n");
        stringBuilder.append("  Subject: " + this.subject.toString() + "\r\n");
        stringBuilder.append("  Signature Algorithm: " + this.algId.toString() + "\r\n");
        stringBuilder.append("  Key:  " + this.pubKey.toString() + "\r\n");
        stringBuilder.append("  " + this.interval.toString() + "\r\n");
        stringBuilder.append("  Issuer: " + this.issuer.toString() + "\r\n");
        stringBuilder.append("  " + this.serialNum.toString() + "\r\n");
        if (this.issuerUniqueId != null) {
            stringBuilder.append("  Issuer Id:\r\n" + this.issuerUniqueId.toString() + "\r\n");
        }
        if (this.subjectUniqueId != null) {
            stringBuilder.append("  Subject Id:\r\n" + this.subjectUniqueId.toString() + "\r\n");
        }
        if (this.extensions != null) {
            Collection<Extension> collection = this.extensions.getAllExtensions();
            Object[] objectArray = collection.toArray();
            stringBuilder.append("\r\nCertificate Extensions: " + objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuilder.append("\r\n[" + (i + 1) + "]: ");
                Extension extension = (Extension)objectArray[i];
                try {
                    if (OIDMap.getClass(extension.getExtensionId()) == null) {
                        stringBuilder.append(extension.toString());
                        byte[] byArray = extension.getExtensionValue();
                        if (byArray == null) continue;
                        DerOutputStream derOutputStream = new DerOutputStream();
                        derOutputStream.putOctetString(byArray);
                        byArray = derOutputStream.toByteArray();
                        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                        stringBuilder.append("Extension unknown: DER encoded OCTET string =\r\n" + hexDumpEncoder.encodeBuffer(byArray) + "\r\n");
                        continue;
                    }
                    stringBuilder.append(extension.toString());
                    continue;
                }
                catch (Exception exception) {
                    stringBuilder.append(", Error parsing this extension");
                }
            }
        }
        stringBuilder.append("\r\n]");
        return stringBuilder.toString();
    }

    @Override
    public void set(String string, Object object) throws CertificateException, IOException {
        X509AttributeName x509AttributeName;
        int n;
        if (debug != null) {
            debug.entry(16384L, className, "set", string, object);
        }
        if ((n = this.attributeMap((x509AttributeName = new X509AttributeName(string)).getPrefix())) == 0) {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized: " + string);
            }
            throw new CertificateException("Attribute name not recognized: " + string);
        }
        this.rawCertInfo = null;
        String string2 = x509AttributeName.getSuffix();
        switch (n) {
            case 1: {
                if (string2 == null) {
                    this.setVersion(object);
                    break;
                }
                this.version.set(string2, object);
                break;
            }
            case 2: {
                if (string2 == null) {
                    this.setSerialNumber(object);
                    break;
                }
                this.serialNum.set(string2, object);
                break;
            }
            case 3: {
                if (string2 == null) {
                    this.setAlgorithmId(object);
                    break;
                }
                this.algId.set(string2, object);
                break;
            }
            case 4: {
                if (string2 == null) {
                    this.setIssuer(object);
                    break;
                }
                this.issuer.set(string2, object);
                break;
            }
            case 5: {
                if (string2 == null) {
                    this.setValidity(object);
                    break;
                }
                if (this.interval == null) {
                    this.interval = new CertificateValidity();
                }
                this.interval.set(string2, object);
                break;
            }
            case 6: {
                if (string2 == null) {
                    this.setSubject(object);
                    break;
                }
                this.subject.set(string2, object);
                break;
            }
            case 7: {
                if (string2 == null) {
                    this.setKey(object);
                    break;
                }
                this.pubKey.set(string2, object);
                break;
            }
            case 8: {
                if (string2 == null) {
                    this.setIssuerUniqueId(object);
                    break;
                }
                this.issuerUniqueId.set(string2, object);
                break;
            }
            case 9: {
                if (string2 == null) {
                    this.setSubjectUniqueId(object);
                    break;
                }
                this.subjectUniqueId.set(string2, object);
                break;
            }
            case 10: {
                if (string2 == null) {
                    this.setExtensions(object);
                    break;
                }
                if (this.extensions == null) {
                    this.extensions = new CertificateExtensions();
                }
                this.extensions.set(string2, object);
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    @Override
    public void delete(String string) throws CertificateException, IOException {
        X509AttributeName x509AttributeName;
        int n;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", string);
        }
        if ((n = this.attributeMap((x509AttributeName = new X509AttributeName(string)).getPrefix())) == 0) {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Attribute name not recognized: " + string);
            }
            throw new CertificateException("Attribute name not recognized: " + string);
        }
        this.rawCertInfo = null;
        String string2 = x509AttributeName.getSuffix();
        switch (n) {
            case 1: {
                if (string2 == null) {
                    this.version = null;
                    break;
                }
                this.version.delete(string2);
                break;
            }
            case 2: {
                if (string2 == null) {
                    this.serialNum = null;
                    break;
                }
                this.serialNum.delete(string2);
                break;
            }
            case 3: {
                if (string2 == null) {
                    this.algId = null;
                    break;
                }
                this.algId.delete(string2);
                break;
            }
            case 4: {
                if (string2 == null) {
                    this.issuer = null;
                    break;
                }
                this.issuer.delete(string2);
                break;
            }
            case 5: {
                if (string2 == null) {
                    this.interval = null;
                    break;
                }
                this.interval.delete(string2);
                break;
            }
            case 6: {
                if (string2 == null) {
                    this.subject = null;
                    break;
                }
                this.subject.delete(string2);
                break;
            }
            case 7: {
                if (string2 == null) {
                    this.pubKey = null;
                    break;
                }
                this.pubKey.delete(string2);
                break;
            }
            case 8: {
                if (string2 == null) {
                    this.issuerUniqueId = null;
                    break;
                }
                this.issuerUniqueId.delete(string2);
                break;
            }
            case 9: {
                if (string2 == null) {
                    this.subjectUniqueId = null;
                    break;
                }
                this.subjectUniqueId.delete(string2);
                break;
            }
            case 10: {
                if (string2 == null) {
                    this.extensions = null;
                    break;
                }
                this.extensions.delete(string2);
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    Extension getExt(String string) {
        Extension extension = null;
        X509AttributeName x509AttributeName = new X509AttributeName(string);
        int n = this.attributeMap(x509AttributeName.getPrefix());
        if (n == 0) {
            if (debug != null) {
                debug.text(16384L, className, "getExt", "Attribute name not recognized: " + string);
            }
            return null;
        }
        String string2 = x509AttributeName.getSuffix();
        switch (n) {
            case 10: {
                extension = string2 == null ? null : (this.extensions == null ? null : this.extensions.getExt(string2));
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getExt", extension);
        }
        return extension;
    }

    @Override
    public Object get(String string) throws CertificateException, IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", string);
        }
        Object object = null;
        X509AttributeName x509AttributeName = new X509AttributeName(string);
        int n = this.attributeMap(x509AttributeName.getPrefix());
        if (n == 0) {
            if (debug != null) {
                debug.text(16384L, className, "get", "Attribute name not recognized: " + string);
            }
            throw new CertificateParsingException("Attribute name not recognized: " + string);
        }
        String string2 = x509AttributeName.getSuffix();
        switch (n) {
            case 10: {
                if (string2 == null) {
                    object = this.extensions;
                    break;
                }
                if (this.extensions == null) {
                    object = null;
                    break;
                }
                object = this.extensions.get(string2);
                break;
            }
            case 6: {
                if (string2 == null) {
                    object = this.subject;
                    break;
                }
                object = this.subject.get(string2);
                break;
            }
            case 4: {
                if (string2 == null) {
                    object = this.issuer;
                    break;
                }
                object = this.issuer.get(string2);
                break;
            }
            case 7: {
                if (string2 == null) {
                    object = this.pubKey;
                    break;
                }
                object = this.pubKey.get(string2);
                break;
            }
            case 3: {
                if (string2 == null) {
                    object = this.algId;
                    break;
                }
                object = this.algId.get(string2);
                break;
            }
            case 5: {
                if (string2 == null) {
                    object = this.interval;
                    break;
                }
                object = this.interval.get(string2);
                break;
            }
            case 1: {
                if (string2 == null) {
                    object = this.version;
                    break;
                }
                object = this.version.get(string2);
                break;
            }
            case 2: {
                if (string2 == null) {
                    object = this.serialNum;
                    break;
                }
                object = this.serialNum.get(string2);
                break;
            }
            case 8: {
                if (string2 == null) {
                    object = this.issuerUniqueId;
                    break;
                }
                if (this.issuerUniqueId == null) {
                    object = null;
                    break;
                }
                object = this.issuerUniqueId.get(string2);
                break;
            }
            case 9: {
                object = string2 == null ? this.subjectUniqueId : (this.subjectUniqueId == null ? null : this.subjectUniqueId.get(string2));
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "get", object);
        }
        return object;
    }

    private void parse(DerValue derValue) throws CertificateParsingException, IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "parse", derValue);
        }
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(8192L, className, "parse", "signed fields invalid");
            }
            throw new CertificateParsingException("signed fields invalid");
        }
        this.rawCertInfo = derValue.toByteArray();
        DerInputStream derInputStream = derValue.getData();
        DerValue derValue2 = derInputStream.getDerValue();
        if (derValue2.isContextSpecific((byte)0)) {
            this.version = new CertificateVersion(derValue2);
            derValue2 = derInputStream.getDerValue();
        }
        this.serialNum = new CertificateSerialNumber(derValue2);
        this.algId = new CertificateAlgorithmId(derInputStream);
        this.issuer = new CertificateIssuerName(derInputStream);
        if (this.version.compare(0) == 0 && this.issuer.toString() == null) {
            if (debug != null) {
                debug.text(8192L, className, "parse", "Null issuer DN not allowed in v1 certificate");
            }
            throw new CertificateParsingException("Null issuer DN not allowed in v1 certificate");
        }
        this.interval = new CertificateValidity(derInputStream);
        this.subject = new CertificateSubjectName(derInputStream);
        if (this.version.compare(0) == 0 && this.subject.toString() == null) {
            if (debug != null) {
                debug.text(8192L, className, "parse", "Null subject DN not allowed in v1 certificate");
            }
            throw new CertificateParsingException("Null subject DN not allowed in v1 certificate");
        }
        this.pubKey = this.provider != null ? new CertificateX509Key(derInputStream, this.provider) : new CertificateX509Key(derInputStream);
        if (derInputStream.available() != 0) {
            if (this.version.compare(0) == 0) {
                if (debug != null) {
                    debug.text(8192L, className, "parse", "no more data allowed for version 1 certificate");
                }
                throw new CertificateParsingException("no more data allowed for version 1 certificate");
            }
        } else {
            if (debug != null) {
                debug.exit(8192L, className, "parse_1");
            }
            return;
        }
        derValue2 = derInputStream.getDerValue();
        if (derValue2.isContextSpecific((byte)1)) {
            this.issuerUniqueId = new CertificateIssuerUniqueIdentity(derValue2);
            if (derInputStream.available() == 0) {
                if (debug != null) {
                    debug.exit(8192L, className, "parse_2");
                }
                return;
            }
            derValue2 = derInputStream.getDerValue();
        }
        if (derValue2.isContextSpecific((byte)2)) {
            this.subjectUniqueId = new CertificateSubjectUniqueIdentity(derValue2);
            if (derInputStream.available() == 0) {
                if (debug != null) {
                    debug.exit(8192L, className, "parse_3");
                }
                return;
            }
            derValue2 = derInputStream.getDerValue();
        }
        if (this.version.compare(2) != 0) {
            if (debug != null) {
                debug.text(8192L, className, "parse", "Extensions not allowed in v2 certificate");
            }
            throw new CertificateParsingException("Extensions not allowed in v2 certificate");
        }
        if (derValue2.isConstructed() && derValue2.isContextSpecific((byte)3)) {
            this.extensions = new CertificateExtensions(derValue2.getData());
        }
        if (this.subject == null || this.subject.toString() == null || this.subject.toString().length() == 0) {
            if (this.extensions == null) {
                throw new CertificateParsingException("X.509 Certificate is incomplete: subject field is empty, and certificate has no extensions");
            }
            SubjectAlternativeNameExtension subjectAlternativeNameExtension = null;
            Object var5_5 = null;
            GeneralNames generalNames = null;
            try {
                subjectAlternativeNameExtension = (SubjectAlternativeNameExtension)this.extensions.get("SubjectAlternativeName");
                generalNames = (GeneralNames)subjectAlternativeNameExtension.get("subject_name");
            }
            catch (IOException iOException) {
                throw new CertificateParsingException("X.509 Certificate is incomplete: subject field is empty, and SubjectAlternativeName extension is absent");
            }
            if (generalNames == null || generalNames.isEmpty()) {
                throw new CertificateParsingException("X.509 Certificate is incomplete: subject field is empty, and SubjectAlternativeName extension is empty");
            }
            if (!subjectAlternativeNameExtension.isCritical()) {
                throw new CertificateParsingException("X.509 Certificate is incomplete: SubjectAlternativeName extension MUST be marked critical when subject field is empty");
            }
        }
        if (debug != null) {
            debug.exit(8192L, className, "parse");
        }
    }

    private void emit(DerOutputStream derOutputStream) throws CertificateException, IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "emit", derOutputStream);
        }
        DerOutputStream derOutputStream2 = new DerOutputStream();
        this.version.encode(derOutputStream2);
        this.serialNum.encode(derOutputStream2);
        this.algId.encode(derOutputStream2);
        if (this.version.compare(0) == 0 && this.issuer.toString() == null) {
            if (debug != null) {
                debug.text(8192L, className, "emit", "Null issuer DN not allowed in v1 certificate");
            }
            throw new CertificateParsingException("Null issuer DN not allowed in v1 certificate");
        }
        this.issuer.encode(derOutputStream2);
        this.interval.encode(derOutputStream2);
        if (this.version.compare(0) == 0 && this.subject.toString() == null) {
            if (debug != null) {
                debug.text(8192L, className, "emit", "Null subject DN not allowed in v1 certificate");
            }
            throw new CertificateParsingException("Null subject DN not allowed in v1 certificate");
        }
        this.subject.encode(derOutputStream2);
        this.pubKey.encode(derOutputStream2);
        if (this.issuerUniqueId != null) {
            this.issuerUniqueId.encode(derOutputStream2);
        }
        if (this.subjectUniqueId != null) {
            this.subjectUniqueId.encode(derOutputStream2);
        }
        if (this.extensions != null) {
            this.extensions.encode(derOutputStream2);
        }
        derOutputStream.write((byte)48, derOutputStream2);
        if (debug != null) {
            debug.exit(8192L, className, "emit");
        }
    }

    private int attributeMap(String string) {
        Integer n;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "attributeMap", string);
        }
        if ((n = map.get(string)) == null) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "attributeMap_1", new Integer(0));
            }
            return 0;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "attributeMap", new Integer(n));
        }
        return n;
    }

    private void setVersion(Object object) throws CertificateException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setVersion", object);
        }
        if (object instanceof CertificateVersion) {
            CertificateVersion certificateVersion = (CertificateVersion)object;
            try {
                if (certificateVersion.compare(0) == 0) {
                    this.version = new CertificateVersion(0);
                }
                DerOutputStream derOutputStream = new DerOutputStream();
                ((CertificateVersion)object).encode(derOutputStream);
                this.version = new CertificateVersion(new DerInputStream(derOutputStream.toByteArray()));
            }
            catch (IOException iOException) {
                if (debug != null) {
                    debug.exception(8192L, className, "setVersion", iOException);
                }
                throw new CertificateException(iOException.toString());
            }
        } else if (object instanceof Integer) {
            try {
                this.version = new CertificateVersion((Integer)object);
            }
            catch (IOException iOException) {
                if (debug != null) {
                    debug.exception(8192L, className, "setVersion", iOException);
                }
                throw new CertificateException(iOException.toString());
            }
        } else {
            if (debug != null) {
                debug.text(8192L, className, "setVersion", "Version class type invalid.");
            }
            throw new CertificateException("Version class type invalid.");
        }
        if (debug != null) {
            debug.exit(8192L, className, "setVersion");
        }
    }

    private void setSerialNumber(Object object) throws CertificateException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setSerialNumber", object);
        }
        if (object instanceof CertificateSerialNumber) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                ((CertificateSerialNumber)object).encode(derOutputStream);
                this.serialNum = new CertificateSerialNumber(new DerInputStream(derOutputStream.toByteArray()));
            }
            catch (IOException iOException) {
                if (debug != null) {
                    debug.exception(8192L, className, "setSerialNumber", iOException);
                }
                throw new CertificateException(iOException.toString());
            }
        } else if (object instanceof BigInteger) {
            this.serialNum = new CertificateSerialNumber((BigInteger)object);
        } else {
            if (debug != null) {
                debug.text(8192L, className, "setSerialNumber", "SerialNumber class type invalid.");
            }
            throw new CertificateException("SerialNumber class type invalid.");
        }
        if (debug != null) {
            debug.exit(8192L, className, "setSerialNumber");
        }
    }

    private void setAlgorithmId(Object object) throws CertificateException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setAlgorithmId", object);
        }
        if (object instanceof CertificateAlgorithmId) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                ((CertificateAlgorithmId)object).encode(derOutputStream);
                this.algId = new CertificateAlgorithmId(new DerInputStream(derOutputStream.toByteArray()));
            }
            catch (IOException iOException) {
                if (debug != null) {
                    debug.exception(8192L, className, "setAlgorithmId", iOException);
                }
                throw new CertificateException(iOException.toString());
            }
        } else if (object instanceof AlgorithmId) {
            this.algId = new CertificateAlgorithmId((AlgorithmId)object);
        } else {
            if (debug != null) {
                debug.text(8192L, className, "setAlgorithmId", "AlgorithmId class type invalid.");
            }
            throw new CertificateException("AlgorithmId class type invalid.");
        }
        if (debug != null) {
            debug.exit(8192L, className, "setAlgorithmId");
        }
    }

    private void setIssuer(Object object) throws CertificateException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setIssuer", object);
        }
        if (object instanceof CertificateIssuerName) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                ((CertificateIssuerName)object).encode(derOutputStream);
                this.issuer = new CertificateIssuerName(new DerInputStream(derOutputStream.toByteArray()));
            }
            catch (IOException iOException) {
                if (debug != null) {
                    debug.exception(8192L, className, "setIssuer", iOException);
                }
                throw new CertificateException(iOException.toString());
            }
        } else if (object instanceof X500Name) {
            this.issuer = new CertificateIssuerName((X500Name)object);
        } else {
            if (debug != null) {
                debug.text(8192L, className, "setIssuer", "Issuer class type invalid.");
            }
            throw new CertificateException("Issuer class type invalid.");
        }
        if (debug != null) {
            debug.exit(8192L, className, "setIssuer");
        }
    }

    private void setValidity(Object object) throws CertificateException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setValidity", object);
        }
        if (!(object instanceof CertificateValidity)) {
            if (debug != null) {
                debug.text(8192L, className, "setValidity", "CertificateValidity class type invalid.");
            }
            throw new CertificateException("CertificateValidity class type invalid.");
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            ((CertificateValidity)object).encode(derOutputStream);
            this.interval = new CertificateValidity(new DerInputStream(derOutputStream.toByteArray()));
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.exception(8192L, className, "setValidity", iOException);
            }
            throw new CertificateException(iOException.toString());
        }
        if (debug != null) {
            debug.exit(8192L, className, "setValidity");
        }
    }

    private void setSubject(Object object) throws CertificateException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setSubject", object);
        }
        if (object instanceof CertificateSubjectName) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                ((CertificateSubjectName)object).encode(derOutputStream);
                this.subject = new CertificateSubjectName(new DerInputStream(derOutputStream.toByteArray()));
            }
            catch (IOException iOException) {
                if (debug != null) {
                    debug.exception(8192L, className, "setSubject", iOException);
                }
                throw new CertificateException(iOException.toString());
            }
        } else if (object instanceof X500Name) {
            this.subject = new CertificateSubjectName((X500Name)object);
        } else {
            if (debug != null) {
                debug.text(8192L, className, "setSubject", "Subject class type invalid.");
            }
            throw new CertificateException("Subject class type invalid.");
        }
        if (debug != null) {
            debug.exit(8192L, className, "setSubject");
        }
    }

    private void setKey(Object object) throws CertificateException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setKey", object);
        }
        if (object instanceof CertificateX509Key) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                ((CertificateX509Key)object).encode(derOutputStream);
                if (this.provider != null) {
                    this.pubKey = new CertificateX509Key(new DerInputStream(derOutputStream.toByteArray()), this.provider);
                }
                this.pubKey = new CertificateX509Key(new DerInputStream(derOutputStream.toByteArray()));
            }
            catch (IOException iOException) {
                if (debug != null) {
                    debug.exception(8192L, className, "setKey", iOException);
                }
                throw new CertificateException(iOException.toString());
            }
        } else if (object instanceof PublicKey) {
            this.pubKey = this.provider != null ? new CertificateX509Key((PublicKey)object, this.provider) : new CertificateX509Key((PublicKey)object);
        } else {
            if (debug != null) {
                debug.text(8192L, className, "setKey", "Key class type invalid.");
            }
            throw new CertificateException("Key class type invalid.");
        }
        if (debug != null) {
            debug.exit(8192L, className, "setKey");
        }
    }

    private void setIssuerUniqueId(Object object) throws CertificateException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setIssuerUniqueId", object);
        }
        if (this.version.compare(1) < 0) {
            if (debug != null) {
                debug.text(8192L, className, "setIssuerUniqueId", "Invalid version");
            }
            throw new CertificateException("Invalid version");
        }
        if (object instanceof CertificateIssuerUniqueIdentity) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                ((CertificateIssuerUniqueIdentity)object).encode(derOutputStream);
                this.issuerUniqueId = new CertificateIssuerUniqueIdentity(new DerInputStream(derOutputStream.toByteArray()));
            }
            catch (IOException iOException) {
                if (debug != null) {
                    debug.exception(8192L, className, "setIssuerUniqueId", iOException);
                }
                throw new CertificateException(iOException.toString());
            }
        } else if (object instanceof UniqueIdentity) {
            this.issuerUniqueId = new CertificateIssuerUniqueIdentity((UniqueIdentity)object);
        } else {
            if (debug != null) {
                debug.text(8192L, className, "setIssuerUniqueId", "IssuerUniqueId class type invalid.");
            }
            throw new CertificateException("IssuerUniqueId class type invalid.");
        }
        if (debug != null) {
            debug.exit(8192L, className, "setIssuerUniqueId");
        }
    }

    private void setSubjectUniqueId(Object object) throws CertificateException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setSubjectUniqueId", object);
        }
        if (this.version.compare(1) < 0) {
            if (debug != null) {
                debug.text(8192L, className, "setSubjectUniqueId", "Invalid version");
            }
            throw new CertificateException("Invalid version");
        }
        if (object instanceof CertificateSubjectUniqueIdentity) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                ((CertificateSubjectUniqueIdentity)object).encode(derOutputStream);
                this.subjectUniqueId = new CertificateSubjectUniqueIdentity(new DerInputStream(derOutputStream.toByteArray()));
            }
            catch (IOException iOException) {
                if (debug != null) {
                    debug.exception(8192L, className, "setSubjectUniqueId", iOException);
                }
                throw new CertificateException(iOException.toString());
            }
        } else if (object instanceof UniqueIdentity) {
            this.subjectUniqueId = new CertificateSubjectUniqueIdentity((UniqueIdentity)object);
        } else {
            if (debug != null) {
                debug.text(8192L, className, "setSubjectUniqueId", "SubjectUniqueId class type invalid.");
            }
            throw new CertificateException("SubjectUniqueId class type invalid.");
        }
    }

    private void setExtensions(Object object) throws CertificateException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setExtensions", object);
        }
        if (this.version.compare(2) < 0) {
            if (debug != null) {
                debug.text(8192L, className, "setExtensions", "Invalid version");
            }
            throw new CertificateException("Invalid version");
        }
        if (!(object instanceof CertificateExtensions)) {
            if (debug != null) {
                debug.text(8192L, className, "setExtensions", "Extensions class type invalid.");
            }
            throw new CertificateException("Extensions class type invalid.");
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ((CertificateExtensions)object).encode(byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this.extensions = new CertificateExtensions();
            this.extensions.decodeThis(new ByteArrayInputStream(byArray));
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.exception(8192L, className, "setExtensions", iOException);
            }
            throw new CertificateException(iOException.toString());
        }
        if (debug != null) {
            debug.exit(8192L, className, "setExtensions");
        }
    }

    static {
        map.put(VERSION, new Integer(1));
        map.put(SERIAL_NUMBER, new Integer(2));
        map.put(ALGORITHM_ID, new Integer(3));
        map.put(ISSUER, new Integer(4));
        map.put(VALIDITY, new Integer(5));
        map.put(SUBJECT, new Integer(6));
        map.put(KEY, new Integer(7));
        map.put(ISSUER_ID, new Integer(8));
        map.put(SUBJECT_ID, new Integer(9));
        map.put(EXTENSIONS, new Integer(10));
        debug = Debug.getInstance("ibmpkcs");
        className = "com.ibm.security.x509.X509CertInfo";
    }
}

