/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.Attribute;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.PKIXExtensions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SubjectDirectoryAttributesExtension
extends Extension
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.extensions.SubjectDirectoryAttributes";
    public static final String NAME = "SubjectDirectoryAttributes";
    public static final String NUMBER = "value";
    Attribute[] attributes;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.SubjectDirectoryAttributesExtension";

    private void encodeThis() throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "encodeThis");
        }
        if (this.attributes == null || this.attributes.length == 0) {
            this.extensionValue = null;
            if (debug != null) {
                debug.exit(8192L, className, "encodeThis_1");
            }
            return;
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        for (int i = 0; i < this.attributes.length; ++i) {
            this.attributes[i].encode(derOutputStream2);
        }
        derOutputStream.write((byte)48, derOutputStream2);
        this.extensionValue = derOutputStream.toByteArray();
        if (debug != null) {
            debug.exit(8192L, className, "encodeThis_2");
        }
    }

    public SubjectDirectoryAttributesExtension(Attribute[] attributeArray) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SubjectDirectoryAttributesExtension", attributeArray);
        }
        this.extensionId = PKIXExtensions.SubjectDirectoryAttributes_Id;
        this.critical = false;
        if (attributeArray == null || attributeArray.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "SubjectDirectoryAttributesExtension", "attribs is null or empty");
            }
            throw new IllegalArgumentException("attribs is null or empty");
        }
        this.attributes = new Attribute[attributeArray.length];
        for (int i = 0; i < attributeArray.length; ++i) {
            this.attributes[i] = new Attribute(attributeArray[i].getOID(), attributeArray[i].getDerValue());
        }
        if (debug != null) {
            debug.exit(16384L, className, "SubjectDirectoryAttributesExtension");
        }
    }

    public SubjectDirectoryAttributesExtension() {
        if (debug != null) {
            debug.entry(16384L, className, "SubjectDirectoryAttributesExtension");
        }
        this.extensionId = PKIXExtensions.SubjectDirectoryAttributes_Id;
        this.critical = false;
        this.attributes = null;
        if (debug != null) {
            debug.exit(16384L, className, "SubjectDirectoryAttributesExtension");
        }
    }

    public SubjectDirectoryAttributesExtension(Boolean bl, Object object) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "SubjectDirectoryAttributesExtension", bl, object);
        }
        this.extensionId = PKIXExtensions.SubjectDirectoryAttributes_Id;
        this.critical = bl;
        if (!(object instanceof byte[])) {
            if (debug != null) {
                debug.text(16384L, className, "SubjectDirectoryAttributesExtension", "SubjectDirectoryAttributes: Illegal argument type");
            }
            throw new IOException("SubjectDirectoryAttributes: Illegal argument type");
        }
        int n = Array.getLength(object);
        byte[] byArray = new byte[n];
        System.arraycopy(object, 0, byArray, 0, n);
        this.extensionValue = byArray;
        DerInputStream derInputStream = new DerInputStream(byArray);
        DerValue[] derValueArray = derInputStream.getSequence(1);
        this.attributes = new Attribute[derValueArray.length];
        for (int i = 0; i < derValueArray.length; ++i) {
            DerOutputStream derOutputStream = new DerOutputStream();
            derValueArray[i].encode(derOutputStream);
            DerInputStream derInputStream2 = new DerInputStream(derOutputStream.toByteArray());
            this.attributes[i] = new Attribute(derInputStream2);
        }
        if (debug != null) {
            debug.exit(16384L, className, "SubjectDirectoryAttributesExtension");
        }
    }

    @Override
    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        if (this.attributes == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "toString_1", "");
            }
            return "";
        }
        String string = super.toString() + "SubjectDirectoryAttributes[" + this.attributes.length + "] [\r\n";
        for (int i = 0; i < this.attributes.length; ++i) {
            string = string + "#" + i + this.attributes[i].toString();
        }
        string = string + "]\r\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString_2", string);
        }
        return string;
    }

    @Override
    public void decode(InputStream inputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", inputStream);
            debug.text(16384L, className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.SubjectDirectoryAttributes_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public void set(String string, Object object) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", string, object);
        }
        if (string.equalsIgnoreCase(NUMBER)) {
            if (!(object instanceof Attribute[])) {
                if (debug != null) {
                    debug.text(16384L, className, "set", "Attribute value should be of type Attribute[].");
                }
                throw new IOException("Attribute value should be of type Attribute[].");
            }
            Attribute[] attributeArray = (Attribute[])object;
            if (attributeArray == null || attributeArray.length == 0) {
                if (debug != null) {
                    debug.text(16384L, className, "set", "obj Attribute[] is null or is empty");
                }
                throw new IllegalArgumentException("obj Attribute[] is null or is empty");
            }
            this.attributes = new Attribute[attributeArray.length];
            for (int i = 0; i < attributeArray.length; ++i) {
                this.attributes[i] = new Attribute(attributeArray[i].getOID(), attributeArray[i].getDerValue());
            }
        } else {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized by CertAttrSet:SubjectDirectoryAttributes.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:SubjectDirectoryAttributes.");
        }
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    @Override
    public Object get(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", string);
        }
        if (string.equalsIgnoreCase(NUMBER)) {
            if (this.attributes == null || this.attributes.length == 0) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "get_1", null);
                }
                return null;
            }
            Attribute[] attributeArray = new Attribute[this.attributes.length];
            for (int i = 0; i < this.attributes.length; ++i) {
                attributeArray[i] = new Attribute(this.attributes[i].getOID(), this.attributes[i].getDerValue());
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_2", attributeArray);
            }
            return attributeArray;
        }
        if (debug != null) {
            debug.text(16384L, className, "get_2", "Attribute name not recognized by CertAttrSet:SubjectDirectoryAttributes.");
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:SubjectDirectoryAttributes.");
    }

    @Override
    public void delete(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", string);
        }
        if (!string.equalsIgnoreCase(NUMBER)) {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Attribute name not recognized by CertAttrSet:SubjectDirectoryAttributes.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:SubjectDirectoryAttributes.");
        }
        this.attributes = null;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    @Override
    public Enumeration getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(NUMBER);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", attributeNameEnumeration.elements());
        }
        return attributeNameEnumeration.elements();
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }
}

