/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.BitArray;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AttributeNameEnumeration;
import java.io.IOException;
import java.util.Enumeration;

public final class ReasonFlags {
    public static final String UNUSED = "unused";
    public static final String KEY_COMPROMISE = "key_compromise";
    public static final String CA_COMPROMISE = "ca_compromise";
    public static final String AFFLIATION_CHANGED = "affliation_changed";
    public static final String SUPERSEDED = "superseded";
    public static final String CESSATION_OF_OPERATION = "cessation_of_operation";
    public static final String CERTIFICATE_HOLD = "certificate_hold";
    public static final String PRIVILEGE_WITHDRAWN = "privilege_withdrawn";
    public static final String AA_COMPROMISE = "aa_compromise";
    private boolean[] bitString;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.ReasonFlags";

    private boolean isSet(int n) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "isSet", new Integer(n));
            debug.exit(8192L, (Object)className, "isSet", this.bitString[n]);
        }
        return this.bitString[n];
    }

    private void set(int n, boolean bl) {
        if (debug != null) {
            debug.entry(8192L, className, "set", new Integer(n), new Boolean(bl));
        }
        if (n >= this.bitString.length) {
            boolean[] blArray = new boolean[n + 1];
            System.arraycopy(this.bitString, 0, blArray, 0, this.bitString.length);
            this.bitString = blArray;
        }
        this.bitString[n] = bl;
        if (debug != null) {
            debug.exit(8192L, className, "set");
        }
    }

    public ReasonFlags(byte[] byArray) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "ReasonFlags", (Object)byArray);
        }
        this.bitString = new BitArray(byArray.length * 8, byArray).toBooleanArray();
        if (debug != null) {
            debug.exit(16384L, className, "ReasonFlags");
        }
    }

    public ReasonFlags(boolean[] blArray) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "ReasonFlags", (Object)blArray);
            debug.exit(16384L, className, "ReasonFlags");
        }
        this.bitString = blArray;
    }

    public ReasonFlags(BitArray bitArray) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "ReasonFlags", bitArray);
        }
        this.bitString = bitArray.toBooleanArray();
        if (debug != null) {
            debug.exit(16384L, className, "ReasonFlags");
        }
    }

    public ReasonFlags(DerInputStream derInputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "ReasonFlags", derInputStream);
        }
        DerValue derValue = derInputStream.getDerValue();
        this.bitString = derValue.getUnalignedBitString(true).toBooleanArray();
        if (debug != null) {
            debug.exit(16384L, className, "ReasonFlags");
        }
    }

    public ReasonFlags(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "ReasonFlags", derValue);
        }
        this.bitString = derValue.getUnalignedBitString(true).toBooleanArray();
        if (debug != null) {
            debug.exit(16384L, className, "ReasonFlags");
        }
    }

    public void set(String string, Object object) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", string, object);
        }
        if (!(object instanceof Boolean)) {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute must be of type Boolean.");
            }
            throw new IOException("Attribute must be of type Boolean.");
        }
        boolean bl = (Boolean)object;
        if (string.equalsIgnoreCase(UNUSED)) {
            this.set(0, bl);
        } else if (string.equalsIgnoreCase(KEY_COMPROMISE)) {
            this.set(1, bl);
        } else if (string.equalsIgnoreCase(CA_COMPROMISE)) {
            this.set(2, bl);
        } else if (string.equalsIgnoreCase(AFFLIATION_CHANGED)) {
            this.set(3, bl);
        } else if (string.equalsIgnoreCase(SUPERSEDED)) {
            this.set(4, bl);
        } else if (string.equalsIgnoreCase(CESSATION_OF_OPERATION)) {
            this.set(5, bl);
        } else if (string.equalsIgnoreCase(CERTIFICATE_HOLD)) {
            this.set(6, bl);
        } else if (string.equalsIgnoreCase(PRIVILEGE_WITHDRAWN)) {
            this.set(7, bl);
        } else if (string.equalsIgnoreCase(AA_COMPROMISE)) {
            this.set(8, bl);
        } else {
            if (debug != null) {
                debug.text(16384L, className, "set", "Name not recognized by ReasonFlags");
            }
            throw new IOException("Name not recognized by ReasonFlags");
        }
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    public Object get(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", string);
        }
        if (string.equalsIgnoreCase(UNUSED)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_1", new Boolean(this.isSet(0)));
            }
            return new Boolean(this.isSet(0));
        }
        if (string.equalsIgnoreCase(KEY_COMPROMISE)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_2", new Boolean(this.isSet(1)));
            }
            return new Boolean(this.isSet(1));
        }
        if (string.equalsIgnoreCase(CA_COMPROMISE)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_3", new Boolean(this.isSet(2)));
            }
            return new Boolean(this.isSet(2));
        }
        if (string.equalsIgnoreCase(AFFLIATION_CHANGED)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_4", new Boolean(this.isSet(3)));
            }
            return new Boolean(this.isSet(3));
        }
        if (string.equalsIgnoreCase(SUPERSEDED)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_5", new Boolean(this.isSet(4)));
            }
            return new Boolean(this.isSet(4));
        }
        if (string.equalsIgnoreCase(CESSATION_OF_OPERATION)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_6", new Boolean(this.isSet(5)));
            }
            return new Boolean(this.isSet(5));
        }
        if (string.equalsIgnoreCase(CERTIFICATE_HOLD)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_7", new Boolean(this.isSet(6)));
            }
            return new Boolean(this.isSet(6));
        }
        if (string.equalsIgnoreCase(PRIVILEGE_WITHDRAWN)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_8", new Boolean(this.isSet(7)));
            }
            return new Boolean(this.isSet(7));
        }
        if (string.equalsIgnoreCase(AA_COMPROMISE)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_9", new Boolean(this.isSet(8)));
            }
            return new Boolean(this.isSet(8));
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "get", "Name not recognized by ReasonFlags");
        }
        throw new IOException("Name not recognized by ReasonFlags");
    }

    public void delete(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", string);
        }
        if (string.equalsIgnoreCase(UNUSED)) {
            this.set(0, false);
        } else if (string.equalsIgnoreCase(KEY_COMPROMISE)) {
            this.set(1, false);
        } else if (string.equalsIgnoreCase(CA_COMPROMISE)) {
            this.set(2, false);
        } else if (string.equalsIgnoreCase(AFFLIATION_CHANGED)) {
            this.set(3, false);
        } else if (string.equalsIgnoreCase(SUPERSEDED)) {
            this.set(4, false);
        } else if (string.equalsIgnoreCase(CESSATION_OF_OPERATION)) {
            this.set(5, false);
        } else if (string.equalsIgnoreCase(CERTIFICATE_HOLD)) {
            this.set(6, false);
        } else if (string.equalsIgnoreCase(PRIVILEGE_WITHDRAWN)) {
            this.set(7, false);
        } else if (string.equalsIgnoreCase(AA_COMPROMISE)) {
            this.set(8, false);
        } else {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Name not recognized by ReasonFlags");
            }
            throw new IOException("Name not recognized by ReasonFlags");
        }
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    public String toString() {
        String string;
        block13: {
            string = "Reason Flags [\n";
            if (debug != null) {
                debug.entry(16384L, className, "toString");
            }
            try {
                if (this.isSet(0)) {
                    string = string + "  Unused\n";
                }
                if (this.isSet(1)) {
                    string = string + "  Key Compromise\n";
                }
                if (this.isSet(2)) {
                    string = string + "  CA_Compromise\n";
                }
                if (this.isSet(3)) {
                    string = string + "  Affiliation_Changed\n";
                }
                if (this.isSet(4)) {
                    string = string + "  Superseded\n";
                }
                if (this.isSet(5)) {
                    string = string + "  Cessation Of Operation\n";
                }
                if (this.isSet(6)) {
                    string = string + "  Certificate Hold\n";
                }
                if (this.isSet(7)) {
                    string = string + "  Privilege Withdrawn\n";
                }
                if (this.isSet(8)) {
                    string = string + "  AA Compromise\n";
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (debug == null) break block13;
                debug.exception(16384L, className, "toString", arrayIndexOutOfBoundsException);
            }
        }
        string = string + "]\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }

    public BitArray getReasonFlags() {
        if (debug != null) {
            debug.entry(16384L, className, "getReasonFlags");
            debug.exit(16384L, (Object)className, "getReasonFlags", new BitArray(this.bitString));
        }
        return new BitArray(this.bitString);
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", derOutputStream);
        }
        derOutputStream.putNamedBitString(new BitArray(this.bitString));
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public Enumeration getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(UNUSED);
        attributeNameEnumeration.addElement(KEY_COMPROMISE);
        attributeNameEnumeration.addElement(CA_COMPROMISE);
        attributeNameEnumeration.addElement(AFFLIATION_CHANGED);
        attributeNameEnumeration.addElement(SUPERSEDED);
        attributeNameEnumeration.addElement(CESSATION_OF_OPERATION);
        attributeNameEnumeration.addElement(CERTIFICATE_HOLD);
        attributeNameEnumeration.addElement(PRIVILEGE_WITHDRAWN);
        attributeNameEnumeration.addElement(AA_COMPROMISE);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", attributeNameEnumeration.elements());
        }
        return attributeNameEnumeration.elements();
    }
}

