/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.GeneralNameInterface;
import com.ibm.security.x509.OIDMap;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Arrays;

public final class OtherName
implements GeneralNameInterface {
    private String name;
    private ObjectIdentifier oid;
    private byte[] nameValue = null;
    private GeneralNameInterface gni = null;
    private int myhash = -1;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.OtherName";

    public OtherName(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "OtherName", derValue);
        }
        DerInputStream derInputStream = derValue.toDerInputStream();
        this.oid = derInputStream.getOID();
        DerValue derValue2 = derInputStream.getDerValue();
        this.nameValue = derValue2.toByteArray();
        this.gni = this.getGNI(this.oid, this.nameValue);
        this.name = this.gni != null ? this.gni.toString() : "Unrecognized ObjectIdentifier: " + this.oid.toString();
        if (debug != null) {
            debug.exit(16384L, className, "OtherName");
        }
    }

    public OtherName(ObjectIdentifier objectIdentifier, byte[] byArray) throws IOException {
        if (objectIdentifier == null || byArray == null) {
            throw new NullPointerException("parameters may not be null");
        }
        this.oid = objectIdentifier;
        this.nameValue = byArray;
        this.gni = this.getGNI(objectIdentifier, byArray);
        this.name = this.gni != null ? this.gni.toString() : "Unrecognized ObjectIdentifier: " + objectIdentifier.toString();
    }

    public int getType() {
        if (debug != null) {
            debug.entry(16384L, className, "getType");
            debug.exit(16384L, (Object)className, "getType", 0);
        }
        return 0;
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", derOutputStream);
        }
        if (this.gni == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Unknown Other-Name: " + this.name);
            }
            DerOutputStream derOutputStream2 = new DerOutputStream();
            derOutputStream2.putOID(this.oid);
            derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)0), this.nameValue);
            derOutputStream.write((byte)48, derOutputStream2);
        } else {
            this.gni.encode(derOutputStream);
        }
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public ObjectIdentifier getOID() {
        return this.oid;
    }

    public byte[] getNameValue() {
        return (byte[])this.nameValue.clone();
    }

    public boolean equals(Object object) {
        boolean bl;
        if (this == object) {
            return true;
        }
        if (!(object instanceof OtherName)) {
            return false;
        }
        OtherName otherName = (OtherName)object;
        if (!otherName.oid.equals(this.oid)) {
            return false;
        }
        GeneralNameInterface generalNameInterface = null;
        try {
            generalNameInterface = this.getGNI(otherName.oid, otherName.nameValue);
        }
        catch (IOException iOException) {
            return false;
        }
        if (generalNameInterface != null) {
            try {
                bl = generalNameInterface.constrains(this) == 0;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                bl = false;
            }
        } else {
            bl = Arrays.equals(this.nameValue, otherName.nameValue);
        }
        return bl;
    }

    public int hashCode() {
        if (this.myhash == -1) {
            this.myhash = 37 + this.oid.hashCode();
            for (int i = 0; i < this.nameValue.length; ++i) {
                this.myhash = 37 * this.myhash + this.nameValue[i];
            }
        }
        return this.myhash;
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
            debug.entry(16384L, (Object)className, "toString", "Other-Name: " + this.name);
        }
        return "Other-Name: " + this.name;
    }

    private GeneralNameInterface getGNI(ObjectIdentifier objectIdentifier, byte[] byArray) throws IOException {
        try {
            Class clazz = OIDMap.getClass(objectIdentifier);
            if (clazz == null) {
                if (debug != null) {
                    debug.exit(16384L, className, "OtherName_1");
                }
                return null;
            }
            Class[] classArray = new Class[]{Object.class};
            Constructor constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{byArray};
            return (GeneralNameInterface)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "OtherName", exception);
            }
            throw (IOException)new IOException("Instantiation error: " + exception).initCause(exception);
        }
    }

    public int constrains(GeneralNameInterface generalNameInterface) {
        int n;
        if (generalNameInterface == null) {
            n = -1;
        } else if (generalNameInterface.getType() != 0) {
            n = -1;
        } else {
            throw new UnsupportedOperationException("Narrowing, widening, and matching are not supported for OtherName.");
        }
        return n;
    }

    public int subtreeDepth() {
        throw new UnsupportedOperationException("subtreeDepth() not supported for generic OtherName");
    }
}

