/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.GeneralNameInterface;
import java.io.IOException;

public final class OIDName
implements GeneralNameInterface {
    private ObjectIdentifier oid;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.OIDName";

    public OIDName(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "OIDName", derValue);
        }
        this.oid = derValue.getOID();
        if (debug != null) {
            debug.exit(16384L, className, "OIDName");
        }
    }

    public OIDName(ObjectIdentifier objectIdentifier) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "OIDName", objectIdentifier);
            debug.exit(16384L, className, "OIDName");
        }
        this.oid = objectIdentifier;
    }

    public OIDName(String string) throws IOException {
        try {
            this.oid = new ObjectIdentifier(string);
        }
        catch (Exception exception) {
            throw new IOException("Unable to create OIDName: " + exception);
        }
    }

    public int getType() {
        if (debug != null) {
            debug.entry(16384L, className, "getType");
            debug.exit(16384L, (Object)className, "getType", 8);
        }
        return 8;
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", derOutputStream);
        }
        derOutputStream.putOID(this.oid);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
            debug.exit(16384L, (Object)className, "toString", "OIDName: " + this.oid.toString());
        }
        return "OIDName: " + this.oid.toString();
    }

    public ObjectIdentifier getOID() {
        return this.oid;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof OIDName)) {
            return false;
        }
        OIDName oIDName = (OIDName)object;
        return this.oid.equals(oIDName.oid);
    }

    public int hashCode() {
        return this.oid.hashCode();
    }

    public int constrains(GeneralNameInterface generalNameInterface) throws UnsupportedOperationException {
        int n;
        if (generalNameInterface == null) {
            n = -1;
        } else if (generalNameInterface.getType() != 8) {
            n = -1;
        } else if (this.equals((OIDName)generalNameInterface)) {
            n = 0;
        } else {
            throw new UnsupportedOperationException("Narrowing and widening are not supported for OIDNames");
        }
        return n;
    }

    public int subtreeDepth() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("subtreeDepth() not supported for OIDName.");
    }
}

