/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.DistributionPointName;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.GeneralNameInterface;
import com.ibm.security.x509.GeneralNamesException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;

public final class GeneralNames
extends Vector
implements DistributionPointName {
    static final long serialVersionUID = 937266807388640626L;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.GeneralNames";

    public GeneralNames(DerValue derValue) throws IOException, GeneralNamesException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "GeneralNames", derValue);
        }
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "GeneralNames", "Invalid encoding for GeneralNames.");
            }
            throw new IOException("Invalid encoding for GeneralNames.");
        }
        if (derValue.getData().available() == 0) {
            if (debug != null) {
                debug.text(16384L, className, "GeneralNames", "No data available in passed DER encoded value.");
            }
            throw new GeneralNamesException("No data available in passed DER encoded value.");
        }
        while (derValue.getData().available() != 0) {
            DerValue derValue2 = derValue.getData().getDerValue();
            GeneralName generalName = new GeneralName(derValue2);
            this.addElement(generalName);
        }
        if (debug != null) {
            debug.exit(16384L, className, "GeneralNames");
        }
    }

    public GeneralNames() {
        super(1, 1);
        if (debug != null) {
            debug.entry(16384L, className, "GeneralNames");
            debug.exit(16384L, className, "GeneralNames");
        }
    }

    public void encode(DerOutputStream derOutputStream) throws IOException, GeneralNamesException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", derOutputStream);
        }
        if (this.size() == 0) {
            return;
        }
        Enumeration enumeration = this.elements();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof GeneralNameInterface)) {
                if (debug != null) {
                    debug.text(16384L, className, "encode", "Element in GeneralNames not of type GeneralName.");
                }
                throw new GeneralNamesException("Element in GeneralNames not of type GeneralName.");
            }
            GeneralNameInterface generalNameInterface = (GeneralNameInterface)e;
            DerOutputStream derOutputStream3 = new DerOutputStream();
            generalNameInterface.encode(derOutputStream3);
            int n = generalNameInterface.getType();
            if (n == 4) {
                DerValue derValue = new DerValue(derOutputStream3.toByteArray());
                if (derValue.isContextSpecific()) {
                    derOutputStream2.write(derOutputStream3.toByteArray());
                    continue;
                }
                derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)n), derOutputStream3);
                continue;
            }
            if (n == 0 || n == 3 || n == 5) {
                derOutputStream2.writeImplicit(DerValue.createTag((byte)-128, true, (byte)n), derOutputStream3);
                continue;
            }
            derOutputStream2.writeImplicit(DerValue.createTag((byte)-128, false, (byte)n), derOutputStream3);
        }
        derOutputStream.write((byte)48, derOutputStream2);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        try {
            this.encode(derOutputStream);
        }
        catch (GeneralNamesException generalNamesException) {
            if (debug != null) {
                debug.exception(16384L, className, "encode", generalNamesException);
            }
            throw new IOException("Error encoding a GeneralNames element.");
        }
        outputStream.write(derOutputStream.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public GeneralName getGeneralName(int n) throws GeneralNamesException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getGeneralName", new Integer(n));
        }
        if (this.size() == 0) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getGeneralName_1", null);
            }
            return null;
        }
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof GeneralNameInterface)) {
                if (debug != null) {
                    debug.text(16384L, className, "getGeneralName", "Element in GeneralNames not of type GeneralName.");
                }
                throw new GeneralNamesException("Element in GeneralNames not of type GeneralName.");
            }
            GeneralName generalName = (GeneralName)e;
            if (generalName.getType() != n) continue;
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getGeneralName_2", generalName);
            }
            return generalName;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getGeneralName_3", null);
        }
        return null;
    }
}

