/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.util.Arrays;

public class Extension {
    protected ObjectIdentifier extensionId = null;
    protected boolean critical = false;
    protected byte[] extensionValue = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.Extension";

    protected Extension() {
        if (debug != null) {
            debug.entry(16384L, className, "Extension");
            debug.exit(16384L, className, "Extension");
        }
    }

    public Extension(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "Extension", derValue);
        }
        DerInputStream derInputStream = derValue.toDerInputStream();
        this.extensionId = derInputStream.getOID();
        DerValue derValue2 = derInputStream.getDerValue();
        if (derValue2.getTag() == 1) {
            this.critical = derValue2.getBoolean();
            derValue2 = derInputStream.getDerValue();
            this.extensionValue = derValue2.getOctetString();
        } else {
            this.critical = false;
            this.extensionValue = derValue2.getOctetString();
        }
        if (debug != null) {
            debug.exit(16384L, className, "Extension");
        }
    }

    public Extension(ObjectIdentifier objectIdentifier, boolean bl, byte[] byArray) throws IOException {
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{objectIdentifier, new Boolean(bl), byArray};
            debug.entry(16384L, (Object)className, "Extension", objectArray);
        }
        this.extensionId = objectIdentifier;
        this.critical = bl;
        objectArray = new DerValue(byArray);
        this.extensionValue = objectArray.getOctetString();
        if (debug != null) {
            debug.exit(16384L, className, "Extension");
        }
    }

    public Extension(Extension extension) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "Extension", extension);
        }
        this.extensionId = extension.extensionId;
        this.critical = extension.critical;
        this.extensionValue = extension.extensionValue != null ? (byte[])extension.extensionValue.clone() : extension.extensionValue;
        if (debug != null) {
            debug.exit(16384L, className, "Extension");
        }
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", derOutputStream);
        }
        if (this.extensionId == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Null OID to encode for the extension!");
            }
            throw new IOException("Null OID to encode for the extension!");
        }
        if (this.extensionValue == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "No value to encode for the extension!");
            }
            throw new IOException("No value to encode for the extension!");
        }
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOID(this.extensionId);
        if (this.critical) {
            derOutputStream2.putBoolean(this.critical);
        }
        derOutputStream2.putOctetString(this.extensionValue);
        derOutputStream.write((byte)48, derOutputStream2);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public boolean isCritical() {
        if (debug != null) {
            debug.entry(16384L, className, "isCritical");
            debug.exit(16384L, (Object)className, "isCritical", this.critical);
        }
        return this.critical;
    }

    public ObjectIdentifier getExtensionId() {
        if (debug != null) {
            debug.entry(16384L, className, "getExtensionId");
            debug.exit(16384L, (Object)className, "getExtensionId", this.extensionId);
        }
        return this.extensionId;
    }

    public byte[] getExtensionValue() {
        if (debug != null) {
            debug.entry(16384L, className, "getExtensionValue");
        }
        if (this.extensionValue == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getExtensionValue_1", null);
            }
            return null;
        }
        byte[] byArray = new byte[this.extensionValue.length];
        System.arraycopy(this.extensionValue, 0, byArray, 0, byArray.length);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getExtensionValue_2", byArray);
        }
        return byArray;
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String string = "ObjectId: " + this.extensionId.toString();
        string = this.critical ? string + " Criticality=true\n" : string + " Criticality=false\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }

    public int hashCode() {
        if (debug != null) {
            debug.entry(16384L, className, "hashCode");
        }
        byte[] byArray = this.getExtensionValue();
        int n = byArray.length;
        int n2 = 0;
        while (n > 0) {
            n2 += n-- * byArray[n];
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hashCode", n2);
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (this == object) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", true);
            }
            return true;
        }
        if (!(object instanceof Extension)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", false);
            }
            return false;
        }
        Extension extension = (Extension)object;
        if (this.critical != extension.critical) {
            return false;
        }
        if (!this.extensionId.equals(extension.extensionId)) {
            return false;
        }
        byte[] byArray = this.getExtensionValue();
        byte[] byArray2 = ((Extension)object).getExtensionValue();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_3", Arrays.equals(byArray, byArray2));
        }
        return Arrays.equals(byArray, byArray2);
    }
}

