/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.PKIXExtensions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExtKeyUsageExtension
extends Extension
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.extensions.ExtKeyUsage";
    public static final String NAME = "ExtKeyUsage";
    public static final String EXT_KEY_USAGE = "extkeyusage";
    private Vector<ObjectIdentifier> keyPurposes = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.ExtKeyUsageExtension";

    private void encodeThis() throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "encodeThis");
        }
        if (this.keyPurposes == null || this.keyPurposes.isEmpty()) {
            this.extensionValue = null;
            if (debug != null) {
                debug.exit(8192L, className, "encodeThis_1");
            }
            return;
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        for (int i = 0; i < this.keyPurposes.size(); ++i) {
            ObjectIdentifier objectIdentifier = this.keyPurposes.elementAt(i);
            derOutputStream2.putOID(objectIdentifier);
        }
        derOutputStream.write((byte)48, derOutputStream2);
        this.extensionValue = derOutputStream.toByteArray();
        if (debug != null) {
            debug.exit(8192L, className, "encodeThis_2");
        }
    }

    private boolean validExtKeyPurposeOID(ObjectIdentifier objectIdentifier) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "validExtKeyPurposeOID", objectIdentifier);
        }
        if (objectIdentifier.equals(PKIXExtensions.ServerAuth_Id)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "validExtKeyPurposeOID_1", true);
            }
            return true;
        }
        if (objectIdentifier.equals(PKIXExtensions.ClientAuth_Id)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "validExtKeyPurposeOID_2", true);
            }
            return true;
        }
        if (objectIdentifier.equals(PKIXExtensions.CodeSigning_Id)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "validExtKeyPurposeOID_3", true);
            }
            return true;
        }
        if (objectIdentifier.equals(PKIXExtensions.EmailProtection_Id)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "validExtKeyPurposeOID_4", true);
            }
            return true;
        }
        if (objectIdentifier.equals(PKIXExtensions.IPSecEndSystem_Id)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "validExtKeyPurposeOID_5", true);
            }
            return true;
        }
        if (objectIdentifier.equals(PKIXExtensions.IPSecTunnel_Id)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "validExtKeyPurposeOID_6", true);
            }
            return true;
        }
        if (objectIdentifier.equals(PKIXExtensions.IPSecUser_Id)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "validExtKeyPurposeOID_7", true);
            }
            return true;
        }
        if (objectIdentifier.equals(PKIXExtensions.TimeStamping_Id)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "validExtKeyPurposeOID_8", true);
            }
            return true;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "validExtKeyPurposeOID_9", false);
        }
        return false;
    }

    public ExtKeyUsageExtension(Vector<ObjectIdentifier> vector) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "ExtKeyUsageExtension", vector);
        }
        this.extensionId = PKIXExtensions.ExtKeyUsage_Id;
        this.critical = false;
        if (vector == null || vector.size() == 0) {
            if (debug != null) {
                debug.text(16384L, className, "ExtKeyUsageExtension", "keyPurpose is null or empty.");
            }
            throw new IllegalArgumentException("keyPurpose is null or empty.");
        }
        this.keyPurposes = vector;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "ExtKeyUsageExtension");
        }
    }

    public ExtKeyUsageExtension() {
        if (debug != null) {
            debug.entry(16384L, className, "ExtKeyUsageExtension");
        }
        this.extensionId = PKIXExtensions.ExtKeyUsage_Id;
        this.critical = false;
        this.keyPurposes = new Vector();
        if (debug != null) {
            debug.exit(16384L, className, "ExtKeyUsageExtension");
        }
    }

    public ExtKeyUsageExtension(Boolean bl, Object object) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "ExtKeyUsageExtension", bl, object);
        }
        this.extensionId = PKIXExtensions.ExtKeyUsage_Id;
        this.critical = bl;
        int n = Array.getLength(object);
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = Array.getByte(object, i);
        }
        this.extensionValue = byArray;
        DerValue derValue = new DerValue(byArray);
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "ExtKeyUsageExtension", "Invalid encoding for ExtKeyUsageExtension.");
            }
            throw new IOException("Invalid encoding for ExtKeyUsageExtension.");
        }
        this.keyPurposes = new Vector();
        while (derValue.getData().available() != 0) {
            ObjectIdentifier objectIdentifier = derValue.getData().getOID();
            this.keyPurposes.addElement(objectIdentifier);
        }
        if (debug != null) {
            debug.exit(16384L, className, "ExtKeyUsageExtension");
        }
    }

    @Override
    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        if (this.keyPurposes == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "toString_1", "");
            }
            return "";
        }
        String string = super.toString() + "ExtKeyUsage [\r\n";
        if (this.keyPurposes == null || this.keyPurposes.size() == 0) {
            string = string + "\tnull";
        } else {
            for (int i = 0; i < this.keyPurposes.size(); ++i) {
                ObjectIdentifier objectIdentifier = this.keyPurposes.elementAt(i);
                string = string + "\t" + objectIdentifier.toString();
            }
        }
        string = string + "]\r\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString_2", string);
        }
        return string;
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.ExtKeyUsage_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public void decode(InputStream inputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", inputStream);
            debug.text(16384L, className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void set(String string, Object object) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", string, object);
        }
        if (string.equalsIgnoreCase(EXT_KEY_USAGE)) {
            if (!(object instanceof Vector)) {
                if (debug != null) {
                    debug.text(16384L, className, "set", "Attribute value should be of type Vector.");
                }
                throw new IOException("Attribute value should be of type Vector.");
            }
        } else {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized by CertAttrSet:ExtKeyUsageExtension.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:ExtKeyUsageExtension.");
        }
        this.keyPurposes = (Vector)((Vector)object).clone();
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    @Override
    public Object get(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", string);
        }
        if (string.equalsIgnoreCase(EXT_KEY_USAGE)) {
            if (this.keyPurposes != null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "get_1", this.keyPurposes.clone());
                }
                return this.keyPurposes.clone();
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_2", this.keyPurposes);
            }
            return this.keyPurposes;
        }
        if (debug != null) {
            debug.text(16384L, className, "get", "Attribute name not recognized by CertAttrSet:ExtKeyUsageExtension.");
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:ExtKeyUsageExtension.");
    }

    @Override
    public void delete(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", string);
        }
        if (!string.equalsIgnoreCase(EXT_KEY_USAGE)) {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Attribute name not recognized by CertAttrSet:ExtKeyUsageExtension.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:ExtKeyUsageExtension.");
        }
        this.keyPurposes = null;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    @Override
    public Enumeration<String> getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(EXT_KEY_USAGE);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", attributeNameEnumeration.elements());
        }
        return attributeNameEnumeration.elements();
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }

    public List<String> getExtendedKeyUsage() {
        ArrayList<String> arrayList = new ArrayList<String>(this.keyPurposes.size());
        for (ObjectIdentifier objectIdentifier : this.keyPurposes) {
            arrayList.add(objectIdentifier.toString());
        }
        return arrayList;
    }
}

