/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs12.PKCS12Utils;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public final class DisplayText
implements Cloneable {
    private String text;
    private byte format;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.DisplayText";
    private volatile int cachedHashVal = 0;

    public DisplayText(byte[] byArray) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "DisplayText", (Object)byArray);
        }
        DerInputStream derInputStream = new DerInputStream(byArray);
        DerValue derValue = derInputStream.getDerValue();
        this.decode(derValue);
        if (debug != null) {
            debug.exit(16384L, className, "DisplayText");
        }
    }

    public DisplayText(String string, byte by) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "DisplayText", string, new Byte(by));
        }
        if (string == null) {
            if (debug != null) {
                debug.text(16384L, className, "DisplayText", "text not specified");
            }
            throw new IllegalArgumentException("text not specified");
        }
        if (string.length() > 200) {
            if (debug != null) {
                debug.text(16384L, className, "DisplayText", "text too long");
            }
            throw new IllegalArgumentException("text too long");
        }
        if (by != 30 && by != 12 && by != 22 && by != 26) {
            if (debug != null) {
                debug.text(16384L, className, "DisplayText", "Invalid text format");
            }
            throw new IllegalArgumentException("Invalid text format");
        }
        this.text = string;
        this.format = by;
        if (debug != null) {
            debug.exit(16384L, className, "DisplayText");
        }
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            DisplayText displayText = new DisplayText(derOutputStream.toByteArray());
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", displayText);
            }
            return displayText;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", exception);
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        switch (this.format) {
            case 26: {
                derOutputStream.putVisibleString(this.text);
                break;
            }
            case 30: {
                derOutputStream.putBMPString(this.text);
                break;
            }
            case 12: {
                derOutputStream.putUTF8String(this.text);
                break;
            }
            case 22: {
                derOutputStream.putIA5String(this.text);
                break;
            }
        }
        outputStream.write(derOutputStream.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        if (derValue.getTag() == 30) {
            this.format = (byte)30;
            this.text = PKCS12Utils.bmp2string(new DerInputStream(derValue.toByteArray()).getBMPString());
        } else if (derValue.getTag() == 12) {
            this.format = (byte)12;
            this.text = derValue.getUTF8String();
        } else if (derValue.getTag() == 26) {
            this.format = (byte)26;
            this.text = derValue.getVisibleString();
        } else if (derValue.getTag() == 22) {
            this.format = (byte)22;
            this.text = derValue.getIA5String();
        } else {
            if (debug != null) {
                debug.text(16384L, className, "decode", "DisplayText parsing error, invalid tag " + derValue.getTag());
            }
            throw new IOException("DisplayText parsing error, invalid tag " + derValue.getTag());
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    public boolean equals(Object object) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (object == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", true);
            }
            return true;
        }
        if (!(object instanceof DisplayText)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", false);
            }
            return false;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            ((DisplayText)object).encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", exception);
                debug.exit(16384L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_4", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_5", true);
        }
        return true;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                this.encode(derOutputStream);
                this.cachedHashVal = Arrays.hashCode(derOutputStream.toByteArray());
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public byte getTextFormat() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getTextFormat");
            debug.exit(16384L, (Object)className, "getTextFormat", this.format);
        }
        return this.format;
    }

    public String getText() {
        if (debug != null) {
            debug.entry(16384L, className, "getText");
            debug.exit(16384L, (Object)className, "getText", this.text);
        }
        return this.text;
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String string = "";
        string = string + this.text;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }
}

