/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CertificateVersion
implements CertAttrSet<String> {
    public static final int V1 = 0;
    public static final int V2 = 1;
    public static final int V3 = 2;
    public static final String IDENT = "x509.info.version";
    public static final String NAME = "version";
    public static final String VERSION = "number";
    private int version = 0;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.CertificateVersion";

    private int getVersion() {
        if (debug != null) {
            debug.entry(8192L, className, "getVersion");
            debug.exit(8192L, (Object)className, "getVersion", this.version);
        }
        return this.version;
    }

    private void construct(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "construct", derValue);
        }
        if (derValue.isConstructed() && derValue.isContextSpecific()) {
            derValue = derValue.getData().getDerValue();
            this.version = derValue.getInteger().intValue();
            if (derValue.getData().available() != 0) {
                if (debug != null) {
                    debug.text(8192L, className, "construct", "X.509 version, bad format");
                }
                throw new IOException("X.509 version, bad format");
            }
        }
        if (debug != null) {
            debug.exit(8192L, className, "construct");
        }
    }

    public CertificateVersion() {
        if (debug != null) {
            debug.entry(16384L, className, "CertificateVersion");
            debug.exit(16384L, className, "CertificateVersion");
        }
        this.version = 0;
    }

    public CertificateVersion(int n) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificateVersion", new Integer(n));
        }
        if (n != 0 && n != 1 && n != 2) {
            if (debug != null) {
                debug.text(16384L, className, "CertificateVersion", "X.509 Certificate version " + n + " not supported.\n");
            }
            throw new IOException("X.509 Certificate version " + n + " not supported.\n");
        }
        this.version = n;
        if (debug != null) {
            debug.exit(16384L, className, "CertificateVersion");
        }
    }

    public CertificateVersion(DerInputStream derInputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificateVersion", derInputStream);
        }
        this.version = 0;
        DerValue derValue = derInputStream.getDerValue();
        this.construct(derValue);
        if (debug != null) {
            debug.exit(16384L, className, "CertificateVersion");
        }
    }

    public CertificateVersion(InputStream inputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificateVersion", inputStream);
        }
        this.version = 0;
        DerValue derValue = new DerValue(inputStream);
        this.construct(derValue);
        if (debug != null) {
            debug.exit(16384L, className, "CertificateVersion");
        }
    }

    public CertificateVersion(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificateVersion", derValue);
        }
        this.version = 0;
        this.construct(derValue);
        if (debug != null) {
            debug.exit(16384L, className, "CertificateVersion");
        }
    }

    @Override
    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
            debug.exit(16384L, (Object)className, "toString", "Version: V" + (this.version + 1));
        }
        return "Version: V" + (this.version + 1);
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        if (this.version == 0) {
            if (debug != null) {
                debug.exit(16384L, className, "encode_1");
            }
            return;
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(BigInteger.valueOf(this.version));
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode_2");
        }
    }

    @Override
    public void decode(InputStream inputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", inputStream);
            debug.text(16384L, className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void set(String string, Object object) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", string, object);
        }
        if (!(object instanceof Integer)) {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute must be of type Integer.");
            }
            throw new IOException("Attribute must be of type Integer.");
        }
        if (!string.equalsIgnoreCase(VERSION)) {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized by CertAttrSet: CertificateVersion.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet: CertificateVersion.");
        }
        this.version = (Integer)object;
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    @Override
    public Object get(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", string);
        }
        if (string.equalsIgnoreCase(VERSION)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get", new Integer(this.getVersion()));
            }
            return new Integer(this.getVersion());
        }
        if (debug != null) {
            debug.text(16384L, className, "get", "Attribute name not recognized by CertAttrSet: CertificateVersion.");
        }
        throw new IOException("Attribute name not recognized by CertAttrSet: CertificateVersion.");
    }

    @Override
    public void delete(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", string);
        }
        if (!string.equalsIgnoreCase(VERSION)) {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Attribute name not recognized by CertAttrSet: CertificateVersion.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet: CertificateVersion.");
        }
        this.version = 0;
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    @Override
    public Enumeration<String> getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(VERSION);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", attributeNameEnumeration.elements());
        }
        return attributeNameEnumeration.elements();
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }

    public int compare(int n) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "compare", new Integer(n));
            debug.exit(16384L, (Object)className, "compare", this.version - n);
        }
        return this.version - n;
    }
}

