/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.PKIXExtensions;
import com.ibm.security.x509.PolicyInformation;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CertificatePoliciesExtension
extends Extension
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.extensions.CertificatePolicies";
    public static final String NAME = "CertificatePolicies";
    public static final String CERT_POLICIES = "cert_policies";
    private Vector<PolicyInformation> policies = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.CertificatePoliciesExtension";

    public CertificatePoliciesExtension(Vector<PolicyInformation> vector) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificatePoliciesExtension", vector);
        }
        this.extensionId = PKIXExtensions.CertificatePolicies_Id;
        this.critical = false;
        if (vector == null || vector.size() == 0) {
            if (debug != null) {
                debug.text(16384L, className, "CertificatePoliciesExtension", "policy is null or empty.");
            }
            throw new IllegalArgumentException("policy is null or empty.");
        }
        this.policies = (Vector)vector.clone();
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "CertificatePoliciesExtension");
        }
    }

    public CertificatePoliciesExtension() {
        if (debug != null) {
            debug.entry(16384L, className, "CertificatePoliciesExtension");
        }
        this.extensionId = PKIXExtensions.CertificatePolicies_Id;
        this.critical = false;
        this.policies = new Vector(1, 1);
        if (debug != null) {
            debug.exit(16384L, className, "CertificatePoliciesExtension");
        }
    }

    public CertificatePoliciesExtension(Boolean bl, Object object) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "CertificatePoliciesExtension", bl, object);
        }
        this.extensionId = PKIXExtensions.CertificatePolicies_Id;
        this.critical = bl;
        int n = Array.getLength(object);
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = Array.getByte(object, i);
        }
        this.extensionValue = byArray;
        DerValue derValue = new DerValue(byArray);
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "CertificatePoliciesExtension", "Invalid encoding for CertificatePoliciesExtension.");
            }
            throw new IOException("Invalid encoding for CertificatePoliciesExtension.");
        }
        this.policies = new Vector(1, 1);
        while (derValue.getData().available() != 0) {
            DerValue derValue2 = derValue.getData().getDerValue();
            PolicyInformation policyInformation = new PolicyInformation(derValue2.toByteArray());
            this.policies.add(policyInformation);
        }
        if (debug != null) {
            debug.exit(16384L, className, "CertificatePoliciesExtension");
        }
    }

    @Override
    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        if (this.policies == null) {
            if (debug != null) {
                debug.exit(16384L, className, "toString_1");
            }
            return "";
        }
        String string = super.toString() + "CertificatePolicies [\r\n" + this.policies.toString() + "]\r\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.CertificatePolicies_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public void decode(InputStream inputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", inputStream);
            debug.exit(16384L, (Object)className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void set(String string, Object object) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", string, object);
        }
        if (string.equalsIgnoreCase(CERT_POLICIES)) {
            if (!(object instanceof Vector)) {
                if (debug != null) {
                    debug.text(16384L, className, "set", "Attribute value should be of type Vector.");
                }
                throw new IOException("Attribute value should be of type Vector.");
            }
        } else {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized by CertAttrSet:CertificatePoliciesExtension.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:CertificatePoliciesExtension.");
        }
        this.policies = (Vector)((Vector)object).clone();
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    @Override
    public Object get(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", string);
        }
        if (string.equalsIgnoreCase(CERT_POLICIES)) {
            if (this.policies == null) {
                return null;
            }
            return this.policies.clone();
        }
        if (debug != null) {
            debug.text(16384L, className, "get", "Attribute name not recognized by CertAttrSet:CertificatePoliciesExtension.");
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:CertificatePoliciesExtension.");
    }

    @Override
    public void delete(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", string);
        }
        if (!string.equalsIgnoreCase(CERT_POLICIES)) {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Attribute name not recognized by CertAttrSet:CertificatePoliciesExtension.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:CertificatePoliciesExtension.");
        }
        this.policies = null;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    @Override
    public Enumeration<String> getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(CERT_POLICIES);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", attributeNameEnumeration.elements());
        }
        return attributeNameEnumeration.elements();
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }

    private void encodeThis() throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "encodeThis");
        }
        if (this.policies == null || this.policies.isEmpty()) {
            this.extensionValue = null;
            if (debug != null) {
                debug.exit(8192L, className, "encodeThis_1");
            }
            return;
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        for (PolicyInformation policyInformation : this.policies) {
            policyInformation.encode(derOutputStream2);
        }
        derOutputStream.write((byte)48, derOutputStream2);
        this.extensionValue = derOutputStream.toByteArray();
        if (debug != null) {
            debug.exit(8192L, className, "encodeThis_2");
        }
    }
}

