/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.GeneralName;
import java.io.IOException;

public class AccessDescription {
    private int myhash = -1;
    protected ObjectIdentifier accessMethod = null;
    protected GeneralName accessLocation = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.AccessDescription";
    public static final ObjectIdentifier Ad_OCSP_Id;

    public AccessDescription(byte[] byArray) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "AccessDecription", (Object)byArray);
        }
        DerInputStream derInputStream = new DerInputStream(byArray);
        DerValue derValue = derInputStream.getDerValue();
        this.decode(derValue);
        if (debug != null) {
            debug.exit(16384L, className, "AccessDecription");
        }
    }

    public AccessDescription(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "AccessDescription", derValue);
        }
        DerInputStream derInputStream = derValue.toDerInputStream();
        this.accessMethod = derInputStream.getOID();
        this.accessLocation = new GeneralName(derInputStream.getDerValue());
        if (debug != null) {
            debug.exit(16384L, className, "AccessDescription");
        }
    }

    public AccessDescription(ObjectIdentifier objectIdentifier, GeneralName generalName) throws IOException {
        if (debug != null) {
            Object[] objectArray = new Object[]{objectIdentifier, generalName};
            debug.entry(16384L, (Object)className, "AccessDescription", objectArray);
        }
        this.accessMethod = objectIdentifier;
        this.accessLocation = generalName;
        if (debug != null) {
            debug.exit(16384L, className, "AccessDescription");
        }
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", derOutputStream);
        }
        if (this.accessMethod == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Null OID to encode for the AccessDescription!");
            }
            throw new IOException("Null OID to encode for the AccessDescription!");
        }
        if (this.accessLocation == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "No value to encode for the AccessDescription!");
            }
            throw new IOException("No value to encode for the AccessDescription!");
        }
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOID(this.accessMethod);
        this.accessLocation.encode(derOutputStream2);
        derOutputStream.write((byte)48, derOutputStream2);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "Invalid encoding for AccessDescription.");
            }
            throw new IOException("Invalid encoding for AccessDescription.");
        }
        this.accessMethod = derValue.getData().getOID();
        this.accessLocation = new GeneralName(derValue.getData().getDerValue());
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    public ObjectIdentifier getAccessMethod() {
        if (debug != null) {
            debug.entry(16384L, className, "getaccessMethod");
            debug.exit(16384L, (Object)className, "getaccessMethod", this.accessMethod);
        }
        return this.accessMethod;
    }

    public GeneralName getAccessLocation() {
        if (debug != null) {
            debug.entry(16384L, className, "getAccessLocation");
        }
        return this.accessLocation;
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String string = "accessMethod: " + this.accessMethod.toString() + "\n";
        string = string + "accessLocation: " + this.accessLocation.toString();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }

    public boolean equals(Object object) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (!(object instanceof AccessDescription)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", false);
            }
            return false;
        }
        if (object == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", true);
            }
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            ((AccessDescription)object).encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", exception);
                debug.exit(16384L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_4", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_5", true);
        }
        return true;
    }

    public int hashCode() {
        if (this.myhash == -1) {
            this.myhash = this.accessMethod.hashCode() + this.accessLocation.hashCode();
        }
        return this.myhash;
    }

    static {
        ObjectIdentifier objectIdentifier = null;
        try {
            objectIdentifier = new ObjectIdentifier("1.3.6.1.5.5.7.48.1");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Ad_OCSP_Id = objectIdentifier;
    }
}

