/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.util.text;

import com.ibm.security.util.text.Utility;
import java.lang.reflect.Method;

public final class CompactByteArray
implements Cloneable {
    public static final int UNICODECOUNT = 65536;
    private static final int BLOCKSHIFT = 7;
    private static final int BLOCKCOUNT = 128;
    private static final int INDEXSHIFT = 9;
    private static final int INDEXCOUNT = 512;
    private static final int BLOCKMASK = 127;
    private byte[] values;
    private short[] indices;
    private boolean isCompact;
    private int[] hashes;

    public CompactByteArray() {
        this(0);
    }

    public CompactByteArray(byte by) {
        int n;
        this.values = new byte[65536];
        this.indices = new short[512];
        this.hashes = new int[512];
        for (n = 0; n < 65536; ++n) {
            this.values[n] = by;
        }
        for (n = 0; n < 512; ++n) {
            this.indices[n] = (short)(n << 7);
            this.hashes[n] = 0;
        }
        this.isCompact = false;
    }

    public CompactByteArray(short[] sArray, byte[] byArray) {
        if (sArray.length != 512) {
            throw new IllegalArgumentException("Index out of bounds!");
        }
        for (int i = 0; i < 512; ++i) {
            short s = sArray[i];
            if (s >= 0 && s < byArray.length + 128) continue;
            throw new IllegalArgumentException("Index out of bounds!");
        }
        this.indices = sArray;
        this.values = byArray;
        this.isCompact = true;
    }

    public CompactByteArray(String string, String string2) {
        this(Utility.RLEStringToShortArray(string), Utility.RLEStringToByteArray(string2));
    }

    public byte elementAt(char c) {
        return this.values[(this.indices[c >> 7] & 0xFFFF) + (c & 0x7F)];
    }

    public void setElementAt(char c, byte by) {
        if (this.isCompact) {
            this.expand();
        }
        this.values[c] = by;
        this.touchBlock(c >> 7, by);
    }

    public void setElementAt(char n, char c, byte by) {
        if (this.isCompact) {
            this.expand();
        }
        for (int i = n; i <= c; ++i) {
            this.values[i] = by;
            this.touchBlock(i >> 7, by);
        }
    }

    public void compact() {
        if (!this.isCompact) {
            int n = 0;
            int n2 = 0;
            int n3 = -1;
            int n4 = 0;
            while (n4 < this.indices.length) {
                this.indices[n4] = -1;
                boolean bl = this.blockTouched(n4);
                if (!bl && n3 != -1) {
                    this.indices[n4] = n3;
                } else {
                    int n5 = 0;
                    int n6 = 0;
                    n6 = 0;
                    while (n6 < n) {
                        if (this.hashes[n4] == this.hashes[n6] && CompactByteArray.arrayRegionMatches(this.values, n2, this.values, n5, 128)) {
                            this.indices[n4] = (short)n5;
                            break;
                        }
                        ++n6;
                        n5 += 128;
                    }
                    if (this.indices[n4] == -1) {
                        System.arraycopy(this.values, n2, this.values, n5, 128);
                        this.indices[n4] = (short)n5;
                        this.hashes[n6] = this.hashes[n4];
                        ++n;
                        if (!bl) {
                            n3 = (short)n5;
                        }
                    }
                }
                ++n4;
                n2 += 128;
            }
            Class<?> clazz = null;
            Method method = null;
            try {
                clazz = Class.forName("com.ibm.jvm.ExtendedSystem");
                if (clazz != null) {
                    method = clazz.getMethod("resizeArray", Integer.TYPE, Object.class, Integer.TYPE, Integer.TYPE);
                }
            }
            catch (Exception exception) {
                clazz = null;
                method = null;
            }
            if (method != null) {
                int n7 = n * 128;
                try {
                    this.values = (byte[])method.invoke(null, new Integer(n7), this.values, new Integer(0), new Integer(n7));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.isCompact = true;
                this.hashes = null;
            } else {
                int n8 = n * 128;
                byte[] byArray = new byte[n8];
                System.arraycopy(this.values, 0, byArray, 0, n8);
                this.values = byArray;
                this.isCompact = true;
                this.hashes = null;
            }
        }
    }

    static final boolean arrayRegionMatches(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4 = n + n3;
        int n5 = n2 - n;
        for (int i = n; i < n4; ++i) {
            if (byArray[i] == byArray2[i + n5]) continue;
            return false;
        }
        return true;
    }

    private final void touchBlock(int n, int n2) {
        this.hashes[n] = this.hashes[n] + (n2 << 1) | 1;
    }

    private final boolean blockTouched(int n) {
        return this.hashes[n] != 0;
    }

    public short[] getIndexArray() {
        return this.indices;
    }

    public byte[] getStringArray() {
        return this.values;
    }

    public Object clone() {
        try {
            CompactByteArray compactByteArray = (CompactByteArray)super.clone();
            compactByteArray.values = (byte[])this.values.clone();
            compactByteArray.indices = (short[])this.indices.clone();
            if (this.hashes != null) {
                compactByteArray.hashes = (int[])this.hashes.clone();
            }
            return compactByteArray;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CompactByteArray compactByteArray = (CompactByteArray)object;
        for (int i = 0; i < 65536; ++i) {
            if (this.elementAt((char)i) == compactByteArray.elementAt((char)i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        int n2 = Math.min(3, this.values.length / 16);
        for (int i = 0; i < this.values.length; i += n2) {
            n = n * 37 + this.values[i];
        }
        return n;
    }

    private void expand() {
        if (this.isCompact) {
            int n;
            this.hashes = new int[512];
            byte[] byArray = new byte[65536];
            for (n = 0; n < 65536; ++n) {
                byte by;
                byArray[n] = by = this.elementAt((char)n);
                this.touchBlock(n >> 7, by);
            }
            for (n = 0; n < 512; ++n) {
                this.indices[n] = (short)(n << 7);
            }
            this.values = null;
            this.values = byArray;
            this.isCompact = false;
        }
    }

    private byte[] getArray() {
        return this.values;
    }
}

