/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.util;

import com.ibm.security.util.DerInputBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

class DerIndefLenConverter {
    private static final int TAG_MASK = 31;
    private static final int FORM_MASK = 32;
    private static final int CLASS_MASK = 192;
    private static final int LEN_LONG = 128;
    private static final int LEN_MASK = 127;
    private static final int SKIP_EOC_BYTES = 2;
    private byte[] data;
    private byte[] newData;
    private int newDataPos;
    private int dataPos;
    private int dataSize;
    private int index;
    private ArrayList ndefsList = new ArrayList();
    private int numOfTotalLenBytes = 0;

    private boolean isEOC(int n) {
        return (n & 0x1F) == 0 && (n & 0x20) == 0 && (n & 0xC0) == 0;
    }

    static boolean isLongForm(int n) {
        return (n & 0x80) == 128;
    }

    DerIndefLenConverter() {
    }

    static boolean isIndefinite(int n) {
        return DerIndefLenConverter.isLongForm(n) && (n & 0x7F) == 0;
    }

    private void parseTag() throws IOException {
        if (this.dataPos == this.dataSize) {
            return;
        }
        if (this.isEOC(this.data[this.dataPos]) && this.data[this.dataPos + 1] == 0) {
            int n;
            int n2 = 0;
            Object var2_2 = null;
            for (n = this.ndefsList.size() - 1; n >= 0 && !((var2_2 = this.ndefsList.get(n)) instanceof Integer); --n) {
                n2 += ((byte[])var2_2).length - 3;
            }
            if (n < 0) {
                throw new IOException("EOC does not have matching indefinite-length tag");
            }
            int n3 = this.dataPos - (Integer)var2_2 + n2;
            byte[] byArray = this.getLengthBytes(n3);
            this.ndefsList.set(n, byArray);
            this.numOfTotalLenBytes += byArray.length - 3;
        }
        ++this.dataPos;
    }

    private void writeTag() {
        byte by;
        if (this.dataPos == this.dataSize) {
            return;
        }
        if (this.isEOC(by = this.data[this.dataPos++]) && this.data[this.dataPos] == 0) {
            ++this.dataPos;
            this.writeTag();
        } else {
            this.newData[this.newDataPos++] = by;
        }
    }

    private int parseLength() throws IOException {
        int n;
        int n2 = 0;
        if (this.dataPos == this.dataSize) {
            return n2;
        }
        if (DerIndefLenConverter.isIndefinite(n = this.data[this.dataPos++] & 0xFF)) {
            this.ndefsList.add(new Integer(this.dataPos));
            return n2;
        }
        if (DerIndefLenConverter.isLongForm(n)) {
            if ((n &= 0x7F) > 4) {
                throw new IOException("Too much data");
            }
            if (this.dataSize - this.dataPos < n + 1) {
                throw new IOException("Too little data");
            }
            for (int i = 0; i < n; ++i) {
                n2 = (n2 << 8) + (this.data[this.dataPos++] & 0xFF);
            }
        } else {
            n2 = n & 0x7F;
        }
        return n2;
    }

    private void writeLengthAndValue() throws IOException {
        int n;
        if (this.dataPos == this.dataSize) {
            return;
        }
        int n2 = 0;
        if (DerIndefLenConverter.isIndefinite(n = this.data[this.dataPos++] & 0xFF)) {
            byte[] byArray = (byte[])this.ndefsList.get(this.index++);
            System.arraycopy(byArray, 0, this.newData, this.newDataPos, byArray.length);
            this.newDataPos += byArray.length;
            return;
        }
        if (DerIndefLenConverter.isLongForm(n)) {
            n &= 0x7F;
            for (int i = 0; i < n; ++i) {
                n2 = (n2 << 8) + (this.data[this.dataPos++] & 0xFF);
            }
        } else {
            n2 = n & 0x7F;
        }
        this.writeLength(n2);
        this.writeValue(n2);
    }

    private void writeLength(int n) {
        if (n < 128) {
            this.newData[this.newDataPos++] = (byte)n;
        } else if (n < 256) {
            this.newData[this.newDataPos++] = -127;
            this.newData[this.newDataPos++] = (byte)n;
        } else if (n < 65536) {
            this.newData[this.newDataPos++] = -126;
            this.newData[this.newDataPos++] = (byte)(n >> 8);
            this.newData[this.newDataPos++] = (byte)n;
        } else if (n < 0x1000000) {
            this.newData[this.newDataPos++] = -125;
            this.newData[this.newDataPos++] = (byte)(n >> 16);
            this.newData[this.newDataPos++] = (byte)(n >> 8);
            this.newData[this.newDataPos++] = (byte)n;
        } else {
            this.newData[this.newDataPos++] = -124;
            this.newData[this.newDataPos++] = (byte)(n >> 24);
            this.newData[this.newDataPos++] = (byte)(n >> 16);
            this.newData[this.newDataPos++] = (byte)(n >> 8);
            this.newData[this.newDataPos++] = (byte)n;
        }
    }

    private byte[] getLengthBytes(int n) {
        byte[] byArray;
        int n2 = 0;
        if (n < 128) {
            byArray = new byte[1];
            byArray[n2++] = (byte)n;
        } else if (n < 256) {
            byArray = new byte[2];
            byArray[n2++] = -127;
            byArray[n2++] = (byte)n;
        } else if (n < 65536) {
            byArray = new byte[3];
            byArray[n2++] = -126;
            byArray[n2++] = (byte)(n >> 8);
            byArray[n2++] = (byte)n;
        } else if (n < 0x1000000) {
            byArray = new byte[4];
            byArray[n2++] = -125;
            byArray[n2++] = (byte)(n >> 16);
            byArray[n2++] = (byte)(n >> 8);
            byArray[n2++] = (byte)n;
        } else {
            byArray = new byte[5];
            byArray[n2++] = -124;
            byArray[n2++] = (byte)(n >> 24);
            byArray[n2++] = (byte)(n >> 16);
            byArray[n2++] = (byte)(n >> 8);
            byArray[n2++] = (byte)n;
        }
        return byArray;
    }

    private int getNumOfLenBytes(int n) {
        int n2 = 0;
        n2 = n < 128 ? 1 : (n < 256 ? 2 : (n < 65536 ? 3 : (n < 0x1000000 ? 4 : 5)));
        return n2;
    }

    private void parseValue(int n) {
        this.dataPos += n;
    }

    private void writeValue(int n) {
        for (int i = 0; i < n; ++i) {
            this.newData[this.newDataPos++] = this.data[this.dataPos++];
        }
    }

    private static int getLength(byte[] byArray) throws IOException {
        int n;
        int n2 = byArray[1];
        int n3 = 2;
        int n4 = n2;
        if ((n4 & 0x80) == 0) {
            n = n4;
        } else {
            if ((n4 &= 0x7F) == 0) {
                return -1;
            }
            if (n4 < 0 || n4 > 4) {
                throw new IOException("DerInputStream.getLength(): lengthTag=" + n4 + ", " + (n4 < 0 ? "incorrect DER encoding." : "too big."));
            }
            n = 0;
            while (n4 > 0) {
                n <<= 8;
                n += 0xFF & byArray[n3++];
                --n4;
            }
        }
        return n;
    }

    static byte[] convertIndefToDef(byte[] byArray) throws IOException {
        byte[] byArray2 = DerIndefLenConverter.convertIndefToDef(new DerInputBuffer(byArray));
        return byArray2;
    }

    static byte[] convertIndefToDef(InputStream inputStream) throws IOException {
        inputStream.mark(4);
        int n = inputStream.read();
        int n2 = DerIndefLenConverter.getLength(inputStream);
        if (n2 == -1) {
            if ((n & 0x3F) == 48 || (n & 0x3F) == 49) {
                return DerIndefLenConverter.getIndefSeqSet(inputStream, n &= 0x3F);
            }
            if ((n & 0xE0) == 160) {
                return DerIndefLenConverter.getIndefSeqSet(inputStream, n);
            }
            if ((n & 0x3F) == 35) {
                return DerIndefLenConverter.getIndefBitString(inputStream);
            }
            if ((n & 0x3F) == 36) {
                return DerIndefLenConverter.getIndefOctetString(inputStream);
            }
            if ((n & 0x3F) == 45) {
                return DerIndefLenConverter.getIndefSimpleString(inputStream, n);
            }
        }
        byte[] byArray = new byte[inputStream.available()];
        inputStream.read(byArray);
        return byArray;
    }

    static byte[] putLength(int n) throws IOException {
        byte[] byArray = null;
        byArray = n < 128 ? new byte[]{(byte)n} : (n < 256 ? new byte[]{-127, (byte)n} : (n < 65536 ? new byte[]{-126, (byte)(n >> 8), (byte)n} : (n < 0x1000000 ? new byte[]{-125, (byte)(n >> 16), (byte)(n >> 8), (byte)n} : new byte[]{-124, (byte)(n >> 24), (byte)(n >> 16), (byte)(n >> 8), (byte)n})));
        return byArray;
    }

    private static byte[] getIndefSeqSet(InputStream inputStream, int n) throws IOException {
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte by = 0;
        int n2 = 0;
        while (true) {
            byte[] byArray3;
            inputStream.mark(4);
            by = (byte)inputStream.read();
            n2 = inputStream.read();
            if (by == 0 && (n2 & 0xFF) == 0) {
                if (byArray != null) {
                    byArray3 = DerIndefLenConverter.putLength(byArray.length);
                    byArray2 = new byte[byArray3.length + 1 + byArray.length];
                    byArray2[0] = (byte)n;
                    System.arraycopy(byArray3, 0, byArray2, 1, byArray3.length);
                    System.arraycopy(byArray, 0, byArray2, byArray3.length + 1, byArray.length);
                } else {
                    byArray2 = new byte[]{(byte)n, 0};
                }
                byArray = null;
                return byArray2;
            }
            if ((n2 & 0xFF) == 128) {
                inputStream.reset();
                byArray2 = DerIndefLenConverter.convertIndefToDef(inputStream);
            } else if ((n2 & 0xFF) != 128) {
                inputStream.reset();
                by = (byte)inputStream.read();
                n2 = DerIndefLenConverter.getLength(inputStream);
                byArray3 = DerIndefLenConverter.putLength(n2);
                byArray2 = new byte[1 + n2 + byArray3.length];
                byArray2[0] = by;
                System.arraycopy(byArray3, 0, byArray2, 1, byArray3.length);
                if (inputStream.read(byArray2, 1 + byArray3.length, n2) != n2) {
                    throw new IOException("short read of DER OctetString");
                }
            } else {
                throw new IOException("DER input not a BMP string; invalid length");
            }
            byArray3 = new byte[(byArray == null ? 0 : byArray.length) + (byArray2 == null ? 0 : byArray2.length)];
            int n3 = 0;
            if (byArray != null) {
                System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                n3 += byArray.length;
            }
            if (byArray2 != null) {
                System.arraycopy(byArray2, 0, byArray3, n3, byArray2.length);
            }
            byArray = byArray3;
            byArray3 = null;
            byArray2 = null;
        }
    }

    private static byte[] getIndefOctetString(InputStream inputStream) throws IOException {
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte by = 0;
        byte by2 = 0;
        while (true) {
            byte[] byArray3;
            inputStream.mark(4);
            by = (byte)inputStream.read();
            by2 = (byte)inputStream.read();
            if (by == 0 && by2 == 0) {
                if (byArray != null) {
                    byArray3 = DerIndefLenConverter.putLength(byArray.length);
                    byArray2 = new byte[byArray3.length + 1 + byArray.length];
                    byArray2[0] = 4;
                    System.arraycopy(byArray3, 0, byArray2, 1, byArray3.length);
                    System.arraycopy(byArray, 0, byArray2, byArray3.length + 1, byArray.length);
                } else {
                    byArray2 = new byte[]{4, 0};
                }
                byArray = null;
                return byArray2;
            }
            if (by == 36 && (by2 & 0xFF) == 128) {
                byArray2 = DerIndefLenConverter.getIndefOctetString(inputStream);
                int n = DerIndefLenConverter.getLength(byArray2);
                byte[] byArray4 = new byte[n];
                System.arraycopy(byArray2, byArray2.length - n, byArray4, 0, byArray4.length);
                byArray2 = byArray4;
            } else if (by == 4 && (by2 & 0xFF) != 128) {
                inputStream.reset();
                inputStream.read();
                by2 = (byte)DerIndefLenConverter.getLength(inputStream);
                byArray2 = new byte[by2];
                if (inputStream.read(byArray2) != by2) {
                    throw new IOException("short read of DER OctetString");
                }
            } else {
                throw new IOException("DER input not an Octet string; invalid length");
            }
            byArray3 = new byte[(byArray == null ? 0 : byArray.length) + (byArray2 == null ? 0 : byArray2.length)];
            int n = 0;
            if (byArray != null) {
                System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                n += byArray.length;
            }
            if (byArray2 != null) {
                System.arraycopy(byArray2, 0, byArray3, n, byArray2.length);
            }
            byArray = byArray3;
            byArray3 = null;
            byArray2 = null;
        }
    }

    private static byte[] getIndefBitString(InputStream inputStream) throws IOException {
        Object var1_1 = null;
        byte[] byArray = null;
        byte by = 0;
        byte by2 = 0;
        while (true) {
            inputStream.mark(4);
            by = (byte)inputStream.read();
            by2 = (byte)inputStream.read();
            if (by == 36 && by2 == 128) {
                byArray = DerIndefLenConverter.getIndefBitString(inputStream);
            } else if (by == 4 && by2 >= 0) {
                inputStream.reset();
                inputStream.read();
                by2 = (byte)DerIndefLenConverter.getLength(inputStream);
                byArray = new byte[by2];
                if (inputStream.read(byArray) != by2) {
                    throw new IOException("short read of DER OctetString");
                }
            } else {
                throw new IOException("DER input not a BMP string; invalid length");
            }
            inputStream.mark(4);
            by = (byte)inputStream.read();
            by2 = (byte)inputStream.read();
            byte[] byArray2 = new byte[(var1_1).length + byArray.length];
            if (by == 0 && by2 == 0) {
                byArray2[0] = byArray[0];
                System.arraycopy(var1_1, 0, byArray2, 1, (var1_1).length);
                System.arraycopy(byArray, 1, byArray2, (var1_1).length + 1, byArray.length - 1);
                return byArray2;
            }
            inputStream.reset();
            System.arraycopy(var1_1, 0, byArray2, 0, (var1_1).length);
            System.arraycopy(byArray, 0, byArray2, (var1_1).length, byArray.length);
            byArray2 = null;
            byArray = null;
        }
    }

    private static byte[] getIndefBMPString(InputStream inputStream) throws IOException {
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte by = 0;
        int n = 0;
        while (true) {
            inputStream.mark(4);
            by = (byte)inputStream.read();
            n = inputStream.read();
            if (by == 0 && n == 0) {
                return byArray;
            }
            if (by == 62 && n == 128) {
                byArray2 = DerIndefLenConverter.getIndefBMPString(inputStream);
            } else if (by == 30 && n >= 0) {
                inputStream.reset();
                inputStream.read();
                n = DerIndefLenConverter.getLength(inputStream);
                if (n % 2 != 0) {
                    throw new IOException("DER input not a BMP string; invalid length");
                }
                byArray2 = new byte[n];
                if (inputStream.read(byArray2) != n) {
                    throw new IOException("short read of DER BMPString");
                }
            } else {
                throw new IOException("DER input not a BMP string or invalid length");
            }
            byte[] byArray3 = new byte[byArray.length + byArray2.length];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
            byArray3 = null;
            byArray2 = null;
        }
    }

    private static byte[] getIndefSimpleString(InputStream inputStream, int n) throws IOException {
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte by = 0;
        int n2 = 0;
        while (true) {
            inputStream.mark(4);
            by = (byte)inputStream.read();
            n2 = inputStream.read();
            if (by == 0 && n2 == 0) {
                return byArray;
            }
            if (by == n && n2 == 128) {
                byArray2 = DerIndefLenConverter.getIndefSimpleString(inputStream, n);
            } else if (by == (n & 0xDF) && n2 >= 0) {
                inputStream.reset();
                inputStream.read();
                n2 = DerIndefLenConverter.getLength(inputStream);
                byArray2 = new byte[n2];
                if (inputStream.read(byArray2) != n2) {
                    throw new IOException("short read of DER String");
                }
            } else {
                throw new IOException("DER input not a string or invalid length");
            }
            byte[] byArray3 = new byte[byArray.length + byArray2.length];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
            byArray3 = null;
            byArray2 = null;
        }
    }

    private static byte[] getIndefUTF8String(InputStream inputStream) throws IOException {
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte by = 0;
        int n = 0;
        while (true) {
            inputStream.mark(4);
            by = (byte)inputStream.read();
            n = inputStream.read();
            if (by == 0 && n == 0) {
                return byArray;
            }
            if (by == 44 && n == 128) {
                byArray2 = DerIndefLenConverter.getIndefUTF8String(inputStream);
            } else if (by == 12 && n >= 0) {
                inputStream.reset();
                inputStream.read();
                n = DerIndefLenConverter.getLength(inputStream);
                byArray2 = new byte[n];
                if (inputStream.read(byArray2) != n) {
                    throw new IOException("short read of DER UTF8String");
                }
            } else {
                throw new IOException("DER input not a UTF8String or invalid length");
            }
            byte[] byArray3 = new byte[byArray.length + byArray2.length];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
            byArray3 = null;
            byArray2 = null;
        }
    }

    private static byte[] getIndefUniversalString(InputStream inputStream) throws IOException {
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte by = 0;
        int n = 0;
        while (true) {
            inputStream.mark(4);
            by = (byte)inputStream.read();
            n = inputStream.read();
            if (by == 0 && n == 0) {
                return byArray;
            }
            if (by == 60 && n == 128) {
                byArray2 = DerIndefLenConverter.getIndefUniversalString(inputStream);
            } else if (by == 28 && n >= 0) {
                inputStream.reset();
                inputStream.read();
                n = DerIndefLenConverter.getLength(inputStream);
                byArray2 = new byte[n];
                if (inputStream.read(byArray2) != n) {
                    throw new IOException("short read of DER UniversalString");
                }
            } else {
                throw new IOException("DER input not a UniversalString or invalid length");
            }
            byte[] byArray3 = new byte[byArray.length + byArray2.length];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
            byArray3 = null;
            byArray2 = null;
        }
    }

    static int getLength(InputStream inputStream) throws IOException {
        return DerIndefLenConverter.getLength(inputStream.read(), inputStream);
    }

    static int getLength(int n, InputStream inputStream) throws IOException {
        int n2;
        int n3 = n;
        if ((n3 & 0x80) == 0) {
            n2 = n3;
        } else {
            if ((n3 &= 0x7F) == 0) {
                return -1;
            }
            if (n3 < 0 || n3 > 4) {
                throw new IOException("DerInputStream.getLength(): lengthTag=" + n3 + ", " + (n3 < 0 ? "incorrect DER encoding." : "too big."));
            }
            inputStream.mark(4);
            inputStream.reset();
            n2 = 0;
            while (n3 > 0) {
                n2 <<= 8;
                n2 += 0xFF & inputStream.read();
                --n3;
            }
        }
        return n2;
    }
}

