/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.smime.jmail;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.smime.jmail.PKCS7MimeDataSource;
import com.ibm.security.smime.jmail.SMIMEMimeMessage;
import com.ibm.security.smime.jmail.SMIMEUtils;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;
import javax.mail.Message;
import javax.mail.MessageContext;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePartDataSource;
import javax.mail.internet.ParseException;

public class PKCS7MimeHandler
implements DataContentHandler {
    private static String PKCS7MIMEDATASOURCE_CLASSNAME = "com.ibm.security.smime.jmail.PKCS7MimeDataSource";
    private String provider = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.smime.jmail.PKCS7MimeHandler";

    public PKCS7MimeHandler() {
        if (debug != null) {
            debug.entry(16384L, className, "PKCS7MimeHandler");
            debug.exit(16384L, className, "PKCS7MimeHandler");
        }
    }

    public PKCS7MimeHandler(String string) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PKCS7MimeHandler", string);
            debug.exit(16384L, className, "PKCS7MimeHandler");
        }
        if (string != null) {
            this.provider = new String(string);
        }
    }

    public Object getContent(DataSource dataSource) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getContent", dataSource);
        }
        try {
            if (dataSource instanceof PKCS7MimeDataSource) {
                PKCS7MimeDataSource pKCS7MimeDataSource = (PKCS7MimeDataSource)dataSource;
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getContent_1", pKCS7MimeDataSource.getContentInfo());
                }
                return pKCS7MimeDataSource.getContentInfo();
            }
            if (dataSource instanceof MimePartDataSource) {
                MimePartDataSource mimePartDataSource = (MimePartDataSource)dataSource;
                MessageContext messageContext = mimePartDataSource.getMessageContext();
                Message message = messageContext.getMessage();
                MessageContext messageContext2 = mimePartDataSource.getMessageContext();
                Session session = messageContext2.getSession();
                if (message instanceof SMIMEMimeMessage) {
                    SMIMEMimeMessage sMIMEMimeMessage = (SMIMEMimeMessage)message;
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "getContent_2", this.parseSMIMEMimeMessage(sMIMEMimeMessage));
                    }
                    return this.parseSMIMEMimeMessage(sMIMEMimeMessage);
                }
                if (message instanceof MimeMessage) {
                    MimeMessage mimeMessage = (MimeMessage)message;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    mimeMessage.writeTo((OutputStream)byteArrayOutputStream);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                    SMIMEMimeMessage sMIMEMimeMessage = new SMIMEMimeMessage(session, (InputStream)byteArrayInputStream, this.provider);
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "getContent_3", this.parseSMIMEMimeMessage(sMIMEMimeMessage));
                    }
                    return this.parseSMIMEMimeMessage(sMIMEMimeMessage);
                }
            }
        }
        catch (ParseException parseException) {
            if (debug != null) {
                debug.exception(16384L, className, "getContent", parseException);
            }
            throw new IOException(parseException.toString());
        }
        catch (MessagingException messagingException) {
            if (debug != null) {
                debug.exception(16384L, className, "getContent", messagingException);
            }
            throw new IOException(messagingException.toString());
        }
        if (debug != null) {
            debug.text(16384L, className, "getContent", "DataSource class " + dataSource.getClass().getName() + " is not supported.");
        }
        throw new IOException("DataSource class " + dataSource.getClass().getName() + " is not supported.");
    }

    private Object parseSMIMEMimeMessage(SMIMEMimeMessage sMIMEMimeMessage) throws IOException, MessagingException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "parseSMIMEMimeMessage", (Object)sMIMEMimeMessage);
        }
        if (sMIMEMimeMessage.isSignedDataSignatureOnly()) {
            Object object = sMIMEMimeMessage.getContent();
            if (object instanceof MimeMultipart) {
                MimeMultipart mimeMultipart = (MimeMultipart)object;
                int n = mimeMultipart.getCount();
                if (n == 2) {
                    MimeBodyPart mimeBodyPart = (MimeBodyPart)mimeMultipart.getBodyPart(1);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    mimeBodyPart.writeTo((OutputStream)byteArrayOutputStream);
                    byte[] byArray = SMIMEUtils.getMessageBody(byteArrayOutputStream.toByteArray());
                    PKCS7MimeDataSource pKCS7MimeDataSource = new PKCS7MimeDataSource(byArray, true, this.provider);
                    if (debug != null) {
                        debug.exit(8192L, (Object)className, "parseSMIMEMimeMessage_1", pKCS7MimeDataSource.getContentInfo());
                    }
                    return pKCS7MimeDataSource.getContentInfo();
                }
                if (debug != null) {
                    debug.text(8192L, className, "parseSMIMEMimeMessage_1", "Expected two parts to this S/MIME signature-only message, but found " + n + " parts.");
                }
                throw new IOException("Expected two parts to this S/MIME signature-only message, but found " + n + " parts.");
            }
        } else {
            if (sMIMEMimeMessage.isEnvelopedData() || sMIMEMimeMessage.isSignedData() || sMIMEMimeMessage.isSignedDataCertificateOnly()) {
                byte[] byArray = SMIMEUtils.getMessageBodyRemoveTrailer(sMIMEMimeMessage.getContentBytes());
                PKCS7MimeDataSource pKCS7MimeDataSource = new PKCS7MimeDataSource(byArray, true, this.provider);
                if (debug != null) {
                    debug.exit(8192L, (Object)className, "parseSMIMEMimeMessage_2", pKCS7MimeDataSource.getContentInfo());
                }
                return pKCS7MimeDataSource.getContentInfo();
            }
            if (debug != null) {
                debug.text(8192L, className, "parseSMIMEMimeMessage_2", "Unknown S/MIME PKCS #7 message type.");
            }
            throw new IOException("Unknown S/MIME PKCS #7 message type.");
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "parseSMIMEMimeMessage_3", null);
        }
        return null;
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] dataFlavorArray;
        block7: {
            block6: {
                dataFlavorArray = new DataFlavor[4];
                if (debug != null) {
                    debug.entry(16384L, className, "getTransferDataFlavors");
                }
                try {
                    dataFlavorArray[0] = new ActivationDataFlavor(Class.forName("java.lang.String"), "application/x-pkcs7-mime", "PKCS7 MIME");
                }
                catch (Exception exception) {
                    if (debug == null) break block6;
                    debug.exception(16384L, className, "getTransferDataFlavors", exception);
                }
            }
            dataFlavorArray[1] = new DataFlavor("application/x-pkcs7-mime", "PKCS7 MIME");
            try {
                dataFlavorArray[2] = new ActivationDataFlavor(Class.forName("java.lang.String"), "application/x-pkcs7-signature", "PKCS7 Signature MIME");
            }
            catch (Exception exception) {
                if (debug == null) break block7;
                debug.exception(16384L, className, "getTransferDataFlavors", exception);
            }
        }
        dataFlavorArray[3] = new DataFlavor("application/x-pkcs7-signature", "PKCS7 Signature MIME");
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getTransferDataFlavors", dataFlavorArray);
        }
        return dataFlavorArray;
    }

    public Object getTransferData(DataFlavor dataFlavor, DataSource dataSource) throws UnsupportedFlavorException, IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getTransferData", dataFlavor, dataSource);
        }
        if (dataFlavor == null) {
            if (debug != null) {
                debug.text(16384L, className, "getTransferData", "DataFlavor is null");
            }
            throw new IOException("DataFlavor is null");
        }
        if (dataSource == null) {
            if (debug != null) {
                debug.text(16384L, className, "getTransferData", "DataSource is null");
            }
            throw new IOException("DataSource is null");
        }
        String string = dataFlavor.getMimeType();
        if (!string.equals("application/x-pkcs7-mime") && !string.equals("application/x-pkcs7-signature")) {
            if (debug != null) {
                debug.text(16384L, className, "getTransferData", "Dataflavor mimetype " + string + " is not supported by PKCS7MimeHandler.");
            }
            throw new IOException("Dataflavor mimetype " + string + " is not supported by PKCS7MimeHandler.");
        }
        if (!dataFlavor.getRepresentationClass().getName().equals(PKCS7MIMEDATASOURCE_CLASSNAME)) {
            if (debug != null) {
                debug.text(16384L, className, "getTransferData", dataFlavor.getRepresentationClass().getName() + " not supported by PKCS7MimeHandler.");
            }
            throw new IOException(dataFlavor.getRepresentationClass().getName() + " not supported by PKCS7MimeHandler.");
        }
        try {
            ContentInfo contentInfo = null;
            if (dataSource instanceof PKCS7MimeDataSource) {
                contentInfo = ((PKCS7MimeDataSource)dataSource).getContentInfo();
            } else {
                ByteArrayInputStream byteArrayInputStream = (ByteArrayInputStream)dataSource.getInputStream();
                int n = byteArrayInputStream.available();
                byte[] byArray = new byte[n];
                int n2 = byteArrayInputStream.read(byArray, 0, n);
                contentInfo = new ContentInfo(byArray, this.provider);
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getTransferData_1", contentInfo);
            }
            return contentInfo;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "getTransferData", exception);
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getTransferData_2", null);
            }
            return null;
        }
    }

    public void writeTo(Object object, String string, OutputStream outputStream) throws IOException {
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{object, string, outputStream};
            debug.entry(16384L, (Object)className, "writeTo", objectArray);
        }
        if (object instanceof ContentInfo) {
            objectArray = (Object[])object;
            objectArray.encode(outputStream);
            if (debug != null) {
                debug.exit(16384L, className, "writeTo");
            }
            return;
        }
        if (debug != null) {
            debug.text(16384L, className, "writeTo", "obj must be of type ContentInfo.  Instead obj is of class " + object.getClass().getName());
        }
        throw new IOException("obj must be of type ContentInfo.  Instead obj is of class " + object.getClass().getName());
    }

    public String toString() {
        String string = "PKCS7MimeHandler";
        if (debug != null) {
            debug.entry(16384L, className, "toString");
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }
}

