/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.smime.jmail;

import com.ibm.misc.BASE64Decoder;
import com.ibm.misc.Debug;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.SignedData;
import com.ibm.security.util.DerOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;

public class PKCS7MimeDataSource
implements DataSource,
Cloneable {
    private ContentInfo contentInfo;
    private String provider = null;
    public static final String CONTENT_TYPE_PKCS7 = "application/x-pkcs7-mime";
    public static final String CONTENT_TYPE_PKCS7_SIGNATURE = "application/x-pkcs7-signature";
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.smime.jmail.PKCS7MimeDataSource";

    private PKCS7MimeDataSource(String string) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "PKCS7MimeDataSource", string);
        }
        if (string != null) {
            this.provider = new String(string);
        }
        if (debug != null) {
            debug.exit(8192L, className, "PKCS7MimeDataSource");
        }
    }

    public PKCS7MimeDataSource(ContentInfo contentInfo) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PKCS7MimeDataSource", contentInfo);
        }
        if (contentInfo == null) {
            if (debug != null) {
                debug.text(16384L, className, "PKCS7MimeDataSource", "ContentInfo is null.");
            }
            throw new IllegalArgumentException("ContentInfo is null.");
        }
        this.contentInfo = contentInfo;
        if (debug != null) {
            debug.exit(16384L, className, "PKCS7MimeDataSource");
        }
    }

    public PKCS7MimeDataSource(ContentInfo contentInfo, String string) {
        if (debug != null) {
            debug.entry(16384L, className, "PKCS7MimeDataSource", contentInfo, string);
        }
        if (contentInfo == null) {
            if (debug != null) {
                debug.text(16384L, className, "PKCS7MimeDataSource", "ContentInfo is null.");
            }
            throw new IllegalArgumentException("ContentInfo is null.");
        }
        if (string != null) {
            this.provider = new String(string);
        }
        this.contentInfo = contentInfo;
        if (debug != null) {
            debug.exit(16384L, className, "PKCS7MimeDataSource");
        }
    }

    public PKCS7MimeDataSource(byte[] byArray, boolean bl) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "PKCS7MimeDataSource", byArray, new Boolean(bl));
        }
        if (byArray == null || byArray.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "PKCS7MimeDataSource", "encoding is null or empty");
            }
            throw new IllegalArgumentException("encoding is null or empty");
        }
        byte[] byArray2 = byArray;
        if (bl) {
            BASE64Decoder bASE64Decoder = new BASE64Decoder();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            byArray2 = bASE64Decoder.decodeBuffer(byteArrayInputStream);
        }
        this.contentInfo = new ContentInfo(byArray2, this.provider);
        if (debug != null) {
            debug.exit(16384L, className, "PKCS7MimeDataSource");
        }
    }

    public PKCS7MimeDataSource(byte[] byArray, boolean bl, String string) throws IOException {
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{byArray, new Boolean(bl), string};
            debug.entry(16384L, (Object)className, "PKCS7MimeDataSource", objectArray);
        }
        if (byArray == null || byArray.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "PKCS7MimeDataSource", "encoding is null or empty");
            }
            throw new IllegalArgumentException("encoding is null or empty");
        }
        objectArray = byArray;
        if (string != null) {
            this.provider = new String(string);
        }
        if (bl) {
            BASE64Decoder bASE64Decoder = new BASE64Decoder();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            objectArray = bASE64Decoder.decodeBuffer(byteArrayInputStream);
        }
        this.contentInfo = new ContentInfo((byte[])objectArray, this.provider);
        if (debug != null) {
            debug.exit(16384L, className, "PKCS7MimeDataSource");
        }
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            PKCS7MimeDataSource pKCS7MimeDataSource = new PKCS7MimeDataSource(this.provider);
            if (this.contentInfo != null) {
                pKCS7MimeDataSource.setContentInfo((ContentInfo)this.contentInfo.clone());
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", pKCS7MimeDataSource);
            }
            return pKCS7MimeDataSource;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", exception);
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    private void setContentInfo(ContentInfo contentInfo) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setContentInfo", contentInfo);
        }
        this.contentInfo = (ContentInfo)contentInfo.clone();
        if (debug != null) {
            debug.exit(8192L, className, "setContentInfo");
        }
    }

    public ContentInfo getContentInfo() {
        if (debug != null) {
            debug.entry(16384L, className, "getContentInfo");
        }
        if (this.contentInfo == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContentInfo_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getContentInfo_2", (ContentInfo)this.contentInfo.clone());
        }
        return (ContentInfo)this.contentInfo.clone();
    }

    public InputStream getInputStream() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getInputStream");
        }
        if (this.contentInfo == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getInputStream_1", null);
            }
            return null;
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        this.contentInfo.encode(derOutputStream);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(derOutputStream.toByteArray());
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getInputStream", byteArrayInputStream);
        }
        return byteArrayInputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getOutputStream");
            debug.exit(16384L, (Object)className, "getOutputStream", new ByteArrayOutputStream());
        }
        return new ByteArrayOutputStream();
    }

    public String getContentType() {
        String string = null;
        if (debug != null) {
            debug.entry(16384L, className, "getContentType");
        }
        if (this.contentInfo != null) {
            SignedData signedData;
            string = CONTENT_TYPE_PKCS7;
            if (this.contentInfo.isSignedData() && !(signedData = (SignedData)this.contentInfo.getContent()).hasContent()) {
                string = CONTENT_TYPE_PKCS7_SIGNATURE;
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getContentType", string);
        }
        return string;
    }

    public String getName() {
        String string = null;
        if (debug != null) {
            debug.entry(16384L, className, "getName");
        }
        if (this.contentInfo != null) {
            string = this.contentInfo.getContentTypeString();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getName", string);
        }
        return string;
    }

    public String toString() {
        String string = "PKCS7MimeDataSource:  ";
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        string = this.contentInfo != null ? string + this.contentInfo.toString() : string + "Does not contain a ContentInfo object.";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }
}

