/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcsutil;

import com.ibm.misc.Debug;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.util.Arrays;

public final class PublicKeyAndChallenge
extends PKCSDerObject {
    private PublicKey spki;
    private String challenge;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcsutil.PublicKeyAndChallenge";
    private volatile int cachedHashVal = 0;

    public PublicKeyAndChallenge(byte[] byArray) throws IOException {
        super(byArray);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PublicKeyAndChallenge", (Object)byArray);
            debug.exit(16384L, className, "PublicKeyAndChallenge");
        }
    }

    public PublicKeyAndChallenge(byte[] byArray, String string) throws IOException {
        super(byArray, string);
        if (debug != null) {
            debug.entry(16384L, className, "PublicKeyAndChallenge", byArray, string);
            debug.exit(16384L, className, "PublicKeyAndChallenge");
        }
    }

    public PublicKeyAndChallenge(PublicKey publicKey, String string) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, className, "PublicKeyAndChallenge", publicKey, string);
        }
        if (publicKey == null) {
            if (debug != null) {
                debug.text(16384L, className, "PublicKeyAndChallenge", "publicKey not specified");
            }
            throw new IllegalArgumentException("publicKey not specified");
        }
        if (string == null) {
            if (debug != null) {
                debug.text(16384L, className, "PublicKeyAndChallenge", "challenge not specified");
            }
            throw new IllegalArgumentException("challenge not specified");
        }
        this.challenge = string;
        this.spki = publicKey;
        if (debug != null) {
            debug.exit(16384L, className, "PublicKeyAndChallenge");
        }
    }

    public PublicKeyAndChallenge(PublicKey publicKey, String string, String string2) throws InvalidKeyException {
        super(string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{publicKey, string, string2};
            debug.entry(16384L, (Object)className, "PublicKeyAndChallenge", objectArray);
        }
        if (publicKey == null) {
            if (debug != null) {
                debug.text(16384L, className, "PublicKeyAndChallenge", "publicKey not specified");
            }
            throw new IllegalArgumentException("publicKey not specified");
        }
        if (string == null) {
            if (debug != null) {
                debug.text(16384L, className, "PublicKeyAndChallenge", "challenge not specified");
            }
            throw new IllegalArgumentException("challenge not specified");
        }
        this.challenge = string;
        this.spki = publicKey;
        if (debug != null) {
            debug.exit(16384L, className, "PublicKeyAndChallenge");
        }
    }

    public PublicKey getSubjectPublicKeyInfo() throws InvalidKeyException, IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getSubjectPublicKeyInfo");
        }
        if (this.spki == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSubjectPublicKeyInfo_1", null);
            }
            return null;
        }
        DerValue derValue = new DerValue(this.spki.getEncoded());
        PublicKey publicKey = X509Key.parse(derValue);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSubjectPublicKeyInfo_2", publicKey);
        }
        return publicKey;
    }

    public String getChallenge() {
        if (debug != null) {
            debug.entry(16384L, className, "getChallenge");
            debug.exit(16384L, (Object)className, "getChallenge", this.challenge);
        }
        return this.challenge;
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        derOutputStream.write(this.spki.getEncoded());
        derOutputStream.putIA5String(this.challenge);
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "parsing error, not a SEQUENCE");
            }
            throw new IOException("parsing error, not a SEQUENCE");
        }
        this.spki = null;
        this.challenge = null;
        if (derValue.getData().available() == 0) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "parsing error, missing data");
            }
            throw new IOException("parsing error, missing data");
        }
        this.spki = X509Key.parse(derValue.getData().getDerValue());
        if (derValue.getData().available() == 0) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "parsing error, missing data");
            }
            throw new IOException("parsing error, missing data");
        }
        this.challenge = derValue.getData().getDerValue().getIA5String();
        if (derValue.getData().available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "parsing error, data overrun");
            }
            throw new IOException("parsing error, data overrun");
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    public boolean equals(Object object) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (object == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", true);
            }
            return true;
        }
        if (!(object instanceof PublicKeyAndChallenge)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", false);
            }
            return false;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            ((PublicKeyAndChallenge)object).encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", exception);
                debug.exit(16384L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_4", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_5", true);
        }
        return true;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                this.encode(derOutputStream);
                this.cachedHashVal = Arrays.hashCode(derOutputStream.toByteArray());
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public String toString() {
        String string = "PublicKeyAndChallenge:";
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        string = this.spki != null ? string + "\r\n\tpublicKey: " + this.spki.toString() : string + "\r\n\tpublicKey: null";
        string = this.challenge != null ? string + "\r\n\tchallenge: " + this.challenge : string + "\r\n\tchallenge: null";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }

    public Object clone() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            this.encode(derOutputStream);
            PublicKeyAndChallenge publicKeyAndChallenge = new PublicKeyAndChallenge(derOutputStream.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", publicKeyAndChallenge);
            }
            return publicKeyAndChallenge;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", exception);
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }
}

