/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs9;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs9.PKCS9DerObject;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public final class UnstructuredName
extends PKCS9DerObject
implements Cloneable {
    private String[] names;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs9.UnstructuredName";
    private volatile int cachedHashVal = 0;

    public UnstructuredName(byte[] byArray) throws IOException {
        super(byArray);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "UnstructuredName", (Object)byArray);
            debug.exit(16384L, className, "UnstructuredName");
        }
    }

    public UnstructuredName(byte[] byArray, String string) throws IOException {
        super(byArray, string);
        if (debug != null) {
            debug.entry(16384L, className, "UnstructuredName", byArray, string);
            debug.exit(16384L, className, "UnstructuredName");
        }
    }

    public UnstructuredName(String[] stringArray) {
        this.names = stringArray;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "UnstructuredName", stringArray);
            debug.exit(16384L, className, "UnstructuredName");
        }
    }

    public UnstructuredName(String[] stringArray, String string) {
        super(string);
        this.names = stringArray;
        if (debug != null) {
            debug.entry(16384L, className, "UnstructuredName", stringArray, string);
            debug.exit(16384L, className, "UnstructuredName");
        }
    }

    public UnstructuredName(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            debug.entry(16384L, className, "UnstructuredName", string, new Boolean(bl));
            debug.exit(16384L, className, "UnstructuredName");
        }
    }

    public UnstructuredName(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "UnstructuredName", objectArray);
            debug.exit(16384L, className, "UnstructuredName");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
            debug.exit(16384L, className, "clone");
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            UnstructuredName unstructuredName = new UnstructuredName(derOutputStream.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", unstructuredName);
            }
            return unstructuredName;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", exception);
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    public boolean equals(Object object) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (object == this) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals", new Boolean(false));
            }
            return true;
        }
        if (object instanceof UnstructuredName) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", this.equals((UnstructuredName)object));
            }
            return this.equals((UnstructuredName)object);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(false));
        }
        return false;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                this.encode(derOutputStream);
                this.cachedHashVal = Arrays.hashCode(derOutputStream.toByteArray());
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.exit(16384L, (Object)className, "getObjectIdentifier", PKCSOID.UNSTRUCTURED_NAME_OID);
        }
        return PKCSOID.UNSTRUCTURED_NAME_OID;
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        if (this.names == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Unstructured Names not specified.");
            }
            throw new IOException("Unstructured Names not specified.");
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putOID(this.getObjectIdentifier());
        DerEncoder[] derEncoderArray = new DerOutputStream[this.names.length];
        for (int i = 0; i < this.names.length; ++i) {
            derEncoderArray[i] = new DerOutputStream();
            ((DerOutputStream)derEncoderArray[i]).putIA5String(this.names[i]);
        }
        derOutputStream.putOrderedSetOf((byte)49, derEncoderArray);
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream.toByteArray());
        outputStream.write(derOutputStream2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public String[] getUnstructuredNames() {
        if (debug != null) {
            debug.entry(16384L, className, "getUnstructuredNames");
            debug.exit(16384L, (Object)className, "getUnstructuredNames", this.names.clone());
        }
        return (String[])this.names.clone();
    }

    public Object getValue() {
        if (debug != null) {
            debug.entry(16384L, className, "getValue");
            debug.exit(16384L, (Object)className, "getValue", this.getUnstructuredNames());
        }
        return this.getUnstructuredNames();
    }

    public boolean isTagValid(byte by) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isTagValid", new Byte(by));
        }
        if (by == 22) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "isTagValid", new Boolean(true));
            }
            return true;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "isTagValid", new Boolean(false));
        }
        return false;
    }

    public boolean isSingleValued() {
        if (debug != null) {
            debug.entry(16384L, className, "isSingleValued");
            debug.exit(16384L, (Object)className, "isSingleValued", new Boolean(false));
        }
        return false;
    }

    public String getAttributeName() {
        if (debug != null) {
            debug.entry(16384L, className, "isSingleValued");
            debug.exit(16384L, (Object)className, "isSingleValued", "UnstructuredName");
        }
        return "UnstructuredName";
    }

    public String toString() {
        int n = this.names.length;
        String string = "PKCS9 UnstructuredName:";
        for (int i = 0; i < n; ++i) {
            string = string + " \"" + this.names[i] + "\"";
            if (i == n - 1) continue;
            string = string + ",";
        }
        string = string + "\r\n";
        return string;
    }

    protected void decode(DerValue derValue) throws IOException {
        super.decode(derValue);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        DerValue[] derValueArray = null;
        if (derValue.getTag() == 48) {
            DerInputStream derInputStream = new DerInputStream(derValue.toByteArray());
            DerValue[] derValueArray2 = derInputStream.getSequence(2);
            derValueArray = new DerInputStream(derValueArray2[1].toByteArray()).getSet(1);
        } else {
            derValueArray = new DerInputStream(derValue.toByteArray()).getSet(1);
        }
        this.names = new String[derValueArray.length];
        for (int i = 0; i < derValueArray.length; ++i) {
            this.names[i] = derValueArray[i].getAsString();
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private boolean equals(UnstructuredName unstructuredName) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "equals", unstructuredName);
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            unstructuredName.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(8192L, className, "equals", exception);
                debug.exit(8192L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }
}

