/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs9;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs9.PKCS9DerObject;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public final class UnstructuredAddress
extends PKCS9DerObject
implements Cloneable {
    private String[] addresses;
    private byte type;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs9.UnstructuredAddress";
    private volatile int cachedHashVal = 0;

    public UnstructuredAddress(byte[] byArray) throws IOException {
        super(byArray);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "UnstructuredAddress", (Object)byArray);
            debug.exit(16384L, className, "UnstructuredAddress");
        }
    }

    public UnstructuredAddress(byte[] byArray, String string) throws IOException {
        super(byArray, string);
        if (debug != null) {
            debug.entry(16384L, className, "UnstructuredAddress", byArray, string);
            debug.exit(16384L, className, "UnstructuredAddress");
        }
    }

    public UnstructuredAddress(String[] stringArray, byte by) {
        this.addresses = stringArray;
        this.type = by;
        if (debug != null) {
            debug.entry(16384L, className, "UnstructuredAddress", stringArray, new Byte(by));
            debug.exit(16384L, className, "UnstructuredAddress");
        }
    }

    public UnstructuredAddress(String[] stringArray, byte by, String string) {
        super(string);
        this.addresses = stringArray;
        this.type = by;
        if (debug != null) {
            Object[] objectArray = new Object[]{stringArray, new Byte(by), string};
            debug.entry(16384L, (Object)className, "UnstructuredAddress", objectArray);
            debug.exit(16384L, className, "UnstructuredAddress");
        }
    }

    public UnstructuredAddress(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            debug.entry(16384L, className, "UnstructuredAddress", string, new Boolean(bl));
            debug.exit(16384L, className, "UnstructuredAddress");
        }
    }

    public UnstructuredAddress(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{this.addresses, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "UnstructuredAddress", objectArray);
            debug.exit(16384L, className, "UnstructuredAddress");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            UnstructuredAddress unstructuredAddress = new UnstructuredAddress(derOutputStream.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", unstructuredAddress);
            }
            return unstructuredAddress;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", exception);
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    public boolean equals(Object object) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (object == this) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals", new Boolean(true));
            }
            return true;
        }
        if (object instanceof UnstructuredAddress) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(this.equals((UnstructuredAddress)object)));
            }
            return this.equals((UnstructuredAddress)object);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(false));
        }
        return false;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                this.encode(derOutputStream);
                this.cachedHashVal = Arrays.hashCode(derOutputStream.toByteArray());
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.exit(16384L, (Object)className, "getObjectIdentifier", PKCSOID.UNSTRUCTURED_ADDRESS_OID);
        }
        return PKCSOID.UNSTRUCTURED_ADDRESS_OID;
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        if (this.addresses == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Unstructured addresses not specified.");
            }
            throw new IOException("Unstructured addresses not specified.");
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putOID(this.getObjectIdentifier());
        DerEncoder[] derEncoderArray = new DerOutputStream[this.addresses.length];
        for (int i = 0; i < this.addresses.length; ++i) {
            derEncoderArray[i] = new DerOutputStream();
            if (this.type == 20) {
                ((DerOutputStream)derEncoderArray[i]).putPrintableString(this.addresses[i]);
                continue;
            }
            ((DerOutputStream)derEncoderArray[i]).putPrintableString(this.addresses[i]);
        }
        derOutputStream.putOrderedSetOf((byte)49, derEncoderArray);
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.write((byte)48, derOutputStream.toByteArray());
        outputStream.write(derOutputStream3.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public String[] getUnstructuredAddresses() {
        if (debug != null) {
            debug.entry(16384L, className, "getUnstructuredAddresses");
            debug.exit(16384L, (Object)className, "getUnstructuredAddresses", this.addresses.clone());
        }
        return (String[])this.addresses.clone();
    }

    public byte getType() {
        if (debug != null) {
            debug.entry(16384L, className, "getType");
            debug.exit(16384L, (Object)className, "getType", new Byte(this.type));
        }
        return this.type;
    }

    public Object getValue() {
        if (debug != null) {
            debug.entry(16384L, className, "getValue");
            debug.exit(16384L, (Object)className, "getValue", this.getUnstructuredAddresses());
        }
        return this.getUnstructuredAddresses();
    }

    public boolean isTagValid(byte by) {
        if (debug != null) {
            debug.entry(16384L, className, "isTagValid");
        }
        if (by == 19 || by == 20) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "isTagValid", new Boolean(true));
            }
            return true;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "isTagValid", new Boolean(false));
        }
        return false;
    }

    public boolean isSingleValued() {
        if (debug != null) {
            debug.entry(16384L, className, "isSingleValued");
            debug.exit(16384L, (Object)className, "isSingleValued", new Boolean(false));
        }
        return false;
    }

    public String getAttributeName() {
        if (debug != null) {
            debug.entry(16384L, className, "getAttributeName");
            debug.exit(16384L, (Object)className, "getAttributeName", "UnstructuredAddress");
        }
        return "UnstructuredAddress";
    }

    public String toString() {
        int n = this.addresses.length;
        String string = "PKCS9 UnstructuredAddress: ";
        for (int i = 0; i < n; ++i) {
            string = string + " \"" + this.addresses[i] + "\"";
            if (i == n - 1) continue;
            string = string + ",";
        }
        string = string + "\r\n";
        return string;
    }

    protected void decode(DerValue derValue) throws IOException {
        super.decode(derValue);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        DerValue[] derValueArray = null;
        if (derValue.getTag() == 48) {
            DerInputStream derInputStream = new DerInputStream(derValue.toByteArray());
            DerValue[] derValueArray2 = derInputStream.getSequence(2);
            derValueArray = new DerInputStream(derValueArray2[1].toByteArray()).getSet(1);
        } else {
            derValueArray = new DerInputStream(derValue.toByteArray()).getSet(1);
        }
        this.type = derValueArray[0].getTag() == 20 ? (byte)20 : (byte)19;
        this.addresses = new String[derValueArray.length];
        for (int i = 0; i < derValueArray.length; ++i) {
            this.addresses[i] = derValueArray[i].getAsString();
            if (debug == null) continue;
            debug.exit(16384L, className, "decode");
        }
    }

    private boolean equals(UnstructuredAddress unstructuredAddress) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "equals", unstructuredAddress);
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            unstructuredAddress.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(8192L, className, "equals", exception);
                debug.exit(8192L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "equals", new Boolean(false));
        }
        return true;
    }
}

