/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs9;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.EncapsulatedContentInfo;
import com.ibm.security.pkcs7.SignedData;
import com.ibm.security.pkcs9.PKCS9DerObject;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;

public class SignatureTimestampToken
extends PKCS9DerObject
implements Cloneable {
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs9.SignatureTimestampToken";
    private ContentInfo contentInfo;

    public SignatureTimestampToken(ContentInfo contentInfo) {
        this.contentInfo = contentInfo;
    }

    public SignatureTimestampToken(byte[] byArray) throws IOException {
        super(byArray);
    }

    public SignatureTimestampToken(byte[] byArray, String string) throws IOException {
        super(byArray, string);
    }

    public SignatureTimestampToken(String string, boolean bl) throws IOException {
        super(string, bl);
    }

    public SignatureTimestampToken(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
    }

    public boolean isTagValid(byte by) {
        return by == 48;
    }

    public boolean isSingleValued() {
        return true;
    }

    public String getAttributeName() {
        return "SignatureTimestampToken";
    }

    public Object getValue() {
        if (this.contentInfo == null) {
            return null;
        }
        return this.contentInfo.clone();
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        if (this.contentInfo == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "TimestampToken object is not initialized.");
            }
            throw new IOException("TimestampToken object is not initialized.");
        }
        DerEncoder[] derEncoderArray = new DerOutputStream[]{new DerOutputStream()};
        this.contentInfo.encode(derEncoderArray[0]);
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putOID(this.getObjectIdentifier());
        derOutputStream.putOrderedSetOf((byte)49, derEncoderArray);
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[\n");
        stringBuilder.append("SignatureTimestampToken :\n");
        stringBuilder.append(this.contentInfo.toString());
        stringBuilder.append("\n]");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SignatureTimestampToken)) {
            return false;
        }
        return this.contentInfo.equals(((SignatureTimestampToken)object).getValue());
    }

    public int hashCode() {
        return this.contentInfo.hashCode();
    }

    protected void decode(DerValue derValue) throws IOException {
        Object object;
        super.decode(derValue);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        DerValue[] derValueArray = null;
        if (derValue.getTag() == 48) {
            object = new DerInputStream(derValue.toByteArray());
            DerValue[] derValueArray2 = ((DerInputStream)object).getSequence(2);
            derValueArray = new DerInputStream(derValueArray2[1].toByteArray()).getSet(1);
        } else {
            derValueArray = new DerInputStream(derValue.toByteArray()).getSet(1);
        }
        this.contentInfo = new ContentInfo(derValueArray[0].toByteArray());
        if (!this.contentInfo.getContentType().equals(PKCSOID.SIGNED_DATA_OID)) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "decode", "ContentInfo is not SignedData", this.contentInfo.getContentType());
            }
            throw new IOException("Invalid encoding of SignatureTimestampToken");
        }
        object = ((SignedData)this.contentInfo.getContent()).getEncapsulatedContentInfo();
        if (object == null || !((EncapsulatedContentInfo)object).getContentType().equals(PKCSOID.TSTINFO_OID)) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "decode", "EncapsulatedContentInfo does not contain a TSTInfo object", object == null ? null : ((EncapsulatedContentInfo)object).getContentType());
            }
            throw new IOException("Invalid encoding of SignatureTimestampToken");
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "decode", derValue);
        }
    }

    public ObjectIdentifier getObjectIdentifier() {
        return PKCSOID.SIGNATURE_TIMESTAMP_TOKEN_OID;
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            SignatureTimestampToken signatureTimestampToken = new SignatureTimestampToken(derOutputStream.toByteArray());
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", signatureTimestampToken);
            }
            return signatureTimestampToken;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", exception);
            }
            return null;
        }
    }
}

