/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs9;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs9.PKCS9DerObject;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.CertificateExtensions;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CertificateException;

public class ExtensionRequest
extends PKCS9DerObject
implements Cloneable {
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs9.ExtensionRequest";
    private CertificateExtensions certExtensions;

    public ExtensionRequest(CertificateExtensions certificateExtensions) {
        this.certExtensions = certificateExtensions;
    }

    public ExtensionRequest(byte[] byArray) throws IOException {
        super(byArray);
    }

    public ExtensionRequest(byte[] byArray, String string) throws IOException {
        super(byArray, string);
    }

    public ExtensionRequest(String string, boolean bl) throws IOException {
        super(string, bl);
    }

    public ExtensionRequest(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
    }

    public boolean isTagValid(byte by) {
        return by == 48;
    }

    public boolean isSingleValued() {
        return true;
    }

    public String getAttributeName() {
        return "ExtensionRequest";
    }

    public Object getValue() {
        if (this.certExtensions != null) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                this.certExtensions.encode(derOutputStream, true);
                DerInputStream derInputStream = new DerInputStream(derOutputStream.toByteArray());
                return new CertificateExtensions(derInputStream);
            }
            catch (Exception exception) {
                if (debug != null) {
                    debug.exception(16384L, className, "getValue", exception);
                }
                return null;
            }
        }
        return null;
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        if (this.certExtensions == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "ExtensionRequest object is not initialized.");
            }
            throw new IOException("ExtensionRequest object is not initialized.");
        }
        DerEncoder[] derEncoderArray = new DerOutputStream[]{new DerOutputStream()};
        try {
            this.certExtensions.encode(derEncoderArray[0], true);
        }
        catch (CertificateException certificateException) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Error encoding CertificateExtensions object.");
            }
            throw new IOException(certificateException.getMessage());
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putOID(this.getObjectIdentifier());
        derOutputStream.putOrderedSetOf((byte)49, derEncoderArray);
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[\n");
        stringBuilder.append("ExtensionRequest :\n");
        stringBuilder.append(this.certExtensions.toString());
        stringBuilder.append("\n]");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ExtensionRequest)) {
            return false;
        }
        return this.certExtensions.equals(((ExtensionRequest)object).getValue());
    }

    public int hashCode() {
        return this.certExtensions.hashCode();
    }

    protected void decode(DerValue derValue) throws IOException {
        super.decode(derValue);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        DerValue[] derValueArray = null;
        if (derValue.getTag() == 48) {
            DerInputStream derInputStream = new DerInputStream(derValue.toByteArray());
            DerValue[] derValueArray2 = derInputStream.getSequence(2);
            derValueArray = new DerInputStream(derValueArray2[1].toByteArray()).getSet(1);
        } else {
            derValueArray = new DerInputStream(derValue.toByteArray()).getSet(1);
        }
        this.certExtensions = new CertificateExtensions(new DerInputStream(derValueArray[0].toByteArray()));
        if (debug != null) {
            debug.exit(16384L, (Object)className, "decode", derValue);
        }
    }

    public ObjectIdentifier getObjectIdentifier() {
        return PKCSOID.EXTENSION_REQUEST_OID;
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            ExtensionRequest extensionRequest = new ExtensionRequest(derOutputStream.toByteArray());
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", extensionRequest);
            }
            return extensionRequest;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }
}

