/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs9;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs9.PKCS9DerObject;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public final class ExtendedCertificateAttributes
extends PKCS9DerObject
implements Cloneable {
    private PKCSAttributes attributes;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs9.ExtendedCertificateAttributes";
    private volatile int cachedHashVal = 0;

    public ExtendedCertificateAttributes(byte[] byArray) throws IOException {
        super(byArray);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "ExtendedCertificateAttributes", (Object)byArray);
            debug.exit(16384L, className, "ExtendedCertificateAttributes");
        }
    }

    public ExtendedCertificateAttributes(byte[] byArray, String string) throws IOException {
        super(byArray, string);
        if (debug != null) {
            debug.entry(16384L, className, "ExtendedCertificateAttributes", byArray, string);
            debug.exit(16384L, className, "ExtendedCertificateAttributes");
        }
    }

    public ExtendedCertificateAttributes(PKCSAttribute pKCSAttribute) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "ExtendedCertificateAttributes", pKCSAttribute);
        }
        PKCSAttribute[] pKCSAttributeArray = new PKCSAttribute[]{pKCSAttribute};
        this.attributes = new PKCSAttributes(pKCSAttributeArray);
        if (debug != null) {
            debug.exit(16384L, className, "ExtendedCertificateAttributes");
        }
    }

    public ExtendedCertificateAttributes(PKCSAttribute pKCSAttribute, String string) {
        if (debug != null) {
            debug.entry(16384L, className, "ExtendedCertificateAttributes", pKCSAttribute, string);
        }
        PKCSAttribute[] pKCSAttributeArray = new PKCSAttribute[]{pKCSAttribute};
        this.attributes = new PKCSAttributes(pKCSAttributeArray, string);
        if (debug != null) {
            debug.exit(16384L, className, "ExtendedCertificateAttributes");
        }
    }

    public ExtendedCertificateAttributes(PKCSAttributes pKCSAttributes) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "ExtendedCertificateAttributes", pKCSAttributes);
        }
        this.attributes = pKCSAttributes;
        if (debug != null) {
            debug.exit(16384L, className, "ExtendedCertificateAttributes");
        }
    }

    public ExtendedCertificateAttributes(PKCSAttributes pKCSAttributes, String string) {
        super(string);
        if (debug != null) {
            debug.entry(16384L, className, "ExtendedCertificateAttributes", pKCSAttributes, string);
            debug.exit(16384L, className, "ExtendedCertificateAttributes");
        }
        this.attributes = pKCSAttributes;
    }

    public ExtendedCertificateAttributes(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            debug.entry(16384L, className, "ExtendedCertificateAttributes", string, new Boolean(bl));
            debug.exit(16384L, className, "ExtendedCertificateAttributes");
        }
    }

    public ExtendedCertificateAttributes(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "ExtendedCertificateAttributes", objectArray);
            debug.exit(16384L, className, "ExtendedCertificateAttributes");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            ExtendedCertificateAttributes extendedCertificateAttributes = new ExtendedCertificateAttributes(derOutputStream.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", extendedCertificateAttributes);
            }
            return extendedCertificateAttributes;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    public boolean equals(Object object) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (object == this) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals", new Boolean(true));
            }
            return true;
        }
        if (object instanceof ExtendedCertificateAttributes) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(this.equals((ExtendedCertificateAttributes)object)));
            }
            return this.equals((ExtendedCertificateAttributes)object);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(false));
        }
        return false;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                this.encode(derOutputStream);
                this.cachedHashVal = Arrays.hashCode(derOutputStream.toByteArray());
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.exit(16384L, (Object)className, "getObjectIdentifier", PKCSOID.EXTENDED_CERTIFICATE_ATTRIBUTES_OID);
        }
        return PKCSOID.EXTENDED_CERTIFICATE_ATTRIBUTES_OID;
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        if (this.attributes == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Attributes not specified.");
            }
            throw new IOException("Attributes not specified.");
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putOID(this.getObjectIdentifier());
        this.attributes.encode(derOutputStream2);
        derOutputStream.write((byte)49, derOutputStream2.toByteArray());
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.write((byte)48, derOutputStream.toByteArray());
        outputStream.write(derOutputStream3.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public PKCSAttributes getExtendedCertificateAttributes() {
        if (debug != null) {
            debug.entry(16384L, className, "getExtendedCertificateAttributes");
            debug.exit(16384L, (Object)className, "getExtendedCertificateAttributes", this.attributes);
        }
        return this.attributes;
    }

    public Object getValue() {
        if (debug != null) {
            debug.entry(16384L, className, "getValue");
            debug.exit(16384L, (Object)className, "getValue", this.getExtendedCertificateAttributes());
        }
        return this.getExtendedCertificateAttributes();
    }

    public boolean isTagValid(byte by) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isTagValid", new Byte(by));
        }
        if (by == 49) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "isTagValid", new Boolean(true));
            }
            return true;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "isTagValid", new Boolean(false));
        }
        return false;
    }

    public boolean isSingleValued() {
        if (debug != null) {
            debug.entry(16384L, className, "isSingleValued");
            debug.exit(16384L, (Object)className, "isSingleValued", new Boolean(true));
        }
        return true;
    }

    public String getAttributeName() {
        if (debug != null) {
            debug.entry(16384L, className, "getAttributeName");
            debug.exit(16384L, (Object)className, "getAttributeName", "ExtendedCertificateAttributes");
        }
        return "ExtendedCertificateAttributes";
    }

    public String toString() {
        String string = "PKCS9 ExtendedCertificateAttributes:\r\n";
        if (this.attributes == null || this.attributes.size() == 0) {
            string = string + "\tNo PKCSAttributes value set.\r\n";
        } else {
            PKCSAttribute[] pKCSAttributeArray = this.attributes.getAttributes();
            for (int i = 0; i < pKCSAttributeArray.length; ++i) {
                string = string + "PKCSAttribute[" + i + "]:\r\n";
                string = string + pKCSAttributeArray[i].toString();
                ++i;
            }
        }
        return string;
    }

    protected void decode(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        super.decode(derValue);
        DerValue[] derValueArray = null;
        if (derValue.getTag() == 48) {
            DerInputStream derInputStream = new DerInputStream(derValue.toByteArray());
            DerValue[] derValueArray2 = derInputStream.getSequence(2);
            derValueArray = new DerInputStream(derValueArray2[1].toByteArray()).getSet(1);
        } else {
            derValueArray = new DerInputStream(derValue.toByteArray()).getSet(1);
        }
        this.attributes = new PKCSAttributes(new DerInputStream(derValueArray[0].toByteArray()), this.provider);
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private boolean equals(ExtendedCertificateAttributes extendedCertificateAttributes) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "equals", extendedCertificateAttributes);
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            extendedCertificateAttributes.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(8192L, className, "equals", exception);
                debug.exit(8192L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }
}

