/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs8;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;

public class PrivateKeyInfo
extends PKCSDerObject
implements PrivateKey {
    public static final BigInteger version = BigInteger.ZERO;
    protected AlgorithmId algid;
    protected byte[] key;
    protected PKCSAttributes attributes;
    private static final byte TAG_ATTRS = 0;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs8.PrivateKeyInfo";

    public PrivateKeyInfo() {
        if (debug != null) {
            debug.entry(16384L, className, "PrivateKeyInfo");
            debug.exit(16384L, className, "PrivateKeyInfo");
        }
    }

    public PrivateKeyInfo(String string) {
        super(string);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PrivateKeyInfo", string);
            debug.exit(16384L, className, "PrivateKeyInfo");
        }
    }

    public PrivateKeyInfo(byte[] byArray) throws IOException {
        super(byArray);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PrivateKeyInfo", (Object)byArray);
            debug.exit(16384L, className, "PrivateKeyInfo");
        }
    }

    public PrivateKeyInfo(byte[] byArray, String string) throws IOException {
        super(byArray, string);
        if (debug != null) {
            debug.entry(16384L, className, "PrivateKeyInfo", byArray, string);
            debug.exit(16384L, className, "PrivateKeyInfo");
        }
    }

    public PrivateKeyInfo(AlgorithmId algorithmId, byte[] byArray, PKCSAttributes pKCSAttributes) throws IOException {
        if (debug != null) {
            Object[] objectArray = new Object[]{algorithmId, byArray, pKCSAttributes};
            debug.entry(16384L, (Object)className, "PrivateKeyInfo", objectArray);
        }
        this.algid = algorithmId;
        this.key = byArray;
        this.attributes = pKCSAttributes;
        if (debug != null) {
            debug.exit(16384L, className, "PrivateKeyInfo");
        }
    }

    public PrivateKeyInfo(AlgorithmId algorithmId, byte[] byArray, PKCSAttributes pKCSAttributes, String string) throws IOException {
        super(string);
        if (debug != null) {
            Object[] objectArray = new Object[]{algorithmId, byArray, pKCSAttributes, string};
            debug.entry(16384L, (Object)className, "PrivateKeyInfo", objectArray);
        }
        this.algid = algorithmId;
        this.key = byArray;
        this.attributes = pKCSAttributes;
        if (debug != null) {
            debug.exit(16384L, className, "PrivateKeyInfo");
        }
    }

    public PrivateKeyInfo(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            debug.entry(16384L, className, "PrivateKeyInfo", string, new Boolean(bl));
            debug.exit(16384L, className, "PrivateKeyInfo");
        }
    }

    public PrivateKeyInfo(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "PrivateKeyInfo", objectArray);
            debug.exit(16384L, className, "PrivateKeyInfo");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        derOutputStream.putInteger(version);
        this.algid.encode(derOutputStream);
        derOutputStream.putOctetString(this.key);
        if (this.attributes != null && this.attributes.size() > 0) {
            DerOutputStream derOutputStream3 = new DerOutputStream();
            this.attributes.encode(derOutputStream3);
            derOutputStream.writeImplicit(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream3);
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public static PrivateKey parseKey(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(49152L, (Object)className, "parseKey", derValue);
            debug.exit(49152L, className, "parseKey");
        }
        return PrivateKeyInfo.parseKey(derValue, null);
    }

    public static PrivateKey parseKey(DerValue derValue, String string) throws IOException {
        PrivateKey privateKey;
        if (debug != null) {
            debug.entry(49152L, className, "parseKey", derValue, string);
        }
        if (derValue.getTag() != 48) {
            throw new IOException("corrupt private key");
        }
        BigInteger bigInteger = derValue.getData().getInteger();
        if (!version.equals(bigInteger)) {
            if (debug != null) {
                debug.text(49152L, className, "parseKey", "version mismatch: (supported: " + version + ") parsed: " + bigInteger);
            }
            throw new IOException("version mismatch: (supported: " + version + ") parsed: " + bigInteger);
        }
        AlgorithmId algorithmId = AlgorithmId.parse(derValue.getData().getDerValue(), string);
        byte[] byArray = derValue.getData().getOctetString();
        PKCSAttributes pKCSAttributes = derValue.getData().available() != 0 ? new PKCSAttributes(derValue.getData(), string) : null;
        try {
            privateKey = PrivateKeyInfo.buildPrivateKeyInfo(algorithmId, byArray, pKCSAttributes, string);
        }
        catch (InvalidKeyException invalidKeyException) {
            if (debug != null) {
                debug.exception(49152L, className, "parseKey", invalidKeyException);
            }
            throw new IOException("corrupt private key");
        }
        if (debug != null) {
            debug.exit(49152L, (Object)className, "parseKey", privateKey);
        }
        return privateKey;
    }

    public PrivateKeyInfo addAttributes(PKCSAttributes pKCSAttributes) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "addAttributes", pKCSAttributes);
        }
        PrivateKeyInfo privateKeyInfo = (PrivateKeyInfo)this.clone();
        if (pKCSAttributes == null || pKCSAttributes.size() == 0) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "addAttributes_1", privateKeyInfo);
            }
            return privateKeyInfo;
        }
        privateKeyInfo.attributes = privateKeyInfo.attributes == null ? pKCSAttributes : privateKeyInfo.attributes.addAttributes(pKCSAttributes);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "addAttributes_2", privateKeyInfo);
        }
        return privateKeyInfo;
    }

    public PrivateKeyInfo addAttribute(PKCSAttribute pKCSAttribute) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "addAttribute", pKCSAttribute);
        }
        PrivateKeyInfo privateKeyInfo = (PrivateKeyInfo)this.clone();
        if (pKCSAttribute == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "addAttribute_1", privateKeyInfo);
            }
            return privateKeyInfo;
        }
        PKCSAttribute[] pKCSAttributeArray = new PKCSAttribute[]{pKCSAttribute};
        privateKeyInfo.attributes = privateKeyInfo.attributes == null ? new PKCSAttributes(pKCSAttributeArray, this.provider) : privateKeyInfo.attributes.addAttributes(new PKCSAttributes(pKCSAttributeArray, this.provider));
        if (debug != null) {
            debug.exit(16384L, (Object)className, "addAttribute_2", privateKeyInfo);
        }
        return privateKeyInfo;
    }

    public String getAlgorithm() {
        if (debug != null) {
            debug.entry(16384L, className, "getAlgorithm");
            debug.exit(16384L, (Object)className, "getAlgorithm", this.algid.getName());
        }
        return this.algid.getName();
    }

    public AlgorithmId getAlgorithmId() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "getAlgorithmId");
                debug.exit(16384L, (Object)className, "getAlgorithmId", new AlgorithmId(this.algid.getOID(), this.algid.getParameters(), this.provider));
            }
            return new AlgorithmId(this.algid.getOID(), this.algid.getParameters(), this.provider);
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getAlgorithmId", new AlgorithmId(this.algid.getOID(), this.provider));
            }
            return new AlgorithmId(this.algid.getOID(), this.provider);
        }
    }

    public synchronized byte[] getEncoded() {
        byte[] byArray;
        block4: {
            byArray = null;
            if (debug != null) {
                debug.entry(16384L, className, "getEncoded");
            }
            try {
                byArray = this.encode();
            }
            catch (IOException iOException) {
                if (debug == null) break block4;
                debug.exception(16384L, className, "getEncoded", iOException);
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getEncoded", byArray);
        }
        return byArray;
    }

    public String getFormat() {
        if (debug != null) {
            debug.entry(16384L, className, "getFormat");
            debug.exit(16384L, (Object)className, "getFormat", "PKCS#8");
        }
        return "PKCS#8";
    }

    public PKCSAttribute getAttribute(ObjectIdentifier objectIdentifier) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getAttribute", objectIdentifier);
        }
        if (objectIdentifier == null || this.attributes == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getAttribute_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getAttribute_2", (PKCSAttribute)this.attributes.getAttribute(objectIdentifier));
        }
        return (PKCSAttribute)this.attributes.getAttribute(objectIdentifier);
    }

    public PKCSAttributes getAttributes() {
        if (debug != null) {
            debug.entry(16384L, className, "getAttributes");
            debug.exit(16384L, (Object)className, "getAttributes", this.attributes);
        }
        return this.attributes;
    }

    public boolean hasAttribute(ObjectIdentifier objectIdentifier) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "hasAttribute", objectIdentifier);
        }
        if (this.attributes == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "hasAttribute_1", false);
            }
            return false;
        }
        PKCSAttribute pKCSAttribute = this.getAttribute(objectIdentifier);
        if (pKCSAttribute == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "hasAttribute_2", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hasAttribute_3", true);
        }
        return true;
    }

    public boolean hasAttributes() {
        if (debug != null) {
            debug.entry(16384L, className, "hasAttributes");
        }
        if (this.attributes != null && this.attributes.size() > 0) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "hasAttributes", true);
            }
            return true;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hasAttributes", false);
        }
        return false;
    }

    public boolean equals(Object object) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (object instanceof PrivateKeyInfo) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", this.equals((PrivateKeyInfo)object));
            }
            return this.equals((PrivateKeyInfo)object);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", false);
        }
        return false;
    }

    public String toString() {
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String string = "algorithm = " + this.algid.toString();
        string = string + "\r\nunparsed keybits =\r\n" + hexDumpEncoder.encodeBuffer(this.key);
        if (this.attributes != null) {
            string = string + "\r\nattributes:";
            string = string + "\r\n" + this.attributes.toString();
        } else {
            string = string + "\r\nno attributes";
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }

    public int hashCode() {
        int n = 0;
        if (debug != null) {
            debug.entry(16384L, className, "hashCode");
        }
        byte[] byArray = this.getEncoded();
        for (int i = 1; i < byArray.length; ++i) {
            n += byArray[i] * i;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hashCode", n);
        }
        return n;
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(derOutputStream.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", privateKeyInfo);
            }
            return privateKeyInfo;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "PrivateKeyInfo parsing error.");
            }
            throw new IOException("PrivateKeyInfo parsing error.");
        }
        BigInteger bigInteger = derValue.getData().getInteger();
        if (!bigInteger.equals(version)) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "Version mismatch: (supported: " + version + ", parsed: " + bigInteger);
            }
            throw new IOException("Version mismatch: (supported: " + version + ", parsed: " + bigInteger);
        }
        this.algid = AlgorithmId.parse(derValue.getData().getDerValue());
        this.key = derValue.getData().getOctetString();
        this.parseKeyBits();
        this.attributes = derValue.getData().available() != 0 ? new PKCSAttributes(derValue.getData(), this.provider) : null;
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    static void encode(DerOutputStream derOutputStream, AlgorithmId algorithmId, byte[] byArray, PKCSAttributes pKCSAttributes) throws IOException {
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{derOutputStream, algorithmId, byArray, pKCSAttributes};
            debug.entry(49152L, (Object)className, "encode", objectArray);
        }
        objectArray = new PrivateKeyInfo(algorithmId, byArray, pKCSAttributes);
        objectArray.encode(derOutputStream);
        if (debug != null) {
            debug.exit(49152L, className, "encode");
        }
    }

    static void encode(DerOutputStream derOutputStream, AlgorithmId algorithmId, byte[] byArray, PKCSAttributes pKCSAttributes, String string) throws IOException {
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{derOutputStream, algorithmId, byArray, pKCSAttributes, string};
            debug.entry(49152L, (Object)className, "encode", objectArray);
        }
        objectArray = new PrivateKeyInfo(algorithmId, byArray, pKCSAttributes, string);
        objectArray.encode(derOutputStream);
        if (debug != null) {
            debug.exit(49152L, className, "encode");
        }
    }

    protected void parseKeyBits() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "parseKeyBits");
        }
        this.encode();
        if (debug != null) {
            debug.exit(16384L, className, "parseKeyBits");
        }
    }

    static PrivateKey buildPrivateKeyInfo(AlgorithmId algorithmId, byte[] byArray, PKCSAttributes pKCSAttributes) throws IOException, InvalidKeyException {
        if (debug != null) {
            Object[] objectArray = new Object[]{algorithmId, byArray, pKCSAttributes};
            debug.entry(49152L, (Object)className, "buildPrivateKeyInfo", objectArray);
            debug.exit(49152L, className, "buildPrivateKeyInfo");
        }
        return PrivateKeyInfo.buildPrivateKeyInfo(algorithmId, byArray, pKCSAttributes, null);
    }

    static PrivateKey buildPrivateKeyInfo(AlgorithmId algorithmId, byte[] byArray, PKCSAttributes pKCSAttributes, String string) throws IOException, InvalidKeyException {
        block9: {
            Object[] objectArray;
            if (debug != null) {
                objectArray = new Object[]{algorithmId, byArray, pKCSAttributes, string};
                debug.entry(49152L, (Object)className, "buildPrivateKeyInfo", objectArray);
            }
            objectArray = new DerOutputStream();
            PrivateKeyInfo.encode((DerOutputStream)objectArray, algorithmId, byArray, pKCSAttributes, string);
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(objectArray.toByteArray());
            try {
                KeyFactory keyFactory = string != null ? KeyFactory.getInstance(algorithmId.getName(), string) : KeyFactory.getInstance(algorithmId.getName());
                PrivateKey privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
                if (debug != null) {
                    debug.exit(49152L, (Object)className, "buildPrivateKeyInfo_1", privateKey);
                }
                return privateKey;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                if (debug != null) {
                    debug.exception(49152L, className, "buildPrivateKeyInfo", noSuchAlgorithmException);
                }
            }
            catch (NoSuchProviderException noSuchProviderException) {
                if (debug != null) {
                    debug.exception(49152L, className, "buildPrivateKeyInfo", noSuchProviderException);
                }
                throw new IOException("Provider " + string + " not found");
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                if (debug == null) break block9;
                debug.exception(49152L, className, "buildPrivateKeyInfo", invalidKeySpecException);
            }
        }
        PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(algorithmId, byArray, pKCSAttributes, string);
        if (debug != null) {
            debug.exit(49152L, (Object)className, "buildPrivateKeyInfo", privateKeyInfo);
        }
        return privateKeyInfo;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "writeObject", objectOutputStream);
        }
        objectOutputStream.write(this.getEncoded());
        if (debug != null) {
            debug.exit(8192L, className, "writeObject");
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "readObject", objectInputStream);
        }
        if (objectInputStream == null) {
            if (debug != null) {
                debug.text(8192L, className, "readObject", "stream not specified.");
            }
            throw new IllegalArgumentException("stream not specified.");
        }
        try {
            DerValue derValue = new DerValue(objectInputStream);
            this.decode(derValue);
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.exception(8192L, className, "readObject", iOException);
            }
            throw new IOException("Deserialized key is invalid: " + iOException.getMessage());
        }
        if (debug != null) {
            debug.exit(8192L, className, "readObject");
        }
    }

    public byte[] getKeyBytes() {
        if (debug != null) {
            debug.entry(16384L, className, "getKeyBytes");
        }
        if (this.key == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getKeyBytes_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getKeyBytes_2", (byte[])this.key.clone());
        }
        return (byte[])this.key.clone();
    }

    protected void finalize() {
        if (debug != null) {
            debug.entry(16384L, className, "finalize");
        }
        if (this.key != null) {
            Arrays.fill(this.key, (byte)0);
            this.key = null;
        }
        if (debug != null) {
            debug.exit(16384L, className, "finalize");
        }
    }

    private boolean equals(PrivateKeyInfo privateKeyInfo) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "equals", privateKeyInfo);
        }
        if (privateKeyInfo == this) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals_1", true);
            }
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            privateKeyInfo.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(8192L, className, "equals", exception);
                debug.exit(8192L, (Object)className, "equals_2", true);
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "equals_4", true);
        }
        return true;
    }
}

