/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs7;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.PKCS7;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public final class EncapsulatedContentInfo
extends PKCSDerObject
implements Cloneable {
    private static final byte TAG_ECONTENT = 0;
    private ObjectIdentifier contentType;
    private byte[] content;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs7.EncapsulatedContentInfo";
    private volatile int cachedHashVal = 0;

    public EncapsulatedContentInfo(byte[] byArray) throws IOException {
        super(byArray);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "EncapsulatedContentInfo", (Object)byArray);
            debug.exit(16384L, className, "EncapsulatedContentInfo");
        }
    }

    public EncapsulatedContentInfo(byte[] byArray, String string) throws IOException {
        super(byArray, string);
        if (debug != null) {
            debug.entry(16384L, className, "EncapsulatedContentInfo", byArray, string);
            debug.exit(16384L, className, "EncapsulatedContentInfo");
        }
    }

    public EncapsulatedContentInfo(ContentInfo contentInfo) throws IOException {
        this(contentInfo, null);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "EncapsulatedContentInfo", contentInfo);
            debug.exit(16384L, className, "EncapsulatedContentInfo");
        }
    }

    public EncapsulatedContentInfo(ContentInfo contentInfo, String string) throws IOException {
        super(string);
        if (debug != null) {
            debug.entry(16384L, className, "EncapsulatedContentInfo", contentInfo, string);
        }
        this.contentType = contentInfo.getContentType();
        if (contentInfo.getContent() != null) {
            DerOutputStream derOutputStream = new DerOutputStream();
            contentInfo.getContent().encode(derOutputStream);
            DerValue derValue = new DerValue(derOutputStream.toByteArray());
            this.content = derValue.getData().toByteArray();
        } else {
            this.content = null;
        }
        if (debug != null) {
            debug.exit(16384L, className, "EncapsulatedContentInfo");
        }
    }

    public EncapsulatedContentInfo(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            debug.entry(16384L, className, "EncapsulatedContentInfo", string, new Boolean(bl));
            debug.exit(16384L, className, "EncapsulatedContentInfo");
        }
    }

    public EncapsulatedContentInfo(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "EncapsulatedContentInfo", objectArray);
            debug.exit(16384L, className, "EncapsulatedContentInfo");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            EncapsulatedContentInfo encapsulatedContentInfo = new EncapsulatedContentInfo(derOutputStream.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", encapsulatedContentInfo);
            }
            return encapsulatedContentInfo;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", exception);
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putOID(this.contentType);
        if (this.content != null) {
            DerOutputStream derOutputStream3 = new DerOutputStream();
            derOutputStream3.putOctetString(this.content);
            derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream3);
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "EncapsulatedData parsing error tag " + derValue.getTag() + " is not a sequence.");
            }
            throw new IOException("EncapsulatedData parsing error tag " + derValue.getTag() + " is not a sequence.");
        }
        this.contentType = derValue.getData().getOID();
        if (derValue.getData().available() != 0) {
            DerValue derValue2 = derValue.getData().getDerValue();
            if (derValue2.isContextSpecific((byte)0)) {
                if (derValue2.isConstructed()) {
                    byte[] byArray = derValue2.getData().toByteArray();
                    DerValue derValue3 = new DerValue(byArray);
                    derValue3.resetTag((byte)4);
                    DerInputStream derInputStream = derValue3.getData();
                    byArray = derInputStream != null ? derInputStream.toByteArray() : new byte[]{};
                    this.content = PKCS7.stripOctetTags(byArray);
                } else {
                    derValue2.resetTag((byte)4);
                    this.content = derValue2.getOctetString();
                }
            }
        } else {
            this.content = null;
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    public boolean equals(Object object) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.exit(16384L, className, "equals");
        }
        if (object == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", new Boolean(true));
            }
            return true;
        }
        if (!(object instanceof EncapsulatedContentInfo)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", new Boolean(false));
            }
            return false;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            ((EncapsulatedContentInfo)object).encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_3", new Boolean(false));
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_4", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                this.encode(derOutputStream);
                this.cachedHashVal = Arrays.hashCode(derOutputStream.toByteArray());
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public String toString() {
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        String string = "PKCS7 EncapsulatedContentInfo:\r\n";
        string = string + "\tcontentType: " + this.contentType;
        string = this.content != null ? string + "\r\n\tcontent:\r\n" + hexDumpEncoder.encodeBuffer(this.content) + "\r\n" : string + "\r\n\tcontent: null";
        return string;
    }

    public ObjectIdentifier getContentType() {
        if (debug != null) {
            debug.entry(16384L, className, "getContentType");
            debug.exit(16384L, (Object)className, "getContentType", this.contentType);
        }
        return this.contentType;
    }

    public ContentInfo getContentInfo() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getContentInfo");
        }
        if (this.content == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContentInfo", null);
            }
            return null;
        }
        ContentInfo contentInfo = new ContentInfo(this.contentType, this.content, this.provider);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getContentInfo", contentInfo);
        }
        return contentInfo;
    }

    public byte[] getContent() {
        if (debug != null) {
            debug.entry(16384L, className, "getContent");
        }
        if (this.content == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContent", null);
            }
            return null;
        }
        byte[] byArray = new byte[this.content.length];
        System.arraycopy(this.content, 0, byArray, 0, this.content.length);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getContent", byArray);
        }
        return byArray;
    }
}

