/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs7;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs7.Content;
import com.ibm.security.pkcs7.EncapsulatedContentInfo;
import com.ibm.security.pkcs7.PKCS7;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Arrays;

public final class DigestedData
extends Content
implements Cloneable {
    private BigInteger version;
    private AlgorithmId digestAlgorithm;
    private EncapsulatedContentInfo encapsulatedContent;
    private byte[] digest;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs7.DigestedData";
    private volatile int cachedHashVal = 0;

    public DigestedData(byte[] byArray) throws IOException {
        super(byArray);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "DigestedData", (Object)byArray);
            debug.exit(16384L, className, "DigestedData");
        }
    }

    public DigestedData(byte[] byArray, String string) throws IOException {
        super(byArray, string);
        if (debug != null) {
            debug.entry(16384L, className, "DigestedData", byArray, string);
            debug.exit(16384L, className, "DigestedData");
        }
    }

    public DigestedData(String string, EncapsulatedContentInfo encapsulatedContentInfo) throws IOException, NoSuchAlgorithmException {
        this(string, encapsulatedContentInfo, null);
        if (debug != null) {
            debug.entry(16384L, className, "DigestedData", string, encapsulatedContentInfo);
            debug.exit(16384L, className, "DigestedData");
        }
    }

    public DigestedData(String string, EncapsulatedContentInfo encapsulatedContentInfo, String string2) throws IOException, NoSuchAlgorithmException {
        super(string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, encapsulatedContentInfo, string2};
            debug.entry(16384L, (Object)className, "DigestedData", objectArray);
        }
        if (string == null) {
            if (debug != null) {
                debug.text(16384L, className, "DigestedData", "Digest algorithm was not specified.");
            }
            throw new IllegalArgumentException("Digest algorithm was not specified.");
        }
        if (encapsulatedContentInfo == null) {
            if (debug != null) {
                debug.text(16384L, className, "DigestedData", "EncapsulatedContentInfo was not specified.");
            }
            throw new IllegalArgumentException("EncapsulatedContentInfo was not specified.");
        }
        this.setEncapsulatedContentInfo(encapsulatedContentInfo);
        this.setDigestAlgorithm(string);
        this.calculateMessageDigest(string, encapsulatedContentInfo);
        if (debug != null) {
            debug.exit(16384L, className, "DigestedData");
        }
    }

    public DigestedData(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            debug.entry(16384L, className, "DigestedData", string, new Boolean(bl));
            debug.exit(16384L, className, "DigestedData");
        }
    }

    public DigestedData(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "DigestedData", objectArray);
            debug.exit(16384L, className, "DigestedData");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            DigestedData digestedData = new DigestedData(derOutputStream.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", digestedData);
            }
            return digestedData;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", exception);
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.exit(16384L, (Object)className, "getObjectIdentifier", PKCSOID.DIGESTED_DATA_OID);
        }
        return PKCSOID.DIGESTED_DATA_OID;
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putInteger(this.version);
        derOutputStream.putInteger(this.version);
        this.digestAlgorithm.encode(derOutputStream);
        this.encapsulatedContent.encode(derOutputStream);
        derOutputStream.putOctetString(this.digest);
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        if (derValue.getTag() != 48) {
            debug.text(16384L, className, "decode", "DigestedData parsing error");
            throw new IOException("DigestedData parsing error");
        }
        this.version = derValue.getData().getInteger();
        DerValue derValue2 = derValue.getData().getDerValue();
        this.digestAlgorithm = AlgorithmId.parse(derValue.getData().getDerValue());
        derValue2 = derValue.getData().getDerValue();
        this.encapsulatedContent = new EncapsulatedContentInfo(derValue2.toByteArray(), this.provider);
        this.digest = derValue.getData().getOctetString();
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    public boolean equals(Object object) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (object == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", new Boolean(true));
            }
            return true;
        }
        if (!(object instanceof DigestedData)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", new Boolean(false));
            }
            return false;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            ((DigestedData)object).encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", exception);
                debug.exit(16384L, (Object)className, "equals_3", new Boolean(false));
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_4", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                this.encode(derOutputStream);
                this.cachedHashVal = Arrays.hashCode(derOutputStream.toByteArray());
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public BigInteger getVersion() {
        if (debug != null) {
            debug.entry(16384L, className, "getVersion");
            debug.exit(16384L, (Object)className, "getVersion", this.version);
        }
        return this.version;
    }

    public AlgorithmId getDigestAlgorithm() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getDigestAlgorithm");
        }
        if (this.digestAlgorithm == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getDigestAlgorithm", null);
            }
            return null;
        }
        AlgorithmId algorithmId = new AlgorithmId(this.digestAlgorithm.getOID(), this.digestAlgorithm.getParameters(), this.provider);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getVersion", algorithmId);
        }
        return algorithmId;
    }

    public EncapsulatedContentInfo getEncapsulatedContentInfo() {
        if (debug != null) {
            debug.entry(16384L, className, "getEncapsulatedContentInfo");
            debug.exit(16384L, (Object)className, "getEncapsulatedContentInfo", this.encapsulatedContent.clone());
        }
        return (EncapsulatedContentInfo)this.encapsulatedContent.clone();
    }

    private void setEncapsulatedContentInfo(EncapsulatedContentInfo encapsulatedContentInfo) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setEncapsulatedContentInfo", encapsulatedContentInfo);
        }
        this.encapsulatedContent = encapsulatedContentInfo;
        this.calculateVersion();
        if (debug != null) {
            debug.exit(8192L, className, "setEncapsulatedContentInfo");
        }
    }

    public byte[] getDigest() {
        if (debug != null) {
            debug.entry(16384L, className, "getDigest");
        }
        if (this.digest == null || this.digest.length == 0) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getDigest", null);
            }
            return null;
        }
        byte[] byArray = new byte[this.digest.length];
        System.arraycopy(this.digest, 0, byArray, 0, this.digest.length);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getDigest", byArray);
        }
        return byArray;
    }

    private void setDigestAlgorithm(String string) throws IOException, NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setDigestAlgorithm", string);
        }
        if (string == null) {
            if (debug != null) {
                debug.text(8192L, className, "setDigestAlgorithm", "Digest algorithm was not specified.");
            }
            throw new IllegalArgumentException("Digest algorithm was not specified.");
        }
        String string2 = PKCS7.getDigestAlgorithm(string);
        this.digestAlgorithm = AlgorithmId.get(string);
        this.digest = null;
        this.calculateMessageDigest(string2, this.encapsulatedContent);
        if (debug != null) {
            debug.exit(8192L, className, "setDigestAlgorithm");
        }
    }

    private void calculateMessageDigest(AlgorithmId algorithmId, EncapsulatedContentInfo encapsulatedContentInfo) throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "calculateMessageDigest", algorithmId, encapsulatedContentInfo);
        }
        this.calculateMessageDigest(algorithmId.getName(), encapsulatedContentInfo);
        if (debug != null) {
            debug.exit(8192L, className, "calculateMessageDigest");
        }
    }

    private void calculateMessageDigest(String string, EncapsulatedContentInfo encapsulatedContentInfo) throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "calculateMessageDigest", string, encapsulatedContentInfo);
        }
        if (string == null) {
            if (debug != null) {
                debug.text(8192L, className, "calculateMessageDigest", "Digest algorithm was not specified.");
            }
            throw new IllegalArgumentException("Digest algorithm was not specified.");
        }
        if (encapsulatedContentInfo == null) {
            if (debug != null) {
                debug.text(8192L, className, "calculateMessageDigest", "EncapsulatedContentInfo was not specified.");
            }
            throw new IllegalArgumentException("EncapsulatedContentInfo was not specified.");
        }
        this.digest = null;
        byte[] byArray = encapsulatedContentInfo.getContent();
        MessageDigest messageDigest = null;
        try {
            messageDigest = this.provider != null ? MessageDigest.getInstance(string, this.provider) : MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (debug != null) {
                debug.exception(8192L, className, "calculateMessageDigest", noSuchAlgorithmException);
            }
            throw new IOException(noSuchAlgorithmException.toString());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            if (debug != null) {
                debug.exception(8192L, className, "calculateMessageDigest", noSuchProviderException);
            }
            throw new IOException("provider" + this.provider + " not found:" + noSuchProviderException.toString());
        }
        this.digest = messageDigest.digest(byArray);
        if (debug != null) {
            debug.exit(8192L, className, "calculateMessageDigest");
        }
    }

    public String toString() {
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        String string = "PKCS7 DigestedData:\r\n";
        string = string + "\tversion: " + this.version.intValue();
        string = string + "\r\n\tdigestAlgorithm: " + this.digestAlgorithm;
        string = string + "\r\n\tencapsulatedContent:\r\n" + this.encapsulatedContent;
        string = this.digest != null ? string + "\r\n\tdigest: \r\n" + hexDumpEncoder.encodeBuffer(this.digest) : string + "\r\n\tdigest: not calculated";
        string = string + "\r\n";
        return string;
    }

    private void calculateVersion() {
        if (debug != null) {
            debug.entry(8192L, className, "calculateVersion");
        }
        this.version = BigInteger.ZERO;
        if (!this.encapsulatedContent.getContentType().equals(PKCSOID.DATA_OID)) {
            this.version = BigInteger.valueOf(2L);
        }
        if (debug != null) {
            debug.exit(8192L, className, "calculateVersion");
        }
    }
}

