/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs7;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public final class DigestInfo
extends PKCSDerObject
implements Cloneable {
    private AlgorithmId alg;
    private byte[] digest;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs7.DigestInfo";
    private volatile int cachedHashVal = 0;

    public DigestInfo(byte[] byArray) throws IOException {
        super(byArray);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "DigestInfo", (Object)byArray);
            debug.exit(16384L, className, "DigestInfo");
        }
    }

    public DigestInfo(byte[] byArray, String string) throws IOException {
        super(byArray, string);
        if (debug != null) {
            debug.entry(16384L, className, "DigestInfo", byArray, string);
            debug.exit(16384L, className, "DigestInfo");
        }
    }

    public DigestInfo(String string, AlgorithmParameters algorithmParameters, byte[] byArray) throws IOException, NoSuchAlgorithmException {
        this(string, algorithmParameters, byArray, null);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, algorithmParameters, byArray};
            debug.entry(16384L, (Object)className, "DigestInfo", objectArray);
            debug.exit(16384L, className, "DigestInfo");
        }
    }

    public DigestInfo(String string, AlgorithmParameters algorithmParameters, byte[] byArray, String string2) throws IOException, NoSuchAlgorithmException {
        super(string2);
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{string, algorithmParameters, byArray, string2};
            debug.entry(16384L, (Object)className, "DigestInfo", objectArray);
        }
        if (string == null || string.length() == 0) {
            if (debug != null) {
                debug.text(16384L, className, "DigestInfo", "Algorithm must be specified");
            }
            throw new IllegalArgumentException("Algorithm must be specified");
        }
        if (byArray == null || byArray.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "DigestInfo", "Digest must be specified");
            }
            throw new IllegalArgumentException("Digest must be specified");
        }
        objectArray = AlgorithmId.get(string);
        byte[] byArray2 = null;
        try {
            if (algorithmParameters != null) {
                byArray2 = algorithmParameters.getEncoded();
            }
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.exception(16384L, className, "DigestInfo", iOException);
            }
            throw new IllegalArgumentException("Algorithm parameters cannot be encoded.");
        }
        if (algorithmParameters == null) {
            this.alg = objectArray;
        } else {
            ObjectIdentifier objectIdentifier = objectArray.getOID();
            this.alg = new AlgorithmId(objectIdentifier, byArray2, string2);
        }
        this.digest = byArray;
        if (debug != null) {
            debug.exit(16384L, className, "DigestInfo");
        }
    }

    public DigestInfo(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            debug.entry(16384L, className, "DigestInfo", string, new Boolean(bl));
            debug.exit(16384L, className, "DigestInfo");
        }
    }

    public DigestInfo(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "DigestInfo", objectArray);
            debug.exit(16384L, className, "DigestInfo");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            DigestInfo digestInfo = new DigestInfo(derOutputStream.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", digestInfo);
            }
            return digestInfo;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", exception);
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        this.alg.encode(derOutputStream);
        derOutputStream.putOctetString(this.digest);
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        if (derValue.getTag() != 48) {
            throw new IOException("DigestInfo parsing error");
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        this.alg = AlgorithmId.parse(derValue2);
        this.digest = derValue.getData().getOctetString();
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    public boolean equals(Object object) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (object == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", new Boolean(true));
            }
            return true;
        }
        if (!(object instanceof DigestInfo)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", new Boolean(false));
            }
            return false;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            ((DigestInfo)object).encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", exception);
                debug.exit(16384L, (Object)className, "equals_3", new Boolean(false));
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_4", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                this.encode(derOutputStream);
                this.cachedHashVal = Arrays.hashCode(derOutputStream.toByteArray());
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public AlgorithmId getDigestAlgorithm() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getDigestAlgorithm");
        }
        if (this.alg == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getDigestAlgorithm", null);
            }
            return null;
        }
        AlgorithmId algorithmId = new AlgorithmId(this.alg.getOID(), this.alg.getParameters());
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getDigestAlgorithm", algorithmId);
        }
        return algorithmId;
    }

    public byte[] getDigest() {
        if (debug != null) {
            debug.entry(16384L, className, "getDigest");
        }
        if (this.digest == null || this.digest.length == 0) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getDigest", null);
            }
            return null;
        }
        byte[] byArray = new byte[this.digest.length];
        System.arraycopy(this.digest, 0, byArray, 0, this.digest.length);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getDigest", byArray);
        }
        return byArray;
    }

    public String toString() {
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        String string = "";
        string = string + "Digest Info: ";
        string = string + "\r\n\talgorithm: " + this.alg;
        string = string + "\r\n\tdigest:\r\n";
        string = string + hexDumpEncoder.encodeBuffer(this.digest);
        return string;
    }
}

