/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs12;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs12.Bag;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public final class SafeBag
extends PKCSDerObject
implements Cloneable {
    private Bag bag;
    private ObjectIdentifier oid;
    private Object value;
    private byte[] encodedValue;
    private PKCSAttributes attrSet;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs12.SafeBag";
    private volatile int cachedHashVal = 0;

    public SafeBag(byte[] byArray) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SafeBag", (Object)byArray);
        }
        this.decode(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "SafeBag");
        }
    }

    public SafeBag(byte[] byArray, String string) throws IOException {
        super(string);
        if (debug != null) {
            debug.entry(16384L, className, "SafeBag", byArray, string);
        }
        this.decode(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "SafeBag");
        }
    }

    public SafeBag(Bag bag, PKCSAttributes pKCSAttributes) throws IOException {
        this(bag, pKCSAttributes, null);
        if (debug != null) {
            debug.entry(16384L, className, "SafeBag", bag, pKCSAttributes);
            debug.exit(16384L, className, "SafeBag");
        }
    }

    public SafeBag(Bag bag, PKCSAttributes pKCSAttributes, String string) throws IOException {
        super(string);
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{bag, pKCSAttributes, string};
            debug.entry(16384L, (Object)className, "SafeBag", objectArray);
        }
        this.bag = bag;
        objectArray = bag.getObjectIdentifier();
        this.oid = objectArray.equals(PKCSOID.X509CERTBAG_OID) || objectArray.equals(PKCSOID.SDSICERTBAG_OID) || objectArray.equals(PKCSOID.X509_CERT_OID) || objectArray.equals(PKCSOID.SDSI_CERT_OID) ? PKCSOID.CERTBAG_OID : (objectArray.equals(PKCSOID.X509CRLBAG_OID) || objectArray.equals(PKCSOID.X509_CRL_OID) ? PKCSOID.CRLBAG_OID : objectArray);
        this.value = bag.getValue();
        DerOutputStream derOutputStream = new DerOutputStream();
        PKCSDerObject pKCSDerObject = (PKCSDerObject)((Object)bag);
        pKCSDerObject.encode(derOutputStream);
        byte[] byArray = derOutputStream.toByteArray();
        this.encodedValue = byArray;
        this.attrSet = pKCSAttributes;
        if (debug != null) {
            debug.exit(16384L, className, "SafeBag");
        }
    }

    public SafeBag(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            debug.entry(16384L, className, "SafeBag", string, new Boolean(bl));
            debug.exit(16384L, className, "SafeBag");
        }
    }

    public SafeBag(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            debug.entry(16384L, className, "SafeBag", string, new Boolean(bl));
            debug.exit(16384L, className, "SafeBag");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        derOutputStream.putOID(this.oid);
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.write(this.encodedValue);
        DerValue derValue = new DerValue(this.encodedValue);
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream3);
        if (this.attrSet != null) {
            this.attrSet.encode(derOutputStream);
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public SafeBag addAttributes(PKCSAttribute[] pKCSAttributeArray) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "addAttributes", pKCSAttributeArray);
        }
        SafeBag safeBag = (SafeBag)this.clone();
        if (pKCSAttributeArray == null || pKCSAttributeArray.length == 0) {
            return safeBag;
        }
        if (safeBag.attrSet == null) {
            safeBag.attrSet = new PKCSAttributes(pKCSAttributeArray, this.provider);
        } else {
            for (int i = 0; i < pKCSAttributeArray.length; ++i) {
                safeBag.attrSet = safeBag.attrSet.addAttribute(pKCSAttributeArray[i]);
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "addAttributes", safeBag);
        }
        return safeBag;
    }

    public SafeBag replaceAttributes(PKCSAttributes pKCSAttributes) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "replaceAttributes", pKCSAttributes);
        }
        SafeBag safeBag = (SafeBag)this.clone();
        safeBag.attrSet = pKCSAttributes;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "replaceAttributes", safeBag);
        }
        return safeBag;
    }

    public PKCSAttributes getAttributes() {
        if (debug != null) {
            debug.entry(16384L, className, "getAttributes");
        }
        if (this.attrSet == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getAttributes_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getAttributes_2", (PKCSAttributes)this.attrSet.clone());
        }
        return (PKCSAttributes)this.attrSet.clone();
    }

    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
        }
        ObjectIdentifier objectIdentifier = null;
        try {
            objectIdentifier = new ObjectIdentifier(this.oid.toString());
        }
        catch (Exception exception) {
            objectIdentifier = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getObjectIdentifier", objectIdentifier);
        }
        return objectIdentifier;
    }

    public byte[] getValue() {
        if (debug != null) {
            debug.entry(16384L, className, "getValue");
            debug.exit(16384L, (Object)className, "getValue", (byte[])this.encodedValue.clone());
        }
        return (byte[])this.encodedValue.clone();
    }

    public boolean equals(Object object) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (object == this) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals_1", true);
            }
            return true;
        }
        if (object instanceof SafeBag) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", this.equals((SafeBag)object));
            }
            return this.equals((SafeBag)object);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_2", false);
        }
        return false;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                this.encode(derOutputStream);
                this.cachedHashVal = Arrays.hashCode(derOutputStream.toByteArray());
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            SafeBag safeBag = new SafeBag(derOutputStream.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", safeBag);
            }
            return safeBag;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", exception);
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    public String toString() {
        String string = "";
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        if (this.bag != null) {
            string = string + this.bag.toString();
        } else {
            string = string + "SafeBag:";
            string = string + "\r\nobject identifier: " + this.oid;
            string = string + "\r\ncontents:";
            string = string + "\r\n";
            string = string + hexDumpEncoder.encodeBuffer(this.encodedValue);
        }
        string = string + "\r\n";
        if (this.attrSet != null) {
            string = string + "attributes:";
            string = string + "\r\n";
            string = string + this.attrSet.toString();
        } else {
            string = string + "no attributes";
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }

    protected void decode(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "SafeBag parsing error, not a SEQUENCE");
            }
            throw new IOException("SafeBag parsing error, not a SEQUENCE");
        }
        this.oid = derValue.getData().getOID();
        DerValue derValue2 = derValue.getData().getDerValue();
        if (derValue2.isContextSpecific((byte)0)) {
            DerValue derValue3 = derValue2.getData().getDerValue();
            this.encodedValue = derValue3.toByteArray();
        } else {
            this.encodedValue = derValue2.toByteArray();
        }
        if (derValue.getData().available() != 0) {
            this.attrSet = new PKCSAttributes(derValue.getData(), this.provider);
        }
        if (derValue.getData().available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "SafeBag parsing error - data overrun, bytes = " + derValue.getData().available());
            }
            throw new IOException("SafeBag parsing error - data overrun, bytes = " + derValue.getData().available());
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private boolean equals(SafeBag safeBag) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "equals", safeBag);
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            safeBag.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals_2", false);
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "equals_4", true);
        }
        return true;
    }
}

