/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs12;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs12.AuthenticatedSafe;
import com.ibm.security.pkcs12.Bag;
import com.ibm.security.pkcs12.BasicPFX;
import com.ibm.security.pkcs12.CertBag;
import com.ibm.security.pkcs12.CrlBag;
import com.ibm.security.pkcs12.KeyBag;
import com.ibm.security.pkcs12.MacData;
import com.ibm.security.pkcs12.SafeBag;
import com.ibm.security.pkcs12.SafeContents;
import com.ibm.security.pkcs12.SafeContentsBag;
import com.ibm.security.pkcs12.ShroudedKeyBag;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.Data;
import com.ibm.security.pkcs7.EncryptedContentInfo;
import com.ibm.security.pkcs7.EncryptedData;
import com.ibm.security.pkcs7.EnvelopedData;
import com.ibm.security.pkcs7.SignedData;
import com.ibm.security.pkcs8.EncryptedPrivateKeyInfo;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public final class PKCS12PFX
extends BasicPFX
implements Cloneable {
    private static String SLASH = "/";
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs12.PKCS12PFX";

    public PKCS12PFX() {
        if (debug != null) {
            debug.entry(16384L, className, "PKCS12PFX");
            debug.exit(16384L, className, "PKCS12PFX");
        }
    }

    public PKCS12PFX(String string) {
        super(string);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PKCS12PFX", string);
            debug.exit(16384L, className, "PKCS12PFX");
        }
    }

    public PKCS12PFX(byte[] byArray) throws IOException {
        this();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PKCS12PFX", (Object)byArray);
        }
        this.decode(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "PKCS12PFX");
        }
    }

    public PKCS12PFX(byte[] byArray, String string) throws IOException {
        this(string);
        if (debug != null) {
            debug.entry(16384L, className, "PKCS12PFX", byArray, string);
        }
        this.decode(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "PKCS12PFX");
        }
    }

    public PKCS12PFX(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl)};
            debug.entry(16384L, (Object)className, "PKCS12PFX", objectArray);
            debug.exit(16384L, className, "PKCS12PFX");
        }
    }

    public PKCS12PFX(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "PKCS12PFX", objectArray);
            debug.exit(16384L, className, "PKCS12PFX");
        }
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            return new PKCS12PFX(derOutputStream.toByteArray(), this.provider);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    public synchronized void addBag(Object object, PKCSAttributes pKCSAttributes) throws PKCSException, IOException {
        if (debug != null) {
            debug.entry(16384L, className, "addBag", object, pKCSAttributes);
        }
        SafeBag[] safeBagArray = this.buildSafeBags(object, pKCSAttributes);
        this.addSafeBags(safeBagArray);
        if (debug != null) {
            debug.exit(16384L, className, "addBag");
        }
    }

    public synchronized void addBagWithPasswordPrivacy(Object object, PKCSAttributes pKCSAttributes, String string, char[] cArray) throws NoSuchAlgorithmException, IOException, PKCSException {
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{object, pKCSAttributes, string, cArray};
            debug.entry(16384L, (Object)className, "addBagWithPasswordPrivacy", objectArray);
        }
        objectArray = this.buildSafeBags(object, pKCSAttributes);
        this.addSafeBagsWithPasswordPrivacy((SafeBag[])objectArray, string, cArray);
        if (debug != null) {
            debug.exit(16384L, className, "addBagWithPasswordPrivacy");
        }
    }

    public synchronized void addBagWithPubkeyPrivacy(Object object, PKCSAttributes pKCSAttributes, Certificate[] certificateArray) throws PKCSException, IOException {
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{object, pKCSAttributes, certificateArray};
            debug.entry(16384L, (Object)className, "addBagWithPubkeyPrivacy", objectArray);
        }
        objectArray = this.buildSafeBags(object, pKCSAttributes);
        this.addSafeBagsWithPubkeyPrivacy((SafeBag[])objectArray, certificateArray);
        if (debug != null) {
            debug.exit(16384L, className, "addBagWithPubkeyPrivacy");
        }
    }

    public synchronized void addSafeBags(SafeBag[] safeBagArray) throws PKCSException, IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "addSafeBags", safeBagArray);
        }
        SafeContents safeContents = new SafeContents(safeBagArray, this.provider);
        byte[] byArray = safeContents.encode();
        Data data = new Data(this.provider);
        data.setData(byArray);
        ContentInfo contentInfo = new ContentInfo(data, this.provider);
        this.addContentToAuthSafe(contentInfo);
        if (debug != null) {
            debug.exit(16384L, className, "addSafeBags");
        }
    }

    public synchronized void addSafeBagsWithPasswordPrivacy(SafeBag[] safeBagArray, String string, char[] cArray) throws NoSuchAlgorithmException, IOException, PKCSException {
        if (debug != null) {
            Object[] objectArray = new Object[]{safeBagArray, string, cArray};
            debug.entry(16384L, (Object)className, "addSafeBagsWithPasswordPrivacy", objectArray);
        }
        super.addSafeBagsWithPasswordPrivacy(safeBagArray, string, cArray);
        if (debug != null) {
            debug.exit(16384L, className, "addSafeBagsWithPasswordPrivacy");
        }
    }

    public synchronized void addSafeBagsWithPubkeyPrivacy(SafeBag[] safeBagArray, Certificate[] certificateArray) throws PKCSException, IOException {
        if (debug != null) {
            debug.entry(16384L, className, "addSafeBagsWithPubkeyPrivacy", safeBagArray, certificateArray);
        }
        SafeContents safeContents = new SafeContents(safeBagArray, this.provider);
        byte[] byArray = safeContents.encode();
        Data data = new Data(this.provider);
        data.setData(byArray);
        ContentInfo contentInfo = new ContentInfo(data, this.provider);
        EnvelopedData envelopedData = new EnvelopedData(certificateArray, contentInfo, "DESede", 168, null, this.provider);
        ContentInfo contentInfo2 = new ContentInfo(envelopedData, this.provider);
        this.addContentToAuthSafe(contentInfo2);
        if (debug != null) {
            debug.exit(16384L, className, "addSafeBagsWithPubkeyPrivacy");
        }
    }

    public synchronized void applySignature(String string, String string2, Certificate certificate, PrivateKey privateKey) throws PKCSException, NoSuchAlgorithmException, IOException {
        ContentInfo contentInfo;
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{string, string2, certificate, privateKey};
            debug.entry(16384L, (Object)className, "applySignature", objectArray);
        }
        this.macData = null;
        this.authSafe = this.authSafeContents.toContentInfo();
        objectArray = string + SLASH + string2;
        SignedData signedData = new SignedData(certificate, this.authSafe, (String)objectArray, privateKey, false, this.provider);
        this.authSafe = contentInfo = new ContentInfo(signedData, this.provider);
        if (debug != null) {
            debug.exit(16384L, className, "applySignature");
        }
    }

    public boolean verifySignature(Certificate certificate) throws IOException, PKCSException, NoSuchAlgorithmException {
        ContentInfo contentInfo;
        boolean bl = false;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "verifySignature", certificate);
        }
        SignedData signedData = null;
        if (this.authSafe.getContentType().equals(PKCSOID.SIGNED_DATA_OID)) {
            signedData = (SignedData)this.authSafe.getContent();
            bl = signedData.verify(certificate);
        }
        if (bl && (contentInfo = signedData.getEncapsulatedContentInfo().getContentInfo()).getContentType().equals(PKCSOID.DATA_OID)) {
            Data data = (Data)contentInfo.getContent();
            this.verifiedContents = new AuthenticatedSafe(data.getData(), this.provider);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "verifySignature", bl);
        }
        return bl;
    }

    public boolean hasDigitalSignature() {
        if (debug != null) {
            debug.entry(16384L, className, "hasDigitalSignature");
        }
        if (this.authSafe != null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "hasDigitalSignature_1", this.authSafe.getContentType().equals(PKCSOID.SIGNED_DATA_OID));
            }
            return this.authSafe.getContentType().equals(PKCSOID.SIGNED_DATA_OID);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hasDigitalSignature_2", false);
        }
        return false;
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        if (this.authSafe == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Data integrity protection must be applied to this PFX before encoding.");
            }
            throw new IOException("Data integrity protection must be applied to this PFX before encoding.");
        }
        super.encode(outputStream);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public boolean equals(Object object) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
            debug.exit(16384L, (Object)className, "equals", super.equals(object));
        }
        return super.equals(object);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
            debug.exit(16384L, (Object)className, "toString", super.toString());
        }
        return super.toString();
    }

    public synchronized void applyMac(char[] cArray) throws PKCSException, NoSuchAlgorithmException, IOException {
        int n = 2000;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "applyMac", (Object)cArray);
        }
        super.applyMac(cArray, n);
        if (debug != null) {
            debug.exit(16384L, className, "applyMac");
        }
    }

    public boolean verifyMac(char[] cArray) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "verifyMac", (Object)cArray);
            debug.exit(16384L, (Object)className, "verifyMac", super.verifyMac(cArray));
        }
        return super.verifyMac(cArray);
    }

    public MacData getMacData() {
        if (debug != null) {
            debug.entry(16384L, className, "getMacData");
            debug.exit(16384L, (Object)className, "getMacData", super.getMacData());
        }
        return super.getMacData();
    }

    public Certificate[] getCertificates(char[] cArray, PrivateKey privateKey, Certificate certificate) throws IOException, PKCSException {
        if (debug != null) {
            Object[] objectArray = new Object[]{cArray, privateKey, certificate};
            debug.entry(16384L, className, "getCertificates");
        }
        if (cArray != null || privateKey != null || certificate != null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCertificates_1", super.getCertificates(cArray, privateKey, certificate, true));
            }
            return super.getCertificates(cArray, privateKey, certificate, true);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCertificates_2", super.getCertificates(cArray, privateKey, certificate, false));
        }
        return super.getCertificates(cArray, privateKey, certificate, false);
    }

    public Certificate[] getAllCertificates(char[] cArray, PrivateKey privateKey, Certificate certificate) throws IOException, PKCSException {
        if (debug != null) {
            Object[] objectArray = new Object[]{cArray, privateKey, certificate};
            debug.entry(16384L, (Object)className, "getAllCertificates", objectArray);
            debug.exit(16384L, (Object)className, "getAllCertificates", super.getCertificates(cArray, privateKey, certificate, false));
        }
        return super.getCertificates(cArray, privateKey, certificate, false);
    }

    public CRL[] getCRLs(char[] cArray, PrivateKey privateKey, Certificate certificate) throws IOException, PKCSException {
        if (debug != null) {
            Object[] objectArray = new Object[]{cArray, privateKey, certificate};
            debug.entry(16384L, (Object)className, "getCRLs", objectArray);
        }
        if (cArray != null || privateKey != null || certificate != null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCRLs_1", super.getCRLs(cArray, privateKey, certificate, true));
            }
            return super.getCRLs(cArray, privateKey, certificate, true);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCRLs_2", super.getCRLs(cArray, privateKey, certificate, false));
        }
        return super.getCRLs(cArray, privateKey, certificate, false);
    }

    public CRL[] getAllCRLs(char[] cArray, PrivateKey privateKey, Certificate certificate) throws IOException, PKCSException {
        if (debug != null) {
            Object[] objectArray = new Object[]{cArray, privateKey, certificate};
            debug.entry(16384L, (Object)className, "getAllCRLs", objectArray);
            debug.exit(16384L, (Object)className, "getAllCRLs", super.getCRLs(cArray, privateKey, certificate, false));
        }
        return super.getCRLs(cArray, privateKey, certificate, false);
    }

    public PrivateKeyInfo[] getPrivateKeys(char[] cArray, PrivateKey privateKey, Certificate certificate) throws IOException, PKCSException {
        if (debug != null) {
            Object[] objectArray = new Object[]{cArray, privateKey, certificate};
            debug.entry(16384L, (Object)className, "getPrivateKeys", objectArray);
        }
        if (cArray != null || privateKey != null || certificate != null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getPrivateKeys_1", super.getPrivateKeys(cArray, privateKey, certificate, true));
            }
            return super.getPrivateKeys(cArray, privateKey, certificate, true);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getPrivateKeys_2", super.getPrivateKeys(cArray, privateKey, certificate, false));
        }
        return super.getPrivateKeys(cArray, privateKey, certificate, false);
    }

    public PrivateKeyInfo[] getAllPrivateKeys(char[] cArray, PrivateKey privateKey, Certificate certificate) throws IOException, PKCSException {
        if (debug != null) {
            Object[] objectArray = new Object[]{cArray, privateKey, certificate};
            debug.entry(16384L, (Object)className, "getAllPrivateKeys", objectArray);
            debug.exit(16384L, (Object)className, "getAllPrivateKeys", super.getPrivateKeys(cArray, privateKey, certificate, false));
        }
        return super.getPrivateKeys(cArray, privateKey, certificate, false);
    }

    public EncryptedPrivateKeyInfo[] getShroudedKeys(char[] cArray, PrivateKey privateKey, Certificate certificate) throws IOException, PKCSException {
        if (debug != null) {
            Object[] objectArray = new Object[]{cArray, privateKey, certificate};
            debug.entry(16384L, (Object)className, "getShroudedKeys", objectArray);
        }
        if (cArray != null || privateKey != null || certificate != null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getShroudedKeys_1", super.getShroudedKeys(cArray, privateKey, certificate, true));
            }
            return super.getShroudedKeys(cArray, privateKey, certificate, true);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getShroudedKeys_2", super.getShroudedKeys(cArray, privateKey, certificate, false));
        }
        return super.getShroudedKeys(cArray, privateKey, certificate, false);
    }

    public EncryptedPrivateKeyInfo[] getAllShroudedKeys(char[] cArray, PrivateKey privateKey, Certificate certificate) throws IOException, PKCSException {
        if (debug != null) {
            Object[] objectArray = new Object[]{cArray, privateKey, certificate};
            debug.entry(16384L, (Object)className, "getAllShroundedKeys", objectArray);
            debug.exit(16384L, (Object)className, "getAllShroundedKeys", super.getShroudedKeys(cArray, privateKey, certificate, false));
        }
        return super.getShroudedKeys(cArray, privateKey, certificate, false);
    }

    public SafeContents[] getSafeContents(char[] cArray, PrivateKey privateKey, Certificate certificate) throws IOException, PKCSException {
        if (debug != null) {
            Object[] objectArray = new Object[]{cArray, privateKey, certificate};
            debug.entry(16384L, (Object)className, "getSafeContents", objectArray);
        }
        if (cArray != null || privateKey != null || certificate != null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSafeContents_1", super.getSafeContents(cArray, privateKey, certificate, true));
            }
            return super.getSafeContents(cArray, privateKey, certificate, true);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSafeContents_2", super.getSafeContents(cArray, privateKey, certificate, false));
        }
        return super.getSafeContents(cArray, privateKey, certificate, false);
    }

    public SafeContents[] getAllSafeContents(char[] cArray, PrivateKey privateKey, Certificate certificate) throws IOException, PKCSException {
        if (debug != null) {
            Object[] objectArray = new Object[]{cArray, privateKey, certificate};
            debug.entry(16384L, (Object)className, "getAllSafeContents", objectArray);
            debug.exit(16384L, (Object)className, "getAllSafeContents", super.getSafeContents(cArray, privateKey, certificate, false));
        }
        return super.getSafeContents(cArray, privateKey, certificate, false);
    }

    public SafeBag[] getSafeBags(char[] cArray, PrivateKey privateKey, Certificate certificate) throws IOException, PKCSException {
        if (debug != null) {
            Object[] objectArray = new Object[]{cArray, privateKey, certificate};
            debug.entry(16384L, (Object)className, "getSafeBags", objectArray);
        }
        if (cArray != null || privateKey != null || certificate != null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSafeBags_1", super.getSafeBags(cArray, privateKey, certificate, true));
            }
            return super.getSafeBags(cArray, privateKey, certificate, true);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSafeBags_2", super.getSafeBags(cArray, privateKey, certificate, false));
        }
        return super.getSafeBags(cArray, privateKey, certificate, false);
    }

    public SafeBag[] getAllSafeBags(char[] cArray, PrivateKey privateKey, Certificate certificate) throws IOException, PKCSException {
        if (debug != null) {
            Object[] objectArray = new Object[]{cArray, privateKey, certificate};
            debug.entry(16384L, (Object)className, "getAllSafeBags", objectArray);
            debug.exit(16384L, (Object)className, "getAllSafeBags", super.getSafeBags(cArray, privateKey, certificate, false));
        }
        return super.getSafeBags(cArray, privateKey, certificate, false);
    }

    protected void decode(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        super.decode(derValue);
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private SafeBag[] buildSafeBags(Object object, PKCSAttributes pKCSAttributes) throws PKCSException, IOException {
        PKCSDerObject pKCSDerObject;
        if (debug != null) {
            debug.entry(16384L, className, "buildSafeBags", object, pKCSAttributes);
        }
        if (object instanceof PrivateKeyInfo) {
            pKCSDerObject = new KeyBag((PrivateKeyInfo)object, this.provider);
        } else if (object instanceof EncryptedPrivateKeyInfo) {
            pKCSDerObject = new ShroudedKeyBag((EncryptedPrivateKeyInfo)object, this.provider);
        } else if (object instanceof Certificate) {
            pKCSDerObject = new CertBag((Certificate)object, this.provider);
        } else if (object instanceof CRL) {
            pKCSDerObject = new CrlBag((CRL)object, this.provider);
        } else if (object instanceof SafeContents) {
            pKCSDerObject = new SafeContentsBag((SafeContents)object, this.provider);
        } else {
            String string = object.getClass().getName();
            if (debug != null) {
                debug.text(16384L, className, "buildSafeBags", "Unsupported input object class: " + string);
            }
            throw new IllegalArgumentException("Unsupported input object class: " + string);
        }
        SafeBag[] safeBagArray = new SafeBag[]{new SafeBag((Bag)((Object)pKCSDerObject), pKCSAttributes, this.provider)};
        if (debug != null) {
            debug.exit(16384L, (Object)className, "buildSafeBags", safeBagArray);
        }
        return safeBagArray;
    }

    ContentInfo protectWithPasswordPrivacy(byte[] byArray, String string, String string2, char[] cArray) throws IOException, PKCSException, NoSuchAlgorithmException {
        AlgorithmId algorithmId;
        Object object;
        AlgorithmId algorithmId2;
        byte[] byArray2;
        Cipher cipher;
        SecretKey secretKey;
        Object[] objectArray;
        AlgorithmParameters algorithmParameters = null;
        if (debug != null) {
            objectArray = new Object[]{byArray, string, string2, cArray};
            debug.entry(16384L, (Object)className, "protectWithPasswordPrivacy", objectArray);
        }
        objectArray = "PBEWith" + string + "And" + string2;
        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
        try {
            SecretKeyFactory secretKeyFactory = this.provider != null ? SecretKeyFactory.getInstance("PBEWithSha1AndRC2", this.provider) : SecretKeyFactory.getInstance("PBEWithSha1AndRC2");
            secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "protectWithPasswordPrivacy", exception);
            }
            throw new PKCSException(exception, "Unable to encrypt bag contents (" + exception.toString() + ")");
        }
        int n = 8;
        String string3 = string2.toUpperCase();
        if (string3.indexOf("DES") != -1) {
            n = 20;
        }
        byte[] byArray3 = new byte[n];
        SecureRandom secureRandom = null;
        try {
            secureRandom = this.provider != null ? SecureRandom.getInstance("IBMSecureRandom", this.provider) : SecureRandom.getInstance("IBMSecureRandom");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (debug != null) {
                debug.exception(16384L, className, "protectWithPasswordPrivacy", noSuchAlgorithmException);
            }
            secureRandom = new SecureRandom();
        }
        catch (NoSuchProviderException noSuchProviderException) {
            if (debug != null) {
                debug.exception(16384L, className, "protectWithPasswordPrivacy", noSuchProviderException);
            }
            throw new PKCSException("provider " + this.provider + " not found");
        }
        secureRandom.nextBytes(byArray3);
        int n2 = secureRandom.nextInt();
        BigInteger bigInteger = BigInteger.valueOf(n2);
        BigInteger bigInteger2 = BigInteger.valueOf(100L);
        int n3 = 2000;
        PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(byArray3, n3);
        try {
            algorithmParameters = this.provider != null ? AlgorithmParameters.getInstance("PBE", this.provider) : AlgorithmParameters.getInstance("PBE");
            algorithmParameters.init(pBEParameterSpec);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "protectWithPasswordPrivacy", exception);
            }
            throw new PKCSException(exception, "Unable to encrypt bag contents (" + exception.toString() + ")");
        }
        try {
            cipher = this.provider != null ? Cipher.getInstance((String)objectArray, this.provider) : Cipher.getInstance((String)objectArray);
            cipher.init(1, (Key)secretKey, algorithmParameters);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "protectWithPasswordPrivacy", exception);
            }
            throw new PKCSException(exception, "Unable to encrypt bag contents (" + exception.toString() + ")");
        }
        try {
            byArray2 = cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "protectWithPasswordPrivacy", exception);
            }
            throw new PKCSException(exception, "Unable to encrypt bag contents (" + exception.toString() + ")");
        }
        AlgorithmParameters algorithmParameters2 = cipher.getParameters();
        byte[] byArray4 = null;
        if (algorithmParameters2 != null) {
            byArray4 = algorithmParameters2.getEncoded();
        }
        try {
            algorithmId2 = AlgorithmId.get(cipher.getAlgorithm());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (debug != null) {
                debug.exception(16384L, className, "protectWithPasswordPrivacy", noSuchAlgorithmException);
            }
            throw new PKCSException(noSuchAlgorithmException, "Unsupported password-based encryption algorithm: " + cipher.getAlgorithm());
        }
        if (byArray4 != null) {
            object = algorithmId2.getOID();
            algorithmId = new AlgorithmId((ObjectIdentifier)object, byArray4, this.provider);
        } else {
            algorithmId = algorithmId2;
        }
        object = new EncryptedContentInfo(PKCSOID.DATA_OID, algorithmId, byArray2, this.provider);
        EncryptedData encryptedData = new EncryptedData((EncryptedContentInfo)object, null, this.provider);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "protectWithPasswordPrivacy", new ContentInfo(encryptedData, this.provider));
        }
        return new ContentInfo(encryptedData, this.provider);
    }

    private ContentInfo[] getPFXContents() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getPFXContents");
        }
        if (this.verifiedContents != null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getPFXContents_1", this.verifiedContents.getContentInfos());
            }
            return this.verifiedContents.getContentInfos();
        }
        if (this.authSafe != null) {
            PKCSDerObject pKCSDerObject;
            Data data;
            if (this.authSafe.getContentType().equals(PKCSOID.DATA_OID)) {
                data = (Data)this.authSafe.getContent();
            } else {
                pKCSDerObject = (SignedData)this.authSafe.getContent();
                ContentInfo contentInfo = ((SignedData)pKCSDerObject).getEncapsulatedContentInfo().getContentInfo();
                data = (Data)contentInfo.getContent();
            }
            pKCSDerObject = new AuthenticatedSafe(data.getData(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getPFXContents_2", ((AuthenticatedSafe)pKCSDerObject).getContentInfos());
            }
            return ((AuthenticatedSafe)pKCSDerObject).getContentInfos();
        }
        if (this.authSafeContents != null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getPFXContents_3", this.authSafeContents.getContentInfos());
            }
            return this.authSafeContents.getContentInfos();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getPFXContents_4", new ContentInfo[0]);
        }
        return new ContentInfo[0];
    }
}

