/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs12;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs12.Bag;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public final class KeyBag
extends PKCSDerObject
implements Bag,
Cloneable {
    private ObjectIdentifier oid = PKCSOID.KEYBAG_OID;
    private PrivateKeyInfo value;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs12.KeyBag";
    private volatile int cachedHashVal = 0;

    public KeyBag(PrivateKeyInfo privateKeyInfo) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "KeyBag", privateKeyInfo);
            debug.exit(16384L, className, "KeyBag");
        }
        this.value = privateKeyInfo;
    }

    public KeyBag(PrivateKeyInfo privateKeyInfo, String string) {
        super(string);
        this.value = privateKeyInfo;
        if (debug != null) {
            debug.entry(16384L, className, "KeyBag", privateKeyInfo, string);
            debug.exit(16384L, className, "KeyBag");
        }
    }

    public KeyBag(byte[] byArray) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "KeyBag", (Object)byArray);
        }
        this.decode(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "KeyBag");
        }
    }

    public KeyBag(byte[] byArray, String string) throws IOException {
        super(string);
        if (debug != null) {
            debug.entry(16384L, className, "KeyBag", byArray, string);
        }
        this.decode(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "KeyBag");
        }
    }

    public KeyBag(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl)};
            debug.entry(16384L, (Object)className, "KeyBag", objectArray);
            debug.exit(16384L, className, "KeyBag");
        }
    }

    public KeyBag(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "KeyBag", objectArray);
            debug.exit(16384L, className, "KeyBag");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.value.encode(outputStream);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
            debug.exit(16384L, className, "encode");
        }
    }

    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.exit(16384L, (Object)className, "getObjectIdentifier", PKCSOID.KEYBAG_OID);
        }
        return PKCSOID.KEYBAG_OID;
    }

    public Object getValue() {
        if (debug != null) {
            debug.entry(16384L, className, "getValue");
            debug.exit(16384L, (Object)className, "getValue", this.value.clone());
        }
        return this.value.clone();
    }

    public byte[] getEncodedValue() {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, className, "getEncodedValue");
        }
        try {
            this.value.encode(derOutputStream);
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getEncodedValue_1", null);
            }
            return null;
        }
        byte[] byArray = derOutputStream.toByteArray();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getEncodedValue_2", null);
        }
        return byArray;
    }

    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", "KeyBag");
        }
        return "KeyBag";
    }

    public boolean equals(Object object) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (object == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", true);
            }
            return true;
        }
        if (object instanceof KeyBag) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", this.equals((KeyBag)object));
            }
            return this.equals((KeyBag)object);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_2", false);
        }
        return false;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                this.encode(derOutputStream);
                this.cachedHashVal = Arrays.hashCode(derOutputStream.toByteArray());
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            KeyBag keyBag = new KeyBag(derOutputStream.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", keyBag);
            }
            return keyBag;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String string = "KeyBag:";
        string = string + "\r\nobject identifier: " + this.oid;
        string = string + "\r\nprivate key info:\r\n";
        string = string + this.value.toString();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }

    protected void decode(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        this.value = new PrivateKeyInfo(derValue.toByteArray(), this.provider);
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private boolean equals(KeyBag keyBag) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", keyBag);
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            keyBag.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", exception);
                debug.exit(16384L, (Object)className, "equals_2", false);
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_3", true);
        }
        return true;
    }
}

