/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs12;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs12.AuthenticatedSafe;
import com.ibm.security.pkcs12.CertBag;
import com.ibm.security.pkcs12.CrlBag;
import com.ibm.security.pkcs12.KeyBag;
import com.ibm.security.pkcs12.MacData;
import com.ibm.security.pkcs12.PKCS12;
import com.ibm.security.pkcs12.SafeBag;
import com.ibm.security.pkcs12.SafeContents;
import com.ibm.security.pkcs12.ShroudedKeyBag;
import com.ibm.security.pkcs7.Content;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.Data;
import com.ibm.security.pkcs7.DigestInfo;
import com.ibm.security.pkcs7.EncryptedContentInfo;
import com.ibm.security.pkcs7.EncryptedData;
import com.ibm.security.pkcs7.EnvelopedData;
import com.ibm.security.pkcs7.SignedData;
import com.ibm.security.pkcs8.EncryptedPrivateKeyInfo;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;

abstract class BasicPFX
extends PKCSDerObject {
    private BigInteger version = BigInteger.valueOf(3L);
    ContentInfo authSafe;
    MacData macData;
    AuthenticatedSafe authSafeContents;
    AuthenticatedSafe verifiedContents;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs12.BasicPFX";

    BasicPFX() {
        if (debug != null) {
            debug.entry(16384L, className, "BasicPFX");
            debug.exit(16384L, className, "BasicPFX");
        }
    }

    BasicPFX(String string) {
        super(string);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "BasicPFX", string);
            debug.exit(16384L, className, "BasicPFX");
        }
    }

    BasicPFX(byte[] byArray) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "BasicPFX", (Object)byArray);
        }
        this.decode(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "BasicPFX");
        }
    }

    BasicPFX(byte[] byArray, String string) throws IOException {
        super(string);
        if (debug != null) {
            debug.entry(16384L, className, "BasicPFX", byArray, string);
        }
        this.decode(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "BasicPFX");
        }
    }

    BasicPFX(ContentInfo contentInfo, MacData macData, String string) {
        super(string);
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{contentInfo, macData, string};
            debug.entry(16384L, (Object)className, "BasicPFX", objectArray);
        }
        if (!(objectArray = contentInfo.getContentType()).equals(PKCSOID.SIGNED_DATA_OID) && !objectArray.equals(PKCSOID.DATA_OID)) {
            if (debug != null) {
                debug.text(16384L, className, "BasicPFX", "Content type must be Data or SignedData.");
            }
            throw new IllegalArgumentException("Content type must be Data or SignedData.");
        }
        if (objectArray.equals(PKCSOID.DATA_OID) && macData == null) {
            if (debug != null) {
                debug.text(16384L, className, "BasicPFX", "MacData value must be specified for password-integrity mode (content type Data).");
            }
            throw new IllegalArgumentException("MacData value must be specified for password-integrity mode (content type Data).");
        }
        this.authSafe = contentInfo;
        this.macData = macData;
        if (debug != null) {
            debug.exit(16384L, className, "BasicPFX");
        }
    }

    BasicPFX(ContentInfo contentInfo, MacData macData) {
        this(contentInfo, macData, null);
        if (debug != null) {
            debug.entry(16384L, className, "BasicPFX", contentInfo, macData);
            debug.exit(16384L, className, "BasicPFX");
        }
    }

    BasicPFX(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl)};
            debug.entry(16384L, (Object)className, "BasicPFX", objectArray);
            debug.exit(16384L, className, "BasicPFX");
        }
    }

    BasicPFX(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "BasicPFX", objectArray);
            debug.exit(16384L, className, "BasicPFX");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        if (this.authSafe == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "No data to encode.");
            }
            throw new IOException("No data to encode.");
        }
        if (this.authSafe.getContentType().equals(PKCSOID.DATA_OID) && this.macData == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Integrity protection must be applied before encoding.");
            }
            throw new IOException("Integrity protection must be applied before encoding.");
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putInteger(this.version);
        this.authSafe.encode(derOutputStream);
        if (this.macData != null) {
            this.macData.encode(derOutputStream);
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public boolean equals(Object object) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (object == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", true);
            }
            return true;
        }
        if (object instanceof BasicPFX) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", this.equals((BasicPFX)object));
            }
            return this.equals((BasicPFX)object);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_2", false);
        }
        return false;
    }

    public int hashCode() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            int n = Arrays.hashCode(derOutputStream.toByteArray());
            return n;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    boolean equals(BasicPFX basicPFX) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", basicPFX);
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            basicPFX.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", exception);
                debug.exit(16384L, (Object)className, "equals_2", false);
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_4", true);
        }
        return true;
    }

    public String toString() {
        String string = "";
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        string = string + "PFX:";
        string = string + "\r\n\tversion: " + this.version;
        string = string + "\r\n\tauthsafe: ";
        string = this.authSafe == null ? string + "null" : string + "\r\n" + this.authSafe.toString();
        string = string + "\r\n\tmacdata: ";
        string = this.macData == null ? string + "null" : string + "\r\n" + this.macData.toString();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }

    protected void decode(DerValue derValue) throws IOException {
        BigInteger bigInteger;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "PFX parsing error, not a SEQUENCE.");
            }
            throw new IOException("PFX parsing error, not a SEQUENCE.");
        }
        if (this.version == null) {
            this.version = BigInteger.valueOf(3L);
        }
        if (!this.version.equals(bigInteger = derValue.getData().getInteger())) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "Invalid version: " + bigInteger + ". Must be 3.");
            }
            throw new IOException("Invalid version: " + bigInteger + ". Must be 3.");
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        this.authSafe = new ContentInfo(derValue2.toByteArray(), this.provider);
        ObjectIdentifier objectIdentifier = this.authSafe.getContentType();
        if (!objectIdentifier.equals(PKCSOID.SIGNED_DATA_OID) && !objectIdentifier.equals(PKCSOID.DATA_OID)) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "Content type must be Data or SignedData");
            }
            throw new IOException("Content type must be Data or SignedData");
        }
        if (objectIdentifier.equals(PKCSOID.SIGNED_DATA_OID)) {
            if (derValue.getData().available() != 0) {
                if (debug != null) {
                    debug.text(16384L, className, "decode", "PFX parsing error - data overrun, bytes = " + derValue.getData().available());
                }
                throw new IOException("PFX parsing error - data overrun, bytes = " + derValue.getData().available());
            }
        } else {
            derValue2 = derValue.getData().getDerValue();
            this.macData = new MacData(derValue2.toByteArray(), this.provider);
            if (derValue.getData().available() != 0) {
                if (debug != null) {
                    debug.text(16384L, className, "decode", "PFX parsing error - data overrun, bytes = " + derValue.getData().available());
                }
                throw new IOException("PFX parsing error - data overrun, bytes = " + derValue.getData().available());
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    int getVersion() {
        if (debug != null) {
            debug.entry(16384L, className, "getVersion");
            debug.exit(16384L, (Object)className, "getVersion", this.version.intValue());
        }
        return this.version.intValue();
    }

    ContentInfo getAuthenticatedSafe() {
        if (debug != null) {
            debug.entry(16384L, className, "getAuthenticatedSafe");
            debug.exit(16384L, (Object)className, "getAuthenticatedSafe", this.authSafe);
        }
        return this.authSafe;
    }

    MacData getMacData() {
        if (debug != null) {
            debug.entry(16384L, className, "getMacData");
            debug.exit(16384L, (Object)className, "getMacData", (MacData)this.macData.clone());
        }
        return (MacData)this.macData.clone();
    }

    String[] getFriendlyNames(char[] cArray) throws PKCSException {
        int n;
        SafeBag[] safeBagArray;
        Vector<Object> vector = new Vector<Object>();
        String[] stringArray = null;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getFriendlyNames", (Object)cArray);
        }
        try {
            safeBagArray = this.getSafeBags(cArray, null, null, false);
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.exception(16384L, className, "getFriendlyNames", iOException);
            }
            throw new PKCSException(iOException, "Error extracting SafeBags from PFX (" + iOException.toString() + ")");
        }
        for (n = 0; n < safeBagArray.length; ++n) {
            Object object;
            PKCSAttribute pKCSAttribute;
            PKCSAttributes pKCSAttributes = safeBagArray[n].getAttributes();
            if (pKCSAttributes == null || (pKCSAttribute = (PKCSAttribute)pKCSAttributes.getAttribute(PKCSOID.FRIENDLY_NAME_OID)) == null) continue;
            try {
                object = pKCSAttribute.getAttributeValue();
            }
            catch (IOException iOException) {
                if (debug == null) continue;
                debug.exception(16384L, className, "getFriendlyNames", iOException);
                continue;
            }
            if (vector.contains(object)) continue;
            vector.add(object);
        }
        if (vector.size() > 0) {
            stringArray = new String[vector.size()];
            for (n = 0; n < vector.size(); ++n) {
                stringArray[n] = (String)vector.elementAt(n);
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getFriendlyNames", stringArray);
        }
        return stringArray;
    }

    byte[][] getAllLocalKeyIds(char[] cArray) throws PKCSException {
        SafeBag[] safeBagArray;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object = null;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getAllLocalKeyIds", (Object)cArray);
        }
        try {
            safeBagArray = this.getSafeBags(cArray, null, null, false);
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.exception(16384L, className, "getAllLocalKeyIds", iOException);
            }
            throw new PKCSException(iOException, "Error extracting SafeBags from PFX (" + iOException.toString() + ")");
        }
        for (int i = 0; i < safeBagArray.length; ++i) {
            Object object2;
            PKCSAttribute pKCSAttribute;
            PKCSAttributes pKCSAttributes = safeBagArray[i].getAttributes();
            if (pKCSAttributes == null || (pKCSAttribute = (PKCSAttribute)pKCSAttributes.getAttribute(PKCSOID.LOCAL_KEY_ID_OID)) == null) continue;
            try {
                object2 = pKCSAttribute.getAttributeValue();
            }
            catch (IOException iOException) {
                if (debug == null) continue;
                debug.exception(16384L, className, "getAllLocalKeyIds", iOException);
                continue;
            }
            if (arrayList.contains(object2)) continue;
            arrayList.add(object2);
        }
        if (arrayList.size() > 0) {
            object = new byte[arrayList.size()][];
            Iterator iterator = arrayList.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                object[n] = (byte[])iterator.next();
                ++n;
            }
        }
        return object;
    }

    Certificate[] getCertificatesByLocalKeyId(char[] cArray, byte[] byArray) throws PKCSException {
        Object object;
        LinkedList linkedList;
        if (debug != null) {
            debug.entry(16384L, className, "getCertificatesByLocalKeyId", cArray, byArray.toString());
        }
        if ((linkedList = (LinkedList)this.getSafeBagsByLocalKeyId(cArray, byArray)).size() == 0) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCertificatesByLocalKeyId_1", null);
            }
            return null;
        }
        LinkedList linkedList2 = new LinkedList();
        for (int i = 0; i < linkedList.size(); ++i) {
            SafeBag safeBag = (SafeBag)linkedList.get(i);
            object = safeBag.getObjectIdentifier();
            if (!((ObjectIdentifier)object).equals(PKCSOID.CERTBAG_OID) && !((ObjectIdentifier)object).equals(PKCSOID.CERT_TYPES_OID)) continue;
            linkedList2.add(linkedList.get(i));
        }
        if (linkedList2.size() == 0) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCertificatesByLocalKeyId_2", null);
            }
            return null;
        }
        Certificate[] certificateArray = new Certificate[linkedList2.size()];
        for (int i = 0; i < linkedList2.size(); ++i) {
            CertBag certBag;
            object = (SafeBag)linkedList2.get(i);
            try {
                certBag = new CertBag(((SafeBag)object).getValue(), this.provider);
            }
            catch (IOException iOException) {
                if (debug != null) {
                    debug.exception(16384L, className, "getCertificatesByLocalKeyId", iOException);
                }
                throw new PKCSException(iOException, "Error extracting CertBags from PFX (" + iOException.toString() + ")");
            }
            certificateArray[i] = (Certificate)certBag.getValue();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCertificatesByLocalKeyId_3", certificateArray);
        }
        return certificateArray;
    }

    EncryptedPrivateKeyInfo[] getShroudedKeysByLocalKeyId(char[] cArray, byte[] byArray) throws PKCSException {
        Object object;
        LinkedList linkedList;
        if (debug != null) {
            debug.entry(16384L, className, "getShroudedKeysByFriendlyName", cArray, byArray);
        }
        if ((linkedList = (LinkedList)this.getSafeBagsByLocalKeyId(cArray, byArray)).size() == 0) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getShroudedKeysByFriendlyName_1", null);
            }
            return null;
        }
        LinkedList linkedList2 = new LinkedList();
        for (int i = 0; i < linkedList.size(); ++i) {
            SafeBag safeBag = (SafeBag)linkedList.get(i);
            object = safeBag.getObjectIdentifier();
            if (!((ObjectIdentifier)object).equals(PKCSOID.SHROUDEDKEYBAG_OID)) continue;
            linkedList2.add(linkedList.get(i));
        }
        if (linkedList2.size() == 0) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getShroudedKeysByFriendlyName_2", null);
            }
            return null;
        }
        EncryptedPrivateKeyInfo[] encryptedPrivateKeyInfoArray = new EncryptedPrivateKeyInfo[linkedList2.size()];
        for (int i = 0; i < linkedList2.size(); ++i) {
            ShroudedKeyBag shroudedKeyBag;
            object = (SafeBag)linkedList2.get(i);
            try {
                shroudedKeyBag = new ShroudedKeyBag(((SafeBag)object).getValue(), this.provider);
            }
            catch (IOException iOException) {
                if (debug != null) {
                    debug.exception(16384L, className, "getShroudedKeysByFriendlyName", iOException);
                }
                throw new PKCSException(iOException, "Error extracting ShroudedKeyBags from PFX (" + iOException.toString() + ")");
            }
            encryptedPrivateKeyInfoArray[i] = (EncryptedPrivateKeyInfo)shroudedKeyBag.getValue();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getShroudedKeysByFriendlyName_3", encryptedPrivateKeyInfoArray);
        }
        return encryptedPrivateKeyInfoArray;
    }

    byte[] getLocalKeyIdOfShroudedKey(EncryptedPrivateKeyInfo encryptedPrivateKeyInfo, char[] cArray) throws PKCSException, IOException {
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo2 = null;
        SafeBag[] safeBagArray = this.getTypedBags(PKCSOID.SHROUDEDKEYBAG_OID, cArray, null, null, false);
        if (safeBagArray == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getLocalKeyIdOfShroudedKey", null);
            }
            return null;
        }
        for (int i = 0; i < safeBagArray.length; ++i) {
            PKCSAttribute pKCSAttribute;
            byte[] byArray = safeBagArray[i].getValue();
            encryptedPrivateKeyInfo2 = new EncryptedPrivateKeyInfo(byArray, this.provider);
            if (!encryptedPrivateKeyInfo2.equals((Object)encryptedPrivateKeyInfo)) continue;
            PKCSAttributes pKCSAttributes = safeBagArray[i].getAttributes();
            if (pKCSAttributes != null && (pKCSAttribute = (PKCSAttribute)pKCSAttributes.getAttribute(PKCSOID.LOCAL_KEY_ID_OID)) != null) {
                return (byte[])pKCSAttribute.getAttributeValue();
            }
            return null;
        }
        return null;
    }

    String getFriendlyNameOfShroudedKey(EncryptedPrivateKeyInfo encryptedPrivateKeyInfo, char[] cArray) throws PKCSException, IOException {
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo2 = null;
        SafeBag[] safeBagArray = this.getTypedBags(PKCSOID.SHROUDEDKEYBAG_OID, cArray, null, null, false);
        if (safeBagArray == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getFriendlyNameOfShroudedKey", null);
            }
            return null;
        }
        for (int i = 0; i < safeBagArray.length; ++i) {
            PKCSAttribute pKCSAttribute;
            byte[] byArray = safeBagArray[i].getValue();
            encryptedPrivateKeyInfo2 = new EncryptedPrivateKeyInfo(byArray, this.provider);
            if (!encryptedPrivateKeyInfo2.equals((Object)encryptedPrivateKeyInfo)) continue;
            PKCSAttributes pKCSAttributes = safeBagArray[i].getAttributes();
            if (pKCSAttributes != null && (pKCSAttribute = (PKCSAttribute)pKCSAttributes.getAttribute(PKCSOID.FRIENDLY_NAME_OID)) != null) {
                return (String)pKCSAttribute.getAttributeValue();
            }
            return null;
        }
        return null;
    }

    Certificate[] getCertificatesByFriendlyName(char[] cArray, String string) throws PKCSException {
        Object object;
        Vector vector;
        if (debug != null) {
            debug.entry(16384L, className, "getCertificatesByFriendlyName", cArray, string);
        }
        if ((vector = this.getSafeBagsByFriendlyName(cArray, string)).size() == 0) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCertificatesByFriendlyName_1", null);
            }
            return null;
        }
        Vector vector2 = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            SafeBag safeBag = (SafeBag)vector.elementAt(i);
            object = safeBag.getObjectIdentifier();
            if (!((ObjectIdentifier)object).equals(PKCSOID.CERTBAG_OID) && !((ObjectIdentifier)object).equals(PKCSOID.CERT_TYPES_OID)) continue;
            vector2.add(vector.elementAt(i));
        }
        if (vector2.size() == 0) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCertificatesByFriendlyName_2", null);
            }
            return null;
        }
        Certificate[] certificateArray = new Certificate[vector2.size()];
        for (int i = 0; i < vector2.size(); ++i) {
            CertBag certBag;
            object = (SafeBag)vector2.elementAt(i);
            try {
                certBag = new CertBag(((SafeBag)object).getValue(), this.provider);
            }
            catch (IOException iOException) {
                if (debug != null) {
                    debug.exception(16384L, className, "getCertificatesByFriendlyName", iOException);
                }
                throw new PKCSException(iOException, "Error extracting CertBags from PFX (" + iOException.toString() + ")");
            }
            certificateArray[i] = (Certificate)certBag.getValue();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCertificatesByFriendlyName_3", certificateArray);
        }
        return certificateArray;
    }

    PrivateKeyInfo[] getPrivateKeysByFriendlyName(char[] cArray, String string) throws PKCSException {
        Object object;
        Vector vector;
        if (debug != null) {
            debug.entry(16384L, className, "getPrivateKeysByFriendlyName", cArray, string);
        }
        if ((vector = this.getSafeBagsByFriendlyName(cArray, string)).size() == 0) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getPrivateKeysByFriendlyName_1", null);
            }
            return null;
        }
        Vector vector2 = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            SafeBag safeBag = (SafeBag)vector.elementAt(i);
            object = safeBag.getObjectIdentifier();
            if (!((ObjectIdentifier)object).equals(PKCSOID.KEYBAG_OID)) continue;
            vector2.add(vector.elementAt(i));
        }
        if (vector2.size() == 0) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getPrivateKeysByFriendlyName_2", null);
            }
            return null;
        }
        PrivateKeyInfo[] privateKeyInfoArray = new PrivateKeyInfo[vector2.size()];
        for (int i = 0; i < vector2.size(); ++i) {
            KeyBag keyBag;
            object = (SafeBag)vector2.elementAt(i);
            try {
                keyBag = new KeyBag(((SafeBag)object).getValue(), this.provider);
            }
            catch (IOException iOException) {
                if (debug != null) {
                    debug.exception(16384L, className, "getPrivateKeysByFriendlyName", iOException);
                }
                throw new PKCSException(iOException, "Error extracting KeyBags from PFX (" + iOException.toString() + ")");
            }
            privateKeyInfoArray[i] = (PrivateKeyInfo)keyBag.getValue();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getPrivateKeysByFriendlyName_3", privateKeyInfoArray);
        }
        return privateKeyInfoArray;
    }

    EncryptedPrivateKeyInfo[] getShroudedKeysByFriendlyName(char[] cArray, String string) throws PKCSException {
        Object object;
        Vector vector;
        if (debug != null) {
            debug.entry(16384L, className, "getShroudedKeysByFriendlyName", cArray, string);
        }
        if ((vector = this.getSafeBagsByFriendlyName(cArray, string)).size() == 0) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getShroudedKeysByFriendlyName_1", null);
            }
            return null;
        }
        Vector vector2 = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            SafeBag safeBag = (SafeBag)vector.elementAt(i);
            object = safeBag.getObjectIdentifier();
            if (!((ObjectIdentifier)object).equals(PKCSOID.SHROUDEDKEYBAG_OID)) continue;
            vector2.add(vector.elementAt(i));
        }
        if (vector2.size() == 0) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getShroudedKeysByFriendlyName_2", null);
            }
            return null;
        }
        EncryptedPrivateKeyInfo[] encryptedPrivateKeyInfoArray = new EncryptedPrivateKeyInfo[vector2.size()];
        for (int i = 0; i < vector2.size(); ++i) {
            ShroudedKeyBag shroudedKeyBag;
            object = (SafeBag)vector2.elementAt(i);
            try {
                shroudedKeyBag = new ShroudedKeyBag(((SafeBag)object).getValue(), this.provider);
            }
            catch (IOException iOException) {
                if (debug != null) {
                    debug.exception(16384L, className, "getShroudedKeysByFriendlyName", iOException);
                }
                throw new PKCSException(iOException, "Error extracting ShroudedKeyBags from PFX (" + iOException.toString() + ")");
            }
            encryptedPrivateKeyInfoArray[i] = (EncryptedPrivateKeyInfo)shroudedKeyBag.getValue();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getShroudedKeysByFriendlyName_3", encryptedPrivateKeyInfoArray);
        }
        return encryptedPrivateKeyInfoArray;
    }

    boolean verifyMac(char[] cArray) throws IOException {
        byte[] byArray;
        byte[] byArray2;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "verifyMac", (Object)cArray);
        }
        if (this.macData == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "verifyMac_1", false);
            }
            return false;
        }
        DigestInfo digestInfo = this.macData.getMac();
        byte[] byArray3 = digestInfo.getDigest();
        AlgorithmId algorithmId = digestInfo.getDigestAlgorithm();
        byte[] byArray4 = this.macData.getSalt();
        int n = this.macData.getIterations();
        try {
            Data data = (Data)this.authSafe.getContent();
            byArray2 = data.getData();
            byArray = this.calculateMac(byArray2, algorithmId.getName(), cArray, byArray4, n);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "verifyMac", exception);
                debug.exit(16384L, (Object)className, "verifyMac_2", false);
            }
            return false;
        }
        if (byArray3.length != byArray.length) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "verifyMac_3", false);
            }
            return false;
        }
        for (int i = 0; i < byArray3.length; ++i) {
            if (byArray3[i] == byArray[i]) continue;
            if (debug != null) {
                debug.exit(16384L, (Object)className, "verifyMac_3", false);
            }
            return false;
        }
        this.verifiedContents = new AuthenticatedSafe(byArray2, this.provider);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "verifyMac_4", true);
        }
        return true;
    }

    PrivateKeyInfo[] getPrivateKeys(char[] cArray, PrivateKey privateKey, Certificate certificate, boolean bl) throws IOException, PKCSException {
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{cArray, privateKey, certificate, new Boolean(bl)};
            debug.entry(16384L, (Object)className, "getPrivateKeys", objectArray);
        }
        if ((objectArray = this.getTypedBags(PKCSOID.KEYBAG_OID, cArray, privateKey, certificate, bl)) == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getPrivateKeys_1", null);
            }
            return null;
        }
        PrivateKeyInfo[] privateKeyInfoArray = new PrivateKeyInfo[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            byte[] byArray = objectArray[i].getValue();
            try {
                privateKeyInfoArray[i] = new PrivateKeyInfo(byArray, this.provider);
                continue;
            }
            catch (IOException iOException) {
                if (debug == null) continue;
                debug.exception(16384L, className, "getPrivateKeys", iOException);
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getPrivateKeys_2", privateKeyInfoArray);
        }
        return privateKeyInfoArray;
    }

    EncryptedPrivateKeyInfo[] getShroudedKeys(char[] cArray, PrivateKey privateKey, Certificate certificate, boolean bl) throws IOException, PKCSException {
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{cArray, privateKey, certificate, new Boolean(bl)};
            debug.entry(16384L, (Object)className, "getShroudedKeys", objectArray);
        }
        if ((objectArray = this.getTypedBags(PKCSOID.SHROUDEDKEYBAG_OID, cArray, privateKey, certificate, bl)) == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getShroudedKeys_1", null);
            }
            return null;
        }
        EncryptedPrivateKeyInfo[] encryptedPrivateKeyInfoArray = new EncryptedPrivateKeyInfo[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            byte[] byArray = objectArray[i].getValue();
            try {
                encryptedPrivateKeyInfoArray[i] = new EncryptedPrivateKeyInfo(byArray, this.provider);
                continue;
            }
            catch (IOException iOException) {
                if (debug == null) continue;
                debug.exception(16384L, className, "getShroudedKeys", iOException);
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getShroudedKeys_2", encryptedPrivateKeyInfoArray);
        }
        return encryptedPrivateKeyInfoArray;
    }

    Certificate[] getCertificates(char[] cArray, PrivateKey privateKey, Certificate certificate, boolean bl) throws IOException, PKCSException {
        Object[] objectArray;
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        if (debug != null) {
            objectArray = new Object[]{cArray, privateKey, certificate, new Boolean(bl)};
            debug.entry(16384L, (Object)className, "getCertificates", objectArray);
        }
        objectArray = this.getTypedBags(PKCSOID.X509CERTBAG_OID, cArray, privateKey, certificate, bl);
        SafeBag[] safeBagArray = this.getTypedBags(PKCSOID.SDSICERTBAG_OID, cArray, privateKey, certificate, bl);
        SafeBag[] safeBagArray2 = this.getTypedBags(PKCSOID.CERTBAG_OID, cArray, privateKey, certificate, bl);
        if (objectArray == null && safeBagArray == null && safeBagArray2 == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCertificates_1", null);
            }
            return null;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (objectArray != null) {
            n = objectArray.length;
        }
        if (safeBagArray != null) {
            n2 = safeBagArray.length;
        }
        if (safeBagArray2 != null) {
            n3 = safeBagArray2.length;
        }
        SafeBag[] safeBagArray3 = new SafeBag[n + n2 + n3];
        int n4 = 0;
        if (objectArray != null) {
            System.arraycopy(objectArray, 0, safeBagArray3, n4, objectArray.length);
            n4 = objectArray.length;
        }
        if (safeBagArray != null) {
            System.arraycopy(safeBagArray, 0, safeBagArray3, n4, safeBagArray.length);
            n4 += safeBagArray.length;
        }
        if (safeBagArray2 != null) {
            System.arraycopy(safeBagArray2, 0, safeBagArray3, n4, safeBagArray2.length);
        }
        Certificate[] certificateArray = new Certificate[safeBagArray3.length];
        for (int i = 0; i < safeBagArray3.length; ++i) {
            byte[] byArray = safeBagArray3[i].getValue();
            CertBag certBag = new CertBag(byArray, this.provider);
            certificateArray[i] = (Certificate)certBag.getValue();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCertificates_2", certificateArray);
        }
        return certificateArray;
    }

    CRL[] getCRLs(char[] cArray, PrivateKey privateKey, Certificate certificate, boolean bl) throws IOException, PKCSException {
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{cArray, privateKey, certificate, new Boolean(bl)};
            debug.entry(16384L, (Object)className, "getCRLs", objectArray);
        }
        objectArray = this.getTypedBags(PKCSOID.X509CRLBAG_OID, cArray, privateKey, certificate, bl);
        SafeBag[] safeBagArray = this.getTypedBags(PKCSOID.CRLBAG_OID, cArray, privateKey, certificate, bl);
        if (objectArray == null && safeBagArray == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCRLs_1", null);
            }
            return null;
        }
        int n = 0;
        int n2 = 0;
        if (objectArray != null) {
            n = objectArray.length;
        }
        if (safeBagArray != null) {
            n2 = safeBagArray.length;
        }
        SafeBag[] safeBagArray2 = new SafeBag[n + n2];
        int n3 = 0;
        if (objectArray != null) {
            System.arraycopy(objectArray, 0, safeBagArray2, n3, objectArray.length);
            n3 = objectArray.length;
        }
        if (safeBagArray != null) {
            System.arraycopy(safeBagArray, 0, safeBagArray2, n3, safeBagArray.length);
            n3 += safeBagArray.length;
        }
        CRL[] cRLArray = new CRL[safeBagArray2.length];
        for (int i = 0; i < safeBagArray2.length; ++i) {
            byte[] byArray = safeBagArray2[i].getValue();
            CrlBag crlBag = new CrlBag(safeBagArray2[i].getObjectIdentifier(), byArray, this.provider);
            cRLArray[i] = (CRL)crlBag.getValue();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCRLs_2", cRLArray);
        }
        return cRLArray;
    }

    SafeContents[] getSafeContents(char[] cArray, PrivateKey privateKey, Certificate certificate, boolean bl) throws IOException, PKCSException {
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{cArray, privateKey, certificate, new Boolean(bl)};
            debug.entry(16384L, (Object)className, "getSafeContents", objectArray);
        }
        if ((objectArray = this.getTypedBags(PKCSOID.SAFECONTENTSBAG_OID, cArray, privateKey, certificate, bl)) == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSafeContents_1", null);
            }
            return null;
        }
        SafeContents[] safeContentsArray = new SafeContents[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            byte[] byArray = objectArray[i].getValue();
            try {
                safeContentsArray[i] = new SafeContents(byArray, this.provider);
                continue;
            }
            catch (IOException iOException) {
                if (debug == null) continue;
                debug.exception(16384L, className, "getSafeContents", iOException);
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSafeContents_2", safeContentsArray);
        }
        return safeContentsArray;
    }

    SafeBag[] getSafeBags(char[] cArray, PrivateKey privateKey, Certificate certificate, boolean bl) throws IOException, PKCSException {
        if (debug != null) {
            Object[] objectArray = new Object[]{cArray, privateKey, certificate, new Boolean(bl)};
            debug.entry(16384L, (Object)className, "getSafeBags", objectArray);
            debug.exit(16384L, (Object)className, "getSafeBags", this.getBags(cArray, privateKey, certificate, bl));
        }
        return this.getBags(cArray, privateKey, certificate, bl);
    }

    synchronized void applyMac(char[] cArray, int n) throws PKCSException, NoSuchAlgorithmException, IOException {
        int n2 = 1;
        if (debug != null) {
            debug.entry(16384L, className, "applyMac", cArray, new Integer(n));
        }
        if (n > 0) {
            n2 = n;
        }
        this.authSafe = this.authSafeContents.toContentInfo();
        Data data = (Data)this.authSafe.getContent();
        byte[] byArray = data.getData();
        byte[] byArray2 = new byte[20];
        SecureRandom secureRandom = null;
        try {
            secureRandom = this.provider != null ? SecureRandom.getInstance("IBMSecureRandom", this.provider) : SecureRandom.getInstance("IBMSecureRandom");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (debug != null) {
                debug.exception(16384L, className, "applyMac", noSuchAlgorithmException);
            }
            secureRandom = new SecureRandom();
        }
        catch (NoSuchProviderException noSuchProviderException) {
            if (debug != null) {
                debug.exception(16384L, className, "applyMac", noSuchProviderException);
            }
            throw new PKCSException("provider " + this.provider + " not found: " + noSuchProviderException);
        }
        secureRandom.nextBytes(byArray2);
        byte[] byArray3 = this.calculateMac(byArray, "SHA1", cArray, byArray2, n2);
        DigestInfo digestInfo = new DigestInfo("SHA1", null, byArray3, this.provider);
        this.macData = new MacData(digestInfo, byArray2, n2, this.provider);
        if (debug != null) {
            debug.exit(16384L, className, "applyMac");
        }
    }

    Vector getSafeBagsByFriendlyName(char[] cArray, String string) throws PKCSException {
        SafeBag[] safeBagArray;
        if (debug != null) {
            debug.entry(16384L, className, "getSafeBagsByFriendlyName", cArray, string);
        }
        try {
            safeBagArray = this.getSafeBags(cArray, null, null, false);
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.exception(16384L, className, "getSafeBagsByFriendlyName", iOException);
            }
            throw new PKCSException(iOException, "Error extracting SafeBags from PFX (" + iOException.toString() + ")");
        }
        Vector<SafeBag> vector = new Vector<SafeBag>();
        for (int i = 0; i < safeBagArray.length; ++i) {
            PKCSAttribute pKCSAttribute;
            PKCSAttributes pKCSAttributes = safeBagArray[i].getAttributes();
            if (pKCSAttributes == null || (pKCSAttribute = (PKCSAttribute)pKCSAttributes.getAttribute(PKCSOID.FRIENDLY_NAME_OID)) == null) continue;
            try {
                String string2 = (String)pKCSAttribute.getAttributeValue();
                if (!string2.equals(string)) continue;
                vector.add(safeBagArray[i]);
                continue;
            }
            catch (Exception exception) {
                if (debug == null) continue;
                debug.exception(16384L, className, "getSafeBagsByFriendlyName", exception);
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSafeBagsByFriendlyName", vector);
        }
        return vector;
    }

    Collection getSafeBagsByLocalKeyId(char[] cArray, byte[] byArray) throws PKCSException {
        SafeBag[] safeBagArray;
        if (debug != null) {
            debug.entry(16384L, className, "getSafeBagsByLocalKeyId", cArray, byArray);
        }
        try {
            safeBagArray = this.getSafeBags(cArray, null, null, false);
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.exception(16384L, className, "getSafeBagsByLocalKeyId", iOException);
            }
            throw new PKCSException(iOException, "Error extracting SafeBags from PFX (" + iOException.toString() + ")");
        }
        LinkedList<SafeBag> linkedList = new LinkedList<SafeBag>();
        for (int i = 0; i < safeBagArray.length; ++i) {
            PKCSAttribute pKCSAttribute;
            PKCSAttributes pKCSAttributes = safeBagArray[i].getAttributes();
            if (pKCSAttributes == null || (pKCSAttribute = (PKCSAttribute)pKCSAttributes.getAttribute(PKCSOID.LOCAL_KEY_ID_OID)) == null) continue;
            try {
                byte[] byArray2 = (byte[])pKCSAttribute.getAttributeValue();
                boolean bl = false;
                if (byArray2.length == byArray.length) {
                    bl = true;
                    for (int j = 0; j < byArray2.length; ++j) {
                        if (byArray2[j] == byArray[j]) continue;
                        bl = false;
                    }
                }
                if (!bl) continue;
                linkedList.add(safeBagArray[i]);
                continue;
            }
            catch (Exception exception) {
                if (debug == null) continue;
                debug.exception(16384L, className, "getSafeBagsByLocalKeyId", exception);
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSafeBagsByLocalKeyId", linkedList);
        }
        return linkedList;
    }

    private SafeBag[] getTypedBags(ObjectIdentifier objectIdentifier, char[] cArray, PrivateKey privateKey, Certificate certificate, boolean bl) throws IOException {
        Object[] objectArray;
        Vector<SafeBag> vector = new Vector<SafeBag>();
        if (debug != null) {
            objectArray = new Object[]{objectIdentifier, cArray, privateKey, certificate, new Boolean(bl)};
            debug.entry(8192L, (Object)className, "getTypedBags", objectArray);
        }
        if ((objectArray = this.getBags(cArray, privateKey, certificate, bl)) == null) {
            objectArray = new SafeBag[]{};
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (!objectArray[i].getObjectIdentifier().equals(objectIdentifier)) continue;
            vector.add(objectArray[i]);
        }
        if (vector.size() == 0) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "getTypedBags_1", null);
            }
            return null;
        }
        SafeBag[] safeBagArray = new SafeBag[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            safeBagArray[i] = (SafeBag)vector.elementAt(i);
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "getTypedBags_2", safeBagArray);
        }
        return safeBagArray;
    }

    private byte[] calculateMac(byte[] byArray, String string, char[] cArray, byte[] byArray2, int n) throws PKCSException, NoSuchAlgorithmException {
        Mac mac;
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{byArray, string, cArray, byArray2, new Integer(n)};
            debug.entry(16384L, (Object)className, "calculateMac", objectArray);
        }
        objectArray = "SHA";
        int n2 = 20;
        String string2 = string.toUpperCase();
        if (string2.indexOf("MD2") != -1) {
            objectArray = "MD2";
            n2 = 16;
        } else if (string2.indexOf("MD5") != -1) {
            objectArray = "MD5";
            n2 = 16;
        } else if (string2.indexOf("SHA") == -1) {
            if (debug != null) {
                debug.text(16384L, className, "calculateMac", "Unsupported MAC algorithm: " + string + ".  Digest algorithm must be one of SHA, MD2 or MD5.");
            }
            throw new IllegalArgumentException("Unsupported MAC algorithm: " + string + ".  Digest algorithm must be one of SHA, MD2 or MD5.");
        }
        byte[] byArray3 = PKCS12.genKey((byte)3, (String)objectArray, cArray, byArray2, n, n2);
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray3, string);
        String string3 = objectArray.toUpperCase();
        String string4 = string3.indexOf("SHA") != -1 ? "HmacSHA1" : "Hmac" + (String)objectArray;
        try {
            mac = this.provider != null ? Mac.getInstance(string4, this.provider) : Mac.getInstance(string4);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.text(16384L, className, "calculateMac", "Unable to instantiate HMAC (" + exception.toString() + ")");
            }
            throw new PKCSException(exception, "Unable to instantiate HMAC (" + exception.toString() + ")");
        }
        try {
            mac.init(secretKeySpec, null);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "calculateMac", exception);
            }
            throw new PKCSException(exception, "Unable to initialize HMAC (" + exception.toString() + ")");
        }
        mac.update(byArray, 0, byArray.length);
        byte[] byArray4 = mac.doFinal();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "calculateMac", byArray4);
        }
        return byArray4;
    }

    private SafeBag[] getBags(char[] cArray, PrivateKey privateKey, Certificate certificate, boolean bl) throws IOException {
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{cArray, privateKey, certificate, new Boolean(bl)};
            debug.entry(8192L, (Object)className, "getBags", objectArray);
        }
        objectArray = new HexDumpEncoder();
        Vector<Object> vector = new Vector<Object>();
        ContentInfo[] contentInfoArray = this.getPFXContents();
        for (int i = 0; i < contentInfoArray.length; ++i) {
            Object[] objectArray2;
            Object[] objectArray3;
            Object object;
            Object object2;
            Content content;
            if (contentInfoArray[i].getContentType().equals(PKCSOID.DATA_OID)) {
                if (bl) continue;
                content = (Data)contentInfoArray[i].getContent();
                object2 = ((Data)content).getData();
                object = new SafeContents((byte[])object2, this.provider);
                objectArray3 = ((SafeContents)object).getSafeBags();
                for (int j = 0; j < objectArray3.length; ++j) {
                    vector.add(objectArray3[j]);
                }
                continue;
            }
            if (contentInfoArray[i].getContentType().equals(PKCSOID.ENCRYPTED_DATA_OID)) {
                try {
                    content = (EncryptedData)contentInfoArray[i].getContent();
                    object2 = ((EncryptedData)content).getEncryptedContent();
                    object = ((EncryptedContentInfo)object2).getContentEncryptionAlgorithm();
                    objectArray3 = ((EncryptedContentInfo)object2).getEncryptedContent();
                    String string = ((AlgorithmId)object).getName();
                    objectArray2 = ((AlgorithmId)object).getParameters();
                    DerValue derValue = new DerValue((byte[])objectArray2);
                    DerValue[] derValueArray = new DerValue[]{derValue.getData().getDerValue(), derValue.getData().getDerValue()};
                    byte[] byArray = derValueArray[0].getOctetString();
                    int n = derValueArray[1].getInteger().intValue();
                    PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(byArray, n);
                    AlgorithmParameters algorithmParameters = null;
                    algorithmParameters = this.provider != null ? AlgorithmParameters.getInstance("PBE", this.provider) : AlgorithmParameters.getInstance("PBE");
                    algorithmParameters.init(pBEParameterSpec);
                    PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
                    SecretKeyFactory secretKeyFactory = null;
                    secretKeyFactory = this.provider != null ? SecretKeyFactory.getInstance(string, this.provider) : SecretKeyFactory.getInstance(string);
                    SecretKey secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
                    Cipher cipher = null;
                    cipher = this.provider != null ? Cipher.getInstance(string, this.provider) : Cipher.getInstance(string);
                    cipher.init(2, (Key)secretKey, algorithmParameters);
                    byte[] byArray2 = cipher.doFinal((byte[])objectArray3);
                    SafeContents safeContents = new SafeContents(byArray2, this.provider);
                    SafeBag[] safeBagArray = safeContents.getSafeBags();
                    for (int j = 0; j < safeBagArray.length; ++j) {
                        vector.add(safeBagArray[j]);
                    }
                    continue;
                }
                catch (Exception exception) {
                    if (debug == null) continue;
                    debug.exception(8192L, className, "getBags", exception);
                    continue;
                }
            }
            if (!contentInfoArray[i].getContentType().equals(PKCSOID.ENVELOPED_DATA_OID) || privateKey == null || certificate == null) continue;
            try {
                content = (EnvelopedData)contentInfoArray[i].getContent();
                object2 = ((EnvelopedData)content).decrypt(privateKey, certificate);
                object = (Data)((ContentInfo)object2).getContent();
                objectArray3 = ((Data)object).getData();
                SafeContents safeContents = new SafeContents((byte[])objectArray3, this.provider);
                objectArray2 = safeContents.getSafeBags();
                for (int j = 0; j < objectArray2.length; ++j) {
                    vector.add(objectArray2[j]);
                }
                continue;
            }
            catch (Exception exception) {
                if (debug == null) continue;
                debug.exception(8192L, className, "getBags", exception);
            }
        }
        if (vector.size() == 0) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "getBags_1", null);
            }
            return null;
        }
        SafeBag[] safeBagArray = new SafeBag[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            safeBagArray[i] = (SafeBag)vector.elementAt(i);
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "getBags_2", safeBagArray);
        }
        return safeBagArray;
    }

    private ContentInfo[] getPFXContents() throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "getPFXContents");
        }
        if (this.verifiedContents != null) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "getPFXContents_1", this.verifiedContents.getContentInfos());
            }
            return this.verifiedContents.getContentInfos();
        }
        if (this.authSafe != null) {
            PKCSDerObject pKCSDerObject;
            Data data;
            if (this.authSafe.getContentType().equals(PKCSOID.DATA_OID)) {
                data = (Data)this.authSafe.getContent();
            } else {
                pKCSDerObject = (SignedData)this.authSafe.getContent();
                ContentInfo contentInfo = ((SignedData)pKCSDerObject).getEncapsulatedContentInfo().getContentInfo();
                data = (Data)contentInfo.getContent();
            }
            pKCSDerObject = new AuthenticatedSafe(data.getData(), this.provider);
            if (debug != null) {
                debug.exit(8192L, (Object)className, "getPFXContents_2", ((AuthenticatedSafe)pKCSDerObject).getContentInfos());
            }
            return ((AuthenticatedSafe)pKCSDerObject).getContentInfos();
        }
        if (this.authSafeContents != null) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "getPFXContents_3", this.authSafeContents.getContentInfos());
            }
            return this.authSafeContents.getContentInfos();
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "getPFXContents_4", new ContentInfo[0]);
        }
        return new ContentInfo[0];
    }

    synchronized void addSafeBagsWithPasswordPrivacy(SafeBag[] safeBagArray, String string, char[] cArray) throws NoSuchAlgorithmException, IOException, PKCSException {
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{safeBagArray, string, cArray};
            debug.entry(16384L, (Object)className, "addSafeBagsWithPasswordPrivacy", objectArray);
        }
        objectArray = new SafeContents(safeBagArray, this.provider);
        byte[] byArray = objectArray.encode();
        ContentInfo contentInfo = this.protectWithPasswordPrivacy(byArray, "SHA", string, cArray);
        this.addContentToAuthSafe(contentInfo);
        if (debug != null) {
            debug.exit(16384L, className, "addSafeBagsWithPasswordPrivacy");
        }
    }

    synchronized void addContentToAuthSafe(ContentInfo contentInfo) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "addContentToAuthSafe", contentInfo);
        }
        ContentInfo[] contentInfoArray = new ContentInfo[]{contentInfo};
        this.authSafeContents = this.authSafeContents == null ? new AuthenticatedSafe(contentInfoArray, this.provider) : this.authSafeContents.addContentInfo(contentInfoArray);
        if (debug != null) {
            debug.exit(16384L, className, "addContentToAuthSafe");
        }
    }

    abstract ContentInfo protectWithPasswordPrivacy(byte[] var1, String var2, String var3, char[] var4) throws IOException, PKCSException, NoSuchAlgorithmException;
}

