/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs10;

import com.ibm.misc.Debug;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.util.Arrays;

public final class CertificationRequestInfo
extends PKCSDerObject
implements Cloneable {
    private static final byte TAG_ATTRIBUTES = 0;
    private static final BigInteger version = BigInteger.ZERO;
    private X500Name subject;
    private PublicKey spki;
    private PKCSAttributes attributeSet;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs10.CertificationRequestInfo";
    private volatile int cachedHashVal = 0;

    public CertificationRequestInfo(byte[] byArray) throws IOException {
        super(byArray);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificationRequestInfo", (Object)byArray);
            debug.exit(16384L, className, "CertificationRequestInfo");
        }
    }

    public CertificationRequestInfo(byte[] byArray, String string) throws IOException {
        super(byArray, string);
        if (debug != null) {
            debug.entry(16384L, className, "CertificationRequestInfo", byArray, string);
            debug.exit(16384L, className, "CertificationRequestInfo");
        }
    }

    public CertificationRequestInfo(X500Name x500Name, PublicKey publicKey, PKCSAttributes pKCSAttributes) {
        if (debug != null) {
            Object[] objectArray = new Object[]{x500Name, publicKey, pKCSAttributes};
            debug.entry(16384L, (Object)className, "CertificationRequestInfo", objectArray);
        }
        if (x500Name == null) {
            if (debug != null) {
                debug.text(16384L, className, "CertificationRequestInfo", "No subject specified");
            }
            throw new IllegalArgumentException("No subject specified");
        }
        if (publicKey == null) {
            if (debug != null) {
                debug.text(16384L, className, "CertificationRequestInfo", "No public key specified");
            }
            throw new IllegalArgumentException("No public key specified");
        }
        this.subject = x500Name;
        this.spki = publicKey;
        this.attributeSet = pKCSAttributes != null ? pKCSAttributes : new PKCSAttributes((PKCSAttribute[])null);
        if (debug != null) {
            debug.exit(16384L, className, "CertificationRequestInfo");
        }
    }

    public CertificationRequestInfo(X500Name x500Name, PublicKey publicKey, PKCSAttributes pKCSAttributes, String string) {
        super(string);
        if (debug != null) {
            Object[] objectArray = new Object[]{x500Name, publicKey, pKCSAttributes, string};
            debug.entry(16384L, (Object)className, "CertificationRequestInfo", objectArray);
        }
        if (x500Name == null) {
            if (debug != null) {
                debug.text(16384L, className, "CertificationRequestInfo", "No subject specified");
            }
            throw new IllegalArgumentException("No subject specified");
        }
        if (publicKey == null) {
            if (debug != null) {
                debug.text(16384L, className, "CertificationRequestInfo", "No public key specified");
            }
            throw new IllegalArgumentException("No public key specified");
        }
        this.subject = x500Name;
        this.spki = publicKey;
        this.attributeSet = pKCSAttributes != null ? pKCSAttributes : new PKCSAttributes((PKCSAttribute[])null, this.provider);
        if (debug != null) {
            debug.exit(16384L, className, "CertificationRequestInfo");
        }
    }

    public CertificationRequestInfo(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl)};
            debug.entry(16384L, (Object)className, "CertificationRequestInfo", objectArray);
            debug.exit(16384L, className, "CertificationRequestInfo");
        }
    }

    public CertificationRequestInfo(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "CertificationRequestInfo", objectArray);
            debug.exit(16384L, className, "CertificationRequestInfo");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putInteger(version);
        this.subject.encode(derOutputStream);
        derOutputStream.write(this.spki.getEncoded());
        DerOutputStream derOutputStream3 = new DerOutputStream();
        this.attributeSet.encode(derOutputStream3);
        derOutputStream.writeImplicit(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream3);
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public boolean equals(Object object) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (object == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(true));
            }
            return true;
        }
        if (object instanceof CertificationRequestInfo) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", this.equals((CertificationRequestInfo)object));
            }
            return this.equals((CertificationRequestInfo)object);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(false));
        }
        return false;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                this.encode(derOutputStream);
                this.cachedHashVal = Arrays.hashCode(derOutputStream.toByteArray());
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public String toString() {
        String string = "";
        string = string + "PKCS #10 Certification request info:";
        string = string + "\r\n\tversion: " + version;
        string = string + "\r\n\tsubject: " + this.subject;
        string = string + "\r\n\tpublic key info: \r\n" + this.spki.toString();
        string = string + "\r\n\tattributes: " + this.attributeSet.toString();
        return string;
    }

    public Object clone() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            return new CertificationRequestInfo(derOutputStream.toByteArray(), this.provider);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public BigInteger getVersion() {
        if (debug != null) {
            debug.entry(16384L, className, "getVersion");
            debug.exit(16384L, (Object)className, "getVersion", version);
        }
        return version;
    }

    public X500Name getSubjectName() {
        if (debug != null) {
            debug.entry(16384L, className, "getSubjectName");
            debug.exit(16384L, (Object)className, "getSubjectName", this.subject);
        }
        return this.subject;
    }

    public PublicKey getSubjectPublicKeyInfo() throws InvalidKeyException, IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getSubjectPublicKeyInfo");
        }
        if (this.spki == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSubjectPublicKeyInfo", null);
            }
            return null;
        }
        DerValue derValue = new DerValue(this.spki.getEncoded());
        PublicKey publicKey = X509Key.parse(derValue);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSubjectPublicKeyInfo", publicKey);
        }
        return publicKey;
    }

    public PKCSAttributes getAttributes() {
        if (debug != null) {
            debug.entry(16384L, className, "getAttributes");
            debug.exit(16384L, (Object)className, "getAttributes", this.attributeSet);
        }
        return this.attributeSet;
    }

    protected void decode(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "CertificationRequestInfo parsing error");
            }
            throw new IOException("CertificationRequestInfo parsing error");
        }
        BigInteger bigInteger = derValue.getData().getInteger();
        if (!bigInteger.equals(version)) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "Version mismatch: (supported: " + version + ", parsed: " + bigInteger);
            }
            throw new IOException("Version mismatch: (supported: " + version + ", parsed: " + bigInteger);
        }
        this.subject = new X500Name(derValue.getData().getDerValue());
        this.spki = X509Key.parse(derValue.getData().getDerValue());
        this.attributeSet = derValue.getData().available() != 0 ? new PKCSAttributes(derValue.getData(), this.provider) : new PKCSAttributes((PKCSAttribute[])null, this.provider);
        if (derValue.getData().available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "CertificationRequestInfo parsing error - data overrun, bytes = " + derValue.getData().available());
            }
            throw new IOException("CertificationRequestInfo parsing error - data overrun, bytes = " + derValue.getData().available());
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private boolean equals(CertificationRequestInfo certificationRequestInfo) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", certificationRequestInfo);
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            certificationRequestInfo.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", exception);
                debug.exit(16384L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }
}

