/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs1;

import com.ibm.misc.Debug;
import com.ibm.security.pkcsutil.PKCSException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;

public final class PKCS1 {
    private String version = "1.5";
    private String provider = null;
    private String signature = "SHAwithRSA";
    private String encryption = "RSA";
    private String mgf = "MGF1";
    public static final String PKCS1_VERSION_1_5 = "1.5";
    public static final String PKCS1_VERSION2 = "2.0";
    static final String RSA_ALGORITHM = "RSA";
    static final String MESSAGE_DIGEST_MD2 = "MD2";
    static final String MESSAGE_DIGEST_MD5 = "MD5";
    static final String MESSAGE_DIGEST_SHA = "SHA";
    static final String MESSAGE_DIGEST_SHA1 = "SHA1";
    static final String MESSAGE_DIGEST_SHA_1 = "SHA-1";
    static final String SIGNATURE_SHA_RSA = "SHAwithRSA";
    static final String SIGNATURE_MD2_RSA = "MD2withRSA";
    static final String SIGNATURE_MD5_RSA = "MD5withRSA";
    static final String MGF_MGF1 = "MGF1";
    static final String MGF_NULL = "NO_MGF";
    static final int MD2_RESULT_LENGTH = 16;
    static final int MD5_RESULT_LENGTH = 16;
    static final int SHA_RESULT_LENGTH = 20;
    private static final BigInteger BIG_INT_ZERO = BigInteger.ZERO;
    private static final String[] OaepHashAlgorithms = new String[]{"SHA", "SHA1", "SHA-1"};
    private static final String[] version1_5SignAlgorithms = new String[]{"SHA", "SHA1", "SHA-1", "MD2", "MD5"};
    private static final String[] mgfAlgorithms = new String[]{"MGF1"};
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs1.PKCS1";

    public PKCS1(String string, String string2, String string3, String string4, String string5) {
        this(string, string2, string3, string4);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, string2, string3, string4, string5};
            debug.entry(16384L, (Object)className, "PKCS1", objectArray);
        }
        if (string5 != null) {
            this.provider = new String(string5);
        }
        if (debug != null) {
            debug.exit(16384L, className, "PKCS1");
        }
    }

    public PKCS1(String string, String string2, String string3, String string4) {
        if (debug != null) {
            Object[] objectArray = new Object[]{string, string2, string3, string4};
            debug.entry(16384L, (Object)className, "PKCS1", objectArray);
        }
        try {
            if (string != null) {
                this.setVersion(string);
            }
            if (string2 != null) {
                this.setEncryptionAlgorithm(string2);
            }
            if (string4 != null) {
                this.setMGF(string4);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (string3 != null) {
            this.setSignatureHashAlgorithm(string3);
        }
        if (debug != null) {
            debug.exit(16384L, className, "PKCS1");
        }
    }

    public String getVersion() {
        if (debug != null) {
            debug.entry(16384L, className, "getVersion");
            debug.exit(16384L, (Object)className, "getVersion", this.version);
        }
        return this.version;
    }

    public String getEncryptionAlgorithmString() {
        if (debug != null) {
            debug.entry(16384L, className, "getEncryptionAlgorithmString");
            debug.exit(16384L, (Object)className, "getEncryptionAlgorithmString", this.encryption);
        }
        return this.encryption;
    }

    public String getSignatureHashAlgorithmString() {
        String string = null;
        if (debug != null) {
            debug.entry(16384L, className, "getSignatureHashAlgorithmString");
        }
        string = SIGNATURE_MD2_RSA.equals(this.signature) ? new String(MESSAGE_DIGEST_MD2) : (SIGNATURE_MD5_RSA.equals(this.signature) ? new String(MESSAGE_DIGEST_MD5) : new String(MESSAGE_DIGEST_SHA));
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSignatureHashAlgorithmString", string);
        }
        return string;
    }

    public String getSignatureAlgorithmString() {
        if (debug != null) {
            debug.entry(16384L, className, "getSignatureAlgorithmString");
            debug.exit(16384L, (Object)className, "getSignatureAlgorithmString", this.signature);
        }
        return this.signature;
    }

    public String getMGF() {
        if (debug != null) {
            debug.entry(16384L, className, "getMGF");
        }
        if (PKCS1_VERSION2.equalsIgnoreCase(this.version)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getMGF", this.mgf);
            }
            return this.mgf;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getMGF", null);
        }
        return null;
    }

    public byte[] encrypt(PublicKey publicKey, byte[] byArray) throws PKCSException, NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, className, "encrypt", publicKey, byArray);
        }
        if (publicKey == null) {
            if (debug != null) {
                debug.text(16384L, className, "encrypt", "Public Key must be specified");
            }
            throw new IllegalArgumentException("Public Key must be specified.");
        }
        if (byArray == null) {
            if (debug != null) {
                debug.text(16384L, className, "encrypt", "Message must be specified");
            }
            throw new IllegalArgumentException("Message must be specified.");
        }
        Cipher cipher = null;
        if (publicKey.getAlgorithm() != RSA_ALGORITHM) {
            if (debug != null) {
                debug.text(16384L, className, "encrypt", "Invalid key: RSA public key algorithm expected");
            }
            throw new PKCSException("Invalid key: RSA public key expected");
        }
        if (!(publicKey instanceof RSAPublicKey)) {
            if (debug != null) {
                debug.text(16384L, className, "encrypt", "Invalid key: RSA public key expected");
            }
            throw new PKCSException("Invalid key: RSA public key expected");
        }
        try {
            cipher = this.provider != null ? Cipher.getInstance(this.encryption, this.provider) : Cipher.getInstance(this.encryption);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "encrypt", exception);
            }
            throw new PKCSException(exception, "Error : (" + exception.toString() + ")");
        }
        try {
            cipher.init(1, publicKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            if (debug != null) {
                debug.exception(16384L, className, "encrypt", invalidKeyException);
            }
            throw new PKCSException(invalidKeyException, "Invalid key: RSA public key expected");
        }
        byte[] byArray2 = null;
        try {
            byArray2 = cipher.doFinal(byArray);
        }
        catch (BadPaddingException badPaddingException) {
            if (debug != null) {
                debug.exception(16384L, className, "encrypt", badPaddingException);
            }
            throw new PKCSException(badPaddingException, "Error : (" + badPaddingException.toString() + ")");
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            if (debug != null) {
                debug.exception(16384L, className, "encrypt", illegalBlockSizeException);
            }
            throw new PKCSException(illegalBlockSizeException, "Error : (" + illegalBlockSizeException.toString() + ")");
        }
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encrypt", (Object)byArray2);
        }
        return byArray2;
    }

    public byte[] encrypt(Certificate certificate, byte[] byArray) throws PKCSException, NoSuchAlgorithmException {
        byte[] byArray2 = null;
        if (debug != null) {
            debug.entry(16384L, className, "encrypt", certificate, byArray);
        }
        if (certificate == null) {
            if (debug != null) {
                debug.text(16384L, className, "encrypt", "Certificate must be specified");
            }
            throw new IllegalArgumentException("Certificate must be specified.");
        }
        if (!(certificate instanceof X509Certificate)) {
            if (debug != null) {
                debug.text(16384L, className, "encrypt", "Certificate type " + certificate.getClass().getName() + " not supported. Only instances of java.security.cert.X509Certificate are supported");
            }
            throw new IllegalArgumentException("Certificate type " + certificate.getClass().getName() + "not supported.  Only instances of " + "java.security.cert.X509Certificate are supported.");
        }
        try {
            ((X509Certificate)certificate).checkValidity();
        }
        catch (CertificateExpiredException certificateExpiredException) {
            if (debug != null) {
                debug.exception(16384L, className, "encrypt", certificateExpiredException);
            }
            throw new PKCSException(certificateExpiredException, "Certificate has expired.");
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            if (debug != null) {
                debug.exception(16384L, className, "encrypt", certificateNotYetValidException);
            }
            throw new PKCSException(certificateNotYetValidException, "Certificate is not yet valid.");
        }
        byArray2 = this.encrypt(certificate.getPublicKey(), byArray);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "encrypt", byArray2);
        }
        return byArray2;
    }

    public byte[] decrypt(PrivateKey privateKey, byte[] byArray) throws PKCSException, NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, className, "decrypt", privateKey, byArray);
        }
        if (privateKey == null) {
            if (debug != null) {
                debug.text(16384L, className, "decrypt", "Private Key must be specified");
            }
            throw new IllegalArgumentException("Private Key must be specified.");
        }
        if (byArray == null) {
            if (debug != null) {
                debug.text(16384L, className, "decrypt", "Cipher text must be specified");
            }
            throw new IllegalArgumentException("Cipher text must be specified.");
        }
        Cipher cipher = null;
        if (privateKey.getAlgorithm() != RSA_ALGORITHM) {
            if (debug != null) {
                debug.text(16384L, className, "decrypt", "Invalid key: RSA algorithm expected");
            }
            throw new PKCSException("Invalid key: RSA private key expected");
        }
        if (!(privateKey instanceof RSAPrivateKey) && !(privateKey instanceof RSAPrivateCrtKey)) {
            if (debug != null) {
                debug.text(16384L, className, "decrypt", "Invalid key: RSA private key expected");
            }
            throw new PKCSException("Invalid key: RSA private key expected");
        }
        try {
            cipher = this.provider != null ? Cipher.getInstance(this.encryption, this.provider) : Cipher.getInstance(this.encryption);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "decrypt", exception);
            }
            throw new PKCSException(exception, "Error : (" + exception.toString() + ")");
        }
        try {
            cipher.init(2, privateKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            if (debug != null) {
                debug.exception(16384L, className, "decrypt", invalidKeyException);
            }
            throw new PKCSException(invalidKeyException, "Invalid key: RSA private key expected");
        }
        byte[] byArray2 = null;
        try {
            byArray2 = cipher.doFinal(byArray);
        }
        catch (BadPaddingException badPaddingException) {
            if (debug != null) {
                debug.exception(16384L, className, "decrypt", badPaddingException);
            }
            throw new PKCSException(badPaddingException, "Error : (" + badPaddingException.toString() + ")");
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            if (debug != null) {
                debug.exception(16384L, className, "decrypt", illegalBlockSizeException);
            }
            throw new PKCSException(illegalBlockSizeException, "Error : (" + illegalBlockSizeException.toString() + ")");
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "decrypt", byArray2);
        }
        return byArray2;
    }

    public byte[] sign(PrivateKey privateKey, byte[] byArray) throws PKCSException, NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, className, "sign", privateKey, byArray);
        }
        if (privateKey == null) {
            if (debug != null) {
                debug.text(16384L, className, "sign", "Private Key must be specified.");
            }
            throw new IllegalArgumentException("Private Key must be specified.");
        }
        if (byArray == null) {
            if (debug != null) {
                debug.text(16384L, className, "sign", "Message must be specified.");
            }
            throw new IllegalArgumentException("Message must be specified.");
        }
        if (byArray.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "sign", "Message length is 0.");
            }
            throw new IllegalArgumentException("Message must be specified.");
        }
        if (privateKey.getAlgorithm() != RSA_ALGORITHM) {
            if (debug != null) {
                debug.text(16384L, className, "sign", "Invalid key: RSA Algorithm expected.");
            }
            throw new PKCSException("Invalid key: RSA private key expected");
        }
        if (!(privateKey instanceof RSAPrivateKey) && !(privateKey instanceof RSAPrivateCrtKey)) {
            if (debug != null) {
                debug.text(16384L, className, "sign", "Invalid key: RSA private key expecited");
            }
            throw new PKCSException("Invalid key: RSA private key expected");
        }
        Signature signature = null;
        try {
            signature = this.provider != null ? Signature.getInstance(this.signature, this.provider) : Signature.getInstance(this.signature);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "sign", exception);
            }
            throw new PKCSException(exception, "Error : (" + exception.toString() + ")");
        }
        try {
            signature.initSign(privateKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            if (debug != null) {
                debug.exception(16384L, className, "sign", invalidKeyException);
            }
            throw new PKCSException(invalidKeyException, "Invalid key: RSA private key expected");
        }
        byte[] byArray2 = null;
        try {
            signature.update(byArray);
            byArray2 = signature.sign();
        }
        catch (SignatureException signatureException) {
            if (debug != null) {
                debug.exception(16384L, className, "sign", signatureException);
            }
            throw new PKCSException(signatureException, "Error : (" + signatureException.toString() + ")");
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "sign", byArray2);
        }
        return byArray2;
    }

    public boolean verify(PublicKey publicKey, byte[] byArray, byte[] byArray2) throws PKCSException, NoSuchAlgorithmException {
        Object object;
        boolean bl = false;
        if (debug != null) {
            object = new Object[]{publicKey, byArray, byArray2};
            debug.entry(16384L, (Object)className, "verify", (Object[])object);
        }
        if (publicKey == null) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Public Key must be specified");
            }
            throw new IllegalArgumentException("Public Key must be specified.");
        }
        if (byArray == null) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Message must be specified");
            }
            throw new IllegalArgumentException("Message must be specified.");
        }
        if (byArray.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Message length cannot be 0");
            }
            throw new IllegalArgumentException("Message must be specified.");
        }
        if (byArray2 == null) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Signature must be specified");
            }
            throw new IllegalArgumentException("Signature must be specified.");
        }
        if (byArray2.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Signature length cannot be 0");
            }
            throw new IllegalArgumentException("Signature must be specified.");
        }
        if (publicKey.getAlgorithm() != RSA_ALGORITHM) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Invalid key: Public Key Algorithm must be RSA");
            }
            throw new PKCSException("Invalid key: RSA public key expected");
        }
        if (!(publicKey instanceof RSAPublicKey)) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Invalid key: RSA public key expected");
            }
            throw new PKCSException("Invalid key: RSA public key expected");
        }
        object = null;
        try {
            object = this.provider != null ? Signature.getInstance(this.signature, this.provider) : Signature.getInstance(this.signature);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "verify", exception);
            }
            throw new PKCSException(exception, "Error : (" + exception.toString() + ")");
        }
        try {
            ((Signature)object).initVerify(publicKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            if (debug != null) {
                debug.exception(16384L, className, "verify", invalidKeyException);
            }
            throw new PKCSException(invalidKeyException, "Invalid key: RSA public key expected");
        }
        try {
            ((Signature)object).update(byArray);
            bl = ((Signature)object).verify(byArray2);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "verify", bl);
            }
            return bl;
        }
        catch (SignatureException signatureException) {
            if (debug != null) {
                debug.exception(16384L, className, "verify", signatureException);
            }
            throw new PKCSException(signatureException, "Error : (" + signatureException.toString() + ")");
        }
    }

    public boolean verify(Certificate certificate, byte[] byArray, byte[] byArray2) throws PKCSException, NoSuchAlgorithmException {
        boolean bl = false;
        if (debug != null) {
            Object[] objectArray = new Object[]{certificate, byArray, byArray2};
            debug.entry(16384L, (Object)className, "verify", objectArray);
        }
        if (certificate == null) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Certificate must be specified");
            }
            throw new IllegalArgumentException("Certificate must be specified.");
        }
        if (!(certificate instanceof X509Certificate)) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Certificate type " + certificate.getClass().getName() + " not supported. Only instances of java.security.cert.X509Certificate are supported");
            }
            throw new IllegalArgumentException("Certificate type " + certificate.getClass().getName() + "not supported.  Only instances of java.security.cert.X509Certificate are supported.");
        }
        try {
            ((X509Certificate)certificate).checkValidity();
        }
        catch (CertificateExpiredException certificateExpiredException) {
            if (debug != null) {
                debug.exception(16384L, className, "verify", certificateExpiredException);
            }
            throw new PKCSException(certificateExpiredException, "Certificate has expired.");
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            if (debug != null) {
                debug.exception(16384L, className, "verify", certificateNotYetValidException);
            }
            throw new PKCSException(certificateNotYetValidException, "Certificate is not yet valid.");
        }
        bl = this.verify(certificate.getPublicKey(), byArray, byArray2);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "verify", bl);
        }
        return bl;
    }

    public String toString() {
        return "PKCS1: version: " + this.getVersion() + "\r\n\tencryption algorithm: " + this.getEncryptionAlgorithmString() + "\r\n\tsignature algorithm: " + this.getSignatureAlgorithmString();
    }

    private static boolean inSet(String string, String[] stringArray) {
        boolean bl = false;
        if (debug != null) {
            debug.entry(8192L, className, "inSet", string, stringArray);
        }
        if (stringArray != null && string != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equalsIgnoreCase(stringArray[i])) continue;
                bl = true;
                break;
            }
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "inSet", bl);
        }
        return bl;
    }

    private void setVersion(String string) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setVersion", string);
        }
        if (string.equalsIgnoreCase(PKCS1_VERSION_1_5)) {
            this.version = PKCS1_VERSION_1_5;
            if (debug != null) {
                debug.exit(8192L, className, "setVersion");
            }
            return;
        }
        if (debug != null) {
            debug.text(8192L, className, "setVersion", "PKCS #1 version " + string + " not supported");
        }
        throw new IllegalArgumentException("PKCS #1 version " + string + " not supported.");
    }

    private void setEncryptionAlgorithm(String string) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setEncryptionAlgorithm", string);
        }
        if (PKCS1_VERSION2.equalsIgnoreCase(this.version)) {
            if (!PKCS1.inSet(string, OaepHashAlgorithms)) {
                if (debug != null) {
                    debug.text(8192L, className, "setEncryptionAlgorithm", "Encryption algorithm " + string + " not supported in version 2.0");
                }
                throw new IllegalArgumentException("Encryption algorithm " + string + " not supported in version 2.0");
            }
            this.encryption = string.toUpperCase();
        } else if (!string.equalsIgnoreCase(RSA_ALGORITHM)) {
            if (debug != null) {
                debug.text(8192L, className, "setEncryptionAlgorithm", "Encryption algorithm " + string + " not supported in version 1.5");
            }
            throw new IllegalArgumentException("Encryption algorithm " + string + " not supported in version 1.5.");
        }
        if (debug != null) {
            debug.exit(8192L, className, "setEncryptionAlgorithm");
        }
    }

    private void setSignatureHashAlgorithm(String string) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setSignatureHashAlgorithm", string);
        }
        if (!PKCS1.inSet(string, version1_5SignAlgorithms)) {
            if (debug != null) {
                debug.text(8192L, className, "setSignatureHashAlgorithm", "Digest algorithm " + string + " not supported");
            }
            throw new IllegalArgumentException("Digest algorithm " + string + " not supported.");
        }
        if (string.equalsIgnoreCase(MESSAGE_DIGEST_SHA) || string.equalsIgnoreCase(MESSAGE_DIGEST_SHA1) || string.equalsIgnoreCase(MESSAGE_DIGEST_SHA_1)) {
            this.signature = SIGNATURE_SHA_RSA;
            if (debug != null) {
                debug.exit(8192L, className, "setSignatureHashAlgorithm");
            }
            return;
        }
        if (string.equalsIgnoreCase(MESSAGE_DIGEST_MD2)) {
            this.signature = SIGNATURE_MD2_RSA;
            if (debug != null) {
                debug.exit(8192L, className, "setSignatureHashAlgorithm");
            }
            return;
        }
        this.signature = SIGNATURE_MD5_RSA;
        if (debug != null) {
            debug.exit(8192L, className, "setSignatureHashAlgorithm");
        }
    }

    private void setMGF(String string) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setMGF", string);
        }
        if (PKCS1_VERSION2.equalsIgnoreCase(this.version)) {
            if (!PKCS1.inSet(string, mgfAlgorithms)) {
                if (debug != null) {
                    debug.text(8192L, className, "setMGF", "MGF algorithm " + string + " not supported");
                }
                throw new IllegalArgumentException("MGF algorithm " + string + " not supported.");
            }
        } else {
            if (debug != null) {
                debug.text(8192L, className, "setMGF", "MGF algorithm " + string + " not supported in PKCS#1 version " + this.version);
            }
            throw new IllegalArgumentException("MGF algorithm  not supported in PKCS#1 version " + this.version);
        }
        this.mgf = string.toUpperCase();
        if (debug != null) {
            debug.exit(8192L, className, "setMGF");
        }
    }
}

