/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pkcs11;

import com.ibm.pkcs11.PKCS11;

public class PKCS11MechanismInfo {
    public static final int HW = 1;
    public static final int ENCRYPT = 256;
    public static final int DECRYPT = 512;
    public static final int DIGEST = 1024;
    public static final int SIGN = 2048;
    public static final int SIGN_RECOVER = 4096;
    public static final int VERIFY = 8192;
    public static final int VERIFY_RECOVER = 16384;
    public static final int GENERATE = 32768;
    public static final int GENERATE_KEY_PAIR = 65536;
    public static final int WRAP = 131072;
    public static final int UNWRAP = 262144;
    public static final int DERIVE = 524288;
    public static final int EC_F_P = 0x100000;
    public static final int EC_F_2M = 0x200000;
    public static final int EC_ECPARAMETERS = 0x400000;
    public static final int EC_NAMEDCURVE = 0x800000;
    public static final int EC_UNCOMPRESS = 0x1000000;
    public static final int EC_COMPRESS = 0x2000000;
    public static final int EXTENSION = Integer.MIN_VALUE;
    static final int[] flagList = new int[]{1, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000, 0x1000000, 0x2000000, Integer.MIN_VALUE};
    static final String[] flagNames = new String[]{"HW", "ENCRYPT", "DECRYPT", "DIGEST", "SIGN", "SIGN_RECOVER", "VERIFY", "VERIFY_RECOVER", "GENERATE", "GENERATE_KEY_PAIR", "WRAP", "UNWRAP", "DERIVE", "EC_F_P", "EC_F_2M", "EC_ECPARAMETERS", "EC_NAMEDCURVE", "EC_UNCOMPRESS", "EC_COMPRESS", "EXTENSION"};
    private int minKeySize;
    private int maxKeySize;
    private int flags;

    public PKCS11MechanismInfo(int n, int n2, int n3) {
        this.minKeySize = n;
        this.maxKeySize = n2;
        this.flags = n3;
    }

    public int minKeySize() {
        return this.minKeySize;
    }

    public int maxKeySize() {
        return this.maxKeySize;
    }

    public int flags() {
        return this.flags;
    }

    public String toString() {
        return "minKeySize=" + this.minKeySize + ", maxKeySize=" + this.maxKeySize + ", flags=" + this.flagsToString("|");
    }

    public String flagsToString(String string) {
        return PKCS11.flagsToString(this.flags, flagList, flagNames, string);
    }
}

