/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.misc;

import com.ibm.misc.CharacterEncoder;
import java.io.IOException;
import java.io.OutputStream;

public class HexDumpEncoder
extends CharacterEncoder {
    private int offset;
    private int thisLineLength;
    private int currentByte;
    private byte[] thisLine = new byte[16];

    static void hexDigit(OutputStream outputStream, byte by) {
        int n = 0;
        try {
            n = by >> 4;
            outputStream.write(HexDumpEncoder.trimIt(Integer.toHexString(n)).getBytes("8859_1"));
            n = by & 0xF;
            outputStream.write(HexDumpEncoder.trimIt(Integer.toHexString(n)).getBytes("8859_1"));
        }
        catch (Exception exception) {
            System.out.println("Unable to write to output stream: " + exception);
        }
    }

    private static String trimIt(String string) {
        if (string == null) {
            return new String("00");
        }
        int n = string.length();
        if (n == 0) {
            return new String("00");
        }
        if (n <= 2) {
            return string;
        }
        return string.substring(n - 1);
    }

    protected int bytesPerAtom() {
        return 1;
    }

    protected int bytesPerLine() {
        return 16;
    }

    protected void encodeBufferPrefix(OutputStream outputStream) throws IOException {
        this.offset = 0;
        super.encodeBufferPrefix(outputStream);
    }

    protected void encodeLinePrefix(OutputStream outputStream, int n) throws IOException {
        HexDumpEncoder.hexDigit(outputStream, (byte)(this.offset >>> 8 & 0xFF));
        HexDumpEncoder.hexDigit(outputStream, (byte)(this.offset & 0xFF));
        outputStream.write(58);
        outputStream.write(32);
        this.currentByte = 0;
        this.thisLineLength = n;
    }

    protected void encodeAtom(OutputStream outputStream, byte[] byArray, int n, int n2) throws IOException {
        this.thisLine[this.currentByte] = byArray[n];
        HexDumpEncoder.hexDigit(outputStream, byArray[n]);
        outputStream.write(32);
        ++this.currentByte;
        if (this.currentByte == 8) {
            outputStream.write(32);
        }
    }

    protected void encodeLineSuffix(OutputStream outputStream) throws IOException {
        int n;
        if (this.thisLineLength < 16) {
            for (n = this.thisLineLength; n < 16; ++n) {
                outputStream.write(32);
                outputStream.write(32);
                outputStream.write(32);
                if (n != 7) continue;
                outputStream.write(32);
                outputStream.write(32);
            }
        }
        outputStream.write(32);
        for (n = 0; n < this.thisLineLength; ++n) {
            if (this.thisLine[n] < 48 || this.thisLine[n] > 122 || this.thisLine[n] > 57 && this.thisLine[n] < 65 || this.thisLine[n] > 90 && this.thisLine[n] < 97) {
                outputStream.write(46);
                continue;
            }
            outputStream.write(this.thisLine[n]);
        }
        outputStream.write(10);
        this.offset += this.thisLineLength;
    }
}

