/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.VolatileImage;
import java.awt.image.WritableRaster;
import java.security.AccessController;
import sun.awt.X11ComponentPeer;
import sun.awt.X11GraphicsConfig;
import sun.awt.X11GraphicsDevice;
import sun.awt.X11GraphicsEnvironment;
import sun.awt.image.SunVolatileImage;
import sun.java2d.SurfaceData;
import sun.java2d.opengl.GLXContext;
import sun.java2d.opengl.GLXRemoteOffScreenImage;
import sun.java2d.opengl.GLXSurfaceData;
import sun.java2d.opengl.OGLContext;
import sun.security.action.GetPropertyAction;

public class GLXGraphicsConfig
extends X11GraphicsConfig {
    protected static boolean glxAvailable;
    protected static boolean glxVerbose;
    protected boolean blendPremultAvailable;
    protected boolean texNonPow2Available;
    private ThreadLocal<OGLContext> contextTls = new ThreadLocal<OGLContext>(){

        @Override
        protected OGLContext initialValue() {
            return new GLXContext(GLXGraphicsConfig.this);
        }
    };
    private static ThreadLocal<Long> sharedContextTls;

    private static native boolean initGLX();

    private static native long getGLXConfigInfo(int var0, int var1);

    private static native boolean isDoubleBuffered(long var0);

    private static native boolean isBlendPremultAvailable(long var0);

    private static native boolean isTexNonPow2Available(long var0);

    private native void initConfig(long var1);

    protected GLXGraphicsConfig(X11GraphicsDevice x11GraphicsDevice, int n, boolean bl, long l) {
        super(x11GraphicsDevice, n, 0, 0, bl);
        this.initConfig(l);
        this.blendPremultAvailable = GLXGraphicsConfig.isBlendPremultAvailable(l);
        this.texNonPow2Available = GLXGraphicsConfig.isTexNonPow2Available(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GLXGraphicsConfig getConfig(X11GraphicsDevice x11GraphicsDevice, int n) {
        if (!glxAvailable) {
            return null;
        }
        long l = 0L;
        Object object = OGLContext.LOCK;
        synchronized (object) {
            l = GLXGraphicsConfig.getGLXConfigInfo(x11GraphicsDevice.getScreen(), n);
        }
        if (l == 0L) {
            return null;
        }
        boolean bl = GLXGraphicsConfig.isDoubleBuffered(l);
        return new GLXGraphicsConfig(x11GraphicsDevice, n, bl, l);
    }

    public static boolean isGLXAvailable() {
        return glxAvailable;
    }

    public static boolean isGLXVerbose() {
        return glxVerbose;
    }

    public boolean isBlendPremultAvailable() {
        return this.blendPremultAvailable;
    }

    public boolean isTexNonPow2Available() {
        return this.texNonPow2Available;
    }

    public final OGLContext getContext() {
        return this.contextTls.get();
    }

    private static native long initNativeSharedContext();

    private static native long makeNativeSharedContextCurrent(long var0);

    public static long getThreadSharedContext() {
        long l = sharedContextTls.get();
        return GLXGraphicsConfig.makeNativeSharedContextCurrent(l);
    }

    public BufferedImage createCompatibleImage(int n, int n2) {
        DirectColorModel directColorModel = new DirectColorModel(24, 0xFF0000, 65280, 255);
        WritableRaster writableRaster = ((ColorModel)directColorModel).createCompatibleWritableRaster(n, n2);
        return new BufferedImage(directColorModel, writableRaster, directColorModel.isAlphaPremultiplied(), null);
    }

    public VolatileImage createCompatibleVolatileImage(int n, int n2) {
        return new SunVolatileImage(this, n, n2);
    }

    public BufferedImage createCompatibleImage(int n, int n2, int n3) {
        switch (n3) {
            case 1: {
                return this.createCompatibleImage(n, n2);
            }
            case 2: 
            case 3: {
                ColorModel colorModel = this.getColorModel(n3);
                WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n, n2);
                return new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
            }
        }
        throw new IllegalArgumentException("Unknown transparency type " + n3);
    }

    public ColorModel getColorModel(int n) {
        switch (n) {
            case 1: {
                return new DirectColorModel(24, 0xFF0000, 65280, 255);
            }
            case 2: {
                return new DirectColorModel(25, 0xFF0000, 65280, 255, 0x1000000);
            }
            case 3: {
                ColorSpace colorSpace = ColorSpace.getInstance(1000);
                return new DirectColorModel(colorSpace, 32, 0xFF0000, 65280, 255, -16777216, true, 3);
            }
        }
        return null;
    }

    public String toString() {
        return "GLXGraphicsConfig[dev=" + this.screen + ",vis=0x" + Integer.toHexString(this.visual) + "]";
    }

    public SurfaceData createSurfaceData(X11ComponentPeer x11ComponentPeer) {
        return GLXSurfaceData.createData(x11ComponentPeer);
    }

    public Image createAcceleratedImage(Component component, int n, int n2) {
        ColorModel colorModel = this.getColorModel(1);
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n, n2);
        return new GLXRemoteOffScreenImage(component, colorModel, writableRaster, colorModel.isAlphaPremultiplied());
    }

    private native void swapBuffers(long var1);

    public long createBackBuffer(X11ComponentPeer x11ComponentPeer, int n, BufferCapabilities bufferCapabilities) throws AWTException {
        if (n > 2) {
            throw new AWTException("Only double or single buffering is supported");
        }
        BufferCapabilities bufferCapabilities2 = this.getBufferCapabilities();
        if (!bufferCapabilities2.isPageFlipping()) {
            throw new AWTException("Page flipping is not supported");
        }
        if (bufferCapabilities.getFlipContents() == BufferCapabilities.FlipContents.PRIOR) {
            throw new AWTException("FlipContents.PRIOR is not supported");
        }
        return 1L;
    }

    public void destroyBackBuffer(long l) {
    }

    public VolatileImage createBackBufferImage(Component component, long l) {
        return new SunVolatileImage(component, component.getWidth(), component.getHeight(), Boolean.TRUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flip(X11ComponentPeer x11ComponentPeer, Component component, VolatileImage volatileImage, BufferCapabilities.FlipContents flipContents) {
        long l = x11ComponentPeer.getContentWindow();
        if (flipContents == BufferCapabilities.FlipContents.COPIED) {
            Graphics graphics = x11ComponentPeer.getGraphics();
            try {
                graphics.drawImage(volatileImage, 0, 0, null);
            }
            finally {
                graphics.dispose();
            }
            return;
        }
        if (flipContents == BufferCapabilities.FlipContents.PRIOR) {
            return;
        }
        Object object = OGLContext.LOCK;
        synchronized (object) {
            this.swapBuffers(l);
        }
        if (flipContents == BufferCapabilities.FlipContents.BACKGROUND) {
            object = volatileImage.getGraphics();
            try {
                ((Graphics)object).setColor(component.getBackground());
                ((Graphics)object).fillRect(0, 0, volatileImage.getWidth(), volatileImage.getHeight());
            }
            finally {
                ((Graphics)object).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        boolean bl = false;
        String string = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.opengl"));
        if (string != null) {
            if (string.equals("true") || string.equals("t")) {
                bl = true;
            } else if (string.equals("True") || string.equals("T")) {
                bl = true;
                glxVerbose = true;
            }
        }
        if (bl) {
            OGLContext.LOCK = X11GraphicsEnvironment.class;
            Object object = OGLContext.LOCK;
            synchronized (object) {
                glxAvailable = GLXGraphicsConfig.initGLX();
            }
            if (glxVerbose && !glxAvailable) {
                System.out.println("Could not enable OpenGL pipeline (GLX 1.3 not available)");
            }
        }
        sharedContextTls = new ThreadLocal<Long>(){

            @Override
            protected Long initialValue() {
                return new Long(GLXGraphicsConfig.initNativeSharedContext());
            }
        };
    }
}

